<?php
/**
 * Ecommerce Landing Page: Block Patterns
 *
 * @package Ecommerce Landing Page
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'ecommerce-landing-page',
		array( 'label' => __( 'Ecommerce Landing Page', 'ecommerce-landing-page' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'ecommerce-landing-page/banner-section',
		array(
			'title'      => __( 'Banner Section', 'ecommerce-landing-page' ),
			'categories' => array( 'ecommerce-landing-page' ),
			'content'    => "<!-- wp:cover {\"customOverlayColor\":\"#fff3db\",\"isDark\":false,\"align\":\"full\",\"className\":\"banner-section\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-cover alignfull is-light banner-section\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#fff3db\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"banner-content p-5\"} -->\n<div class=\"wp-block-column banner-content p-5\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":1,\"style\":{\"typography\":{\"fontSize\":\"45px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}}},\"textColor\":\"black\",\"className\":\"mb-3\"} -->\n<h1 class=\"wp-block-heading has-text-align-left mb-3 has-black-color has-text-color has-link-color\" style=\"font-size:45px;font-style:normal;font-weight:700;text-transform:capitalize\">enjoy every single beat on</h1>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"textAlign\":\"left\",\"level\":1,\"style\":{\"typography\":{\"fontSize\":\"45px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|white\"}}}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"banner-heading mb-3\"} -->\n<h1 class=\"wp-block-heading has-text-align-left banner-heading mb-3 has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"font-size:45px;font-style:normal;font-weight:700;text-transform:capitalize\">headphone</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}}},\"textColor\":\"black\",\"className\":\"mb-0\"} -->\n<p class=\"mb-0 has-black-color has-text-color has-link-color\" style=\"font-size:15px\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"orientation\":\"horizontal\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"white\",\"style\":{\"color\":{\"background\":\"#f2612b\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|white\"}}},\"typography\":{\"fontSize\":\"15px\",\"fontStyle\":\"normal\",\"fontWeight\":\"500\",\"textTransform\":\"uppercase\"},\"border\":{\"radius\":\"0px\"}},\"className\":\"is-style-fill mb-5 mt-4\"} -->\n<div class=\"wp-block-button has-custom-font-size is-style-fill mb-5 mt-4\" style=\"font-size:15px;font-style:normal;font-weight:500;text-transform:uppercase\"><a class=\"wp-block-button__link has-white-color has-text-color has-background has-link-color wp-element-button\" style=\"border-radius:0px;background-color:#f2612b\">buy now</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}},\"typography\":{\"fontSize\":\"16px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"textColor\":\"black\"} -->\n<p class=\"has-black-color has-text-color has-link-color\" style=\"font-size:16px;font-style:normal;font-weight:600;text-transform:capitalize\">recommended headphone</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:woocommerce/product-category {\"rows\":1,\"contentVisibility\":{\"image\":true,\"title\":true,\"price\":false,\"rating\":false,\"button\":false},\"categories\":[15],\"className\":\"banner-product-sec\"} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"className\":\"banner-product-img\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center banner-product-img\"><!-- wp:image {\"id\":37,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"product-image\"} -->\n<figure class=\"wp-block-image size-full product-image\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/headphone.png\" alt=\"\" class=\"wp-image-37\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"style\":{\"color\":{\"background\":\"#ffffff6e\"}},\"className\":\"price-sec p-3\"} -->\n<div class=\"wp-block-column price-sec p-3 has-background\" style=\"background-color:#ffffff6e\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}},\"typography\":{\"fontSize\":\"20px\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"textColor\":\"black\"} -->\n<p class=\"has-black-color has-text-color has-link-color\" style=\"font-size:20px;font-style:normal;font-weight:600\">$299</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|white\"}}},\"typography\":{\"fontSize\":\"14px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"save-text p-2\"} -->\n<p class=\"save-text p-2 has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"font-size:14px;font-style:normal;font-weight:600;text-transform:capitalize\">save 30% today</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"textTransform\":\"capitalize\",\"fontSize\":\"14px\"}},\"textColor\":\"black\",\"className\":\"mb-0\"} -->\n<p class=\"mb-0 has-black-color has-text-color has-link-color\" style=\"font-size:14px;font-style:normal;font-weight:600;text-transform:capitalize\">original price $399</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"color\":{\"background\":\"#ffffff6e\"}},\"className\":\"reviews-sec p-3\"} -->\n<div class=\"wp-block-column reviews-sec p-3 has-background\" style=\"background-color:#ffffff6e\"><!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"textTransform\":\"capitalize\",\"fontSize\":\"14px\"}},\"textColor\":\"black\",\"className\":\"mb-1\"} -->\n<p class=\"mb-1 has-black-color has-text-color has-link-color\" style=\"font-size:14px;font-style:normal;font-weight:600;text-transform:capitalize\">our reviews</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"review-img\"} -->\n<div class=\"wp-block-column review-img\"><!-- wp:image {\"id\":54,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"mb-0\"} -->\n<figure class=\"wp-block-image size-full mb-0\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/view.png\" alt=\"\" class=\"wp-image-54\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"textTransform\":\"capitalize\",\"fontSize\":\"14px\"}},\"textColor\":\"black\",\"className\":\"mb-0 ms-3\"} -->\n<p class=\"mb-0 ms-3 has-black-color has-text-color has-link-color\" style=\"font-size:14px;font-style:normal;font-weight:600;text-transform:capitalize\">+123k</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'ecommerce-landing-page/latest-news-and-blog-section',
		array(
			'title'      => __( 'Latest News And Blog Section', 'ecommerce-landing-page' ),
			'categories' => array( 'ecommerce-landing-page' ),
			'content'    => "<!-- wp:group {\"className\":\"post-section py-5\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group post-section py-5\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"typography\":{\"textTransform\":\"capitalize\",\"fontSize\":\"32px\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}}},\"textColor\":\"black\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-black-color has-text-color has-link-color\" style=\"font-size:32px;font-style:normal;font-weight:700;text-transform:capitalize\">latest news and blog</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":\"15px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}}},\"textColor\":\"black\",\"className\":\"mb-4\"} -->\n<p class=\"has-text-align-center mb-4 has-black-color has-text-color has-link-color\" style=\"font-size:15px\">Lorem Ipsum is simply dummy text of the printing and</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"post-content\"} -->\n<div class=\"wp-block-column post-content\"><!-- wp:image {\"id\":113,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/blog01.png\" alt=\"\" class=\"wp-image-113\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|white\"}}},\"typography\":{\"fontSize\":\"18px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"post-date\"} -->\n<p class=\"post-date has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"font-size:18px;font-style:normal;font-weight:700;text-transform:capitalize\">19 dec</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|white\"}}},\"typography\":{\"fontSize\":\"15px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"post-cat\"} -->\n<p class=\"post-cat has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"font-size:15px;font-style:normal;font-weight:700;text-transform:capitalize\">wired headphone</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"16px\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}}},\"textColor\":\"black\"} -->\n<h3 class=\"wp-block-heading has-black-color has-text-color has-link-color\" style=\"font-size:16px;font-style:normal;font-weight:700\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry.</h3>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"className\":\"author-comment\"} -->\n<div class=\"wp-block-columns author-comment\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"500\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}}},\"textColor\":\"black\",\"className\":\"author\"} -->\n<p class=\"author has-black-color has-text-color has-link-color\" style=\"font-size:15px;font-style:normal;font-weight:500;text-transform:capitalize\">james johnathon</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"500\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}}},\"textColor\":\"black\",\"className\":\"comment\"} -->\n<p class=\"comment has-black-color has-text-color has-link-color\" style=\"font-size:15px;font-style:normal;font-weight:500;text-transform:capitalize\">02 comments</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"post-content\"} -->\n<div class=\"wp-block-column post-content\"><!-- wp:image {\"id\":132,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/blog02.png\" alt=\"\" class=\"wp-image-132\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|white\"}}},\"typography\":{\"fontSize\":\"18px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"post-date\"} -->\n<p class=\"post-date has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"font-size:18px;font-style:normal;font-weight:700;text-transform:capitalize\">19 dec</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|white\"}}},\"typography\":{\"fontSize\":\"15px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"post-cat\"} -->\n<p class=\"post-cat has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"font-size:15px;font-style:normal;font-weight:700;text-transform:capitalize\">wired headphone</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"16px\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}}},\"textColor\":\"black\"} -->\n<h3 class=\"wp-block-heading has-black-color has-text-color has-link-color\" style=\"font-size:16px;font-style:normal;font-weight:700\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry.</h3>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"className\":\"author-comment\"} -->\n<div class=\"wp-block-columns author-comment\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"500\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}}},\"textColor\":\"black\",\"className\":\"author\"} -->\n<p class=\"author has-black-color has-text-color has-link-color\" style=\"font-size:15px;font-style:normal;font-weight:500;text-transform:capitalize\">james johnathon</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"500\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}}},\"textColor\":\"black\",\"className\":\"comment\"} -->\n<p class=\"comment has-black-color has-text-color has-link-color\" style=\"font-size:15px;font-style:normal;font-weight:500;text-transform:capitalize\">02 comments</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"post-content\"} -->\n<div class=\"wp-block-column post-content\"><!-- wp:image {\"id\":133,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/blog03.png\" alt=\"\" class=\"wp-image-133\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|white\"}}},\"typography\":{\"fontSize\":\"18px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"post-date\"} -->\n<p class=\"post-date has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"font-size:18px;font-style:normal;font-weight:700;text-transform:capitalize\">19 dec</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|white\"}}},\"typography\":{\"fontSize\":\"15px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"post-cat\"} -->\n<p class=\"post-cat has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"font-size:15px;font-style:normal;font-weight:700;text-transform:capitalize\">wired headphone</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"16px\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}}},\"textColor\":\"black\"} -->\n<h3 class=\"wp-block-heading has-black-color has-text-color has-link-color\" style=\"font-size:16px;font-style:normal;font-weight:700\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry.</h3>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"className\":\"author-comment\"} -->\n<div class=\"wp-block-columns author-comment\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"500\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}}},\"textColor\":\"black\",\"className\":\"author\"} -->\n<p class=\"author has-black-color has-text-color has-link-color\" style=\"font-size:15px;font-style:normal;font-weight:500;text-transform:capitalize\">james johnathon</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"15px\",\"textTransform\":\"capitalize\",\"fontStyle\":\"normal\",\"fontWeight\":\"500\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|black\"}}}},\"textColor\":\"black\",\"className\":\"comment\"} -->\n<p class=\"comment has-black-color has-text-color has-link-color\" style=\"font-size:15px;font-style:normal;font-weight:500;text-transform:capitalize\">02 comments</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->",
		)
	);
}