<?php
/**
 * Footer Social Icons
 *
 * @package ecommerce_online_store
 */

$wp_customize->add_section(
	'ecommerce_online_store_footer_icon_options',
	array(
		'panel' => 'ecommerce_online_store_theme_options',
		'title' => esc_html__( 'Footer Social Icons', 'ecommerce-online-store' ),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'ecommerce_online_store_footer_icon_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Ecommerce_Online_Store_Separator_Custom_Control( $wp_customize, 'ecommerce_online_store_footer_icon_separators', array(
	'label' => __( 'Footer Icon Settings', 'ecommerce-online-store' ),
	'section' => 'ecommerce_online_store_footer_icon_options',
	'settings' => 'ecommerce_online_store_footer_icon_separators',
)));

// Footer Section - Enable Section.
$wp_customize->add_setting(
	'ecommerce_online_store_enable_footer_icon_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'ecommerce_online_store_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Ecommerce_Online_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'ecommerce_online_store_enable_footer_icon_section',
		array(
			'label'    => esc_html__( 'Show / Hide Footer Icon', 'ecommerce-online-store' ),
			'section'  => 'ecommerce_online_store_footer_icon_options',
			'settings' => 'ecommerce_online_store_enable_footer_icon_section',
		)
	)
);

// Add setting for Facebook Link
$wp_customize->add_setting(
	'ecommerce_online_store_footer_facebook_link',
	array(
		'default'           => 'https://www.facebook.com/',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'ecommerce_online_store_footer_facebook_link',
	array(
		'label'           => esc_html__( 'Facebook Link', 'ecommerce-online-store'  ),
		'section'         => 'ecommerce_online_store_footer_icon_options',
		'settings'        => 'ecommerce_online_store_footer_facebook_link',
		'type'      => 'url'
	)
);

// Add setting for Facebook Icon Changing
$wp_customize->add_setting(
	'ecommerce_online_store_facebook_icon',
	array(
        'default' => 'fab fa-facebook-f',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Ecommerce_Online_Store_Change_Icon_Control($wp_customize, 
	'ecommerce_online_store_facebook_icon',
	array(
	    'label'   		=> __('Facebook Icon','ecommerce-online-store'),
	    'section' 		=> 'ecommerce_online_store_footer_icon_options',
		'iconset' => 'fb',
	))  
);


// Add setting for Twitter Link
$wp_customize->add_setting(
	'ecommerce_online_store_footer_twitter_link',
	array(
		'default'           => 'https://x.com/',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'ecommerce_online_store_footer_twitter_link',
	array(
		'label'           => esc_html__( 'Twitter Link', 'ecommerce-online-store'  ),
		'section'         => 'ecommerce_online_store_footer_icon_options',
		'settings'        => 'ecommerce_online_store_footer_twitter_link',
		'type'      => 'url'
	)
);

// Add setting for Twitter Icon Changing
$wp_customize->add_setting(
	'ecommerce_online_store_twitter_icon',
	array(
        'default' => 'fab fa-twitter',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Ecommerce_Online_Store_Change_Icon_Control($wp_customize, 
	'ecommerce_online_store_twitter_icon',
	array(
	    'label'   		=> __('Twitter Icon','ecommerce-online-store'),
	    'section' 		=> 'ecommerce_online_store_footer_icon_options',
		'iconset' => 'fb',
	))  
);

// Add setting for Instagram Link
$wp_customize->add_setting(
	'ecommerce_online_store_footer_instagram_link',
	array(
		'default'           => 'https://www.instagram.com/',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'ecommerce_online_store_footer_instagram_link',
	array(
		'label'           => esc_html__( 'Instagram Link', 'ecommerce-online-store'  ),
		'section'         => 'ecommerce_online_store_footer_icon_options',
		'settings'        => 'ecommerce_online_store_footer_instagram_link',
		'type'      => 'url'
	)
);

// Add setting for Instagram Icon Changing
$wp_customize->add_setting(
	'ecommerce_online_store_instagram_icon',
	array(
        'default' => 'fab fa-instagram',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Ecommerce_Online_Store_Change_Icon_Control($wp_customize, 
	'ecommerce_online_store_instagram_icon',
	array(
	    'label'   		=> __('Instagram Icon','ecommerce-online-store'),
	    'section' 		=> 'ecommerce_online_store_footer_icon_options',
		'iconset' => 'fb',
	))  
);

// Add setting for Linkedin Link
$wp_customize->add_setting(
	'ecommerce_online_store_footer_linkedin_link',
	array(
		'default'           => 'https://in.linkedin.com/',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'ecommerce_online_store_footer_linkedin_link',
	array(
		'label'           => esc_html__( 'Linkedin Link', 'ecommerce-online-store'  ),
		'section'         => 'ecommerce_online_store_footer_icon_options',
		'settings'        => 'ecommerce_online_store_footer_linkedin_link',
		'type'      => 'url'
	)
);

// Add setting for Linkedin Icon Changing
$wp_customize->add_setting(
	'ecommerce_online_store_linkedin_icon',
	array(
        'default' => 'fab fa-linkedin',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Ecommerce_Online_Store_Change_Icon_Control($wp_customize, 
	'ecommerce_online_store_linkedin_icon',
	array(
	    'label'   		=> __('Linkedin Icon','ecommerce-online-store'),
	    'section' 		=> 'ecommerce_online_store_footer_icon_options',
		'iconset' => 'fb',
	))  
);

// Add setting for Youtube Link
$wp_customize->add_setting(
	'ecommerce_online_store_footer_youtube_link',
	array(
		'default'           => 'https://www.youtube.com/',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'ecommerce_online_store_footer_youtube_link',
	array(
		'label'           => esc_html__( 'Youtube Link', 'ecommerce-online-store'  ),
		'section'         => 'ecommerce_online_store_footer_icon_options',
		'settings'        => 'ecommerce_online_store_footer_youtube_link',
		'type'      => 'url'
	)
);

// Add setting for Youtube Icon Changing
$wp_customize->add_setting(
	'ecommerce_online_store_youtube_icon',
	array(
        'default' => 'fab fa-youtube',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Ecommerce_Online_Store_Change_Icon_Control($wp_customize, 
	'ecommerce_online_store_youtube_icon',
	array(
	    'label'   		=> __('Youtube Icon','ecommerce-online-store'),
	    'section' 		=> 'ecommerce_online_store_footer_icon_options',
		'iconset' => 'fb',
	))  
);