<?php
/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Flex_Multi_Business_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	*/
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/go-pro/upgrade-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Flex_Multi_Business_Customize_Section_Pro' );

		$manager->add_section(
			new Flex_Multi_Business_Customize_Section_Pro(
				$manager,
				'flex_multi_business_upgrade_pro',
				array(
					'title'       => esc_html__( 'Flex Themes Pro', 'flex-multi-business' ),
					'pro_text'    => esc_html__( 'GET PRO', 'flex-multi-business' ),
					'pro_url'     => 'https://www.flextheme.net/products/flex-pro-wordpress-theme',
					'priority'    => 5,
				)
			)
		);

	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'flex-multi-business-customize-controls', trailingslashit( get_template_directory_uri() ) . 'inc/customizer/customizer.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'flex-multi-business-customize-controls', trailingslashit( get_template_directory_uri() ) . 'inc/customizer/customizer.css' );
	}
}

// Doing this customizer thang!
Flex_Multi_Business_Customize::get_instance();