(function($) {
    function resetColorsToDefault() {
        // Define default values for your color settings
        const defaultColors = {
            'background_color': '#ffffff',
            'modern_ecommerce_primary_color': '#1cc5dc',
            'modern_ecommerce_heading_color': '#2f3942',
            'modern_ecommerce_text_color': '#4e5f81',
            'modern_ecommerce_top_text_color': '#4e5f81',
            'modern_ecommerce_slider_bg_color' :'#d1e1f1',
            'modern_ecommerce_primary_fade': '#e9f4ff',
            'modern_ecommerce_footer_bg': '#2f3942',
            'modern_ecommerce_post_bg': '#ffffff',
        };

        // Iterate over each setting and set it to its default value
        for (let settingId in defaultColors) {
            wp.customize(settingId).set(defaultColors[settingId]);
        }

        // Optionally refresh the preview
        wp.customize.previewer.refresh();
    }

    // Attach reset function to global scope
    window.resetColorsToDefault = resetColorsToDefault;

    $(document).ready(function() {
        $('.color-reset-btn').val('RESET'); // This adds the 'RESET' text inside the button
    });
})(jQuery);