<?php
/**
 * The template for displaying 404 pages (Not Found).
 * @package Print On Demand Shop
 */
get_header(); ?>

<main role="main" id="skip_content" class="content_box">
    <div class="container">
        <div class="page-content pt-4 text-center">
            <h1><?php echo esc_html(get_theme_mod('print_on_demand_shop_page_not_found_heading',__('404 Not Found','print-on-demand-shop')));?></h1>
            <p class="text-404"><?php echo esc_html(get_theme_mod('print_on_demand_shop_page_not_found_text',__('Looks like you have taken a wrong turn. Dont worry it happens to the best of us.','print-on-demand-shop')));?></p>
            <?php if( get_theme_mod('print_on_demand_shop_page_not_found_button','Back to Home Page') != ''){ ?>
                <div class="read-moresec mt-3 mb-4 mx-0">
                    <a href="<?php echo esc_url( home_url() ); ?>" class="button py-2 px-3"><?php echo esc_html(get_theme_mod('print_on_demand_shop_page_not_found_button',__('Back to Home Page','print-on-demand-shop')));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('print_on_demand_shop_page_not_found_button',__('Back to Home Page','print-on-demand-shop')));?></span></a>
                </div>
            <?php } ?>
        </div>
        <div class="clearfix"></div>
    </div>
</main>

<?php get_footer(); ?>