<?php
/**
 * The template for displaying the footer.
 * @package Print On Demand Shop
 */
?>
<?php if( get_theme_mod( 'print_on_demand_shop_hide_show_scroll',true) != '' || get_theme_mod( 'print_on_demand_shop_display_scroll',true) != ''){ ?>
    <?php $print_on_demand_shop_theme_lay = get_theme_mod( 'print_on_demand_shop_footer_options','Right');
    if($print_on_demand_shop_theme_lay == 'Left align'){ ?>
        <a href="#" id="scrollbutton" class="left"><i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_back_to_top_icon','fas fa-long-arrow-alt-up')); ?>"></i><span class="screen-reader-text"><?php esc_html_e( 'Back to Top', 'print-on-demand-shop' ); ?></span></a>
    <?php }else if($print_on_demand_shop_theme_lay == 'Center align'){ ?>
        <a href="#" id="scrollbutton" class="center"><i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_back_to_top_icon','fas fa-long-arrow-alt-up')); ?>"></i><span class="screen-reader-text"><?php esc_html_e( 'Back to Top', 'print-on-demand-shop' ); ?></span></a>
    <?php }else{ ?>
        <a href="#" id="scrollbutton"><i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_back_to_top_icon','fas fa-long-arrow-alt-up')); ?>"></i><span class="screen-reader-text"><?php esc_html_e( 'Back to Top', 'print-on-demand-shop' ); ?></span></a>
    <?php }?>
<?php }?>
<footer role="contentinfo">
    <?php if( get_theme_mod( 'print_on_demand_shop_footer_hide',true) != '') { ?>
    <?php //Set widget areas classes based on user choice
        $print_on_demand_shop_widget_areas = get_theme_mod('print_on_demand_shop_footer_widget_areas', '4');
        if ($print_on_demand_shop_widget_areas == '3') {
            $print_on_demand_shop_cols = 'col-lg-4 col-md-6 col-sm-12';
        } elseif ($print_on_demand_shop_widget_areas == '4') {
            $print_on_demand_shop_cols = 'col-lg-3 col-md-6 col-sm-12';
        } elseif ($print_on_demand_shop_widget_areas == '2') {
            $print_on_demand_shop_cols = 'col-md-6 col-sm-12';
        } else {
            $print_on_demand_shop_cols = 'col-md-12 col-sm-12';
        }
    ?>
    <aside id="sidebar-footer" class="footer-wp" role="complementary">
        <div class="container">
            <div class="row">
                <div class="<?php echo esc_attr($print_on_demand_shop_cols); ?> footer-block">
                    <?php if (is_active_sidebar('footer-1')) : ?>
                        <?php dynamic_sidebar('footer-1'); ?>
                    <?php else : ?>
                        <aside id="search" class="widget pb-3" role="complementary" aria-label="<?php esc_attr_e('footer1', 'print-on-demand-shop'); ?>">
                            <h3 class="widget-title"><?php esc_html_e( 'Search', 'print-on-demand-shop' ); ?></h3>
                            <?php get_search_form(); ?>
                        </aside>
                    <?php endif; ?>
                </div>

                <div class="<?php echo esc_attr($print_on_demand_shop_cols); ?> footer-block">
                    <?php if (is_active_sidebar('footer-2')) : ?>
                        <?php dynamic_sidebar('footer-2'); ?>
                    <?php else : ?>
                        <aside id="archives" class="widget pb-3" role="complementary" aria-label="<?php esc_attr_e('footer2', 'print-on-demand-shop'); ?>">
                            <h3 class="widget-title"><?php esc_html_e( 'Archives', 'print-on-demand-shop' ); ?></h3>
                            <ul>
                                <?php wp_get_archives( array( 'type' => 'monthly' ) ); ?>
                            </ul>
                        </aside>
                    <?php endif; ?>
                </div>

                <div class="<?php echo esc_attr($print_on_demand_shop_cols); ?> footer-block">
                    <?php if (is_active_sidebar('footer-3')) : ?>
                        <?php dynamic_sidebar('footer-3'); ?>
                    <?php else : ?>
                        <aside id="meta" class="widget pb-3" role="complementary" aria-label="<?php esc_attr_e('footer3', 'print-on-demand-shop'); ?>">
                            <h3 class="widget-title"><?php esc_html_e( 'Meta', 'print-on-demand-shop' ); ?></h3>
                            <ul>
                                <?php wp_register(); ?>
                                <li><?php wp_loginout(); ?></li>
                                <?php wp_meta(); ?>
                            </ul>
                        </aside>
                    <?php endif; ?>
                </div>

                <div class="<?php echo esc_attr($print_on_demand_shop_cols); ?> footer-block">
                    <?php if (is_active_sidebar('footer-4')) : ?>
                        <?php dynamic_sidebar('footer-4'); ?>
                    <?php else : ?>
                        <aside id="categories" class="widget pb-3" role="complementary" aria-label="<?php esc_attr_e('footer4', 'print-on-demand-shop'); ?>">
                            <h3 class="widget-title"><?php esc_html_e( 'Categories', 'print-on-demand-shop' ); ?></h3>
                            <ul>
                                <?php wp_list_categories('title_li=');  ?>
                            </ul>
                        </aside>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </aside>
    <?php }?>
    <?php if( get_theme_mod( 'print_on_demand_shop_copyright_hide',true) != '') { ?>
        <div class="copyright-wrapper py-3 px-0">
            <div class="container">
                <p><?php print_on_demand_shop_credit(); ?> <?php echo esc_html__(get_theme_mod('print_on_demand_shop_footer_copy',__('By Buywptemplate','print-on-demand-shop'))); ?></p>
                <?php if( get_theme_mod( 'print_on_demand_shop_footer_social_hide', false) != '') { ?>
                    <?php if(get_theme_mod('print_on_demand_shop_footer_facebook_url') != '' || get_theme_mod('print_on_demand_shop_footer_instagram_url') != '' || get_theme_mod('print_on_demand_shop_footer_twitter_url') != '' || get_theme_mod('print_on_demand_shop_footer_linkedin_url') != ''){ ?>
                        <div class="socialicons mt-2">
                            <?php if(get_theme_mod('print_on_demand_shop_footer_facebook_url') != ''){ ?>
                                <a target="_blank" href="<?php echo esc_url(get_theme_mod('print_on_demand_shop_footer_facebook_url')); ?>"><i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_footer_facebook_icon','fab fa-facebook-f')); ?>"></i><span class="screen-reader-text"><?php echo esc_html('Facebook', 'print-on-demand-shop'); ?></span></a>
                            <?php }?>
                            <?php if(get_theme_mod('print_on_demand_shop_footer_instagram_url') != ''){ ?>
                                <a target="_blank" href="<?php echo esc_url(get_theme_mod('print_on_demand_shop_footer_instagram_url')); ?>"><i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_footer_instagram_icon','fab fa-instagram')); ?>"></i><span class="screen-reader-text"><?php echo esc_html('Instagram', 'print-on-demand-shop'); ?></span></a>
                            <?php }?>
                            <?php if(get_theme_mod('print_on_demand_shop_footer_twitter_url') != ''){ ?>
                                <a target="_blank" href="<?php echo esc_url(get_theme_mod('print_on_demand_shop_footer_twitter_url')); ?>"><i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_footer_twitter_icon','fab fa-twitter')); ?>"></i><span class="screen-reader-text"><?php echo esc_html('Twitter', 'print-on-demand-shop'); ?></span></a>
                            <?php }?>
                            <?php if(get_theme_mod('print_on_demand_shop_footer_linkedin_url') != ''){ ?>
                                <a target="_blank" href="<?php echo esc_url(get_theme_mod('print_on_demand_shop_footer_linkedin_url')); ?>"><i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_footer_linkedin_icon','fa-brands fa-linkedin-in')); ?>"></i><span class="screen-reader-text"><?php echo esc_html('Youtube', 'print-on-demand-shop'); ?></span></a>
                            <?php }?>
                        </div>
                    <?php }?>
                <?php }?>
            </div>
            </div>
            <div class="clear"></div>
        </div>
    <?php }?>
</footer>

<?php wp_footer(); ?>

</body>
</html>
