<?php
/**
 * The Header for our theme.
 * @package Print On Demand Shop
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta name="viewport" content="width=device-width">
  <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
  <?php if ( function_exists( 'wp_body_open' ) ) {
    wp_body_open();
  } else {
    do_action( 'wp_body_open' );
  } ?>
  <?php if(get_theme_mod('print_on_demand_shop_preloader',false) != '' || get_theme_mod( 'print_on_demand_shop_display_preloader',false) != ''){ ?>
    <div class="frame w-100 h-100">
      <div class="loader">
        <div class="dot-1"></div>
        <div class="dot-2"></div>
        <div class="dot-3"></div>
      </div>
    </div>
  <?php }?>
<header role="banner" class="header-box">
  <a class="screen-reader-text skip-link" href="#skip_content"><?php esc_html_e( 'Skip to content', 'print-on-demand-shop' ); ?></a>
  <div class="top-header">
    <div class="container">
      <div class="row">
        <div class="col-xxl-4 col-xl-4 col-lg-5 col-md-6 col-12 logo-box">
          <div class="logo">
            <div class="row">
              <div class="<?php if( get_theme_mod( 'print_on_demand_shop_site_logo_inline') != '') { ?>col-lg-5 col-md-5 col-5<?php } else { ?>col-lg-12 col-md-12 align-self-center<?php } ?>">
                <?php if ( has_custom_logo() ) : ?>
                  <div class="site-logo"><?php the_custom_logo(); ?></div>
                <?php endif; ?>
              </div>
              <div class="<?php if( get_theme_mod( 'print_on_demand_shop_site_logo_inline') != '') { ?>col-lg-7 col-md-7 col-7 site-logo-inline"<?php } else { ?>col-lg-12 col-md-12 align-self-center<?php } ?>">
                <?php $print_on_demand_shop_blog_info = get_bloginfo( 'name' ); ?>
                <?php if ( ! empty( $print_on_demand_shop_blog_info ) ) : ?>
                  <?php if( get_theme_mod('print_on_demand_shop_site_title_enable',true) != ''){ ?>
                    <?php if ( is_front_page() && is_home() ) : ?>
                      <h1 class="site-title pb-0"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                    <?php else : ?>
                      <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                    <?php endif; ?>
                  <?php }?>
                <?php endif; ?>
                <?php
                $print_on_demand_shop_description = get_bloginfo( 'description', 'display' );
                if ( $print_on_demand_shop_description || is_customize_preview() ) : ?>
                  <?php if( get_theme_mod('print_on_demand_shop_site_tagline_enable',false) != ''){ ?>
                    <p class="site-description"><?php echo esc_html($print_on_demand_shop_description); ?></p>
                  <?php }?>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
        <div class="col-xxl-7 col-xl-7 col-lg-6 col-md-4 col-6 align-self-center menu-box">
          <div class="navigation-header">
            <div class="toggle-nav mobile-menu">
              <button onclick="print_on_demand_shop_openNav()"><i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_responsive_menu_open_icon','fas fa-bars')); ?>"></i></button>
            </div>
            <div id="mySidenav" class="nav sidenav">
              <nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'print-on-demand-shop' ); ?>">
                <?php {
                  wp_nav_menu(
                    array(
                      'theme_location' => 'primary',
                      'menu_class'     => 'menu', 
                      'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                      'fallback_cb' => 'wp_page_menu',
                    )
                  );
                } ?>
              </nav>
              <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="print_on_demand_shop_closeNav()"><i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_responsive_menu_close_icon','fas fa-times')); ?>"></i></a>
            </div>
          </div>
        </div>
        <div class="col-xxl-1 col-xl-1 col-lg-1 col-md-2 col-6 align-self-center btn-box text-lg-end text-center">
          <div class="header-icons d-flex justify-content-lg-end justify-content-md-end justify-content-center gap-4">
            <?php if(class_exists('woocommerce')):?>
              <div class="main-search d-inline-block">
                <span><a href="#"><i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_header_search_icon','fas fa-search')); ?>"></i></a></span>
              </div>
              <div class="searchform_page w-100 h-100">
                <div class="close w-100 text-end me-lg-4 me-3"><a href="#maincontent"><i class="fa fa-times"></i></a></div>
                  <div class="header-search">
                    <?php get_product_search_form(); ?>
                  </div>
              </div>
            <?php else : ?>
              <div class="main-search d-inline-block">
                <span><a href="#"><i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_header_search_icon','fas fa-search')); ?>"></i></a></span>
              </div>
              <div class="searchform_page w-100 h-100">
                <div class="close w-100 text-end me-lg-4 me-3"><a href="#maincontent"><i class="fa fa-times"></i></a></div>
                <div class="search_input">
                  <?php get_search_form(); ?>
                </div>
              </div>
            <?php endif; ?>
            <?php if ( defined('YITH_WCWL') ) { ?>
              <div class="wishlist">
                <a class="wishlist_view" href="<?php echo YITH_WCWL()->get_wishlist_url(); ?>" title="<?php esc_attr_e('Wishlist','print-on-demand-shop'); ?>">
                  <i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_header_wishlist_icon','fa-solid fa-heart')); ?>"></i>
                </a>
              </div>
            <?php } ?>
            <?php if ( class_exists( 'WooCommerce' ) != '' ) {?>
              <div class="cart-box">
                <a href="<?php echo esc_url(wc_get_cart_url()); ?>" title="<?php esc_attr_e('shopping cart','print-on-demand-shop'); ?>">
                  <i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_header_cart_icon','fa-solid fa-cart-shopping')); ?>"></i>
                  <span class="screen-reader-text"><?php esc_html_e('Shopping Cart','print-on-demand-shop'); ?></span>
                </a>
              </div>
            <?php } ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>
