<?php
/**
 * @package Print On Demand Shop
 * @subpackage print-on-demand-shop
 * @since print-on-demand-shop 1.0
 * Setup the WordPress core custom header feature.
 * @uses print_on_demand_shop_header_style()
*/

function print_on_demand_shop_custom_header_setup() {

	add_theme_support( 'custom-header', apply_filters( 'print_on_demand_shop_custom_header_args', array(
		'default-text-color'     => 'fff',
		'header-text' 			 =>	false,
		'width'                  => 1920,
		'height'                 => 300,
		'flex-width'         	=> true,
        'flex-height'        	=> true,
		'wp-head-callback'       => 'print_on_demand_shop_header_style',
	) ) );
}

add_action( 'after_setup_theme', 'print_on_demand_shop_custom_header_setup' );

if ( ! function_exists( 'print_on_demand_shop_header_style' ) ) :

add_action( 'wp_enqueue_scripts', 'print_on_demand_shop_header_style' );
function print_on_demand_shop_header_style() {
	$print_on_demand_shop_header_image = get_header_image() ? get_header_image() : get_template_directory_uri() . '/images/header-image.png';
	$print_on_demand_shop_custom_css = "
        .banner-image-box .top-header-img{
			background-image:url('" . esc_url($print_on_demand_shop_header_image) . "');
			background-repeat: no-repeat;
	        background-position: center center;
	        background-size: cover !important;
	        height: 300px;
		}";
	   	wp_add_inline_style( 'print-on-demand-shop-basic-style', $print_on_demand_shop_custom_css );
}
endif;