<?php
/**
 * Print On Demand Shop Theme Customizer
 * @package Print On Demand Shop
 */

load_template( trailingslashit( get_template_directory() ) . '/inc/logo-sizer.php' );
/**
 * Add postMessage support for site title and description for the Theme Customizer.
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function print_on_demand_shop_customize_register( $wp_customize ) {

	load_template( trailingslashit( get_template_directory() ) . 'inc/custom-control.php' );
	load_template( trailingslashit( get_template_directory() ) . '/inc/icon-changer.php' );

	$wp_customize->add_setting( 'print_on_demand_shop_logo_sizer',array(
		'default' => '',
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_logo_sizer',array(
		'label' => esc_html__( 'Logo Sizer','print-on-demand-shop' ),
		'section' => 'title_tagline',
		'priority'    => 9,
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
			'step' => 1,
		),
	))); 

	$wp_customize->add_setting('print_on_demand_shop_site_title_enable',array(
		'default' => true,
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_site_title_enable',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Site Title','print-on-demand-shop'),
		'section' => 'title_tagline'
	));

 	$wp_customize->add_setting('print_on_demand_shop_site_title_font_size',array(
		'default'=> 25,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_site_title_font_size',array(
		'label' => esc_html__( 'Site Title Font Size (px)','print-on-demand-shop' ),
		'section'=> 'title_tagline',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 50,
      ),
	))); 

	// site title color
   $wp_customize->add_setting('print_on_demand_shop_site_title_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_site_title_color', array(
		'label'    => __('Site Title Color', 'print-on-demand-shop'),
		'section'  => 'title_tagline',
		'settings' => 'print_on_demand_shop_site_title_color',
	)));

   $wp_customize->add_setting('print_on_demand_shop_site_tagline_enable',array(
      'default' => false,
      'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
   ));
   $wp_customize->add_control('print_on_demand_shop_site_tagline_enable',array(
      'type' => 'checkbox',
      'label' => __('Enable / Disable Site Tagline','print-on-demand-shop'),
      'section' => 'title_tagline'
   ));

   $wp_customize->add_setting('print_on_demand_shop_site_tagline_font_size',array(
		'default'=> 13,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_site_tagline_font_size',array(
		'label' => esc_html__( 'Site Tagline Font Size (px)','print-on-demand-shop' ),
		'section'=> 'title_tagline',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
	)));

	// site tagline color
	$wp_customize->add_setting('print_on_demand_shop_site_tagline_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_site_tagline_color', array(
		'label'    => __('Site Tagline Color', 'print-on-demand-shop'),
		'section'  => 'title_tagline',
		'settings' => 'print_on_demand_shop_site_tagline_color',
	)));

    $wp_customize->add_setting('print_on_demand_shop_site_logo_inline',array(
       'default' => false,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control('print_on_demand_shop_site_logo_inline',array(
       'type' => 'checkbox',
       'label' => __('Site logo inline with site title','print-on-demand-shop'),
       'section' => 'title_tagline',
    ));

    $wp_customize->add_setting('print_on_demand_shop_background_skin',array(
        'default' => 'Without Background',
        'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_background_skin',array(
        'type' => 'radio',
        'label' => __('Background Skin','print-on-demand-shop'),
        'description' => __('Here you can add the background skin along with the background image.','print-on-demand-shop'),
        'section' => 'background_image',
        'choices' => array(
            'With Background' => __('With Background Skin','print-on-demand-shop'),
            'Without Background' => __('Without Background Skin','print-on-demand-shop'),
        ),
	) );

	//Important Links
	$wp_customize->add_section( 'print_on_demand_shop_important_links' , array(
    	'title' => esc_html__( 'Important Links', 'print-on-demand-shop' ),
    	'priority' => 10,
	) );

	$wp_customize->add_setting('print_on_demand_shop_doc_link',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_doc_link',array(
		'type'=> 'hidden',
		'description' => "<a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_FREE_DOC) ." '>". esc_html__('Documentation','print-on-demand-shop') ."</a>",
		'section'=> 'print_on_demand_shop_important_links'
	));

	$wp_customize->add_setting('print_on_demand_shop_demo_links',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_demo_links',array(
		'type'=> 'hidden',
		'description' => "<a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_LIVE_DEMO) ." '>". esc_html__('Demo','print-on-demand-shop') ."</a>",
		'section'=> 'print_on_demand_shop_important_links'
	));

	$wp_customize->add_setting('print_on_demand_shop_forum_links',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_forum_links',array(
		'type'=> 'hidden',
		'description' => "<a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_FREE_SUPPORT) ." '>". esc_html__('Support Forum','print-on-demand-shop') ."</a>",
		'section'=> 'print_on_demand_shop_important_links'
	));
	$wp_customize->add_setting('print_on_demand_shop_review_links',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_review_links',array(
		'type'=> 'hidden',
		'description' => "<a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_REVIEW) ." '>". esc_html__('Review','print-on-demand-shop') ."</a>",
		'section'=> 'print_on_demand_shop_important_links'
	));

	//add home page setting pannel
	$wp_customize->add_panel( 'print_on_demand_shop_panel_id', array(
	   'priority' => 11,
	   'capability' => 'edit_theme_options',
	   'theme_supports' => '',
	   'title' => __( 'Theme Settings', 'print-on-demand-shop' ),
	   'description' => __( 'Description of what this panel does.', 'print-on-demand-shop' ),
	) );

	$print_on_demand_shop_font_array = array(
		''                       => 'No Fonts',
		'Abril Fatface'          => 'Abril Fatface',
		'Acme'                   => 'Acme',
		'Anton'                  => 'Anton',
		'Architects Daughter'    => 'Architects Daughter',
		'Arimo'                  => 'Arimo',
		'Arsenal'                => 'Arsenal',
		'Arvo'                   => 'Arvo',
		'Alegreya'               => 'Alegreya',
		'Alfa Slab One'          => 'Alfa Slab One',
		'Averia Serif Libre'     => 'Averia Serif Libre',
		'Bangers'                => 'Bangers',
		'Boogaloo'               => 'Boogaloo',
		'Bad Script'             => 'Bad Script',
		'Bitter'                 => 'Bitter',
		'Bree Serif'             => 'Bree Serif',
		'BenchNine'              => 'BenchNine',
		'Cabin'                  => 'Cabin',
		'Cardo'                  => 'Cardo',
		'Courgette'              => 'Courgette',
		'Cherry Swash'           => 'Cherry Swash',
		'Cormorant Garamond'     => 'Cormorant Garamond',
		'Crimson Text'           => 'Crimson Text',
		'Cuprum'                 => 'Cuprum',
		'Cookie'                 => 'Cookie',
		'Chewy'                  => 'Chewy',
		'Days One'               => 'Days One',
		'Dosis'                  => 'Dosis',
		'Droid Sans'             => 'Droid Sans',
		'Economica'              => 'Economica',
		'Fredoka One'            => 'Fredoka One',
		'Fjalla One'             => 'Fjalla One',
		'Francois One'           => 'Francois One',
		'Frank Ruhl Libre'       => 'Frank Ruhl Libre',
		'Gloria Hallelujah'      => 'Gloria Hallelujah',
		'Great Vibes'            => 'Great Vibes',
		'Handlee'                => 'Handlee',
		'Hammersmith One'        => 'Hammersmith One',
		'Inconsolata'            => 'Inconsolata',
		'Indie Flower'           => 'Indie Flower',
		'IM Fell English SC'     => 'IM Fell English SC',
		'Julius Sans One'        => 'Julius Sans One',
		'Josefin Slab'           => 'Josefin Slab',
		'Josefin Sans'           => 'Josefin Sans',
		'Kanit'                  => 'Kanit',
		'Lobster'                => 'Lobster',
		'Lato'                   => 'Lato',
		'Lora'                   => 'Lora',
		'Libre Baskerville'      => 'Libre Baskerville',
		'Lobster Two'            => 'Lobster Two',
		'Merriweather'           => 'Merriweather',
		'Monda'                  => 'Monda',
		'Montserrat'             => 'Montserrat',
		'Muli'                   => 'Muli',
		'Marck Script'           => 'Marck Script',
		'Noto Serif'             => 'Noto Serif',
		'Open Sans'              => 'Open Sans',
		'Overpass'               => 'Overpass',
		'Overpass Mono'          => 'Overpass Mono',
		'Oxygen'                 => 'Oxygen',
		'Orbitron'               => 'Orbitron',
		'Patua One'              => 'Patua One',
		'Pacifico'               => 'Pacifico',
		'Padauk'                 => 'Padauk',
		'Playball'               => 'Playball',
		'Playfair Display'       => 'Playfair Display',
		'PT Sans'                => 'PT Sans',
		'Philosopher'            => 'Philosopher',
		'Permanent Marker'       => 'Permanent Marker',
		'Poiret One'             => 'Poiret One',
		'Quicksand'              => 'Quicksand',
		'Quattrocento Sans'      => 'Quattrocento Sans',
		'Raleway'                => 'Raleway',
		'Rubik'                  => 'Rubik',
		'Rokkitt'                => 'Rokkitt',
		'Russo One'              => 'Russo One',
		'Righteous'              => 'Righteous',
		'Slabo'                  => 'Slabo',
		'Source Sans Pro'        => 'Source Sans Pro',
		'Shadows Into Light Two' => 'Shadows Into Light Two',
		'Shadows Into Light'     => 'Shadows Into Light',
		'Sacramento'             => 'Sacramento',
		'Shrikhand'              => 'Shrikhand',
		'Tangerine'              => 'Tangerine',
		'Ubuntu'                 => 'Ubuntu',
		'VT323'                  => 'VT323',
		'Varela Round'           => 'Varela Round',
		'Vampiro One'            => 'Vampiro One',
		'Vollkorn'               => 'Vollkorn',
		'Volkhov'                => 'Volkhov',
		'Yanone Kaffeesatz'      => 'Yanone Kaffeesatz'
	);

	//Typography
	$wp_customize->add_section('print_on_demand_shop_typography', array(
		'title'    => __('Typography', 'print-on-demand-shop'),
		'panel'    => 'print_on_demand_shop_panel_id',
	));

	$wp_customize->add_setting('print_on_demand_shop_typography_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_typography_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','print-on-demand-shop'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
   		 'section'=> 'print_on_demand_shop_typography'
 	));

	//This is body FontFamily picker setting
	$wp_customize->add_setting('print_on_demand_shop_body_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_body_color', array(
		'label'    => __('Body Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_typography',
		'settings' => 'print_on_demand_shop_body_color',
	)));

	$wp_customize->add_setting('print_on_demand_shop_body_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control(	'print_on_demand_shop_body_font_family', array(
		'section' => 'print_on_demand_shop_typography',
		'label'   => __('Body Fonts', 'print-on-demand-shop'),
		'type'    => 'select',
		'choices' => $print_on_demand_shop_font_array,
	));

	$wp_customize->add_setting('print_on_demand_shop_body_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('print_on_demand_shop_body_font_size', array(
		'label'   => __('Body Font Size', 'print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'setting' => 'print_on_demand_shop_body_font_size',
		'type'    => 'text',
	));

	$wp_customize->add_setting('print_on_demand_shop_body_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
 	));
 	$wp_customize->add_control('print_on_demand_shop_body_font_weight',array(
		'type' => 'select',
		'label' => __('Body Font Weight','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'choices' => array(
		   '100' => __('100','print-on-demand-shop'),
         '200' => __('200','print-on-demand-shop'),
         '300' => __('300','print-on-demand-shop'),
         '400' => __('400','print-on-demand-shop'),
         '500' => __('500','print-on-demand-shop'),
         '600' => __('600','print-on-demand-shop'),
         '700' => __('700','print-on-demand-shop'),
         '800' => __('800','print-on-demand-shop'),
         '900' => __('900','print-on-demand-shop'),
		),
	) );	

	// This is Paragraph Color picker setting
	$wp_customize->add_setting('print_on_demand_shop_paragraph_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_paragraph_color', array(
		'label'    => __('Paragraph Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_typography',
		'settings' => 'print_on_demand_shop_paragraph_color',
	)));

	//This is Paragraph FontFamily picker setting
	$wp_customize->add_setting('print_on_demand_shop_paragraph_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control(	'print_on_demand_shop_paragraph_font_family', array(
		'section' => 'print_on_demand_shop_typography',
		'label'   => __('Paragraph Fonts', 'print-on-demand-shop'),
		'type'    => 'select',
		'choices' => $print_on_demand_shop_font_array,
	));

	$wp_customize->add_setting('print_on_demand_shop_paragraph_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('print_on_demand_shop_paragraph_font_size', array(
		'label'   => __('Paragraph Font Size', 'print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'setting' => 'print_on_demand_shop_paragraph_font_size',
		'type'    => 'text',
	));

	$wp_customize->add_setting('print_on_demand_shop_paragraph_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
 	));
 	$wp_customize->add_control('print_on_demand_shop_paragraph_font_weight',array(
		'type' => 'select',
		'label' => __('Paragraph Font Weight','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'choices' => array(
		   '100' => __('100','print-on-demand-shop'),
         '200' => __('200','print-on-demand-shop'),
         '300' => __('300','print-on-demand-shop'),
         '400' => __('400','print-on-demand-shop'),
         '500' => __('500','print-on-demand-shop'),
         '600' => __('600','print-on-demand-shop'),
         '700' => __('700','print-on-demand-shop'),
         '800' => __('800','print-on-demand-shop'),
         '900' => __('900','print-on-demand-shop'),
		),
	) );		

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting('print_on_demand_shop_atag_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_atag_color', array(
		'label'    => __('"a" Tag Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_typography',
		'settings' => 'print_on_demand_shop_atag_color',
	)));

	//This is "a" Tag FontFamily picker setting
	$wp_customize->add_setting('print_on_demand_shop_atag_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control(	'print_on_demand_shop_atag_font_family', array(
		'section' => 'print_on_demand_shop_typography',
		'label'   => __('"a" Tag Fonts', 'print-on-demand-shop'),
		'type'    => 'select',
		'choices' => $print_on_demand_shop_font_array,
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting('print_on_demand_shop_li_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_li_color', array(
		'label'    => __('"li" Tag Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_typography',
		'settings' => 'print_on_demand_shop_li_color',
	)));

	//This is "li" Tag FontFamily picker setting
	$wp_customize->add_setting('print_on_demand_shop_li_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control(	'print_on_demand_shop_li_font_family', array(
		'section' => 'print_on_demand_shop_typography',
		'label'   => __('"li" Tag Fonts', 'print-on-demand-shop'),
		'type'    => 'select',
		'choices' => $print_on_demand_shop_font_array,
	));

	// This is H1 Color picker setting
	$wp_customize->add_setting('print_on_demand_shop_h1_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_h1_color', array(
		'label'    => __('H1 Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_typography',
		'settings' => 'print_on_demand_shop_h1_color',
	)));

	//This is H1 FontFamily picker setting
	$wp_customize->add_setting('print_on_demand_shop_h1_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control('print_on_demand_shop_h1_font_family', array(
		'section' => 'print_on_demand_shop_typography',
		'label'   => __('H1 Fonts', 'print-on-demand-shop'),
		'type'    => 'select',
		'choices' => $print_on_demand_shop_font_array,
	));

	//This is H1 FontSize setting
	$wp_customize->add_setting('print_on_demand_shop_h1_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('print_on_demand_shop_h1_font_size', array(
		'label'   => __('H1 Font Size', 'print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'setting' => 'print_on_demand_shop_h1_font_size',
		'type'    => 'text',
	));

	//This is H1 FontWeight setting	
	$wp_customize->add_setting('print_on_demand_shop_h1_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
 	));
 	$wp_customize->add_control('print_on_demand_shop_h1_font_weight',array(
		'type' => 'select',
		'label' => __('H1 Font Weight','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'choices' => array(
		   '100' => __('100','print-on-demand-shop'),
         '200' => __('200','print-on-demand-shop'),
         '300' => __('300','print-on-demand-shop'),
         '400' => __('400','print-on-demand-shop'),
         '500' => __('500','print-on-demand-shop'),
         '600' => __('600','print-on-demand-shop'),
         '700' => __('700','print-on-demand-shop'),
         '800' => __('800','print-on-demand-shop'),
         '900' => __('900','print-on-demand-shop'),
		),
	) );		

	// This is H2 Color picker setting
	$wp_customize->add_setting('print_on_demand_shop_h2_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_h2_color', array(
		'label'    => __('H2 Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_typography',
		'settings' => 'print_on_demand_shop_h2_color',
	)));

	//This is H2 FontFamily picker setting
	$wp_customize->add_setting('print_on_demand_shop_h2_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control(
	'print_on_demand_shop_h2_font_family', array(
		'section' => 'print_on_demand_shop_typography',
		'label'   => __('H2 Fonts', 'print-on-demand-shop'),
		'type'    => 'select',
		'choices' => $print_on_demand_shop_font_array,
	));

	//This is H2 FontSize setting
	$wp_customize->add_setting('print_on_demand_shop_h2_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('print_on_demand_shop_h2_font_size', array(
		'label'   => __('H2 Font Size', 'print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'setting' => 'print_on_demand_shop_h2_font_size',
		'type'    => 'text',
	));

	//This is H2 FontWeight setting	
	$wp_customize->add_setting('print_on_demand_shop_h2_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
 	));
 	$wp_customize->add_control('print_on_demand_shop_h2_font_weight',array(
		'type' => 'select',
		'label' => __('H2 Font Weight','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'choices' => array(
		   '100' => __('100','print-on-demand-shop'),
         '200' => __('200','print-on-demand-shop'),
         '300' => __('300','print-on-demand-shop'),
         '400' => __('400','print-on-demand-shop'),
         '500' => __('500','print-on-demand-shop'),
         '600' => __('600','print-on-demand-shop'),
         '700' => __('700','print-on-demand-shop'),
         '800' => __('800','print-on-demand-shop'),
         '900' => __('900','print-on-demand-shop'),
		),
	) );

	// This is H3 Color picker setting
	$wp_customize->add_setting('print_on_demand_shop_h3_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_h3_color', array(
		'label'    => __('H3 Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_typography',
		'settings' => 'print_on_demand_shop_h3_color',
	)));

	//This is H3 FontFamily picker setting
	$wp_customize->add_setting('print_on_demand_shop_h3_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control(
	'print_on_demand_shop_h3_font_family', array(
		'section' => 'print_on_demand_shop_typography',
		'label'   => __('H3 Fonts', 'print-on-demand-shop'),
		'type'    => 'select',
		'choices' => $print_on_demand_shop_font_array,
	));

	//This is H3 FontSize setting
	$wp_customize->add_setting('print_on_demand_shop_h3_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('print_on_demand_shop_h3_font_size', array(
		'label'   => __('H3 Font Size', 'print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'setting' => 'print_on_demand_shop_h3_font_size',
		'type'    => 'text',
	));

	//This is H3 FontWeight setting	
	$wp_customize->add_setting('print_on_demand_shop_h3_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
 	));
 	$wp_customize->add_control('print_on_demand_shop_h3_font_weight',array(
		'type' => 'select',
		'label' => __('H3 Font Weight','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'choices' => array(
		   '100' => __('100','print-on-demand-shop'),
         '200' => __('200','print-on-demand-shop'),
         '300' => __('300','print-on-demand-shop'),
         '400' => __('400','print-on-demand-shop'),
         '500' => __('500','print-on-demand-shop'),
         '600' => __('600','print-on-demand-shop'),
         '700' => __('700','print-on-demand-shop'),
         '800' => __('800','print-on-demand-shop'),
         '900' => __('900','print-on-demand-shop'),
		),
	) );	

	// This is H4 Color picker setting
	$wp_customize->add_setting('print_on_demand_shop_h4_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_h4_color', array(
		'label'    => __('H4 Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_typography',
		'settings' => 'print_on_demand_shop_h4_color',
	)));

	//This is H4 FontFamily picker setting
	$wp_customize->add_setting('print_on_demand_shop_h4_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control('print_on_demand_shop_h4_font_family', array(
		'section' => 'print_on_demand_shop_typography',
		'label'   => __('H4 Fonts', 'print-on-demand-shop'),
		'type'    => 'select',
		'choices' => $print_on_demand_shop_font_array,
	));

	//This is H4 FontSize setting
	$wp_customize->add_setting('print_on_demand_shop_h4_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('print_on_demand_shop_h4_font_size', array(
		'label'   => __('H4 Font Size', 'print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'setting' => 'print_on_demand_shop_h4_font_size',
		'type'    => 'text',
	));

	//This is H4 FontWeight setting	
	$wp_customize->add_setting('print_on_demand_shop_h4_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
 	));
 	$wp_customize->add_control('print_on_demand_shop_h4_font_weight',array(
		'type' => 'select',
		'label' => __('H4 Font Weight','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'choices' => array(
		   '100' => __('100','print-on-demand-shop'),
         '200' => __('200','print-on-demand-shop'),
         '300' => __('300','print-on-demand-shop'),
         '400' => __('400','print-on-demand-shop'),
         '500' => __('500','print-on-demand-shop'),
         '600' => __('600','print-on-demand-shop'),
         '700' => __('700','print-on-demand-shop'),
         '800' => __('800','print-on-demand-shop'),
         '900' => __('900','print-on-demand-shop'),
		),
	) );	

	// This is H5 Color picker setting
	$wp_customize->add_setting('print_on_demand_shop_h5_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_h5_color', array(
		'label'    => __('H5 Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_typography',
		'settings' => 'print_on_demand_shop_h5_color',
	)));

	//This is H5 FontFamily picker setting
	$wp_customize->add_setting('print_on_demand_shop_h5_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control('print_on_demand_shop_h5_font_family', array(
		'section' => 'print_on_demand_shop_typography',
		'label'   => __('H5 Fonts', 'print-on-demand-shop'),
		'type'    => 'select',
		'choices' => $print_on_demand_shop_font_array,
	));

	//This is H5 FontSize setting
	$wp_customize->add_setting('print_on_demand_shop_h5_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('print_on_demand_shop_h5_font_size', array(
		'label'   => __('H5 Font Size', 'print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'setting' => 'print_on_demand_shop_h5_font_size',
		'type'    => 'text',
	));

	//This is H5 FontWeight setting	
	$wp_customize->add_setting('print_on_demand_shop_h5_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
 	));
 	$wp_customize->add_control('print_on_demand_shop_h5_font_weight',array(
		'type' => 'select',
		'label' => __('H5 Font Weight','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'choices' => array(
		   '100' => __('100','print-on-demand-shop'),
         '200' => __('200','print-on-demand-shop'),
         '300' => __('300','print-on-demand-shop'),
         '400' => __('400','print-on-demand-shop'),
         '500' => __('500','print-on-demand-shop'),
         '600' => __('600','print-on-demand-shop'),
         '700' => __('700','print-on-demand-shop'),
         '800' => __('800','print-on-demand-shop'),
         '900' => __('900','print-on-demand-shop'),
		),
	) );	

	// This is H6 Color picker setting
	$wp_customize->add_setting('print_on_demand_shop_h6_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_h6_color', array(
		'label'    => __('H6 Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_typography',
		'settings' => 'print_on_demand_shop_h6_color',
	)));

	//This is H6 FontFamily picker setting
	$wp_customize->add_setting('print_on_demand_shop_h6_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control('print_on_demand_shop_h6_font_family', array(
		'section' => 'print_on_demand_shop_typography',
		'label'   => __('H6 Fonts', 'print-on-demand-shop'),
		'type'    => 'select',
		'choices' => $print_on_demand_shop_font_array,
	));

	//This is H6 FontSize setting
	$wp_customize->add_setting('print_on_demand_shop_h6_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('print_on_demand_shop_h6_font_size', array(
		'label'   => __('H6 Font Size', 'print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'setting' => 'print_on_demand_shop_h6_font_size',
		'type'    => 'text',
	));

	//This is H6 FontWeight setting	
	$wp_customize->add_setting('print_on_demand_shop_h6_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
 	));
 	$wp_customize->add_control('print_on_demand_shop_h6_font_weight',array(
		'type' => 'select',
		'label' => __('H6 Font Weight','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_typography',
		'choices' => array(
		   '100' => __('100','print-on-demand-shop'),
         '200' => __('200','print-on-demand-shop'),
         '300' => __('300','print-on-demand-shop'),
         '400' => __('400','print-on-demand-shop'),
         '500' => __('500','print-on-demand-shop'),
         '600' => __('600','print-on-demand-shop'),
         '700' => __('700','print-on-demand-shop'),
         '800' => __('800','print-on-demand-shop'),
         '900' => __('900','print-on-demand-shop'),
		),
	) );	

 	//Header Section
	$wp_customize->add_section('print_on_demand_shop_header_section',array(
		'title'	=> __('Header','print-on-demand-shop'),
		'description'	=> __('Add Header here','print-on-demand-shop'),
		'priority'	=> null,
		'panel' => 'print_on_demand_shop_panel_id',
	));

	$wp_customize->add_setting('print_on_demand_shop_header_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_header_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','print-on-demand-shop'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
   		 'section'=> 'print_on_demand_shop_header_section'
 	));

	$wp_customize->add_setting('print_on_demand_shop_header_search_icon',array(
		'default'	=> 'fas fa-search',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_header_search_icon',array(
		'label'	=> __('Search Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_header_section',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('print_on_demand_shop_header_wishlist_icon',array(
		'default'	=> 'fa-solid fa-heart',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_header_wishlist_icon',array(
		'label'	=> __('Wishlist Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_header_section',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('print_on_demand_shop_header_cart_icon',array(
		'default'	=> 'fa-solid fa-cart-shopping',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_header_cart_icon',array(
		'label'	=> __('Cart Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_header_section',
		'type'		=> 'icon'
	)));

 	//Menu Section
	$wp_customize->add_section('print_on_demand_shop_menu_section',array(
		'title'	=> __('Menu Settings','print-on-demand-shop'),
		'priority'	=> null,
		'panel' => 'print_on_demand_shop_panel_id',
	));

	$wp_customize->add_setting('print_on_demand_shop_menu_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_menu_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','print-on-demand-shop'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
   		 'section'=> 'print_on_demand_shop_menu_section'
 	));

	$wp_customize->add_setting('print_on_demand_shop_menu_font_size_option',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize,'print_on_demand_shop_menu_font_size_option',array(
		'label'	=> __('Menu Font Size','print-on-demand-shop'),
		'section'=> 'print_on_demand_shop_menu_section',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 50,
     	),
	)));

	$wp_customize->add_setting('print_on_demand_shop_menu_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize,'print_on_demand_shop_menu_padding',array(
		'label'	=> __('Main Menu Padding','print-on-demand-shop'),
		'section'=> 'print_on_demand_shop_menu_section',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 50,
      ),
	)));

	$wp_customize->add_setting('print_on_demand_shop_font_weight_option_menu',array(
		'default' => '600',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
 	));
 	$wp_customize->add_control('print_on_demand_shop_font_weight_option_menu',array(
		'type' => 'select',
		'label' => __('Menu Font Weight','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_menu_section',
		'choices' => array(
		   '100' => __('100','print-on-demand-shop'),
         '200' => __('200','print-on-demand-shop'),
         '300' => __('300','print-on-demand-shop'),
         '400' => __('400','print-on-demand-shop'),
         '500' => __('500','print-on-demand-shop'),
         '600' => __('600','print-on-demand-shop'),
         '700' => __('700','print-on-demand-shop'),
         '800' => __('800','print-on-demand-shop'),
         '900' => __('900','print-on-demand-shop'),
		),
	) );

	$wp_customize->add_setting('print_on_demand_shop_menu_text_tranform',array(
		'default' => 'Capitalize',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
 	));
 	$wp_customize->add_control('print_on_demand_shop_menu_text_tranform',array(
		'type' => 'select',
		'label' => __('Menu Text Transform','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_menu_section',
		'choices' => array(
		   'Uppercase' => __('Uppercase','print-on-demand-shop'),
		   'Lowercase' => __('Lowercase','print-on-demand-shop'),
		   'Capitalize' => __('Capitalize','print-on-demand-shop'),
		),
	) );

	$wp_customize->add_setting('print_on_demand_shop_menus_item_style',array(
        'default' => '',
        'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_menus_item_style',array(
      'type' => 'select',
		'label' => __('Menu Item Hover Style','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_menu_section',
		'choices' => array(
         'None' => __('None','print-on-demand-shop'),
         'Zoom In' => __('Zoom In','print-on-demand-shop'),
      ),
	));

	$wp_customize->add_setting('print_on_demand_shop_sub_menu_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_sub_menu_hover_color', array(
		'label'    => __('Submenu Hover Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_menu_section',
		'settings' => 'print_on_demand_shop_sub_menu_hover_color',
	)));

	$wp_customize->add_setting('print_on_demand_shop_menu_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_menu_color', array(
		'label'    => __('Menu Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_menu_section',
		'settings' => 'print_on_demand_shop_menu_color',
	)));

	$wp_customize->add_setting('print_on_demand_shop_sub_menu_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_sub_menu_color', array(
		'label'    => __('Submenu Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_menu_section',
		'settings' => 'print_on_demand_shop_sub_menu_color',
	)));

	$wp_customize->add_setting('print_on_demand_shop_menu_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_menu_hover_color', array(
		'label'    => __('Menu Hover Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_menu_section',
		'settings' => 'print_on_demand_shop_menu_hover_color',
	)));

	//Banner Section
	$wp_customize->add_section( 'print_on_demand_shop_banner_section' , array(
    	'title'      => __( 'Banner Section', 'print-on-demand-shop' ),
		'priority'   => null,
		'panel' => 'print_on_demand_shop_panel_id'
	) );

	$wp_customize->add_setting('print_on_demand_shop_banner_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_banner_premium_info',array(
		'type'=> 'hidden',
		'label' => __('Premium Features','print-on-demand-shop'),
		'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
		'section'=> 'print_on_demand_shop_banner_section'
 	));

	$wp_customize->add_setting('print_on_demand_shop_banner_hide',array(
		'default' => false,
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_banner_hide',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Banner','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_banner_section',
	));

 	$wp_customize->add_setting('print_on_demand_shop_banner_small_title',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_banner_small_title',array(
		'label'	=> __('Banner Small Title','print-on-demand-shop'),
		'section'	=> 'print_on_demand_shop_banner_section',
		'input_attrs' => array(
        'placeholder' => __( 'Print On Demand', 'print-on-demand-shop' ),
      ),
		'type'	=> 'text'
	));

 	$wp_customize->add_setting('print_on_demand_shop_banner_title',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_banner_title',array(
		'label'	=> __('Banner Title','print-on-demand-shop'),
		'section'	=> 'print_on_demand_shop_banner_section',
		'input_attrs' => array(
        'placeholder' => __( 'Bring Your Design To Life with our Professional Printing', 'print-on-demand-shop' ),
      ),
		'type'	=> 'text'
	));

 	$wp_customize->add_setting('print_on_demand_shop_banner_desc_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_banner_desc_text',array(
		'label'	=> __('Banner Content','print-on-demand-shop'),
		'section'	=> 'print_on_demand_shop_banner_section',
		'type'	=> 'text'
	));

	$wp_customize->add_setting('print_on_demand_shop_banner_btn_text1',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_banner_btn_text1',array(
		'type' => 'text',
		'label' => __('Add Button Text','print-on-demand-shop'),
		'input_attrs' => array(
        'placeholder' => __( 'Explore More', 'print-on-demand-shop' ),
      ),
		'section' => 'print_on_demand_shop_banner_section',
	) );

	$wp_customize->add_setting('print_on_demand_shop_banner_btn_url1',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw'
 	));
 	$wp_customize->add_control('print_on_demand_shop_banner_btn_url1',array(
		'type' => 'text',
		'label' => __('Add Button URL','print-on-demand-shop'),
		'input_attrs' => array(
        'placeholder' => __( 'www.example-info.com', 'print-on-demand-shop' ),
      ),
		'section' => 'print_on_demand_shop_banner_section',
	) );

	$wp_customize->add_setting('print_on_demand_shop_banner_btn_text2',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_banner_btn_text2',array(
		'type' => 'text',
		'label' => __('Add Button Text','print-on-demand-shop'),
		'input_attrs' => array(
        'placeholder' => __( 'Order Now', 'print-on-demand-shop' ),
      ),
		'section' => 'print_on_demand_shop_banner_section',
	) );

	$wp_customize->add_setting('print_on_demand_shop_banner_btn_url2',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw'
 	));
 	$wp_customize->add_control('print_on_demand_shop_banner_btn_url2',array(
		'type' => 'text',
		'label' => __('Add Button URL','print-on-demand-shop'),
		'input_attrs' => array(
        'placeholder' => __( 'www.example-info.com', 'print-on-demand-shop' ),
      ),
		'section' => 'print_on_demand_shop_banner_section',
	) );

	$wp_customize->add_setting('print_on_demand_shop_banner_bottom_title',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_banner_bottom_title',array(
		'label'	=> __('Banner Review Title','print-on-demand-shop'),
		'section'	=> 'print_on_demand_shop_banner_section',
		'input_attrs' => array(
        'placeholder' => __( 'Clients Review', 'print-on-demand-shop' ),
      ),
		'type'	=> 'text'
	));

	$wp_customize->add_setting('print_on_demand_shop_banner_bottom_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'print_on_demand_shop_banner_bottom_image',array(
      'label' => __('Banner Review Image','print-on-demand-shop'),
		'description' => __('Image Size (180px × 50px).','print-on-demand-shop'),
      'section' => 'print_on_demand_shop_banner_section'
	)));

	$wp_customize->add_setting('print_on_demand_shop_banner_review_desc',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_banner_review_desc',array(
		'label'	=> __('Banner Review Content','print-on-demand-shop'),
		'section'	=> 'print_on_demand_shop_banner_section',
		'type'	=> 'text'
	));

	$print_on_demand_shop_args = array(
    'type'      => 'product',
    'taxonomy'  => 'product_cat'
	);
	$print_on_demand_shop_categories = get_categories($print_on_demand_shop_args);
	$print_on_demand_shop_cat_posts = array();
	$print_on_demand_shop_cat_posts[''] = 'Select';
	foreach ($print_on_demand_shop_categories as $print_on_demand_shop_category) {
	  $print_on_demand_shop_cat_posts[$print_on_demand_shop_category->slug] = $print_on_demand_shop_category->name;
	}

	$wp_customize->add_setting('print_on_demand_shop_product_category', array(
    'default'           => '',
    'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control('print_on_demand_shop_product_category', array(
    'type'    => 'select',
    'choices' => $print_on_demand_shop_cat_posts,
    'label'   => __('Select Product Category', 'print-on-demand-shop'),
    'section' => 'print_on_demand_shop_banner_section',
	));

	//Products Section
  	$wp_customize->add_section('print_on_demand_shop_popular_product_section',array(
		'title' => __('Products Section','print-on-demand-shop'),
		'description' => '',
		'priority'  => null,
		'panel' => 'print_on_demand_shop_panel_id',
	));	

	$wp_customize->add_setting('print_on_demand_shop_products_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_products_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','print-on-demand-shop'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
   		 'section'=> 'print_on_demand_shop_popular_product_section'
 	));

	$wp_customize->add_setting('print_on_demand_shop_section_sub_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_section_sub_title',array(
		'label'	=> __('Add Section Text','print-on-demand-shop'),
		'input_attrs' => array(
         'placeholder' => __( 'Products', 'print-on-demand-shop' ),
      ),
		'section'=> 'print_on_demand_shop_popular_product_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('print_on_demand_shop_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_section_title',array(
		'label'	=> __('Add Section Title','print-on-demand-shop'),
		'input_attrs' => array(
         'placeholder' => __( 'Our Popular Products', 'print-on-demand-shop' ),
      ),
		'section'=> 'print_on_demand_shop_popular_product_section',
		'type'=> 'text'
	));	

	$wp_customize->add_setting('print_on_demand_shop_product_section_btn_text',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_product_section_btn_text',array(
		'type' => 'text',
		'label' => __('Add Button Text','print-on-demand-shop'),
		'input_attrs' => array(
        'placeholder' => __( 'Explore More', 'print-on-demand-shop' ),
      ),
		'section' => 'print_on_demand_shop_popular_product_section',
	) );

	$wp_customize->add_setting('print_on_demand_shop_product_section_btn_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw'
 	));
 	$wp_customize->add_control('print_on_demand_shop_product_section_btn_url',array(
		'type' => 'text',
		'label' => __('Add Button URL','print-on-demand-shop'),
		'input_attrs' => array(
        'placeholder' => __( 'www.example-info.com', 'print-on-demand-shop' ),
      ),
		'section' => 'print_on_demand_shop_popular_product_section',
	) );
	
	$print_on_demand_shop_args = array(
    	'type'      => 'product',
    	'taxonomy'  => 'product_cat'
	);
	$print_on_demand_shop_categories = get_categories($print_on_demand_shop_args);
	$print_on_demand_shop_cat_posts = array();
	$print_on_demand_shop_cat_posts[''] = 'Select';
	foreach ($print_on_demand_shop_categories as $print_on_demand_shop_category) {
	  $print_on_demand_shop_cat_posts[$print_on_demand_shop_category->slug] = $print_on_demand_shop_category->name;
	}

	$wp_customize->add_setting('print_on_demand_shop_popular_product_category', array(
    	'default'           => '',
    	'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control('print_on_demand_shop_popular_product_category', array(
    	'type'    => 'select',
    	'choices' => $print_on_demand_shop_cat_posts,
    	'label'   => __('Select Product Category', 'print-on-demand-shop'),
    	'section' => 'print_on_demand_shop_popular_product_section',
	));

	//layout setting
	$wp_customize->add_section( 'print_on_demand_shop_option', array(
    	'title'      => __( 'Layout Settings', 'print-on-demand-shop' ),
    	'panel'    => 'print_on_demand_shop_panel_id',
	) );

	$wp_customize->add_setting('print_on_demand_shop_layout_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_layout_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','print-on-demand-shop'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
   		 'section'=> 'print_on_demand_shop_option'
 	));

	$wp_customize->add_setting('print_on_demand_shop_preloader',array(
       'default' => false,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
   ));
    $wp_customize->add_control('print_on_demand_shop_preloader',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Preloader','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_option'
   ));

   $wp_customize->add_setting('print_on_demand_shop_preloader_type',array(
     	'default' => 'First Preloader Type',
     	'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_preloader_type',array(
      'type' => 'radio',
      'label' => __('Preloader Types','print-on-demand-shop'),
      'section' => 'print_on_demand_shop_option',
      'choices' => array(
         'First Preloader Type' => __('First Preloader Type','print-on-demand-shop'),
         'Second Preloader Type' => __('Second Preloader Type','print-on-demand-shop'),
      ),
	) );

	$wp_customize->add_setting('print_on_demand_shop_preloader_bg_color_option', array(
		'default'           => '#5F29DE',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_preloader_bg_color_option', array(
		'label'    => __('Preloader Background Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_option',
	)));

	$wp_customize->add_setting('print_on_demand_shop_preloader_icon_color_option', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_preloader_icon_color_option', array(
		'label'    => __('Preloader Icon Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_option',
	)));

	$wp_customize->add_setting('print_on_demand_shop_preloader_bg_img',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'print_on_demand_shop_preloader_bg_img',array(
        'label' => __('Preloader Background Image','print-on-demand-shop'),
        'section' => 'print_on_demand_shop_option'
	)));	

	$wp_customize->add_setting('print_on_demand_shop_width_layout_options',array(
		'default' => 'Default',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_width_layout_options',array(
		'type' => 'radio',
		'label' => __('Container Box','print-on-demand-shop'),
		'description' => __('Here you can change the Width layout. ','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_option',
		'choices' => array(
		   'Default' => __('Default','print-on-demand-shop'),
		   'Container Layout' => __('Container Layout','print-on-demand-shop'),
		   'Box Layout' => __('Box Layout','print-on-demand-shop'),
		),
	) );

	// Add page sidebar
	$wp_customize->add_setting('print_on_demand_shop_page_sidebar',array(
        'default' => 'One Column',
        'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	) );
	$wp_customize->add_control('print_on_demand_shop_page_sidebar', array(
        'type' => 'select',
        'label' => __('Page Sidebar Layout','print-on-demand-shop'),
        'section' => 'print_on_demand_shop_option',
        'choices' => array(
            'One Column' => __('One Column','print-on-demand-shop'),
            'Left Sidebar' => __('Left Sidebar','print-on-demand-shop'),
            'Right Sidebar' => __('Right Sidebar','print-on-demand-shop')
        ),
	)   );

	// Add Settings and Controls for Layout
	$wp_customize->add_setting('print_on_demand_shop_layout_options',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	) );
	$wp_customize->add_control('print_on_demand_shop_layout_options', array(
        'type' => 'select',
        'label' => __('Post Sidebar Layout','print-on-demand-shop'),
        'section' => 'print_on_demand_shop_option',
        'choices' => array(
            'One Column' => __('One Column','print-on-demand-shop'),
            'Three Columns' => __('Three Columns','print-on-demand-shop'),
            'Four Columns' => __('Four Columns','print-on-demand-shop'),
            'Grid Layout' => __('Grid Layout','print-on-demand-shop'),
            'Left Sidebar' => __('Left Sidebar','print-on-demand-shop'),
            'Right Sidebar' => __('Right Sidebar','print-on-demand-shop')
        ),
	)   );

	$wp_customize->add_setting('print_on_demand_shop_sidebar_size',array(
        'default' => 'Sidebar 1/3',
        'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_sidebar_size',array(
        'type' => 'radio',
        'label' => __('Sidebar Size Option','print-on-demand-shop'),
        'section' => 'print_on_demand_shop_option',
        'choices' => array(
            'Sidebar 1/3' => __('Sidebar 1/3','print-on-demand-shop'),
            'Sidebar 1/4' => __('Sidebar 1/4','print-on-demand-shop'),
        ),
	) );	

	//Global Color
	$wp_customize->add_section('print_on_demand_shop_global_color', array(
		'title'    => __('Theme Color Option', 'print-on-demand-shop'),
		'panel'    => 'print_on_demand_shop_panel_id',
	));

	$wp_customize->add_setting('print_on_demand_shop_global_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_global_premium_info',array(
		'type'=> 'hidden',
		'label' => __('Premium Features','print-on-demand-shop'),
		'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank'   href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
		'section'=> 'print_on_demand_shop_global_color'
 	));

	$wp_customize->add_setting('print_on_demand_shop_first_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_first_color', array(
		'label'    => __('Highlight Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_global_color',
		'settings' => 'print_on_demand_shop_first_color',
	)));

	$wp_customize->add_setting('print_on_demand_shop_second_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_second_color', array(
		'label'    => __('Highlight Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_global_color',
		'settings' => 'print_on_demand_shop_second_color',
	)));

	//Blog Post Settings
	$wp_customize->add_section('print_on_demand_shop_post_settings', array(
		'title'    => __('Post General Settings', 'print-on-demand-shop'),
		'panel'    => 'print_on_demand_shop_panel_id',
	));

	$wp_customize->add_setting('print_on_demand_shop_post_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_post_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','print-on-demand-shop'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
   		 'section'=> 'print_on_demand_shop_post_settings'
 	));

	$wp_customize->add_setting('print_on_demand_shop_post_layouts',array(
		'default' => 'Layout 2',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_post_layouts', array(
		'type' => 'select',
		'label' => __('Post Layouts','print-on-demand-shop'),
		'description' => __('Here you can change the 3 different layouts of post','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_post_settings',
		'choices' => array(
		   'Layout 1' => __('Layouts 1','print-on-demand-shop'),
		   'Layout 2' => __('Layouts 2','print-on-demand-shop'),
		   'Layout 3' => __('Layouts 3','print-on-demand-shop'),
	)));

   $wp_customize->add_setting('print_on_demand_shop_post_block_option',array(
        'default' => 'By Block',
        'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_post_block_option',array(
        'type' => 'select',
        'label' => __('Blog Post Shown','print-on-demand-shop'),
        'section' => 'print_on_demand_shop_post_settings',
        'choices' => array(
            'By Block' => __('By Block','print-on-demand-shop'),
            'By Without Block' => __('By Without Block','print-on-demand-shop'),
        ),
	) );

	$wp_customize->add_setting('print_on_demand_shop_metafields_date',array(
		'default' => true,
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_metafields_date',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Date','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_post_settings'
	));

	$wp_customize->add_setting('print_on_demand_shop_post_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_post_date_icon',array(
		'label'	=> __('Post Date Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_post_settings',
		'type'		=> 'icon'
	)));

   $wp_customize->add_setting('print_on_demand_shop_metafields_author',array(
      'default' => true,
      'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
   ));
   $wp_customize->add_control('print_on_demand_shop_metafields_author',array(
      'type' => 'checkbox',
      'label' => __('Enable / Disable Author','print-on-demand-shop'),
      'section' => 'print_on_demand_shop_post_settings'
   ));

   $wp_customize->add_setting('print_on_demand_shop_post_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_post_author_icon',array(
		'label'	=> __('Post Author Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_post_settings',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('print_on_demand_shop_metafields_comment',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control('print_on_demand_shop_metafields_comment',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Comments','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_post_settings'
    ));

    $wp_customize->add_setting('print_on_demand_shop_post_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_post_comment_icon',array(
		'label'	=> __('Post Comment Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_post_settings',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('print_on_demand_shop_metafields_time',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control('print_on_demand_shop_metafields_time',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Time','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_post_settings'
    ));

    $wp_customize->add_setting('print_on_demand_shop_post_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_post_time_icon',array(
		'label'	=> __('Post Time Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_post_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('print_on_demand_shop_post_featured_image',array(
       'default' => 'Image',
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_choices'
    ));
    $wp_customize->add_control('print_on_demand_shop_post_featured_image',array(
       'type' => 'select',
       'label'	=> __('Post Image Options','print-on-demand-shop'),
       'choices' => array(
            'Image' => __('Image','print-on-demand-shop'),
            'Color' => __('Color','print-on-demand-shop'),
            'None' => __('None','print-on-demand-shop'),
        ),
      	'section'	=> 'print_on_demand_shop_post_settings',
    ));

    $wp_customize->add_setting('print_on_demand_shop_post_featured_color', array(
		'default'           => '#5F29DE',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_post_featured_color', array(
		'label'    => __('Post Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_post_settings',
		'settings' => 'print_on_demand_shop_post_featured_color',
		'active_callback' => 'print_on_demand_shop_post_color_enabled'
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_custom_post_color_width',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_custom_post_color_width',	array(
		'label' => esc_html__( 'Color Post Custom Width','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 500,
			'step' => 1,
		),
		'active_callback' => 'print_on_demand_shop_show_post_color'
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_custom_post_color_height',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_custom_post_color_height',array(
		'label' => esc_html__( 'Color Post Custom Height','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 350,
			'step' => 1,
		),
		'active_callback' => 'print_on_demand_shop_show_post_color'
	)));

	$wp_customize->add_setting('print_on_demand_shop_post_featured_image_dimention',array(
       'default' => 'Default',
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_choices'
    ));
    $wp_customize->add_control('print_on_demand_shop_post_featured_image_dimention',array(
       'type' => 'select',
       'label'	=> __('Post Featured Image Dimention','print-on-demand-shop'),
       'choices' => array(
            'Default' => __('Default','print-on-demand-shop'),
            'Custom' => __('Custom','print-on-demand-shop'),
        ),
      	'section'	=> 'print_on_demand_shop_post_settings',
      	'active_callback' => 'print_on_demand_shop_enable_post_featured_image'
    ));

    $wp_customize->add_setting( 'print_on_demand_shop_post_featured_image_custom_width',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_post_featured_image_custom_width',	array(
		'label' => esc_html__( 'Post Featured Image Custom Width','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 500,
			'step' => 1,
		),
		'active_callback' => 'print_on_demand_shop_enable_post_image_custom_dimention'
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_post_featured_image_custom_height',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_post_featured_image_custom_height',	array(
		'label' => esc_html__( 'Post Featured Image Custom Height','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 350,
			'step' => 1,
		),
		'active_callback' => 'print_on_demand_shop_enable_post_image_custom_dimention'
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_image_border_radius', array(
		'default'=> 0,
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize,  'print_on_demand_shop_image_border_radius', array(
		'label'       => esc_html__( 'Featured Image Border Radius','print-on-demand-shop' ),
		'section'     => 'print_on_demand_shop_post_settings',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	)) );

	$wp_customize->add_setting( 'print_on_demand_shop_image_box_shadow',array(
		'default' => 0,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'absint',
		'sanitize_js_callback' => 'absint',
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize,  'print_on_demand_shop_image_box_shadow',array(
		'label' => esc_html__( 'Featured Image Shadow','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
		'type'		=> 'range'
	)));

	$wp_customize->add_setting('print_on_demand_shop_show_first_caps',array(
      'default' => false,
      'sanitize_callback' => 'print_on_demand_shop_sanitize_checkbox',
    ));
	$wp_customize->add_control( 'print_on_demand_shop_show_first_caps',array(
		'label' => esc_html__('First Cap (First Capital Letter)', 'print-on-demand-shop'),
		'type' => 'checkbox',
		'section' => 'print_on_demand_shop_post_settings',
	));

    //Post excerpt
	$wp_customize->add_setting( 'print_on_demand_shop_post_excerpt_number', array(
		'default'              => 30,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'absint',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'print_on_demand_shop_post_excerpt_number', array(
		'label'       => esc_html__( 'Blog Post Content Limit','print-on-demand-shop' ),
		'section'     => 'print_on_demand_shop_post_settings',
		'type'        => 'number',
		'settings'    => 'print_on_demand_shop_post_excerpt_number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('print_on_demand_shop_content_settings',array(
        'default' =>'Excerpt',
        'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_content_settings',array(
        'type' => 'radio',
        'label' => __('Content Settings','print-on-demand-shop'),
        'section' => 'print_on_demand_shop_post_settings',
        'choices' => array(
            'Excerpt' => __('Excerpt','print-on-demand-shop'),
            'Content' => __('Content','print-on-demand-shop'),
        ),
	) );

	$wp_customize->add_setting( 'print_on_demand_shop_post_discription_suffix', array(
		'default'   => __('[...]','print-on-demand-shop'),
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'print_on_demand_shop_post_discription_suffix', array(
		'label'       => esc_html__( 'Post Excerpt Suffix','print-on-demand-shop' ),
		'section'     => 'print_on_demand_shop_post_settings',
		'type'        => 'text',
		'settings'    => 'print_on_demand_shop_post_discription_suffix',
	) );

	$wp_customize->add_setting( 'print_on_demand_shop_blog_post_meta_seperator', array(
		'default'   => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'print_on_demand_shop_blog_post_meta_seperator', array(
		'label'       => esc_html__( 'Meta Box Separator','print-on-demand-shop' ),
		'section'     => 'print_on_demand_shop_post_settings',
		'description' => __('Here you can add the seperator for meta box. e.g. "|",  ",", "/", etc. ','print-on-demand-shop'),
		'type'        => 'text',
		'settings'    => 'print_on_demand_shop_blog_post_meta_seperator',
	) );

	$wp_customize->add_setting('print_on_demand_shop_enable_post_pagination',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
   ));
   $wp_customize->add_control('print_on_demand_shop_enable_post_pagination',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Blog Page Pagination','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_post_settings'
   ));

   $wp_customize->add_setting( 'print_on_demand_shop_post_pagination_position', array(
        'default'			=>  'Bottom',
        'sanitize_callback'	=> 'print_on_demand_shop_sanitize_choices'
   ));
   $wp_customize->add_control( 'print_on_demand_shop_post_pagination_position', array(
        'section' => 'print_on_demand_shop_post_settings',
        'type' => 'select',
        'label' => __( 'Post Pagination Position', 'print-on-demand-shop' ),
        'choices'		=> array(
            'Top'  => __( 'Top', 'print-on-demand-shop' ),
            'Bottom' => __( 'Bottom', 'print-on-demand-shop' ),
            'Both Top & Bottom' => __( 'Both Top & Bottom', 'print-on-demand-shop' ),
   )));

	$wp_customize->add_setting( 'print_on_demand_shop_pagination_settings', array(
        'default'			=> 'Numeric Pagination',
        'sanitize_callback'	=> 'print_on_demand_shop_sanitize_choices'
   ));
   $wp_customize->add_control( 'print_on_demand_shop_pagination_settings', array(
        'section' => 'print_on_demand_shop_post_settings',
        'type' => 'radio',
        'label' => __( 'Post Pagination', 'print-on-demand-shop' ),
        'choices'		=> array(
            'Numeric Pagination'  => __( 'Numeric Pagination', 'print-on-demand-shop' ),
            'next-prev' => __( 'Next / Previous', 'print-on-demand-shop' ),
   )));

	//Button Settings
	$wp_customize->add_section('print_on_demand_shop_button_settings', array(
		'title'    => __('Post Button Settings', 'print-on-demand-shop'),
		'panel'    => 'print_on_demand_shop_panel_id',
	));

	$wp_customize->add_setting('print_on_demand_shop_post_btn_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_post_btn_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','print-on-demand-shop'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
   		 'section'=> 'print_on_demand_shop_button_settings'
 	));

	$wp_customize->add_setting('print_on_demand_shop_button_text',array(
		'default'=> __('Read More','print-on-demand-shop'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_button_text',array(
		'label'	=> __('Add Button Text','print-on-demand-shop'),
		'section'=> 'print_on_demand_shop_button_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('print_on_demand_shop_btn_font_size_option',array(
		'default'=> 14,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize,'print_on_demand_shop_btn_font_size_option',array(
		'label'	=> __('Button Font Size','print-on-demand-shop'),
		'section'=> 'print_on_demand_shop_button_settings',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 50,
     	),
	)));

	$wp_customize->add_setting('print_on_demand_shop_button_text_tranform',array(
		'default' => 'Capitalize',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
 	));
 	$wp_customize->add_control('print_on_demand_shop_button_text_tranform',array(
		'type' => 'select',
		'label' => __('Button Text Transform','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_button_settings',
		'choices' => array(
		   'Uppercase' => __('Uppercase','print-on-demand-shop'),
		   'Lowercase' => __('Lowercase','print-on-demand-shop'),
		   'Capitalize' => __('Capitalize','print-on-demand-shop'),
		),
	) );

	$wp_customize->add_setting('print_on_demand_shop_button_font_weight',array(
		'default' => '700',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
 	));
 	$wp_customize->add_control('print_on_demand_shop_button_font_weight',array(
		'type' => 'select',
		'label' => __('Button Font Weight','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_button_settings',
		'choices' => array(
			'100' => __('100','print-on-demand-shop'),
			'200' => __('200','print-on-demand-shop'),
			'300' => __('300','print-on-demand-shop'),
			'400' => __('400','print-on-demand-shop'),
			'500' => __('500','print-on-demand-shop'),
			'600' => __('600','print-on-demand-shop'),
			'700' => __('700','print-on-demand-shop'),
			'800' => __('800','print-on-demand-shop'),
			'900' => __('900','print-on-demand-shop'),
		),
	) );

	$wp_customize->add_setting( 'print_on_demand_shop_post_button_padding_top',array(
		'default' => '',
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_post_button_padding_top',	array(
		'label' => esc_html__( 'Button Top Bottom Padding (px)','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_button_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_post_button_padding_right',array(
		'default' => '',
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_post_button_padding_right',	array(
		'label' => esc_html__( 'Button Right Left Padding (px)','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_button_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	// button letter spacing
	$wp_customize->add_setting( 'print_on_demand_shop_button_letter_spacing',array(
		'default' => '',
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new  Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_button_letter_spacing', array(
		'label'  =>  esc_html__('Button Letter Spacing (px)','print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_button_settings',
		'input_attrs' => array(
		   'min' => 0,
		   'max' => 50,
		   'step' => 1,
		)
 	)));		

	// Button Shape
	$wp_customize->add_setting('print_on_demand_shop_btn_shape',array(
		'default'=> 'Square',
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control('print_on_demand_shop_btn_shape',array(
		'label'	=> __('Button Shape','print-on-demand-shop'),
		'section'=> 'print_on_demand_shop_button_settings',
		'type' => 'select',
		'choices' => array(
			'Square' => __('Square','print-on-demand-shop'),
			'Round' => __('Round','print-on-demand-shop'),
			'Pill' => __('Pill','print-on-demand-shop'),
		),
	));	

   //Single Post Settings
	$wp_customize->add_section('print_on_demand_shop_single_post_settings', array(
		'title'    => __('Single Post Settings', 'print-on-demand-shop'),
		'panel'    => 'print_on_demand_shop_panel_id',
	));

	$wp_customize->add_setting('print_on_demand_shop_single_post_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_single_post_premium_info',array(
		'type'=> 'hidden',
		'label' => __('Premium Features','print-on-demand-shop'),
		'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
		'section'=> 'print_on_demand_shop_single_post_settings'
 	));

	$wp_customize->add_setting('print_on_demand_shop_single_post_date',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
   ));
   $wp_customize->add_control('print_on_demand_shop_single_post_date',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Date','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_single_post_settings'
   ));

   $wp_customize->add_setting('print_on_demand_shop_single_post_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_single_post_date_icon',array(
		'label'	=> __('Single Post Date Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_single_post_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('print_on_demand_shop_single_post_author',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
   ));
   $wp_customize->add_control('print_on_demand_shop_single_post_author',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Author','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_single_post_settings'
   ));

   $wp_customize->add_setting('print_on_demand_shop_single_post_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
      $wp_customize,'print_on_demand_shop_single_post_author_icon',array(
		'label'	=> __('Single Post Author Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_single_post_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('print_on_demand_shop_single_post_comment',array(
		'default' => true,
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_single_post_comment',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Comments','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_single_post_settings'
	));

 	$wp_customize->add_setting('print_on_demand_shop_single_post_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer( $wp_customize, 'print_on_demand_shop_single_post_comment_icon', array(
		'label'	=> __('Single Post Comment Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_single_post_settings',
		'type'		=> 'icon'
	)));

   $wp_customize->add_setting('print_on_demand_shop_single_post_time',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
   ));
   $wp_customize->add_control('print_on_demand_shop_single_post_time',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Time','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_single_post_settings',
   ));

   $wp_customize->add_setting('print_on_demand_shop_single_post_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_single_post_time_icon',array(
		'label'	=> __('Single Post Time Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_single_post_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('print_on_demand_shop_post_comment_enable',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
   ));
   $wp_customize->add_control('print_on_demand_shop_post_comment_enable',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable post comment','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_single_post_settings',
   ));

	$wp_customize->add_setting('print_on_demand_shop_single_post_featured_image',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
   ));
   $wp_customize->add_control('print_on_demand_shop_single_post_featured_image',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Featured image','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_single_post_settings',
   ));

   $wp_customize->add_setting('print_on_demand_shop_single_post_featured_image_dimention',array(
		'default' => 'Default',
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_single_post_featured_image_dimention',array(
		'type' => 'select',
		'label'	=> __('Single Post Featured Image Dimention','print-on-demand-shop'),
		'choices' => array(
			'Default' => __('Default','print-on-demand-shop'),
			'Custom' => __('Custom','print-on-demand-shop'),
		),
		'section'	=> 'print_on_demand_shop_single_post_settings',
	));

	$wp_customize->add_setting( 'print_on_demand_shop_single_post_featured_image_custom_width',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_single_post_featured_image_custom_width',	array(
		'label' => esc_html__( 'Single Post Featured Image Custom Width','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_single_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 800,
			'step' => 1,
		),
		'active_callback' => 'print_on_demand_shop_enable_single_post_image_custom_dimention'
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_single_post_featured_image_custom_height',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_single_post_featured_image_custom_height',	array(
		'label' => esc_html__( 'Single Post Featured Image Custom Height','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_single_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 800,
			'step' => 1,
		),
		'active_callback' => 'print_on_demand_shop_enable_single_post_image_custom_dimention'
	)));

	$wp_customize->add_setting('print_on_demand_shop_show_hide_single_post_categories',array(
			'default' => true,
			'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
   ));
   $wp_customize->add_control('print_on_demand_shop_show_hide_single_post_categories',array(
			'type' => 'checkbox',
			'label' => __('Single Post Categories','print-on-demand-shop'),
			'section' => 'print_on_demand_shop_single_post_settings'
   ));

	$wp_customize->add_setting('print_on_demand_shop_single_post_tags',array(
      'default' => true,
      'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
   ));
   $wp_customize->add_control('print_on_demand_shop_single_post_tags',array(
      'type' => 'checkbox',
      'label' => __('Enable / Disable Tags','print-on-demand-shop'),
      'section' => 'print_on_demand_shop_single_post_settings'
   ));

	$wp_customize->add_setting('print_on_demand_shop_single_post_layout',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	) );
	$wp_customize->add_control('print_on_demand_shop_single_post_layout', array(
        'type' => 'select',
        'label' => __('Select different Single post sidebar layout','print-on-demand-shop'),
        'section' => 'print_on_demand_shop_single_post_settings',
        'choices' => array(
            'One Column' => __('One Column','print-on-demand-shop'),
            'Left Sidebar' => __('Left Sidebar','print-on-demand-shop'),
            'Right Sidebar' => __('Right Sidebar','print-on-demand-shop')
        ),
	)   );

	$wp_customize->add_setting( 'print_on_demand_shop_single_post_meta_seperator', array(
		'default'   => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'print_on_demand_shop_single_post_meta_seperator', array(
		'label'       => esc_html__( 'Single Post Meta Box Seperator','print-on-demand-shop' ),
		'section'     => 'print_on_demand_shop_single_post_settings',
		'description' => __('Here you can add the seperator for meta box. e.g. "|",  ",", "/", etc. ','print-on-demand-shop'),
		'type'        => 'text',
		'settings'    => 'print_on_demand_shop_single_post_meta_seperator',
	) );

	$wp_customize->add_setting( 'print_on_demand_shop_comment_form_width',array(
		'default' => 100,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_comment_form_width',	array(
		'label' => esc_html__( 'Comment Form Width','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_single_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting('print_on_demand_shop_title_comment_form',array(
       'default' => __('Leave a Reply','print-on-demand-shop'),
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('print_on_demand_shop_title_comment_form',array(
       'type' => 'text',
       'label' => __('Comment Form Heading Text','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_single_post_settings'
    ));

    $wp_customize->add_setting('print_on_demand_shop_comment_form_button_content',array(
       'default' => __('Post Comment','print-on-demand-shop'),
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('print_on_demand_shop_comment_form_button_content',array(
       'type' => 'text',
       'label' => __('Comment Form Button Text','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_single_post_settings'
    ));

	$wp_customize->add_setting('print_on_demand_shop_enable_single_post_pagination',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
   ));
   $wp_customize->add_control('print_on_demand_shop_enable_single_post_pagination',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Single Post Pagination','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_single_post_settings'
   ));

   $wp_customize->add_setting('print_on_demand_shop_prev_text',array(
       'default' => 'Previous page',
       'sanitize_callback'	=> 'sanitize_text_field'
   ));
   $wp_customize->add_control('print_on_demand_shop_prev_text',array(
       'type' => 'text',
       'label' => __('Previous Navigation Text','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_single_post_settings'
   ));

   $wp_customize->add_setting('print_on_demand_shop_next_text',array(
       'default' => 'Next page',
       'sanitize_callback'	=> 'sanitize_text_field'
   ));
   $wp_customize->add_control('print_on_demand_shop_next_text',array(
       'type' => 'text',
       'label' => __('Next Navigation Text','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_single_post_settings'
   ));

	//Grid Post Settings
	$wp_customize->add_section('print_on_demand_shop_grid_settings', array(
		'title'    => __('Grid Post Settings', 'print-on-demand-shop'),
		'panel'    => 'print_on_demand_shop_panel_id',
	));

	$wp_customize->add_setting('print_on_demand_shop_grid_post_date',array(
	'default' => true,
	'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_grid_post_date',array(
	'type' => 'checkbox',
	'label' => __('Enable / Disable Date','print-on-demand-shop'),
	'section' => 'print_on_demand_shop_grid_settings',
	));

	$wp_customize->add_setting('print_on_demand_shop_grid_post_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
		$wp_customize,'print_on_demand_shop_grid_post_date_icon',array(
		'label'	=> __('Post Date Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_grid_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('print_on_demand_shop_grid_post_author',array(
	'default' => true,
	'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_grid_post_author',array(
	'type' => 'checkbox',
	'label' => __('Enable / Disable Author','print-on-demand-shop'),
	'section' => 'print_on_demand_shop_grid_settings',
	));

	$wp_customize->add_setting('print_on_demand_shop_grid_post_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
		$wp_customize,'print_on_demand_shop_grid_post_author_icon',array(
		'label'	=> __('Post Author Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_grid_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('print_on_demand_shop_grid_post_comment',array(
	'default' => true,
	'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_grid_post_comment',array(
	'type' => 'checkbox',
	'label' => __('Enable / Disable Comment','print-on-demand-shop'),
	'section' => 'print_on_demand_shop_grid_settings',
	));

	$wp_customize->add_setting('print_on_demand_shop_grid_post_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
		$wp_customize,'print_on_demand_shop_grid_post_comment_icon',array(
		'label'	=> __('Post Comment Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_grid_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('print_on_demand_shop_grid_post_time',array(
	'default' => true,
	'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_grid_post_time',array(
	'type' => 'checkbox',
	'label' => __('Enable / Disable Time','print-on-demand-shop'),
	'section' => 'print_on_demand_shop_grid_settings',
	));

	$wp_customize->add_setting('print_on_demand_shop_grid_post_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
		$wp_customize,'print_on_demand_shop_grid_post_time_icon',array(
		'label'	=> __('Post Time Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_grid_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_grid_post_meta_seperator', array(
		'default'   => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control( 'print_on_demand_shop_grid_post_meta_seperator', array(
		'label'       => esc_html__( 'Meta Box','print-on-demand-shop' ),
		'section'     => 'print_on_demand_shop_grid_settings',
		'description' => __('Here you can add the seperator for meta box. e.g. "|",  ",", "/", etc. ','print-on-demand-shop'),
		'type'        => 'text',
		'settings'    => 'print_on_demand_shop_grid_post_meta_seperator',
	));

	$wp_customize->add_setting( 'print_on_demand_shop_grid_image_border_radius', array(
		'default'=> 0,
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize,  'print_on_demand_shop_grid_image_border_radius', array(
		'label'       => esc_html__( 'Image Border Radius','print-on-demand-shop' ),
		'section'     => 'print_on_demand_shop_grid_settings',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	)) );

	$wp_customize->add_setting( 'print_on_demand_shop_grid_image_box_shadow',array(
		'default' => 0,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'absint',
		'sanitize_js_callback' => 'absint',
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize,  'print_on_demand_shop_grid_image_box_shadow',array(
		'label' => esc_html__( 'Image Shadow','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_grid_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
		'type'		=> 'range'
	)));

	$wp_customize->add_setting('print_on_demand_shop_grid_post_content',array(
    	'default'   => 'Post Excerpt',
     	'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_grid_post_content',array(
		'type' => 'radio',
		'label' => __('Grid Post Content Settings','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_grid_settings',
		'choices' => array(
		   'None' => __('None','print-on-demand-shop'),
		   'Post Excerpt' => __('Post Excerpt','print-on-demand-shop'),
		   'Post Content' => __('Post Content','print-on-demand-shop'),
		),
	) );

	$wp_customize->add_setting( 'print_on_demand_shop_grid_post_excerpt_number', array(
		'default'              => 30,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'absint',
		'sanitize_js_callback' => 'absint',
	));
	$wp_customize->add_control( 'print_on_demand_shop_grid_post_excerpt_number', array(
		'label'       => esc_html__( 'Grid Post Content Limit','print-on-demand-shop' ),
		'section'     => 'print_on_demand_shop_grid_settings',
		'type'        => 'number',
		'settings'    => 'print_on_demand_shop_grid_post_excerpt_number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'print_on_demand_shop_grid_excerpt_suffix', array(
		'default'   => __('[...]','print-on-demand-shop'),
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'print_on_demand_shop_grid_excerpt_suffix', array(
		'label'       => esc_html__( 'Grid Post Excerpt Suffix','print-on-demand-shop' ),
		'section'     => 'print_on_demand_shop_grid_settings',
		'type'        => 'text',
		'settings'    => 'print_on_demand_shop_grid_excerpt_suffix',
	) );

	$wp_customize->add_setting('print_on_demand_shop_grid_post_block_option',array(
        'default' => 'By Block',
        'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_grid_post_block_option',array(
        'type' => 'select',
        'label' => __('Blog Post Shown','print-on-demand-shop'),
        'section' => 'print_on_demand_shop_grid_settings',
        'choices' => array(
            'By Block' => __('By Block','print-on-demand-shop'),
            'By Without Block' => __('By Without Block','print-on-demand-shop'),
        ),
	) );

	$wp_customize->add_setting('print_on_demand_shop_grid_columns',array(
		'default'           => '3',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
		'transport'         => 'refresh',
	));
	$wp_customize->add_control('print_on_demand_shop_grid_columns',array(
		'type'        => 'radio',
		'label'       => __('Grid Post Columns', 'print-on-demand-shop'),
		'section'     => 'print_on_demand_shop_grid_settings',
		'choices' => array(
		   '3'     => __('Three', 'print-on-demand-shop'),
		   '4'     => __('Four', 'print-on-demand-shop')
		),
	));

	//Related Post Settings
	$wp_customize->add_section('print_on_demand_shop_related_settings', array(
		'title'    => __('Related Post Settings', 'print-on-demand-shop'),
		'panel'    => 'print_on_demand_shop_panel_id',
	));

	$wp_customize->add_setting('print_on_demand_shop_related_post_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_related_post_premium_info',array(
		'type'=> 'hidden',
		'label' => __('Premium Features','print-on-demand-shop'),
		'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
		'section'=> 'print_on_demand_shop_related_settings'
 	));

	$wp_customize->add_setting( 'print_on_demand_shop_related_enable_disable',array(
		'default' => true,
      	'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
    ) );
    $wp_customize->add_control('print_on_demand_shop_related_enable_disable',array(
    	'type' => 'checkbox',
        'label' => __( 'Enable / Disable Related Post','print-on-demand-shop' ),
        'section' => 'print_on_demand_shop_related_settings'
    ));

	$wp_customize->add_setting('print_on_demand_shop_related_metafields_date',array(
		'default' => true,
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_related_metafields_date',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Date','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_related_settings'
	));

    $wp_customize->add_setting('print_on_demand_shop_related_metafields_author',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control('print_on_demand_shop_related_metafields_author',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Author','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_related_settings'
    ));

    $wp_customize->add_setting('print_on_demand_shop_related_metafields_comment',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control('print_on_demand_shop_related_metafields_comment',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Comments','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_related_settings'
    ));

    $wp_customize->add_setting('print_on_demand_shop_related_metafields_time',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control('print_on_demand_shop_related_metafields_time',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Time','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_related_settings'
    ));

	$wp_customize->add_setting( 'print_on_demand_shop_related_post_meta_seperator', array(
		'default'   => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'print_on_demand_shop_related_post_meta_seperator', array(
		'label'       => esc_html__( 'Meta Box Separator','print-on-demand-shop' ),
		'section'     => 'print_on_demand_shop_related_settings',
		'description' => __('Here you can add the seperator for meta box. e.g. "|",  ",", "/", etc. ','print-on-demand-shop'),
		'type'        => 'text',
		'settings'    => 'print_on_demand_shop_related_post_meta_seperator',
	) );

    $wp_customize->add_setting('print_on_demand_shop_related_title',array(
		'default'	=> 'Related Posts',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_related_title',array(
		'label'	=> __('Add Section Title','print-on-demand-shop'),
		'section'	=> 'print_on_demand_shop_related_settings',
		'type'		=> 'text'
	));

	$wp_customize->add_setting( 'print_on_demand_shop_related_posts_count_number', array(
		'default'              => 3,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'print_on_demand_shop_related_posts_count_number', array(
		'label'       => esc_html__( 'Related Post Count','print-on-demand-shop' ),
		'section'     => 'print_on_demand_shop_related_settings',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 10,
		),
	) );

	$wp_customize->add_setting('print_on_demand_shop_related_posts_taxanomies',array(
        'default' => 'categories',
        'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_related_posts_taxanomies',array(
        'type' => 'radio',
        'label' => __('Post Taxonomies','print-on-demand-shop'),
        'section' => 'print_on_demand_shop_related_settings',
        'choices' => array(
            'categories' => __('Categories','print-on-demand-shop'),
            'tags' => __('Tags','print-on-demand-shop'),
        ),
	) );

	$wp_customize->add_setting( 'print_on_demand_shop_related_post_excerpt_number',array(
		'default' => 15,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));

	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_related_post_excerpt_number',	array(
		'label' => esc_html__( 'Content Limit','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_related_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_related_post_discription_suffix', array(
		'default'   => __('[...]','print-on-demand-shop'),
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'print_on_demand_shop_related_post_discription_suffix', array(
		'label'       => esc_html__( 'Post Excerpt Suffix','print-on-demand-shop' ),
		'section'     => 'print_on_demand_shop_related_settings',
		'type'        => 'text',
		'settings'    => 'print_on_demand_shop_related_post_discription_suffix',
	) );

	$wp_customize->add_setting('print_on_demand_shop_related_post_featured_image',array(
		'default' => true,
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_related_post_featured_image',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Featured image','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_related_settings',
	)); 

	//Responsive Media Settings
	$wp_customize->add_section('print_on_demand_shop_responsive_media',array(
		'title'	=> __('Responsive Media','print-on-demand-shop'),
		'panel' => 'print_on_demand_shop_panel_id',
	));

	$wp_customize->add_setting('print_on_demand_shop_responsive_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_responsive_premium_info',array(
		'type'=> 'hidden',
		'label' => __('Premium Features','print-on-demand-shop'),
		'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
		'section'=> 'print_on_demand_shop_responsive_media'
 	));

	$wp_customize->add_setting('print_on_demand_shop_responsive_menu_open_icon',array(
		'default'	=> 'fas fa-bars',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_responsive_menu_open_icon',array(
		'label'	=> __('Responsive Open Menu Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_responsive_media',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('print_on_demand_shop_responsive_menu_close_icon',array(
		'default'	=> 'fas fa-times',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_responsive_menu_close_icon',array(
		'label'	=> __('Responsive Close Menu Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_responsive_media',
		'type'		=> 'icon'
	)));

	// site toggle button color
	$wp_customize->add_setting('print_on_demand_shop_toggle_button_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_toggle_button_color', array(
		'label'    => __('Toggle Button Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_responsive_media',
		'settings' => 'print_on_demand_shop_toggle_button_color',
	)));

	$wp_customize->add_setting('print_on_demand_shop_display_post_date',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control('print_on_demand_shop_display_post_date',array(
       'type' => 'checkbox',
       'label' => __('Display Post Date','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_responsive_media'
    ));

    $wp_customize->add_setting('print_on_demand_shop_display_post_author',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control('print_on_demand_shop_display_post_author',array(
       'type' => 'checkbox',
       'label' => __('Display Post Author','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_responsive_media'
    ));

    $wp_customize->add_setting('print_on_demand_shop_display_post_comment',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control('print_on_demand_shop_display_post_comment',array(
       'type' => 'checkbox',
       'label' => __('Display Post Comment','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_responsive_media'
    ));

	$wp_customize->add_setting('print_on_demand_shop_display_post_time',array(
		'default' => true,
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	 ));
	 $wp_customize->add_control('print_on_demand_shop_display_post_time',array(
		'type' => 'checkbox',
		'label' => __('Display Post Time','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_responsive_media'
	 ));

	$wp_customize->add_setting('print_on_demand_shop_display_sidebar',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control('print_on_demand_shop_display_sidebar',array(
       'type' => 'checkbox',
       'label' => __('Display Sidebar','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_responsive_media'
    ));

    $wp_customize->add_setting('print_on_demand_shop_display_preloader',array(
       'default' => false,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control('print_on_demand_shop_display_preloader',array(
       'type' => 'checkbox',
       'label' => __('Display Preloader','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_responsive_media'
    ));

	$wp_customize->add_setting('print_on_demand_shop_display_scroll',array(
		'default' => true,
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_display_scroll',array(
     	'type' => 'checkbox',
      	'label' => __('Display Scroll To Top','print-on-demand-shop'),
      	'section' => 'print_on_demand_shop_responsive_media',
	));

    //404 Page Setting
	$wp_customize->add_section('print_on_demand_shop_page_not_found',array(
		'title'	=> __('404 Page Not Found / No Result','print-on-demand-shop'),
		'panel' => 'print_on_demand_shop_panel_id',
	));

	$wp_customize->add_setting('print_on_demand_shop_page_not_found_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_page_not_found_premium_info',array(
		'type'=> 'hidden',
		'label' => __('Premium Features','print-on-demand-shop'),
		'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
		'section'=> 'print_on_demand_shop_page_not_found'
 	));

	$wp_customize->add_setting('print_on_demand_shop_page_not_found_heading',array(
		'default'=> __('404 Not Found','print-on-demand-shop'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_page_not_found_heading',array(
		'label'	=> __('404 Heading','print-on-demand-shop'),
		'section'=> 'print_on_demand_shop_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('print_on_demand_shop_page_not_found_text',array(
		'default'=> __('Looks like you have taken a wrong turn. Dont worry it happens to the best of us.','print-on-demand-shop'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_page_not_found_text',array(
		'label'	=> __('404 Content','print-on-demand-shop'),
		'section'=> 'print_on_demand_shop_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('print_on_demand_shop_page_not_found_button',array(
		'default'=>  __('Back to Home Page','print-on-demand-shop'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_page_not_found_button',array(
		'label'	=> __('404 Button','print-on-demand-shop'),
		'section'=> 'print_on_demand_shop_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('print_on_demand_shop_no_search_result_heading',array(
		'default'=> __('Nothing Found','print-on-demand-shop'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('print_on_demand_shop_no_search_result_heading',array(
		'label'	=> __('No Search Results Heading','print-on-demand-shop'),
		'description'=>__('The search page heading display when no results are found.','print-on-demand-shop'),
		'section'=> 'print_on_demand_shop_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('print_on_demand_shop_no_search_result_text',array(
		'default'=> __('Sorry, but nothing matched your search terms. Please try again with some different keywords.','print-on-demand-shop'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_no_search_result_text',array(
		'label'	=> __('No Search Results Text','print-on-demand-shop'),
		'description'=>__('The search page text display when no results are found.','print-on-demand-shop'),
		'section'=> 'print_on_demand_shop_page_not_found',
		'type'=> 'text'
	));

	//Woocommerce Section
	$wp_customize->add_section( 'print_on_demand_shop_woocommerce_section' , array(
    	'title'      => __( 'Woocommerce Settings', 'print-on-demand-shop' ),
    	'description'=>__('The below settings are apply on woocommerce pages.','print-on-demand-shop'),
		'priority'   => null,
		'panel' => 'print_on_demand_shop_panel_id'
	) );

	$wp_customize->add_setting('print_on_demand_shop_woocommerce_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_woocommerce_premium_info',array(
		'type'=> 'hidden',
		'label' => __('Premium Features','print-on-demand-shop'),
		'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
		'section'=> 'print_on_demand_shop_woocommerce_section'
 	));

	/**
	 * Product Columns
	 */
	$wp_customize->add_setting( 'print_on_demand_shop_per_columns' , array(
		'default'           => 4,
		'transport'         => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'print_on_demand_shop_per_columns', array(
		'label'    => __( 'Product per columns', 'print-on-demand-shop' ),
		'section'  => 'print_on_demand_shop_woocommerce_section',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
			'5' => '5',
		),
	) ) );

	$wp_customize->add_setting('print_on_demand_shop_product_per_page',array(
		'default'	=> 12,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_product_per_page',array(
		'label'	=> __('Product per page','print-on-demand-shop'),
		'section'	=> 'print_on_demand_shop_woocommerce_section',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('print_on_demand_shop_shop_sidebar_enable',array(
       'default' => false,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control('print_on_demand_shop_shop_sidebar_enable',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable shop page sidebar','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_woocommerce_section',
    ));

   // shop page sidebar alignment
   $wp_customize->add_setting('print_on_demand_shop_shop_page_layout', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control('print_on_demand_shop_shop_page_layout',array(
		'type'           => 'radio',
		'label'          => __('Shop Page Layout', 'print-on-demand-shop'),
		'section'        => 'print_on_demand_shop_woocommerce_section',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'print-on-demand-shop'),
			'Right Sidebar' => __('Right Sidebar', 'print-on-demand-shop'),
		),
	));

	$wp_customize->add_setting('print_on_demand_shop_product_page_sidebar_enable',array(
		'default' => false,
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_product_page_sidebar_enable',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable single product page sidebar','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_woocommerce_section',
	));

   // single product page sidebar alignment
   $wp_customize->add_setting('print_on_demand_shop_single_product_page_layout', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control('print_on_demand_shop_single_product_page_layout',array(
		'type'           => 'radio',
		'label'          => __('Single Product Page Layout', 'print-on-demand-shop'),
		'section'        => 'print_on_demand_shop_woocommerce_section',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'print-on-demand-shop'),
			'Right Sidebar' => __('Right Sidebar', 'print-on-demand-shop'),
		),
	));

    $wp_customize->add_setting('print_on_demand_shop_related_product_enable',array(
       'default' => true,
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control('print_on_demand_shop_related_product_enable',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Related product','print-on-demand-shop'),
       'section' => 'print_on_demand_shop_woocommerce_section',
    ));

    $wp_customize->add_setting( 'print_on_demand_shop_woo_product_sale_border_radius',array(
		'default' => 3,
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_woo_product_sale_border_radius', array(
        'label'  => __('Woocommerce Product Sale Border Radius','print-on-demand-shop'),
        'section'  => 'print_on_demand_shop_woocommerce_section',
        'type'        => 'number',
        'input_attrs' => array(
        	'step'=> 1,
            'min' => 0,
            'max' => 50,
        )
    )));

    $wp_customize->add_setting('print_on_demand_shop_wooproduct_sale_font_size',array(
		'default'=> 14,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_wooproduct_sale_font_size',array(
		'label'	=> __('Woocommerce Product Sale Font Size','print-on-demand-shop'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'print_on_demand_shop_woocommerce_section',
	)));

    $wp_customize->add_setting('print_on_demand_shop_woo_product_sale_top_bottom_padding',array(
		'default'=> 0,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_woo_product_sale_top_bottom_padding',array(
		'label'	=> __('Woocommerce Product Sale Top Bottom Padding ','print-on-demand-shop'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'print_on_demand_shop_woocommerce_section',
		'type'=> 'number'
	)));

	$wp_customize->add_setting('print_on_demand_shop_woo_product_sale_left_right_padding',array(
		'default'=> 0,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_woo_product_sale_left_right_padding',array(
		'label'	=> __('Woocommerce Product Sale Left Right Padding','print-on-demand-shop'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'print_on_demand_shop_woocommerce_section',
		'type'=> 'number'
	)));

	$wp_customize->add_setting('print_on_demand_shop_woo_product_sale_position',array(
        'default' => 'Left',
        'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_woo_product_sale_position',array(
        'type' => 'select',
        'label' => __('Woocommerce Product Sale Position','print-on-demand-shop'),
        'section' => 'print_on_demand_shop_woocommerce_section',
        'choices' => array(
            'Right' => __('Right','print-on-demand-shop'),
            'Left' => __('Left','print-on-demand-shop'),
        ),
	));

	$wp_customize->add_setting( 'print_on_demand_shop_woocommerce_button_padding_top',array(
		'default' => 12,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_woocommerce_button_padding_top',	array(
		'label' => esc_html__( 'Button Top Bottom Padding (px)','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_woocommerce_button_padding_right',array(
		'default' => 15,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_woocommerce_button_padding_right',	array(
		'label' => esc_html__( 'Button Right Left Padding (px)','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_woocommerce_button_border_radius',array(
		'default' => 3,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_woocommerce_button_border_radius',array(
		'label' => esc_html__( 'Button Border Radius (px)','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

   $wp_customize->add_setting('print_on_demand_shop_woocommerce_product_border_enable',array(
      'default' => false,
      'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
   ));
   $wp_customize->add_control('print_on_demand_shop_woocommerce_product_border_enable',array(
      'type' => 'checkbox',
      'label' => __('Enable / Disable product border','print-on-demand-shop'),
      'section' => 'print_on_demand_shop_woocommerce_section',
   ));

	$wp_customize->add_setting( 'print_on_demand_shop_woocommerce_product_padding_top',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_woocommerce_product_padding_top',	array(
		'label' => esc_html__( 'Product Top Bottom Padding (px)','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_woocommerce_product_padding_right',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_woocommerce_product_padding_right',	array(
		'label' => esc_html__( 'Product Right Left Padding (px)','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_woocommerce_product_border_radius',array(
		'default' => 10,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_woocommerce_product_border_radius',array(
		'label' => esc_html__( 'Product Border Radius (px)','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_woocommerce_product_box_shadow',array(
		'default' => '',
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_woocommerce_product_box_shadow',array(
		'label' => esc_html__( 'Product Box Shadow (px)','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting('print_on_demand_shop_wooproducts_nav',array(
       'default' => 'Yes',
       'sanitize_callback'	=> 'print_on_demand_shop_sanitize_choices'
    ));
    $wp_customize->add_control('print_on_demand_shop_wooproducts_nav',array(
       'type' => 'select',
       'label' => __('Shop Page Products Navigation','print-on-demand-shop'),
       'choices' => array(
            'Yes' => __('Yes','print-on-demand-shop'),
            'No' => __('No','print-on-demand-shop'),
        ),
       'section' => 'print_on_demand_shop_woocommerce_section',
    ));

	//footer text
	$wp_customize->add_section('print_on_demand_shop_footer_section',array(
		'title'	=> __('Footer Text','print-on-demand-shop'),
		'panel' => 'print_on_demand_shop_panel_id'
	));

	$wp_customize->add_setting('print_on_demand_shop_footer_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_footer_premium_info',array(
		'type'=> 'hidden',
		'label' => __('Premium Features','print-on-demand-shop'),
		'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
		'section'=> 'print_on_demand_shop_footer_section'
 	));
	
	$wp_customize->add_setting('print_on_demand_shop_footer_hide',array(
		'default' => true,
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_footer_hide',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Footer','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_footer_section',
	));	

  	$wp_customize->add_setting('print_on_demand_shop_footer_template',array(
      'default'	=> esc_html('print_on_demand_shop-footer-one'),
      'sanitize_callback'	=> 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_footer_template',array(
		'label'	=> esc_html__('Footer style','print-on-demand-shop'),
		'section'	=> 'print_on_demand_shop_footer_section',
		'setting'	=> 'print_on_demand_shop_footer_template',
		'type' => 'select',
		'choices' => array(
          'print_on_demand_shop-footer-one' => esc_html__('Style 1', 'print-on-demand-shop'),
          'print_on_demand_shop-footer-two' => esc_html__('Style 2', 'print-on-demand-shop'),
          'print_on_demand_shop-footer-three' => esc_html__('Style 3', 'print-on-demand-shop'),
          'print_on_demand_shop-footer-four' => esc_html__('Style 4', 'print-on-demand-shop'),
          'print_on_demand_shop-footer-five' => esc_html__('Style 5', 'print-on-demand-shop'),
          )
	));		

	$wp_customize->add_setting('print_on_demand_shop_footer_bg_color', array(
		'default'           => '#5F29DE',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_footer_bg_color', array(
		'label'    => __('Footer Background Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_footer_section',
	)));

	$wp_customize->add_setting('print_on_demand_shop_footer_bg_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'print_on_demand_shop_footer_bg_image',array(
		'label' => __('Footer Background Image','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_footer_section'
	)));
	
	$wp_customize->add_setting('print_on_demand_shop_footer_attatchment',array(
		'default'=> 'scroll',
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_footer_attatchment',array(
		'type' => 'select',
		'label'	=> __('Footer Background Attatchment','print-on-demand-shop'),
		'choices' => array(
            'fixed' => __('fixed','print-on-demand-shop'),
            'scroll' => __('scroll','print-on-demand-shop'),
        ),
		'section'=> 'print_on_demand_shop_footer_section',
	));

	$wp_customize->add_setting('print_on_demand_shop_footer_img_position',array(
		'default' => 'center center',
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	  ));
	  $wp_customize->add_control('print_on_demand_shop_footer_img_position',array(
		  'type' => 'select',
		  'label' => __('Footer Image Position','print-on-demand-shop'),
		  'section' => 'print_on_demand_shop_footer_section',
		  'choices' 	=> array(
			  'left top' 		=> esc_html__( 'Top Left', 'print-on-demand-shop' ),
			  'center top'   => esc_html__( 'Top', 'print-on-demand-shop' ),
			  'right top'   => esc_html__( 'Top Right', 'print-on-demand-shop' ),
			  'left center'   => esc_html__( 'Left', 'print-on-demand-shop' ),
			  'center center'   => esc_html__( 'Center', 'print-on-demand-shop' ),
			  'right center'   => esc_html__( 'Right', 'print-on-demand-shop' ),
			  'left bottom'   => esc_html__( 'Bottom Left', 'print-on-demand-shop' ),
			  'center bottom'   => esc_html__( 'Bottom', 'print-on-demand-shop' ),
			  'right bottom'   => esc_html__( 'Bottom Right', 'print-on-demand-shop' ),
		  ),
	  ));		

	$wp_customize->add_setting('print_on_demand_shop_footer_widget_areas',array(
		'default'           => 4,
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices',
	));
	$wp_customize->add_control('print_on_demand_shop_footer_widget_areas',array(
		'type'        => 'radio',
		'label'       => __('Footer widget area', 'print-on-demand-shop'),
		'section'     => 'print_on_demand_shop_footer_section',
		'description' => __('Select the number of widget areas you want in the footer. After that, go to Appearance > Widgets and add your widgets.', 'print-on-demand-shop'),
		'choices' => array(
		   '1'     => __('One', 'print-on-demand-shop'),
		   '2'     => __('Two', 'print-on-demand-shop'),
		   '3'     => __('Three', 'print-on-demand-shop'),
		   '4'     => __('Four', 'print-on-demand-shop')
		),
	));

	$wp_customize->add_setting('print_on_demand_shop_footer_heading',array(
	    'default' => 'Left',
	    'transport' => 'refresh',
	    'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_footer_heading',array(
	    'type' => 'select',
	    'label' => __('Footer Heading Alignment','print-on-demand-shop'),
	    'section' => 'print_on_demand_shop_footer_section',
	    'choices' => array(
	    	'Left' => __('Left','print-on-demand-shop'),
	        'Center' => __('Center','print-on-demand-shop'),
	        'Right' => __('Right','print-on-demand-shop')
	    ),
	) );

	$wp_customize->add_setting('print_on_demand_shop_footer_heading_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
 	));
 	$wp_customize->add_control('print_on_demand_shop_footer_heading_font_weight',array(
		'type' => 'select',
		'label' => __('Footer Heading Font Weight','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_footer_section',
		'choices' => array(
			'100' => __('100','print-on-demand-shop'),
			'200' => __('200','print-on-demand-shop'),
			'300' => __('300','print-on-demand-shop'),
			'400' => __('400','print-on-demand-shop'),
			'500' => __('500','print-on-demand-shop'),
			'600' => __('600','print-on-demand-shop'),
			'700' => __('700','print-on-demand-shop'),
			'800' => __('800','print-on-demand-shop'),
			'900' => __('900','print-on-demand-shop'),
		),
	) );

	$wp_customize->add_setting('print_on_demand_shop_footer_heading_letter_spacing',array(
		'default'=> 1,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_footer_heading_letter_spacing',array(
		'label'	=> __('Footer Heading Letter Spacing','print-on-demand-shop'),
  		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
	),
		'section'=> 'print_on_demand_shop_footer_section',
	));		

	$wp_customize->add_setting('print_on_demand_shop_footer_content',array(
	    'default' => 'Left',
	    'transport' => 'refresh',
	    'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_footer_content',array(
	    'type' => 'select',
	    'label' => __('Footer Content Alignment','print-on-demand-shop'),
	    'section' => 'print_on_demand_shop_footer_section',
	    'choices' => array(
	    	'Left' => __('Left','print-on-demand-shop'),
	        'Center' => __('Center','print-on-demand-shop'),
	        'Right' => __('Right','print-on-demand-shop')
	    ),
	) );

	$wp_customize->add_setting('print_on_demand_shop_footer_heading_font_size',array(
		'default'=> 25,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_footer_heading_font_size',array(
		'label' => esc_html__( 'Footer Heading Font Size','print-on-demand-shop' ),
		'section'=> 'print_on_demand_shop_footer_section',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
	)));

	$wp_customize->add_setting('print_on_demand_shop_footer_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize,'print_on_demand_shop_footer_padding',array(
		'label'	=> __('Footer Widget Padding','print-on-demand-shop'),
		'section'=> 'print_on_demand_shop_footer_section',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 100,
      ),
	)));

	$wp_customize->add_setting('print_on_demand_shop_hide_show_scroll',array(
		'default' => true,
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_hide_show_scroll',array(
     	'type' => 'checkbox',
      	'label' => __('Enable / Disable Back To Top','print-on-demand-shop'),
      	'section' => 'print_on_demand_shop_footer_section',
	));

	$wp_customize->add_setting('print_on_demand_shop_back_to_top_icon',array(
		'default'	=> 'fas fa-long-arrow-alt-up',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_back_to_top_icon',array(
		'label'	=> __('Back to Top Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_footer_section',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('print_on_demand_shop_scroll_icon_font_size',array(
		'default'=> 22,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_scroll_icon_font_size',array(
		'label'	=> __('Back To Top Icon Font Size','print-on-demand-shop'),
		'section'=> 'print_on_demand_shop_footer_section',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
	)));

	$wp_customize->add_setting('print_on_demand_shop_scroll_icon_color', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_scroll_icon_color', array(
		'label'    => __('Back to Top Icon Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_footer_section',
	)));

	$wp_customize->add_setting('print_on_demand_shop_scroll_icon_hover_color', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_scroll_icon_hover_color', array(
		'label'    => __('Back to Top Icon Hover Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_footer_section',
	)));

	$wp_customize->add_setting('print_on_demand_shop_scroll_icon_background', array(
		'default'           => '#5F29DE',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_scroll_icon_background', array(
		'label'    => __('Back to Top Background Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_footer_section',
	)));

	$wp_customize->add_setting('print_on_demand_shop_scroll_icon_background_hover', array(
		'default'           => '#5F29DE',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_scroll_icon_background_hover', array(
		'label'    => __('Back to Top Background Hover Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_footer_section',
	)));

	$wp_customize->add_setting('print_on_demand_shop_footer_options',array(
        'default' => 'Right align',
        'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_footer_options',array(
        'type' => 'radio',
        'label' => __('Back To Top Alignment','print-on-demand-shop'),
        'section' => 'print_on_demand_shop_footer_section',
        'choices' => array(
            'Left align' => __('Left Align','print-on-demand-shop'),
            'Right align' => __('Right Align','print-on-demand-shop'),
            'Center align' => __('Center Align','print-on-demand-shop'),
        ),
	) );

	$wp_customize->add_setting( 'print_on_demand_shop_top_bottom_scroll_padding',array(
		'default' => 7,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_top_bottom_scroll_padding',	array(
		'label' => esc_html__( 'Top Bottom Scroll Padding (px)','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_footer_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_left_right_scroll_padding',array(
		'default' => 17,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_left_right_scroll_padding',	array(
		'label' => esc_html__( 'Left Right Scroll Padding (px)','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_footer_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_back_to_top_border_radius',array(
		'default' => 5,
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_back_to_top_border_radius', array(
		'label' => esc_html__( 'Back to Top Border Radius (px)','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_footer_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting('print_on_demand_shop_copyright_hide',array(
		'default' => true,
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_copyright_hide',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Copyright','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_footer_section',
	));	

	$wp_customize->add_setting('print_on_demand_shop_footer_copy',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('print_on_demand_shop_footer_copy',array(
		'label'	=> __('Copyright Text','print-on-demand-shop'),
		'section'	=> 'print_on_demand_shop_footer_section',
		'description'	=> __('Add some text for footer like copyright etc.','print-on-demand-shop'),
		'type'		=> 'text'
	));

	$wp_customize->add_setting('print_on_demand_shop_footer_text_align',array(
        'default' => 'center',
        'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_footer_text_align',array(
        'type' => 'radio',
        'label' => __('Copyright Text Alignment ','print-on-demand-shop'),
        'section' => 'print_on_demand_shop_footer_section',
        'choices' => array(
            'left' => __('Left Align','print-on-demand-shop'),
            'right' => __('Right Align','print-on-demand-shop'),
            'center' => __('Center Align','print-on-demand-shop'),
        ),
	) );

	$wp_customize->add_setting('print_on_demand_shop_copyright_text_font_size',array(
		'default'=> 15,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_copyright_text_font_size',array(
		'label' => esc_html__( 'Copyright Font Size (px)','print-on-demand-shop' ),
		'section'=> 'print_on_demand_shop_footer_section',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
	)));

	$wp_customize->add_setting( 'print_on_demand_shop_footer_text_padding',array(
		'default' => 20,
		'transport' => 'refresh',
		'sanitize_callback' => 'print_on_demand_shop_sanitize_integer'
	));
	$wp_customize->add_control( new Print_On_Demand_Shop_Custom_Control( $wp_customize, 'print_on_demand_shop_footer_text_padding',	array(
		'label' => esc_html__( 'Copyright Text Padding (px)','print-on-demand-shop' ),
		'section' => 'print_on_demand_shop_footer_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting('print_on_demand_shop_copyright_text_color', array(
		'default'           => '#ffffff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_copyright_text_color', array(
		'label'    => __('Copyright Text Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_footer_section',
	)));

	$wp_customize->add_setting('print_on_demand_shop_copyright_text_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_copyright_text_hover_color', array(
		'label'    => __('Copyright Text Hover Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_footer_section',
	)));	

	$wp_customize->add_setting('print_on_demand_shop_copyright_text_background', array(
		'default'           => '#FFF6E9',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_copyright_text_background', array(
		'label'    => __('Copyright background Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_footer_section',
	)));

	//Footer Social Icons
	$wp_customize->add_section('print_on_demand_shop_footer_social_icons',array(
		'title'	=> __('Footer Social Icons','print-on-demand-shop'),
		'priority'	=> null,
		'panel' => 'print_on_demand_shop_panel_id',
	));

	$wp_customize->add_setting('print_on_demand_shop_footer_social_icons_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('print_on_demand_shop_footer_social_icons_premium_info',array(
		'type'=> 'hidden',
		'label' => __('Premium Features','print-on-demand-shop'),
		'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','print-on-demand-shop') ."</li><li>". esc_html__('And so on...','print-on-demand-shop') ."</li></ul><a target='_blank' href='". esc_url(PRINT_ON_DEMAND_SHOP_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','print-on-demand-shop') ."</a>",
		'section'=> 'print_on_demand_shop_footer_social_icons'
 	));

	$wp_customize->add_setting('print_on_demand_shop_footer_social_hide',array(
		'default' => false,
		'sanitize_callback'	=> 'print_on_demand_shop_sanitize_checkbox'
	));
	$wp_customize->add_control('print_on_demand_shop_footer_social_hide',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Footer Icons','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_footer_social_icons',
	));	

	$wp_customize->add_setting('print_on_demand_shop_footer_facebook_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('print_on_demand_shop_footer_facebook_url',array(
		'type' => 'url',
		'label' => __('Add Facebook URL','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_footer_social_icons',
	));

	$wp_customize->add_setting('print_on_demand_shop_footer_facebook_icon',array(
		'default'	=> 'fab fa-facebook-f',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_footer_facebook_icon',array(
		'label'	=> __('Choose Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_footer_social_icons',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('print_on_demand_shop_footer_instagram_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('print_on_demand_shop_footer_instagram_url',array(
		'type' => 'url',
		'label' => __('Add Instagram URL','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_footer_social_icons',
	));

	$wp_customize->add_setting('print_on_demand_shop_footer_instagram_icon',array(
		'default'	=> 'fab fa-instagram',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_footer_instagram_icon',array(
		'label'	=> __('Choose Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_footer_social_icons',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('print_on_demand_shop_footer_twitter_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('print_on_demand_shop_footer_twitter_url',array(
		'type' => 'url',
		'label' => __('Add Twitter URL','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_footer_social_icons',
	));

	$wp_customize->add_setting('print_on_demand_shop_footer_twitter_icon',array(
		'default'	=> 'fab fa-twitter',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_footer_twitter_icon',array(
		'label'	=> __('Choose Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_footer_social_icons',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('print_on_demand_shop_footer_linkedin_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('print_on_demand_shop_footer_linkedin_url',array(
		'type' => 'url',
		'label' => __('Add LinkedIn URL','print-on-demand-shop'),
		'section' => 'print_on_demand_shop_footer_social_icons',
	));

	$wp_customize->add_setting('print_on_demand_shop_footer_linkedin_icon',array(
		'default'	=> 'fa-brands fa-linkedin-in',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Print_On_Demand_Shop_Icon_Changer(
        $wp_customize,'print_on_demand_shop_footer_linkedin_icon',array(
		'label'	=> __('Choose Icon','print-on-demand-shop'),
		'transport' => 'refresh',
		'section'	=> 'print_on_demand_shop_footer_social_icons',
		'type'		=> 'icon'
	)));	

	$wp_customize->add_setting('print_on_demand_shop_footer_social_icons_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('print_on_demand_shop_footer_social_icons_size', array(
		'label'   => __('Icon Font Size', 'print-on-demand-shop'),
		'section' => 'print_on_demand_shop_footer_social_icons',
		'setting' => 'print_on_demand_shop_footer_social_icons_size',
		'type'    => 'text',
	));

	$wp_customize->add_setting('print_on_demand_shop_footer_icon_alignment',array(
        'default' => 'center',
        'sanitize_callback' => 'print_on_demand_shop_sanitize_choices'
	));
	$wp_customize->add_control('print_on_demand_shop_footer_icon_alignment',array(
        'type' => 'radio',
        'label' => __('Icon Alignment ','print-on-demand-shop'),
        'section' => 'print_on_demand_shop_footer_social_icons',
        'choices' => array(
            'left' => __('Left Align','print-on-demand-shop'),
            'right' => __('Right Align','print-on-demand-shop'),
            'center' => __('Center Align','print-on-demand-shop'),
        ),
	) );	

	$wp_customize->add_setting('print_on_demand_shop_footer_icon_color_option', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'print_on_demand_shop_footer_icon_color_option', array(
		'label'    => __('Icon Color', 'print-on-demand-shop'),
		'section'  => 'print_on_demand_shop_footer_social_icons',
	)));

	//Reset All Settings
	$wp_customize->add_section( 'print_on_demand_shop_reset_section', array(
		'title'    => __( 'Reset Theme Settings', 'print-on-demand-shop' ),
		'priority'	=> null,
		'panel' => 'print_on_demand_shop_panel_id',
	) );

	//Reset Demo Import
	$wp_customize->add_setting( 'print_on_demand_shop_reset_demo_import_settings', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control('print_on_demand_shop_reset_demo_import_settings',array(
			'label'   => __( 'Reset Demo Import', 'print-on-demand-shop' ),
			'section' => 'print_on_demand_shop_reset_section',
			'type'    => 'button',
			'input_attrs' => array(
				'onclick' => 'ResetDemoSettings()',
			),
	));

	//Reset Global Color
	$wp_customize->add_setting('print_on_demand_shop_reset_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));

	$wp_customize->add_control('print_on_demand_shop_reset_color', array(
		'type'    => 'button',
		'label'   => __('Reset Global Color', 'print-on-demand-shop'),
		'section' => 'print_on_demand_shop_reset_section',
		'input_attrs' => array(
			'onclick' => 'ResetGlobalColor()',
		),
	));
}
add_action( 'customize_register', 'print_on_demand_shop_customize_register' );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Print_On_Demand_Shop_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Print_On_Demand_Shop_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Print_On_Demand_Shop_Customize_Section_Pro(
				$manager,
				'print_on_demand_shop_example_1',
				array(
					'title'   =>  esc_html__( 'Print On Demand Shop Pro', 'print-on-demand-shop' ),
					'pro_text' => esc_html__( 'Get Pro', 'print-on-demand-shop' ),
					'pro_url'  => esc_url( 'https://www.buywptemplates.com/products/print-on-demand-wordpress-theme' ),
					'priority'   => 9
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'print-on-demand-shop-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'print-on-demand-shop-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/css/customize-controls.css' );
	}

	function print_on_demand_shop_sanitize_choices( $input ) {
		$valid = array(
			'1'     => __('One', 'print-on-demand-shop'),
			'2'     => __('Two', 'print-on-demand-shop'),
			'3'     => __('Three', 'print-on-demand-shop'),
			'4'     => __('Four', 'print-on-demand-shop')
		);
		if ( array_key_exists( $input, $valid ) ) {
			return $input;
		} else {
	  		return '';
		}
	}

}

// Doing this customizer thang!
Print_On_Demand_Shop_Customize::get_instance();