<div class="theme-offer">
	<?php
        // Check if the demo import has been completed
        $print_on_demand_shop_demo_import_completed = get_option('print_on_demand_shop_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($print_on_demand_shop_demo_import_completed) {
        echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'print-on-demand-shop') . '</p>';
        echo '<span><a href="' . esc_url(home_url()) . '" class="site-btn" target="_blank">' . esc_html__('VIEW SITE', 'print-on-demand-shop') . '</a></span>';
        }
		
        if (isset($_POST['submit'])) {

            //woocommerce

            if (!is_plugin_active('woocommerce/woocommerce.php')) {
                // Install the plugin if it doesn't exist
                $print_on_demand_shop_plugin_slug = 'woocommerce';
                $print_on_demand_shop_plugin_file = 'woocommerce/woocommerce.php';
  
                // Check if plugin is installed
                $print_on_demand_shop_installed_plugins = get_plugins();
                if (!isset($print_on_demand_shop_installed_plugins[$print_on_demand_shop_plugin_file])) {
                    include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
                    include_once(ABSPATH . 'wp-admin/includes/file.php');
                    include_once(ABSPATH . 'wp-admin/includes/misc.php');
                    include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');
  
                    // Install the plugin
                    $print_on_demand_shop_upgrader = new Plugin_Upgrader();
                    $print_on_demand_shop_upgrader->install('https://downloads.wordpress.org/plugin/woocommerce.latest-stable.zip');
                }
                // Activate the plugin
                activate_plugin($print_on_demand_shop_plugin_file);
            }

            // --- YITH WooCommerce Wishlist Plugin ---
                $wishlist_plugin_slug = 'yith-woocommerce-wishlist';
                $wishlist_plugin_file = 'yith-woocommerce-wishlist/init.php';

                if (!is_plugin_active($wishlist_plugin_file)) {
                    $installed_plugins = get_plugins();
                    if (!isset($installed_plugins[$wishlist_plugin_file])) {
                        // Required includes
                        include_once ABSPATH . 'wp-admin/includes/plugin-install.php';
                        include_once ABSPATH . 'wp-admin/includes/file.php';
                        include_once ABSPATH . 'wp-admin/includes/misc.php';
                        include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';

                        // Install the plugin
                        $wishlist_upgrader = new Plugin_Upgrader();
                        $wishlist_upgrader->install('https://downloads.wordpress.org/plugin/yith-woocommerce-wishlist.latest-stable.zip');
                    }

                    // Activate the plugin
                    activate_plugin($wishlist_plugin_file);
                }


            // ------- Create Nav Menu --------
            $print_on_demand_shop_menuname = 'Main Menus';
            $print_on_demand_shop_bpmenulocation = 'primary';
            $print_on_demand_shop_menu_exists = wp_get_nav_menu_object($print_on_demand_shop_menuname);

            if (!$print_on_demand_shop_menu_exists) {
                $print_on_demand_shop_menu_id = wp_create_nav_menu($print_on_demand_shop_menuname);

                // Create Home Page
                $print_on_demand_shop_home_title = 'Home';
                $print_on_demand_shop_home = array(
                    'post_type' => 'page',
                    'post_title' => $print_on_demand_shop_home_title,
                    'post_content' => '',
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'home'
                );
                $print_on_demand_shop_home_id = wp_insert_post($print_on_demand_shop_home);
                // Assign Home Page Template
                add_post_meta($print_on_demand_shop_home_id, '_wp_page_template', 'page-template/home-page.php');
                // Update options to set Home Page as the front page
                update_option('page_on_front', $print_on_demand_shop_home_id);
                update_option('show_on_front', 'page');
                // Add Home Page to Menu
                wp_update_nav_menu_item($print_on_demand_shop_menu_id, 0, array(
                    'menu-item-title' => __('Home', 'print-on-demand-shop'),
                    'menu-item-classes' => 'home',
                    'menu-item-url' => home_url('/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $print_on_demand_shop_home_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Pages Page with Dummy Content
                $print_on_demand_shop_features_title = 'Features';
                $print_on_demand_shop_features_content = 'Explore all the about we have on our website. Find information about our services, company, and more.
                 Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more contactly with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>
                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $print_on_demand_shop_features = array(
                    'post_type' => 'page',
                    'post_title' => $print_on_demand_shop_features_title,
                    'post_content' => $print_on_demand_shop_features_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'features'
                );
                $print_on_demand_shop_features_id = wp_insert_post($print_on_demand_shop_features);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($print_on_demand_shop_menu_id, 0, array(
                    'menu-item-title' => __('features', 'print-on-demand-shop'),
                    'menu-item-classes' => 'features',
                    'menu-item-url' => home_url('/features/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $print_on_demand_shop_features_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));
                
                // Create Pages Page with Dummy Content
                $print_on_demand_shop_course_title = 'Course';
                $print_on_demand_shop_course_content = 'Explore all the about we have on our website. Find information about our services, company, and more.
                    Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more contactly with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>
                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $print_on_demand_shop_course = array(
                    'post_type' => 'page',
                    'post_title' => $print_on_demand_shop_course_title,
                    'post_content' => $print_on_demand_shop_course_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'course'
                );
                $print_on_demand_shop_course_id = wp_insert_post($print_on_demand_shop_course);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($print_on_demand_shop_menu_id, 0, array(
                    'menu-item-title' => __('course', 'print-on-demand-shop'),
                    'menu-item-classes' => 'course',
                    'menu-item-url' => home_url('/course/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $print_on_demand_shop_course_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Pages Page with Dummy Content
                $print_on_demand_shop_events_title = 'Events';
                $print_on_demand_shop_events_content = 'Explore all the about we have on our website. Find information about our services, company, and more.
                 Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more contactly with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>
                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $print_on_demand_shop_events = array(
                    'post_type' => 'page',
                    'post_title' => $print_on_demand_shop_events_title,
                    'post_content' => $print_on_demand_shop_events_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'events'
                );
                $print_on_demand_shop_events_id = wp_insert_post($print_on_demand_shop_events);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($print_on_demand_shop_menu_id, 0, array(
                    'menu-item-title' => __('events', 'print-on-demand-shop'),
                    'menu-item-classes' => 'events',
                    'menu-item-url' => home_url('/events/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $print_on_demand_shop_events_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Pages Page with Dummy Content
                $print_on_demand_shop_portfolio_title = 'Portfolio';
                $print_on_demand_shop_portfolio_content = 'Explore all the about we have on our website. Find information about our services, company, and more.
                    Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more contactly with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>
                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $print_on_demand_shop_portfolio = array(
                    'post_type' => 'page',
                    'post_title' => $print_on_demand_shop_portfolio_title,
                    'post_content' => $print_on_demand_shop_portfolio_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'portfolio'
                );
                $print_on_demand_shop_portfolio_id = wp_insert_post($print_on_demand_shop_portfolio);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($print_on_demand_shop_menu_id, 0, array(
                    'menu-item-title' => __('portfolio', 'print-on-demand-shop'),
                    'menu-item-classes' => 'portfolio',
                    'menu-item-url' => home_url('/portfolio/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $print_on_demand_shop_portfolio_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Pages Page with Dummy Content
                $print_on_demand_shop_contact_title = 'Contact Us';
                $print_on_demand_shop_contact_content = 'Explore all the contact we have on our website. Find information about our services, company, and more.
                 Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more contactly with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>
                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $print_on_demand_shop_contact = array(
                    'post_type' => 'page',
                    'post_title' => $print_on_demand_shop_contact_title,
                    'post_content' => $print_on_demand_shop_contact_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'contact'
                );
                $print_on_demand_shop_contact_id = wp_insert_post($print_on_demand_shop_contact);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($print_on_demand_shop_menu_id, 0, array(
                    'menu-item-title' => __('Contact', 'print-on-demand-shop'),
                    'menu-item-classes' => 'contact',
                    'menu-item-url' => home_url('/contact/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $print_on_demand_shop_contact_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create wishlist
                $print_on_demand_shop_page_query = new WP_Query(array(
                   'post_type' => 'page',
                   'title' => 'Wishlist',
                   'post_status' => 'publish',
                   'posts_per_page' => 1
                ));
     
                if (!$print_on_demand_shop_page_query->have_posts()) {
                    $print_on_demand_shop_page_title = 'Wishlist';
                    $trackorder = '[yith_wcwl_wishlist]';

                    // Append the WooCommerce tracking shortcode to the content
                    $print_on_demand_shop_content .= do_shortcode($trackorder);

                    // Create the new page
                    $print_on_demand_shop_page = array(
                        'post_type'    => 'page',
                        'post_title'   => $print_on_demand_shop_page_title,
                        'post_content' => $print_on_demand_shop_content,
                        'post_status'  => 'publish',
                        'post_author'  => 1,
                        'post_slug'    => 'track-order'
                    );

                    // Insert the page and get its ID
                    $print_on_demand_shop_page_id = wp_insert_post($print_on_demand_shop_page);

                    // Store the page URL in theme mod
                    if (!is_wp_error($print_on_demand_shop_page_id)) {
                        $print_on_demand_shop_page_url = get_permalink($print_on_demand_shop_page_id); // Get the page URL
                        set_theme_mod('print_on_demand_shop_track_button_url', esc_url($print_on_demand_shop_page_url)); // Save the page URL in theme mod
                    }
                }

                // Set the menu location if it's not already set
                if (!has_nav_menu($print_on_demand_shop_bpmenulocation)) {
                    $print_on_demand_shop_locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
                    if (empty($print_on_demand_shop_locations)) {
                        $print_on_demand_shop_locations = array();
                    }
                    $print_on_demand_shop_locations[$print_on_demand_shop_bpmenulocation] = $print_on_demand_shop_menu_id;
                    set_theme_mod('nav_menu_locations', $print_on_demand_shop_locations);
                }
            }

            // Assign the menu to the theme location
            set_theme_mod('nav_menu_locations', [$print_on_demand_shop_bpmenulocation => $print_on_demand_shop_menu_id]);
                        
            // Set the demo import completion flag
    		update_option('print_on_demand_shop_demo_import_completed', true);
    		// Display success message and "View Site" button
    		echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'print-on-demand-shop') . '</p>';
    		echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('VIEW SITE', 'print-on-demand-shop') . '</a></span>';
            //end

            // Header      
            set_theme_mod( 'print_on_demand_shop_header_search_icon', true );
            set_theme_mod( 'print_on_demand_shop_header_search_icon','fas fa-search' );
            set_theme_mod( 'print_on_demand_shop_header_wishlist_icon', 'fa-solid fa-heart' );
            set_theme_mod( 'print_on_demand_shop_header_cart_icon', 'fa-solid fa-cart-shopping' );

            // Banner
            set_theme_mod( 'print_on_demand_shop_banner_hide', true );
            set_theme_mod( 'print_on_demand_shop_banner_small_title', 'Print On Demand' );
            set_theme_mod( 'print_on_demand_shop_banner_title', 'Bring Your Design to life with our Professional Printing.' );
            set_theme_mod( 'print_on_demand_shop_banner_desc_text', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed  do  eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad' );
            set_theme_mod( 'print_on_demand_shop_banner_btn_text1', 'Explore More' );
            set_theme_mod( 'print_on_demand_shop_banner_btn_url1', '#' );
            set_theme_mod( 'print_on_demand_shop_banner_btn_text2', 'Order Now' );
            set_theme_mod( 'print_on_demand_shop_banner_btn_url2', '#' );
            set_theme_mod( 'print_on_demand_shop_banner_bottom_title', 'Client\'s Review' );
            set_theme_mod( 'print_on_demand_shop_banner_bottom_image', get_template_directory_uri() . '/images/Clients.png' );
            set_theme_mod( 'print_on_demand_shop_banner_review_desc', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.' );

            // Banner Product Section Setup
        set_theme_mod('print_on_demand_shop_product_category', 'banner-products');

        // Define banner product category and product titles
        $print_on_demand_shop_category_names = array('banner-products');
        $print_on_demand_shop_title_array = array(
            array(
                'box Printing',
                'Mug Customization',
                'T-Shirt Printing',
                'phone case Design',
                'Cap Embroidery',
                'Cup Printing',
            )
        );

        // Loop through categories and create products
        foreach ($print_on_demand_shop_category_names as $print_on_demand_index => $print_on_demand_category_name) {
            // Check if category exists, create if not
            $print_on_demand_term = term_exists($print_on_demand_category_name, 'product_cat');

            if ($print_on_demand_term === 0 || $print_on_demand_term === null) {
                $print_on_demand_term = wp_insert_term($print_on_demand_category_name, 'product_cat');
            }

            if (is_wp_error($print_on_demand_term)) {
                error_log('Error creating category: ' . $print_on_demand_term->get_error_message());
                continue;
            }

            $print_on_demand_term_id = $print_on_demand_term['term_id'];

            // Create 6 products in this category
            for ($print_on_demand_i = 0; $print_on_demand_i < 6; $print_on_demand_i++) {
                $print_on_demand_title = $print_on_demand_shop_title_array[$print_on_demand_index][$print_on_demand_i];
                $print_on_demand_content = 'This is a demo product for ' . $print_on_demand_title . '.';

                $print_on_demand_product_post = array(
                    'post_title'   => wp_strip_all_tags($print_on_demand_title),
                    'post_content' => $print_on_demand_content,
                    'post_status'  => 'publish',
                    'post_type'    => 'product',
                );

                $print_on_demand_post_id = wp_insert_post($print_on_demand_product_post);

                if (is_wp_error($print_on_demand_post_id)) {
                    error_log('Error creating product: ' . $print_on_demand_post_id->get_error_message());
                    continue;
                }

                // Assign category
                wp_set_object_terms($print_on_demand_post_id, array($print_on_demand_term_id), 'product_cat');
                
                // WooCommerce meta for product setup
                update_post_meta($print_on_demand_post_id, '_regular_price', '20.00');
                update_post_meta($print_on_demand_post_id, '_price', '15.00');
                update_post_meta($print_on_demand_post_id, '_stock_status', 'instock');
                wp_set_object_terms($print_on_demand_post_id, 'simple', 'product_type');

                // Set image using media_sideload_image
                $print_on_demand_image_url = get_template_directory_uri() . '/images/banner' . ($print_on_demand_i + 1) . '.png';
                $print_on_demand_image_id = media_sideload_image($print_on_demand_image_url, $print_on_demand_post_id, null, 'id');

                if (is_wp_error($print_on_demand_image_id)) {
                    error_log('Image failed for product: ' . $print_on_demand_title);
                    continue;
                }

                set_post_thumbnail($print_on_demand_post_id, $print_on_demand_image_id);
            }
        }

            // Product Section

            // Set section titles
            set_theme_mod('print_on_demand_shop_section_sub_title', 'Products');
            set_theme_mod('print_on_demand_shop_section_title', 'Our Popular Products');
            set_theme_mod('print_on_demand_shop_product_section_btn_text', 'Explore More');
            set_theme_mod('print_on_demand_shop_product_section_btn_url', '#');

            // Create a new category: 'popular-category'
            $popular_category_name = 'popular-category';
            $popular_category_term = term_exists($popular_category_name, 'product_cat');

            if (!$popular_category_term) {
                $popular_category_term = wp_insert_term($popular_category_name, 'product_cat');
            }
            if (!is_wp_error($popular_category_term)) {
                $popular_category_id = $popular_category_term['term_id'];

                // Set this category in customizer
                set_theme_mod('print_on_demand_shop_popular_product_category', $popular_category_name);

                // Define product titles and image URLs
            $print_on_demand_product_titles = array(
                'T Shirt Printing',
                'Business Card Printing',
                'Banner Printing',
                'Cup Printing'
            );

            foreach ($print_on_demand_product_titles as $print_on_demand_index => $print_on_demand_product_title) {
                $print_on_demand_product_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.';
                $product_args = array(
                    'post_title'    => wp_strip_all_tags($print_on_demand_product_title),
                    'post_content'  => $print_on_demand_product_content,
                    'post_status'   => 'publish',
                    'post_type'     => 'product',
                );

                $print_on_demand_product_id = wp_insert_post($product_args);

                if (!is_wp_error($print_on_demand_product_id)) {
                    // Assign to category
                    wp_set_object_terms($print_on_demand_product_id, array($popular_category_id), 'product_cat');

                    // Set price
                    update_post_meta($print_on_demand_product_id, '_regular_price', '99.00');
                    update_post_meta($print_on_demand_product_id, '_price', '99.00');

                    // Add featured image (make sure image exists)
                    $print_on_demand_image_url = get_template_directory_uri() . '/images/product' . ($print_on_demand_index + 1) . '.png';
                    $print_on_demand_image_id = media_sideload_image($print_on_demand_image_url, $print_on_demand_product_id, null, 'id');

                    if (!is_wp_error($print_on_demand_image_id)) {
                        set_post_thumbnail($print_on_demand_product_id, $print_on_demand_image_id);
                    }
                }
            }
        }       
            //Copyright Text
            set_theme_mod( 'print_on_demand_shop_footer_text', 'By Buywptemplate' );

        }
    ?>

    <form action="<?php echo esc_url(home_url()); ?>/wp-admin/themes.php?page=print-on-demand-shop-guide-page" method="POST" onsubmit="return validate(this);">
        <?php if (!get_option('print_on_demand_shop_demo_import_completed')) : ?>
            <form method="post">
            <p><?php esc_html_e('Click the below run importer button to import demo content','print-on-demand-shop'); ?></p>
                <input class= "run-import" type="submit" name="submit" value="<?php esc_attr_e('Run Importer','print-on-demand-shop'); ?>" class="button button-primary button-large">
            </form>
        <?php endif; ?>
    </form>
    <script type="text/javascript">
	function validate(valid) {
		if (confirm("Do you really want to import the theme demo content?")) {
			// Show loader
			document.getElementById('demo-import-loader').style.display = 'block';
			
			// Submit form
			document.forms[0].submit();
		} else {
			return false;
		}
	}
</script>

</div>
