<?php
add_action( 'admin_menu', 'print_on_demand_shop_gettingstarted' );
function print_on_demand_shop_gettingstarted() {
	add_theme_page( esc_html__('Theme Demo Import', 'print-on-demand-shop'), esc_html__('Theme Demo Import', 'print-on-demand-shop'), 'edit_theme_options', 'print-on-demand-shop-guide-page', 'print_on_demand_shop_guide');
}

function print_on_demand_shop_admin_theme_style() {
   wp_enqueue_style('print-on-demand-shop-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/dashboard/get_started_info.css');
   wp_enqueue_script('print-on-demand-shop-tab', esc_url( get_template_directory_uri() ) . '/inc/dashboard/js/get_started_tab.js');
}
add_action('admin_enqueue_scripts', 'print_on_demand_shop_admin_theme_style');

function print_on_demand_shop_notice(){
    global $pagenow;
    if ( is_admin() && ('themes.php' == $pagenow) && isset( $_GET['activated'] ) ) {?>
    <div class="notice notice-success is-dismissible getting_started activation-notice">
		<div class="notice-info">
			<div class="notice-image">
				<img style="width: 100%;max-width: 320px;line-height: 40px;display: inline-block;vertical-align: top;" src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/screenshot.png'; ?>" />
			</div>
			<div class="notice-content">
				<h2><?php esc_html_e( 'Thanks For Installing Print On Demand Shop, You Rock!', 'print-on-demand-shop' ) ?> </h2>
				<p><?php esc_html_e( 'Take benefit of a variety of features, functionalities, elements, and an exclusive set of customization options to build your own professional charity website. Please Click on the link below to know the theme setup information.', 'print-on-demand-shop' ) ?></p>
				<div style="display: grid;">
					<a class="button notice-btn" href="<?php echo esc_url( admin_url( 'themes.php?page=print-on-demand-shop-guide-page' )); ?>"><?php esc_html_e( 'Getting Started', 'print-on-demand-shop' ) ?></a>
					<a class="button notice-btn" target="_blank" href="<?php echo esc_url( PRINT_ON_DEMAND_SHOP_LIVE_DEMO ); ?>"><?php esc_html_e('Pro Demo', 'print-on-demand-shop') ?></a>
					<a  class="button notice-btn" target="_blank" href="<?php echo esc_url( PRINT_ON_DEMAND_SHOP_FREE_DOC ); ?>"><?php esc_html_e('Free Doc', 'print-on-demand-shop') ?></a>
					<a  class="button notice-btn" target="_blank" href="<?php echo esc_url( PRINT_ON_DEMAND_SHOP_BUY_PRO ); ?>"><?php esc_html_e('Upgrade To Pro', 'print-on-demand-shop') ?></a>
				</div>
			</div>
		</div>
	</div>
	<?php }
}
add_action('admin_notices', 'print_on_demand_shop_notice');

/**
 * Theme Info Page
 */
function print_on_demand_shop_guide() {
	// Theme info
	$print_on_demand_shop_return = add_query_arg( array()) ;
	$print_on_demand_shop_theme = wp_get_theme( 'print-on-demand-shop' ); ?>

	<div class="wrap getting-started">
		<div class="getting-started__header">
		    <div>
                <h2 class="tgmpa-notice-warning"></h2>
            </div>
		</div>
		<div class="tab-sec">
			<div class="tab">
				<button role="tab" class="tablinks home" onclick="print_on_demand_shop_openCity(event, 'bwp_getstart')"><?php esc_html_e( 'Getting Started', 'print-on-demand-shop' ); ?></button>
				<button role="tab" class="tablinks" onclick="print_on_demand_shop_openCity(event, 'bwp_setup')"><?php esc_html_e( 'Free Theme Information', 'print-on-demand-shop' ); ?></button>
				<button role="tab" class="tablinks" onclick="print_on_demand_shop_openCity(event, 'bwp_premium_info')"><?php esc_html_e( 'Premium Theme Information', 'print-on-demand-shop' ); ?></button>
				<a class="tablinks tablinks-demo" role="tab" href="<?php echo esc_url( PRINT_ON_DEMAND_SHOP_LIVE_DEMO ); ?>" target="_blank">
					<?php esc_html_e( 'Live Demo', 'print-on-demand-shop' ); ?>
				</a>
				<a class="tablinks tablinks-pro" role="tab" href="<?php echo esc_url( PRINT_ON_DEMAND_SHOP_BUY_PRO ); ?>" target="_blank">
					<?php esc_html_e( 'Buy Pro', 'print-on-demand-shop' ); ?>
				</a>
			</div>
			<div  id="bwp_getstart" class="tabcontent">
				<div class="row">
					<div class="col-md-5 intro">
						<div class="pad-box">
							<h2><?php esc_html_e( 'Welcome to Print On Demand Shop ', 'print-on-demand-shop' ); ?>
							<span><?php esc_html_e( 'Version: ', 'print-on-demand-shop' ); ?><?php echo esc_html($print_on_demand_shop_theme['Version']);?></span>
							</h2>
							<span class="intro__version"><?php esc_html_e( 'Congratulations! You are about to use the most easy to use and flexible WordPress theme.', 'print-on-demand-shop' ); ?>
							</span>
							<div class="powered-by">
								<p><strong><?php esc_html_e( 'Theme created by Buy WP Templates', 'print-on-demand-shop' ); ?></strong></p>
								<p>
									<img class="logo" src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/theme-logo.png'); ?>"/>
								</p>
									<div class="demo-content">
									<?php
										/* Demo Import */
										require get_parent_theme_file_path( '/inc/dashboard/demo-content.php' );
									?>
								</div>
								<div id="demo-import-loader">
									<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/spinner.gif'); ?>" alt="<?php echo esc_attr( 'Loading...', 'print-on-demand-shop'); ?>" />
								</div>
							</div>
						</div>
					</div>
					<div class="col-md-7">
						<div class="install-plugins">
							<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/responsive1.png'); ?>" alt="<?php echo esc_attr( 'responsive-image', 'print-on-demand-shop'); ?>" />
						</div>
					</div>
				</div>
				<div class="dashboard__blocks">
					<div class="row">
						<div class="col-md-3">
							<h3><?php esc_html_e( 'Get Support','print-on-demand-shop'); ?></h3>
							<ol>
								<li><a target="_blank" href="<?php echo esc_url( PRINT_ON_DEMAND_SHOP_FREE_SUPPORT ); ?>"><?php esc_html_e( 'Free Theme Support','print-on-demand-shop'); ?></a></li>
								<li><a target="_blank" href="<?php echo esc_url( PRINT_ON_DEMAND_SHOP_PRO_SUPPORT ); ?>"><?php esc_html_e( 'Premium Theme Support','print-on-demand-shop'); ?></a></li>
							</ol>
						</div>
						<div class="col-md-3">
							<h3><?php esc_html_e( 'Getting Started','print-on-demand-shop'); ?></h3>
							<ol>
								<li><?php esc_html_e( 'Start','print-on-demand-shop'); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizing','print-on-demand-shop'); ?></a> <?php esc_html_e( 'your website.','print-on-demand-shop'); ?> </li>
							</ol>
						</div>
						<div class="col-md-3">
							<h3><?php esc_html_e( 'Help Docs','print-on-demand-shop'); ?></h3>
							<ol>
								<li><a target="_blank" href="<?php echo esc_url( PRINT_ON_DEMAND_SHOP_FREE_DOC ); ?>"><?php esc_html_e( 'Free Theme Documentation','print-on-demand-shop'); ?></a></li>
								<li><a target="_blank" href="<?php echo esc_url( PRINT_ON_DEMAND_SHOP_PRO_DOC ); ?>"><?php esc_html_e( 'Premium Theme Documentation','print-on-demand-shop'); ?></a></li>
							</ol>
						</div>
						<div class="col-md-3">
							<h3><?php esc_html_e( 'Buy Premium','print-on-demand-shop'); ?></h3>
							<ol>
								<a href="<?php echo esc_url( PRINT_ON_DEMAND_SHOP_BUY_PRO ); ?>" target="_blank"><?php esc_html_e('Buy Pro', 'print-on-demand-shop'); ?></a>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<div  id="bwp_setup" class="tabcontent">
				<h2 class="tg-docs-section intruction-title" id="section-4"><?php esc_html_e( '1) Setup Print On Demand Shop Theme', 'print-on-demand-shop' ); ?></h2>
				<div class="row">
					<div class="theme-instruction-block col-md-7">
						<div class="pad-box">
							<p><?php esc_html_e( 'The Print on Demand Theme is a modern, multipurpose solution designed for entrepreneurs, artists, designers, and agencies looking to launch a custom merchandise store or ecommerce business with ease. Crafted with a minimal yet elegant layout, it delivers a clean and sophisticated aesthetic that captures attention while remaining user-friendly and intuitive for all skill levels. Built on the robust Bootstrap framework, the theme is fully responsive, mobile-friendly, and optimized for SEO, ensuring a seamless browsing experience across all devices. It boasts retina-ready visuals for crystal-clear image displays, making your print on demand products like t-shirts, mugs, hoodies, posters, and custom art prints appear stunning and lifelike. Packed with powerful personalization options, including customizable banners, color schemes, and font settings, it reflects your brand’s unique identity while supporting creative online stores, digital product sales, and dropshipping businesses. Key features include an integrated testimonial section, Call to Action (CTA) buttons, and a dedicated Team section—perfect for building trust and credibility with potential buyers. Social media integration ensures your content is shareable and engaging, while its agency-friendly setup suits freelancers and print on demand startups alike. With interactive elements, translation-ready support, secure code, and fast load times, this theme provides the perfect foundation for creating an online t-shirt shop, custom mug store, merchandise shop, or personalized gift business. Best of all, it works seamlessly with the WooCommerce plugin to manage orders, payments, shipping, and inventory, making it a powerful solution for launching a professional and high-performing print on demand shop.', 'print-on-demand-shop' ); ?><p><br>
							<ol>
								<li><?php esc_html_e( 'Start','print-on-demand-shop'); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizing','print-on-demand-shop'); ?></a> <?php esc_html_e( 'your website.','print-on-demand-shop'); ?> </l>
								<li><?php esc_html_e( 'Print On Demand Shop','print-on-demand-shop'); ?> <a target="_blank" href="<?php echo esc_url( PRINT_ON_DEMAND_SHOP_FREE_DOC ); ?>"><?php esc_html_e( 'Documentation','print-on-demand-shop'); ?></a> </li>
							</ol>
						</div>
					</div>
					<div class="col-md-5">
						<div class="pad-box">
								<img class="logo" src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/screenshot.png'); ?>"/>
						</div>
					</div>	
				</div>
			</div>
			<div class="col-md-12 text-block tabcontent"  id="bwp_premium_info">
				<h2 class="dashboard-install-title"><?php esc_html_e( '2) Premium Theme Information.','print-on-demand-shop'); ?></h2>
				<div class="row">
					<div class="col-md-7">
						<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/responsive.png'); ?>" alt="<?php echo esc_attr( 'responsive-image', 'print-on-demand-shop'); ?>">
						<div class="pad-box">
							<h3><?php esc_html_e( 'Pro Theme Description','print-on-demand-shop'); ?></h3>
							<p class="pad-box-p"><?php esc_html_e( 'The Print on Demand WordPress Theme is a modern, multipurpose solution designed for entrepreneurs, artists, and agencies looking to launch a custom merchandise store with ease. Crafted with a minimal yet elegant layout, the theme delivers a clean and sophisticated aesthetic that captures attention while remaining user-friendly and intuitive for all skill levels.Built on the robust Bootstrap framework, the theme is fully responsive and mobile-friendly, ensuring a seamless browsing experience across all devices. It boasts retina-ready visuals for crystal-clear image displays, making your product images appear more stunning and lifelike. This theme is packed with powerful personalization options, including customizable banners, color schemes, and font settings, allowing you to reflect your brands unique identity. It also includes key features such as an integrated testimonial section, Call to Action (CTA) buttons, and a dedicated Team section—perfect for building trust and credibility with potential buyers. Whether youre a developer or a beginner, the themes shortcodes and clean code structure make customization fast and easy. Its translation-ready, secure, and optimized with a faster page load time for better performance and SEO. Social media integration ensures your content is shareable and your audience engaged, while its agency-friendly setup suits creative teams and freelancers alike. With its interactive, sometimes animated elements and overall luxurious vibe, this free theme is the ideal choice for launching a professional print on demand business. Whether you\'re selling t-shirts, mugs, or custom art prints, this theme offers the perfect foundation to build a beautiful, functional, and high-performing online store.', 'print-on-demand-shop' ); ?><p>
						</div>
					</div>
					<div class="col-md-5 install-plugin-right">
						<div class="pad-box">
							<h3><?php esc_html_e( 'Pro Theme Features','print-on-demand-shop'); ?></h3>
							<div class="dashboard-install-benefit">
								<ul>
									<li><?php esc_html_e( 'Theme options using Customizer API','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Responsive design','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Site Icon and Logo option','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Header Images option','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Favicon, Logo, title, and tagline customization','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Advanced Color options and color pallets','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( '100+ Font Family Options','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Pagination option','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Demo Importer','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Enable-Disable options on All sections','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Main Slider','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Woocommerce Compatible','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Unlimited Slides','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Section to show categories','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Product Listing based on category','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Top Categories Section','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Best Seller Tab','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Testimonial with custom post type','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Promotional Banners','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Partner Listing','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Shortcodes for Testimonials','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Newsletter with the help of contact form 7.','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Well-sanitized as per WordPress standards.','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Responsive layout for all devices','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Typography for the complete website','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Global Color pallete','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Section specific Color pallete','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Fully integrated with Font Awesome Icon','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Instagram Section','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Partner Listing','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Background Image Option','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Custom page templates','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Allow setting site title, tagline, logo','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Left and Right Sidebar','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Sticky post & Comment threads','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Customizable Home Page','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Multiple inner page templates','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Contact Page Template','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Blog Full width and right and left sidebar','print-on-demand-shop'); ?></li>
									<li><?php esc_html_e( 'Recent post widget with images, Related post','print-on-demand-shop'); ?></li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php }?>
