// Menu
function print_on_demand_shop_openNav() {
  jQuery(".sidenav").addClass('show');
}
function print_on_demand_shop_closeNav() {
  jQuery(".sidenav").removeClass('show');
}

( function( window, document ) {
  function print_on_demand_shop_keepFocusInMenu() {
    document.addEventListener( 'keydown', function( e ) {
      const print_on_demand_shop_nav = document.querySelector( '.sidenav' );

      if ( ! print_on_demand_shop_nav || ! print_on_demand_shop_nav.classList.contains( 'show' ) ) {
        return;
      }
      const elements = [...print_on_demand_shop_nav.querySelectorAll( 'input, a, button' )],
        print_on_demand_shop_lastEl = elements[ elements.length - 1 ],
        print_on_demand_shop_firstEl = elements[0],
        print_on_demand_shop_activeEl = document.activeElement,
        tabKey = e.keyCode === 9,
        shiftKey = e.shiftKey;

      if ( ! shiftKey && tabKey && print_on_demand_shop_lastEl === print_on_demand_shop_activeEl ) {
        e.preventDefault();
        print_on_demand_shop_firstEl.focus();
      }

      if ( shiftKey && tabKey && print_on_demand_shop_firstEl === print_on_demand_shop_activeEl ) {
        e.preventDefault();
        print_on_demand_shop_lastEl.focus();
      }
    } );
  }
  print_on_demand_shop_keepFocusInMenu();
} )( window, document );

// scroll
jQuery(document).ready(function () {
	jQuery(window).scroll(function () {
    if (jQuery(this).scrollTop() > 0) {
      jQuery('#scrollbutton').fadeIn();
    } else {
      jQuery('#scrollbutton').fadeOut();
    }
	});
	jQuery(window).on("scroll", function () {
	  document.getElementById("scrollbutton").style.display = "block";
	});
	jQuery('#scrollbutton').click(function () {
    jQuery("html, body").animate({
      scrollTop: 0
    }, 600);
    return false;
	});
});

// preloader
jQuery(function($){
  setTimeout(function(){
    $(".frame").delay(1000).fadeOut("slow");
  });
});

// Header search
jQuery('document').ready(function($){
  $('.main-search span a').click(function(){
    $(".searchform_page").slideDown(500);
    print_on_demand_shop_Keyboard_loop($('.searchform_page'));
  });

  $('.close a').click(function(){
    $(".searchform_page").slideUp(500);
  });
});

var print_on_demand_shop_Keyboard_loop = function (elem) {
  var print_on_demand_shop_tabbable = elem.find('select, input, textarea, button, a').filter(':visible');

  var print_on_demand_shop_firstTabbable = print_on_demand_shop_tabbable.first();
  var print_on_demand_shop_lastTabbable = print_on_demand_shop_tabbable.last();
  print_on_demand_shop_firstTabbable.focus();

  /*redirect last tab to first input*/
  print_on_demand_shop_lastTabbable.on('keydown', function (e) {
    if ((e.which === 9 && !e.shiftKey)) {
      e.preventDefault();
      print_on_demand_shop_firstTabbable.focus();
    }
  });

  /*redirect first shift+tab to last input*/
  print_on_demand_shop_firstTabbable.on('keydown', function (e) {
    if ((e.which === 9 && e.shiftKey)) {
      e.preventDefault();
      print_on_demand_shop_lastTabbable.focus();
    }
  });

  /* allow escape key to close insiders div */
  elem.on('keyup', function (e) {
    if (e.keyCode === 27) {
      elem.hide();
    };
  });
};

// Product Slider
jQuery(document).ready(function($){
  $('#banner .slider-for').slick({
    slidesToShow: 1,
    slidesToScroll: 1,
    arrows: false,
    fade: true,
    asNavFor: '.slider-nav',
    autoplay: true,
    autoplaySpeed: 3000
  });

  $('#banner .slider-nav').slick({
    slidesToShow: 5,
    slidesToScroll: 1,
    asNavFor: '.slider-for',
    dots: false,
    centerMode: true,
    centerPadding: '0px', // 🔧 Important!
    focusOnSelect: true,
    arrows: true,
    prevArrow: "<i class='fa-solid fa-arrow-left arrow-prev'></i>",
    nextArrow: "<i class='fa-solid fa-arrow-right arrow-next'></i>",
    autoplay: true,
    autoplaySpeed: 3000,
    responsive: [
      {
        breakpoint: 1199,
        settings: {
          slidesToShow: 3
        }
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1
        }
      }
    ]
  });
});