( function( api ) {

	// Extends our custom "print-on-demand-shop" section.
	api.sectionConstructor['print-on-demand-shop'] = api.Section.extend( {

		// No events for this type of section.
		attachEvents: function () {},

		// Always make the section active.
		isContextuallyActive: function () {
			return true;
		}
	} );

} )( wp.customize );

(function ($) {
    function ResetDemoSettings() {
        if (!confirm("Are you sure you want to reset demo import settings?")) return;

        $.post(ajaxurl, { action: 'print_on_demand_shop_reset_demo_import_settings' }, function () {
            location.reload();
        });
    }

    window.ResetDemoSettings = ResetDemoSettings;
})(jQuery);

(function ($, wp) {
    function ResetGlobalColor() {
        if (confirm("Are you sure you want to reset global color settings?")) {
            wp.customize.instance("print_on_demand_shop_first_color").set("#5F29DE");
			wp.customize.instance("print_on_demand_shop_second_color").set("#FFF6E9");
        }
    }

    window.ResetGlobalColor = ResetGlobalColor;
})(jQuery, wp);
