<?php
/**
 * Template Name: Custom Home Page
 */

get_header(); 

?>

<main role="main" id="skip_content">
  <?php do_action( 'print_on_demand_shop_above_banner' ); ?>
  <?php if ( get_theme_mod( 'print_on_demand_shop_banner_hide', false ) ) { ?>
    <section id="banner" class="mw-100 m-auto py-3 position-relative d-flex align-items-center">
      <div class="container">
        <div class="banner-content">
          <div class="row">
            <div class="col-xl-5 col-lg-5 col-md-6 col-12 align-self-center banner-left-content">
              <?php if(get_theme_mod('print_on_demand_shop_banner_small_title') != ''){ ?>
                <p class="banner-small-title text-capitalize mb-1 text-lg-start text-md-start text-center"><?php echo esc_html(get_theme_mod('print_on_demand_shop_banner_small_title')); ?></p>
              <?php } ?>
              <?php if ( get_theme_mod( 'print_on_demand_shop_banner_title') != '' ){ ?>
                <h1 class="banner-title text-capitalize pb-0 mb-3 text-lg-start text-md-start text-center">
                  <?php echo esc_html( get_theme_mod( 'print_on_demand_shop_banner_title') ); ?>
                </h1>
              <?php } ?>
              <?php if(get_theme_mod('print_on_demand_shop_banner_desc_text') != ''){ ?>
                <p class="banner-desc mb-3 text-lg-start text-md-start text-center"><?php echo esc_html(get_theme_mod('print_on_demand_shop_banner_desc_text')); ?></p>
              <?php } ?>
              <?php if ( get_theme_mod('print_on_demand_shop_banner_btn_text1') != '' || get_theme_mod('print_on_demand_shop_banner_btn_text2') != '') {?>
                <div class="banner-main-btn d-flex gap-2 justify-content-lg-start justify-content-md-start justify-content-center">
                  <div class ="banner-btn1">
                    <a class="text-capitalize mt-1" href="<?php echo esc_url(get_theme_mod('print_on_demand_shop_banner_btn_url1'));?>"><?php echo esc_html(get_theme_mod('print_on_demand_shop_banner_btn_text1'));?></a>
                  </div>
                  <div class ="banner-btn2">
                    <a class="text-capitalize mt-1" href="<?php echo esc_url(get_theme_mod('print_on_demand_shop_banner_btn_url2'));?>"><?php echo esc_html(get_theme_mod('print_on_demand_shop_banner_btn_text2'));?></a>
                  </div>
                </div>
              <?php }?>
              <div class="banner-bottom-box mt-5 pt-5 text-lg-start text-md-start text-center">
                <?php if ( get_theme_mod( 'print_on_demand_shop_banner_bottom_title') != '' ){ ?>
                  <h6 class="banner-review-title text-capitalize pb-0 mb-3">
                    <?php echo esc_html( get_theme_mod( 'print_on_demand_shop_banner_bottom_title') ); ?>
                  </h6>
                <?php } ?>
                <?php if ( get_theme_mod('print_on_demand_shop_banner_bottom_image') != "" ) {?>
                  <div class="bottom-img-box mb-2">
                    <img class="banner-btm-img" src="<?php echo esc_url(get_theme_mod('print_on_demand_shop_banner_bottom_image')); ?>">
                  </div>
                <?php }?>
                <?php if(get_theme_mod('print_on_demand_shop_banner_review_desc') != ''){ ?>
                  <p class="clients-desc mb-2"><?php echo esc_html(get_theme_mod('print_on_demand_shop_banner_review_desc')); ?></p>
                <?php } ?>
              </div>
            </div>
            <div class="offset-xl-1 offset-lg-1 col-xl-6 col-lg-6 col-md-6 col-12 align-self-center banner-product-sec">
              <?php if(get_theme_mod('print_on_demand_shop_product_category') != ''){ ?>
                <div class="slider-for pt-4">
                  <?php if ( class_exists( 'WooCommerce' ) ) {
                    $print_on_demand_shop_args = array(
                      'post_type' => 'product',
                      'product_cat' => get_theme_mod('print_on_demand_shop_product_category'),
                      'order' => 'ASC'
                    );
                    $print_on_demand_shop_loop = new WP_Query( $print_on_demand_shop_args );
                    while ( $print_on_demand_shop_loop->have_posts() ) : $print_on_demand_shop_loop->the_post(); global $product; ?>
                      <div class="product-single-box position-relative">
                        <div class="product-single-inner-box">
                          <div class="product-single-img-box d-flex align-items-center flex-column">
                            <?php if (has_post_thumbnail( $print_on_demand_shop_loop->post->ID )) echo get_the_post_thumbnail($print_on_demand_shop_loop->post->ID, 'shop_catalog'); else echo '<img src="'.esc_url(woocommerce_placeholder_img_src()).'" />'; ?>
                            <h4 class="single-product-title mt-4 pb-0"><a href="<?php echo esc_url(get_permalink( $print_on_demand_shop_loop->post->ID )); ?>"><?php the_title(); ?></a></h4>
                          </div>
                        </div>
                      </div>
                    <?php endwhile; wp_reset_postdata(); ?>
                  <?php } ?>
                </div>
                <div class="product-outer-box position-absolute">
                  <div class="product-bottom-slider">
                    <div class="slider-nav d-flex position-relative">
                      <?php if ( class_exists( 'WooCommerce' ) ) {
                        $print_on_demand_shop_args = array(
                          'post_type' => 'product',
                          'product_cat' => get_theme_mod('print_on_demand_shop_product_category'),
                          'order' => 'ASC',
                          'posts_per_page' => 10
                        );
                        $print_on_demand_shop_loop = new WP_Query( $print_on_demand_shop_args );
                        while ( $print_on_demand_shop_loop->have_posts() ) : $print_on_demand_shop_loop->the_post(); global $product; ?>
                          <div class="product-box">
                            <div class="product-slider-image d-flex justify-content-center position-relative">
                              <?php if (has_post_thumbnail( $print_on_demand_shop_loop->post->ID )) echo get_the_post_thumbnail($print_on_demand_shop_loop->post->ID, 'shop_catalog'); else echo '<img src="'.esc_url(woocommerce_placeholder_img_src()).'" />'; ?>
                              <div class="product-img-overlay position-absolute"></div>
                            </div>
                          </div>
                        <?php endwhile; wp_reset_postdata(); ?>
                      <?php } ?>
                    </div>
                  </div>
                </div>
              <?php }?>
            </div>
          </div>
        </div>
      </div>
      <div class="clearfix"></div>
    </section>
  <?php }?>
  <?php do_action( 'print_on_demand_shop_below_banner' ); ?>

  <!-- Products Section -->
  <?php if( get_theme_mod( 'print_on_demand_shop_section_title') != '' || get_theme_mod( 'print_on_demand_shop_section_small_text') != '' || get_theme_mod( 'print_on_demand_shop_popular_product_category') != '') { ?>
    <section id="product-sec" class="py-5">
      <div class="container">
        <div class="row mb-3">
          <div class="col-xl-9 col-lg-9 col-md-8 col-12 align-self-center">
            <div class="heading-box mb-3 text-lg-start text-md-start text-center">
              <?php if( get_theme_mod( 'print_on_demand_shop_section_sub_title') != '') { ?>  
                <p class="section-desc text-capitalize mb-2"><?php echo esc_html(get_theme_mod('print_on_demand_shop_section_sub_title'));?></p>
              <?php } ?>
              <?php if( get_theme_mod( 'print_on_demand_shop_section_title') != '') { ?>  
                <h2 class="section-heading text-capitalize"><?php echo esc_html(get_theme_mod('print_on_demand_shop_section_title'));?></h2>
              <?php } ?>
            </div>
          </div>
          <div class="col-xl-3 col-lg-3 col-md-4 col-12 align-self-center text-lg-end text-md-end text-center">
            <div class ="product-sec-btn">
              <a class="text-capitalize mt-1" href="<?php echo esc_url(get_theme_mod('print_on_demand_shop_product_section_btn_url'));?>"><?php echo esc_html(get_theme_mod('print_on_demand_shop_product_section_btn_text'));?></a>
            </div>
          </div>
        </div>
        <div class="popular-products">
          <div class="row">
            <?php if ( class_exists( 'WooCommerce' ) ) {
              $print_on_demand_shop_selected_category = get_theme_mod('print_on_demand_shop_popular_product_category');
              if (!empty($print_on_demand_shop_selected_category)) {
                $print_on_demand_shop_args = array(
                  'post_type'      => 'product',
                  'product_cat'    => $print_on_demand_shop_selected_category,
                  'order'          => 'ASC',
                  'hide_empty'     => 0,
                  'posts_per_page' => 4,
                );
                $print_on_demand_shop_loop = new WP_Query($print_on_demand_shop_args);

                while ($print_on_demand_shop_loop->have_posts()) : $print_on_demand_shop_loop->the_post();
                  global $product;
            ?>
            <div class="col-xl-3 col-lg-3 col-md-6 col-12 pt-0 pb-4 px-3 product-main-div">
              <div class="main-product-section mx-md-0 mx-lg-0 mx-2">
                <div class="product-img-box p-4 position-relative">
                  <?php 
                  if (has_post_thumbnail($print_on_demand_shop_loop->post->ID)) {
                    echo get_the_post_thumbnail($print_on_demand_shop_loop->post->ID, 'shop_catalog');
                  } else {
                    echo '<img src="' . esc_url(woocommerce_placeholder_img_src()) . '" />';
                  }
                  ?>
                  <div class="popular-product-icons position-absolute d-flex gap-2">
                    <?php if (defined('YITH_WCWL')) {
                      echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                    } ?>
                    <?php 
                    if ($product->is_type('simple')) {
                      woocommerce_template_loop_add_to_cart($print_on_demand_shop_loop->post, $product);
                    }
                    ?>
                  </div>
                </div>
                <div class="product-content mt-3 text-lg-start text-md-start text-center">
                  <h5 class="popular-product-title pb-0 mb-1">
                    <a href="<?php echo esc_url(get_permalink($print_on_demand_shop_loop->post->ID)); ?>">
                      <?php the_title(); ?>
                    </a>
                  </h5>
                  <p class="popular-product-price">
                    <?php 
                    if ($product->is_on_sale()) {
                      echo wc_price($product->get_sale_price());
                    } else {
                      echo wc_price($product->get_regular_price());
                    }
                    ?>
                  </p>
                </div>
              </div>
            </div>
            <?php endwhile; wp_reset_postdata(); ?>
            <?php }?>
            <?php }?>
          </div>
        </div>
      </div>
    </section>
  <?php }?>

  <div class="container front-page-content mt-4">
    <?php while ( have_posts() ) : the_post(); ?>
      <div class="new-text"><?php the_content(); ?></div>
    <?php endwhile; // end of the loop. ?>
  </div>
</main>

<?php get_footer(); ?>