<?php
/**
 * The template for displaying Search Results pages.
 * @package Print On Demand Shop
 */

get_header(); ?>

<div class="banner-image-box position-relative">
    <div class="top-header-img"></div>
    <div class="top-banner">
        <?php echo '<h1 class="mb-0">' . esc_html__('Results For: ', 'print-on-demand-shop') . get_search_query() . '</h1>'; ?>
    </div>
</div>

<main role="main" id="skip_content">
    <div class="container">
        <?php
        $print_on_demand_shop_layout_option = get_theme_mod( 'print_on_demand_shop_layout_options','Right Sidebar');
        if($print_on_demand_shop_layout_option == 'One Column'){ ?>
            <div id="blog_sec" class="blog-section pt-5">
                <?php if(get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Top' || get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Both Top & Bottom'){ ?>
                    <?php if( get_theme_mod( 'print_on_demand_shop_enable_post_pagination',true) != '') { ?>
                        <div class="navigation">
                            <?php print_on_demand_shop_pagination_type(); ?>
                        </div>
                    <?php } ?>
                <?php } ?>
                <h1 class="entry-title"><?php /* translators: %s: search term */ printf( esc_html__( 'Results For: %s','print-on-demand-shop'), esc_html( get_search_query() ) ); ?></h1> 
                <?php print_on_demand_shop_blog_post_content(); ?>
                <?php if(get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Bottom' || get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Both Top & Bottom'){ ?>
                    <?php if( get_theme_mod( 'print_on_demand_shop_enable_post_pagination',true) != '') { ?>
                        <div class="navigation">
                            <?php print_on_demand_shop_pagination_type(); ?>
                        </div>
                    <?php } ?>
                <?php } ?>
            </div>
        <?php }else if($print_on_demand_shop_layout_option == 'Three Columns'){ ?>
            <div class="row">
                <div id="sidebar" class="col-lg-3 col-md-3"><?php dynamic_sidebar('sidebar-1'); ?></div>
                <div id="blog_sec" class="blog-section col-lg-6 col-md-6 pt-5">
                    <h1 class="search-title"><?php /* translators: %s: search term */ printf( esc_html__( 'Search Results for: %s','print-on-demand-shop'), '<span>' . esc_html( get_search_query() ) . '</span>' ); ?></h1>
                    <?php if ( have_posts() ) :
                        /* Start the Loop */          
                        while ( have_posts() ) : the_post();
                            get_template_part( 'template-parts/content',get_post_format() );           
                        endwhile;
                        else :
                            get_template_part( 'no-results' ); 
                        endif; 
                    ?>
                    <?php if( get_theme_mod( 'print_on_demand_shop_enable_post_pagination',true) != '') { ?>
                        <div class="navigation">
                            <?php print_on_demand_shop_pagination_type(); ?>
                        </div>
                    <?php } ?>
                </div>
                <div id="sidebar" class="col-lg-3 col-md-3"><?php dynamic_sidebar('sidebar-2'); ?></div>
            </div>
        <?php }else if($print_on_demand_shop_layout_option == 'Four Columns'){ ?>
            <div class="row">
                <div id="sidebar" class="col-lg-3 col-md-3"><?php dynamic_sidebar('sidebar-1'); ?></div>
                <div id="blog_sec" class="blog-section col-lg-3 col-md-3 pt-5">
                    <h1 class="search-title"><?php /* translators: %s: search term */ printf( esc_html__( 'Search Results for: %s','print-on-demand-shop'), '<span>' . esc_html( get_search_query() ) . '</span>' ); ?></h1>
                    <?php if ( have_posts() ) :
                    /* Start the Loop */          
                        while ( have_posts() ) : the_post();
                            get_template_part( 'template-parts/content',get_post_format() );           
                        endwhile;
                        else :
                            get_template_part( 'no-results' ); 
                        endif; 
                    ?>
                    <?php if( get_theme_mod( 'print_on_demand_shop_enable_post_pagination',true) != '') { ?>
                        <div class="navigation">
                            <?php print_on_demand_shop_pagination_type(); ?>
                        </div>
                    <?php } ?>
                </div>
                <div id="sidebar" class="col-lg-3 col-md-3"><?php dynamic_sidebar('sidebar-2'); ?></div>
                <div id="sidebar" class="col-lg-3 col-md-3"><?php dynamic_sidebar('sidebar-3'); ?></div>
            </div>
        <?php }else if($print_on_demand_shop_layout_option == 'Grid Layout'){ ?>
            <div class="row">
                <div id="blog_sec" class="blog-section col-lg-8 col-md-8 pt-5">
                    <?php if(get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Top' || get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Both Top & Bottom'){ ?>
                        <?php if( get_theme_mod( 'print_on_demand_shop_enable_post_pagination',true) != '') { ?>
                            <div class="navigation">
                                <?php print_on_demand_shop_pagination_type(); ?>
                            </div>
                        <?php } ?>
                    <?php } ?>
                    <h1 class="entry-title"><?php /* translators: %s: search term */ printf( esc_html__( 'Results For: %s','print-on-demand-shop'), esc_html( get_search_query() ) ); ?></h1> 
                    <div class="row">
                        <?php if ( have_posts() ) :
                            /* Start the Loop */          
                            while ( have_posts() ) : the_post();
                                get_template_part( 'template-parts/grid-layout' );
                            endwhile;
                            else :
                                get_template_part( 'no-results' ); 
                            endif; 
                        ?>
                    </div>
                    <?php if(get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Bottom' || get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Both Top & Bottom'){ ?>
                        <?php if( get_theme_mod( 'print_on_demand_shop_enable_post_pagination',true) != '') { ?>
                            <div class="navigation">
                                <?php print_on_demand_shop_pagination_type(); ?>
                            </div>
                        <?php } ?>
                    <?php } ?>
                </div>
                <div class="col-lg-4 col-md-4 mt-5"><?php get_sidebar(); ?></div>
            </div>
        <?php }else if($print_on_demand_shop_layout_option == 'Left Sidebar'){ ?>
            <div class="row">
                <div class="<?php if( get_theme_mod( 'print_on_demand_shop_sidebar_size', 'Sidebar 1/3') == 'Sidebar 1/3') { ?>col-lg-4 col-md-4 mt-5"<?php } else { ?>col-lg-3 col-md-4 <?php } ?>"><?php get_sidebar(); ?></div>

                <div id="blog_sec" class="<?php if( get_theme_mod( 'print_on_demand_shop_sidebar_size', 'Sidebar 1/3') == 'Sidebar 1/3') { ?>col-lg-8 col-md-8 blog-section pt-5"<?php } else { ?>col-lg-9 col-md-8 pt-5 <?php } ?>">
                    <?php if(get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Top' || get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Both Top & Bottom'){ ?>
                        <?php if( get_theme_mod( 'print_on_demand_shop_enable_post_pagination',true) != '') { ?>
                            <div class="navigation">
                                <?php print_on_demand_shop_pagination_type(); ?>
                            </div>
                        <?php } ?>
                    <?php } ?>
                    <h1 class="entry-title"><?php /* translators: %s: search term */ printf( esc_html__( 'Results For: %s','print-on-demand-shop'), esc_html( get_search_query() ) ); ?></h1> 
                    <?php print_on_demand_shop_blog_post_content(); ?>
                    <?php if(get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Bottom' || get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Both Top & Bottom'){ ?>
                        <?php if( get_theme_mod( 'print_on_demand_shop_enable_post_pagination',true) != '') { ?>
                            <div class="navigation">
                                <?php print_on_demand_shop_pagination_type(); ?>
                            </div>
                        <?php } ?>
                    <?php } ?>
                </div>
            </div>
        <?php }else if($print_on_demand_shop_layout_option == 'Right Sidebar'){ ?>
            <div class="row">
                <div id="blog_sec" class="<?php if( get_theme_mod( 'print_on_demand_shop_sidebar_size', 'Sidebar 1/3') == 'Sidebar 1/3') { ?>col-lg-8 col-md-8 blog-section pt-5"<?php } else { ?>col-lg-9 col-md-8 pt-5 <?php } ?>">
                    <?php if(get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Top' || get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Both Top & Bottom'){ ?>
                        <?php if( get_theme_mod( 'print_on_demand_shop_enable_post_pagination',true) != '') { ?>
                            <div class="navigation">
                                <?php print_on_demand_shop_pagination_type(); ?>
                            </div>
                        <?php } ?>
                    <?php } ?>
                    <h1 class="entry-title"><?php /* translators: %s: search term */ printf( esc_html__( 'Results For: %s','print-on-demand-shop'), esc_html( get_search_query() ) ); ?></h1> 
                    <?php print_on_demand_shop_blog_post_content(); ?>
                    <?php if(get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Bottom' || get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Both Top & Bottom'){ ?>
                        <?php if( get_theme_mod( 'print_on_demand_shop_enable_post_pagination',true) != '') { ?>
                            <div class="navigation">
                                <?php print_on_demand_shop_pagination_type(); ?>
                            </div>
                        <?php } ?>
                    <?php } ?>
                </div>
                <div class="<?php if( get_theme_mod( 'print_on_demand_shop_sidebar_size', 'Sidebar 1/3') == 'Sidebar 1/3') { ?>col-lg-4 col-md-4 mt-5"<?php } else { ?>col-lg-3 col-md-4 <?php } ?>"><?php get_sidebar(); ?></div>
            </div>
        <?php } else {?>
            <div class="row">
                <div id="blog_sec" class="<?php if( get_theme_mod( 'print_on_demand_shop_sidebar_size', 'Sidebar 1/3') == 'Sidebar 1/3') { ?>col-lg-8 col-md-8 blog-section pt-5"<?php } else { ?>col-lg-9 col-md-8 pt-5  <?php } ?>">
                    <?php if(get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Top' || get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Both Top & Bottom'){ ?>
                        <?php if( get_theme_mod( 'print_on_demand_shop_enable_post_pagination',true) != '') { ?>
                            <div class="navigation">
                                <?php print_on_demand_shop_pagination_type(); ?>
                            </div>
                        <?php } ?>
                    <?php } ?>
                    <h1 class="entry-title"><?php /* translators: %s: search term */ printf( esc_html__( 'Results For: %s','print-on-demand-shop'), esc_html( get_search_query() ) ); ?></h1> 
                    <?php print_on_demand_shop_blog_post_content(); ?>
                    <?php if(get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Bottom' || get_theme_mod('print_on_demand_shop_post_pagination_position', 'Bottom') == 'Both Top & Bottom'){ ?>
                        <?php if( get_theme_mod( 'print_on_demand_shop_enable_post_pagination',true) != '') { ?>
                            <div class="navigation">
                                <?php print_on_demand_shop_pagination_type(); ?>
                            </div>
                        <?php } ?>
                    <?php } ?>
                </div>
                <div class="<?php if( get_theme_mod( 'print_on_demand_shop_sidebar_size', 'Sidebar 1/3') == 'Sidebar 1/3') { ?>col-lg-4 col-md-4 mt-5"<?php } else { ?>col-lg-3 col-md-4 <?php } ?>"><?php get_sidebar(); ?></div>
            </div>
        <?php }?>
    </div>
</main>
<div class="clearfix"></div>

<?php get_footer(); ?>