<?php
/**
 * The template for displaying search forms in Print On Demand Shop
 * @package Print On Demand Shop
 */
?>

<form method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label>
		<span class="screen-reader-text"><?php echo esc_html_x( 'Search for:', 'label', 'print-on-demand-shop' ); ?></span>
		<input type="search" class="search-field" placeholder="<?php echo esc_attr( get_theme_mod('print_on_demand_shop_search_placeholder', __('Search', 'print-on-demand-shop')) ); ?>" value="<?php echo esc_attr( get_search_query()) ?>" name="s">
	</label>
	<input type="submit" class="search-submit" value="<?php echo esc_attr_x( 'Search', 'submit button','print-on-demand-shop' ); ?>">
</form>