<?php
/**
 * The template part for displaying grid layout
 * @package Print On Demand Shop
 * @subpackage print_on_demand_shop
 * @since 1.0
 */
?>
<?php 
  $print_on_demand_shop_grid_columns = get_theme_mod('print_on_demand_shop_grid_columns', '3');
  if ($print_on_demand_shop_grid_columns == '4') {
    $print_on_demand_shop_column_class = 'col-lg-3 col-md-6';
  } elseif ($print_on_demand_shop_grid_columns == '3') {
    $print_on_demand_shop_column_class = 'col-lg-4 col-md-6';
  }
?>
<div class="<?php echo esc_attr($print_on_demand_shop_column_class); ?>">
  <article id="post-<?php the_ID(); ?>" <?php post_class('inner-service'); ?>>
    <div class="mainbox gridbox p-4">
      <div class="box-image">
      <?php if( get_theme_mod( 'print_on_demand_shop_post_featured_image',true) != '') { ?>
        <div class="box-image">
          <?php the_post_thumbnail(); ?>
        </div>
      <?php }?>
      </div>
      <h2><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title();?><span class="screen-reader-text"><?php the_title(); ?></span></a></h2>
      <?php if( get_theme_mod( 'print_on_demand_shop_grid_post_date',true) != '' || get_theme_mod( 'print_on_demand_shop_grid_post_author',true) != '' || get_theme_mod( 'print_on_demand_shop_grid_post_comment',true) != '' || get_theme_mod( 'print_on_demand_shop_grid_post_time',true) != '') { ?>
      <div class="metabox py-2 mb-1">
        <?php if( get_theme_mod( 'print_on_demand_shop_grid_post_date',true) != '') { ?>
          <span class="entry-date me-1 py-1"><i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_grid_post_date_icon','far fa-calendar-alt')); ?> me-2"></i><a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day)); ?>"><?php echo esc_html( get_the_date() ); ?><span class="screen-reader-text"><?php echo esc_html( get_the_date() ); ?></span></a></span><span class="ms-1"><?php echo esc_html( get_theme_mod('print_on_demand_shop_grid_post_meta_seperator','|') ); ?></span>
        <?php }?>
        <?php if( get_theme_mod( 'print_on_demand_shop_grid_post_author',true) != '') { ?>
          <span class="entry-author mx-1 py-1"><i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_grid_post_author_icon','fas fa-user')); ?> me-2"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><?php the_author(); ?><span class="screen-reader-text"><?php the_title(); ?></span></a></span><span class="ms-1"><?php echo esc_html( get_theme_mod('print_on_demand_shop_grid_post_meta_seperator','|') ); ?></span>
        <?php }?>
        <?php if( get_theme_mod( 'print_on_demand_shop_grid_post_comment',true) != '') { ?>
          <span class="entry-comments mx-1 py-1"><i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_grid_post_comment_icon','fas fa-comments')); ?> me-2"></i> <?php comments_number( __('0 Comment', 'print-on-demand-shop'), __('0 Comments', 'print-on-demand-shop'), __('% Comments', 'print-on-demand-shop') ); ?></span><span class="ms-1"><?php echo esc_html( get_theme_mod('print_on_demand_shop_grid_post_meta_seperator','|') ); ?></span>
        <?php }?>
        <?php if( get_theme_mod( 'print_on_demand_shop_grid_post_time',true) != '' ) { ?>
          <span class="entry-time mx-1 py-1"><i class="<?php echo esc_attr(get_theme_mod('print_on_demand_shop_grid_post_time_icon','fas fa-clock')); ?> me-2"></i> <?php echo esc_html( get_the_time() ); ?></span>
        <?php }?>
      </div>
    <?php }?>
      <div class="new-text">
				<p>
					<?php $print_on_demand_shop_theme_lay = get_theme_mod( 'print_on_demand_shop_grid_post_content','Post Excerpt');
						if($print_on_demand_shop_theme_lay == 'Post Content'){ ?>
							<?php the_content(); ?>
				    	<?php }
						if($print_on_demand_shop_theme_lay == 'Post Excerpt'){ ?>
						  <?php $print_on_demand_shop_excerpt = get_the_excerpt(); echo esc_html( print_on_demand_shop_string_limit_words( $print_on_demand_shop_excerpt, esc_attr(get_theme_mod('print_on_demand_shop_grid_post_excerpt_number','30')))); ?>  <?php echo esc_html( get_theme_mod('print_on_demand_shop_grid_excerpt_suffix','[...]') ); ?>
					<?php }?>
				</p>
			</div>
      <?php if( get_theme_mod('print_on_demand_shop_button_text','Read More') != ''){ ?>
        <div class="postbtn mt-4 text-start">
          <a href="<?php the_permalink(); ?>"><?php echo esc_html(get_theme_mod('print_on_demand_shop_button_text','Read More'));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('print_on_demand_shop_button_text','Read More'));?></span></a>
        </div>
      <?php }?>
    </div>
  </article>
</div>