<?php
/**
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 */

if ( !defined('ABSPATH') ) {
    die();
}

// Global init settings
function productive_global_register_section_following() {
    
    // Add Section
    add_settings_section(
        'productive_global_section_following',    // Section id
        '', // Section heading
        'productive_global_section_following_description_callback', // A callback method that displays the section description
        'productive_global_section_following_options'   // The menu slug of the page that will display this section
    );

    productive_global_add_section_following_fields('productive_global_section_following_options');

    register_setting( 
            'productive_global_section_following_options', // Option group (section)
            'productive_global_section_following_options',   // Option name (it holds a collection of values of associated field - e.g productive_global_section_following_options[field_name])
            'productive_global_register_section_following_validate'      // Validate user entry
        );

    if ( false == productive_global_get_section_following_options_object() || empty( productive_global_get_section_following_options_object()) ) {
        add_option( 'productive_global_section_following_options', apply_filters( 'productive_global_section_following_options_init_fields', productive_global_section_following_options_init_fields() ) );
    }

}

function productive_global_get_section_following_options_object() {
    $options = get_option( 'productive_global_section_following_options' );
    return $options;
}


function productive_global_register_section_following_validate( $section_inputs ) {
    $validated_values = array();
    foreach ( $section_inputs as $key => $input ) {
        if ( isset($section_inputs[$key]) ) {
            if ( $key === 'productive_global_following_icon_color' && '' != $section_inputs[$key] && !productive_global_validate_input_hex_color( $section_inputs[$key] ) ) {
                add_settings_error( 'productive_global_section_following_options', 'invalid-color-1', esc_html__( 'Invalid colour hex code found for icon color', 'productive-ecommerce' ) );
            } else if ( $key === 'productive_global_following_icon_bg_color' && !productive_global_validate_input_hex_color( $section_inputs[$key] ) ) {
                add_settings_error( 'productive_global_section_following_options', 'invalid-color-2', esc_html__( 'Invalid colour hex code found for icon background color', 'productive-ecommerce' ) );
            } else if ( $key === 'productive_global_following_icon_bg_color_hover' && !productive_global_validate_input_hex_color( $section_inputs[$key] ) ) {
                add_settings_error( 'productive_global_section_following_options', 'invalid-color-1', esc_html__( 'Invalid colour hex code found for icons background color (on Hover)', 'productive-ecommerce' ) );
            } else if ( $key === 'productive_global_following_icon_size' && !is_numeric( $section_inputs[$key] ) ) {
                add_settings_error( 'productive_global_section_following_options', 'invalid-size', esc_html__( 'Icon size must be a number. Please add a valid integer and try again.', 'productive-ecommerce' ) );
            } else if ( $key === 'productive_global_following_icon_spacing' && !is_numeric( $section_inputs[$key] ) ) {
                add_settings_error( 'productive_global_section_following_options', 'invalid-thickness', esc_html__( 'Icons spacing must be a number. Please add a valid integer and try again.', 'productive-ecommerce' ) );
            } else {
                $validated_values[$key] = productive_global_get_sanitized_input_value($input);
            }
        }
    }
    return apply_filters('productive_global_register_section_following_validate', $validated_values, $section_inputs);
}


function productive_global_section_following_options_init_fields() {
    $default_fields_values = array(
        'productive_global_following_icon_color'                                                => '',
        'productive_global_following_icon_bg_color'                                             => '#eef3f7',
        'productive_global_following_icon_bg_color_hover'                                       => '#e9f2f4',
        'productive_global_following_brand_color_around_white_icon'                             => 'brand_color_around_white_icon',
        'productive_global_following_follow_on_copy_location'                                   => 'top',
        'productive_global_following_icon_size'                                                 => '20',
        'productive_global_following_icon_spacing'                                              => '10',
        'productive_global_following_url_site_1'                                                => 'https://linkedin.com/brand',
        'productive_global_following_url_site_2'                                                => 'https://youtube.com/brand',
        'productive_global_following_url_site_3'                                                => 'https://facebook.com/brand',
        'productive_global_following_url_site_4'                                                => 'https://x.com/brand',
        'productive_global_following_url_site_5'                                                => 'https://pinterest.com/brand',
        'productive_global_following_value_whatsapp'                                            => '+441234567891',
        'productive_global_following_value_email'                                               => 'email@example.com',
        'productive_global_following_value_phone'                                               => '+441234567891',
    );
    return apply_filters( 'productive_global_section_following_options_init_fields', $default_fields_values );
}


// Gets

/**
 * Method productive_global_following_icon_color.
 */
function productive_global_following_icon_color() {
    $options = productive_global_get_section_following_options_object();
    if ( isset( $options['productive_global_following_icon_color'] )) {
        $option_value = sanitize_text_field( $options['productive_global_following_icon_color'] );
    } else {
        $option_value = '';
    }
    return $option_value;
}

/**
 * Method productive_global_following_icon_bg_color.
 */
function productive_global_following_icon_bg_color() {
    $options = productive_global_get_section_following_options_object();
    if ( isset( $options['productive_global_following_icon_bg_color'] )) {
        $option_value = sanitize_text_field( $options['productive_global_following_icon_bg_color'] );
    } else {
        $option_value = '';
    }
    return $option_value;
}

/**
 * Method productive_global_following_icon_bg_color_hover.
 */
function productive_global_following_icon_bg_color_hover() {
    $options = productive_global_get_section_following_options_object();
    if ( isset( $options['productive_global_following_icon_bg_color_hover'] )) {
        $option_value = sanitize_text_field( $options['productive_global_following_icon_bg_color_hover'] );
    } else {
        $option_value = '';
    }
    return $option_value;
}

/**
 * Method productive_global_following_brand_color_around_white_icon.
 */
function productive_global_following_brand_color_around_white_icon() {
    $options = productive_global_get_section_following_options_object();
    if ( isset( $options['productive_global_following_brand_color_around_white_icon'] )) {
        $option_value = sanitize_text_field( $options['productive_global_following_brand_color_around_white_icon'] );
    } else {
        $option_value = 'brand_color_around_white_icon';
    }
    return $option_value;
}

/**
 * Method productive_global_following_follow_on_copy_location.
 */
function productive_global_following_follow_on_copy_location() {
    $options = productive_global_get_section_following_options_object();
    if ( isset( $options['productive_global_following_follow_on_copy_location'] )) {
        $option_value = sanitize_text_field( $options['productive_global_following_follow_on_copy_location'] );
    } else {
        $option_value = 'top';
    }
    return $option_value;
}

/**
 * Method productive_global_following_icon_size.
 */
function productive_global_following_icon_size() {
    $options = productive_global_get_section_following_options_object();
    if ( isset( $options['productive_global_following_icon_size'] )) {
        $option_value = sanitize_text_field( $options['productive_global_following_icon_size'] );
    } else {
        $option_value = 20;
    }
    return $option_value;
}

/**
 * Method productive_global_following_icon_spacing.
 */
function productive_global_following_icon_spacing() {
    $options = productive_global_get_section_following_options_object();
    if ( isset( $options['productive_global_following_icon_spacing'] )) {
        $option_value = sanitize_text_field( $options['productive_global_following_icon_spacing'] );
    } else {
        $option_value = 2;
    }
    return $option_value;
}

/**
 * Method productive_global_following_url_site_1.
 */
function productive_global_following_url_site_1() {
    $options = productive_global_get_section_following_options_object();
    $option_value = '';
    if ( isset( $options['productive_global_following_url_site_1'] ) && !empty( $options['productive_global_following_url_site_1'] ) ) {
        $option_value = sanitize_text_field( $options['productive_global_following_url_site_1'] );
    }
    return $option_value;
}

/**
 * Method productive_global_following_url_site_2.
 */
function productive_global_following_url_site_2() {
    $options = productive_global_get_section_following_options_object();
    $option_value = '';
    if ( isset( $options['productive_global_following_url_site_2'] ) && !empty( $options['productive_global_following_url_site_2'] ) ) {
        $option_value = sanitize_text_field( $options['productive_global_following_url_site_2'] );
    }
    return $option_value;
}

/**
 * Method productive_global_following_url_site_3.
 */
function productive_global_following_url_site_3() {
    $options = productive_global_get_section_following_options_object();
    $option_value = '';
    if ( isset( $options['productive_global_following_url_site_3'] ) && !empty( $options['productive_global_following_url_site_3'] ) ) {
        $option_value = sanitize_text_field( $options['productive_global_following_url_site_3'] );
    }
    return $option_value;
}

/**
 * Method productive_global_following_url_site_4.
 */
function productive_global_following_url_site_4() {
    $options = productive_global_get_section_following_options_object();
    $option_value = '';
    if ( isset( $options['productive_global_following_url_site_4'] ) && !empty( $options['productive_global_following_url_site_4'] ) ) {
        $option_value = sanitize_text_field( $options['productive_global_following_url_site_4'] );
    }
    return $option_value;
}

/**
 * Method productive_global_following_url_site_5.
 */
function productive_global_following_url_site_5() {
    $options = productive_global_get_section_following_options_object();
    $option_value = '';
    if ( isset( $options['productive_global_following_url_site_5'] ) && !empty( $options['productive_global_following_url_site_5'] ) ) {
        $option_value = sanitize_text_field( $options['productive_global_following_url_site_5'] );
    }
    return $option_value;
}

/**
 * Method productive_global_following_value_whatsapp.
 */
function productive_global_following_value_whatsapp() {
    $options = productive_global_get_section_following_options_object();
    $option_value = '';
    if ( isset( $options['productive_global_following_value_whatsapp'] ) && !empty( $options['productive_global_following_value_whatsapp'] ) ) {
        $option_value = sanitize_text_field( $options['productive_global_following_value_whatsapp'] );
    }
    return $option_value;
}

/**
 * Method productive_global_following_value_email.
 */
function productive_global_following_value_email() {
    $options = productive_global_get_section_following_options_object();
    $option_value = '';
    if ( isset( $options['productive_global_following_value_email'] ) && !empty( $options['productive_global_following_value_email'] ) ) {
        $option_value = sanitize_text_field( $options['productive_global_following_value_email'] );
    }
    return $option_value;
}

/**
 * Method productive_global_following_value_phone.
 */
function productive_global_following_value_phone() {
    $options = productive_global_get_section_following_options_object();
    $option_value = '';
    if ( isset( $options['productive_global_following_value_phone'] ) && !empty( $options['productive_global_following_value_phone'] ) ) {
        $option_value = sanitize_text_field( $options['productive_global_following_value_phone'] );
    }
    return $option_value;
}
