<?php
/**
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 */

if ( !defined('ABSPATH') ) {
    die();
}

// Start: Popup
function productive_global_section_following_description_callback() {
?>
    <p>
        <h2><?php echo esc_html__( 'Social Media Following Settings', 'productive-ecommerce' ) ?></h2>
        <div><?php echo esc_html__( 'These social media following options are efective across all our plugins and themes', 'productive-ecommerce' ) ?></div>
    </p>
<?php
}

/* ============ START Section fields ================= */
function productive_global_add_section_following_fields($productive_global_section_following_options) {
    
    $args_field_0a = array(
        'label_for' => 'productive_global_following_heading', 
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_heading', // field id
        '', // Field label
        'productive_global_callback_following_heading',
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_0a
        );
    
    $args_field_1a = array(
        'label_for' => 'productive_global_following_icon_color',
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_icon_color', // field id
        esc_html__( 'Icons Colour', 'productive-ecommerce' ), // Field label
        'productive_global_callback_following_icon_color', // This callback function will be rendering this field. So, all html of this field will be rendered in this callback function.
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_1a
        );

    $args_field_2a = array(
        'label_for' => 'productive_global_following_icon_bg_color',
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_icon_bg_color', // field id
        esc_html__( 'Icons Background Colour', 'productive-ecommerce' ), // Field label
        'productive_global_callback_following_icon_bg_color', // This callback function will be rendering this field. So, all html of this field will be rendered in this callback function.
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_2a
        );
    
    $args_field_3a = array(
        'label_for' => 'productive_global_following_icon_bg_color_hover',
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_icon_bg_color_hover', // field id
        esc_html__( 'Icons Background Colour (on Hover)', 'productive-ecommerce' ), // Field label
        'productive_global_callback_following_icon_bg_color_hover', // This callback function will be rendering this field. So, all html of this field will be rendered in this callback function.
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_3a
        );
    
    $args_field_3_4_btw = array(
        'label_for' => 'productive_global_following_brand_color_around_white_icon',
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_brand_color_around_white_icon', // field id
        esc_html__( 'Social Meida Icons Style', 'productive-ecommerce' ), // Field label
        'productive_global_callback_following_brand_color_around_white_icon', // This callback function will be rendering this field. So, all html of this field will be rendered in this callback function.
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_3_4_btw
        );

    $args_field_4a = array(
        'label_for' => 'productive_global_following_follow_on_copy_location',
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_follow_on_copy_location', // field id
        esc_html__( 'Location of the "Follow Us:" Copy', 'productive-ecommerce' ), // Field label
        'productive_global_callback_following_follow_on_copy_location', // This callback function will be rendering this field. So, all html of this field will be rendered in this callback function.
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_4a
        );

    $args_field_5a = array(
        'label_for' => 'productive_global_following_icon_size',
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_icon_size', // field id
        esc_html__( 'Icons Size (px)', 'productive-ecommerce' ), // Field label
        'productive_global_callback_following_icon_size', // This callback function will be rendering this field. So, all html of this field will be rendered in this callback function.
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_5a
        );

    $args_field_5b = array(
        'label_for' => 'productive_global_following_icon_spacing',
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_icon_spacing', // field id
        esc_html__( 'Icons Spacing (px)', 'productive-ecommerce' ), // Field label
        'productive_global_callback_following_icon_spacing', // This callback function will be rendering this field. So, all html of this field will be rendered in this callback function.
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_5b
        );

    
    $args_field_6a = array(
        'label_for' => 'productive_global_following_valued_heading', 
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_valued_heading', // field id
        '', // Field label
        'productive_global_callback_following_enabled_heading',
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_6a
        );

    $args_field_7a = array(
        'label_for' => 'productive_global_following_url_site_1',
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_url_site_1', // field id
        esc_html__( 'Website 1', 'productive-ecommerce' ), // Field label
        'productive_global_callback_following_enable_linkedin', // This callback function will be rendering this field. So, all html of this field will be rendered in this callback function.
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_7a
        );
    
    $args_field_8a = array(
        'label_for' => 'productive_global_following_url_site_2',
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_url_site_2', // field id
        esc_html__( 'Website 2', 'productive-ecommerce' ), // Field label
        'productive_global_callback_following_enable_youtube', // This callback function will be rendering this field. So, all html of this field will be rendered in this callback function.
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_8a
        );

    $args_field_9a = array(
        'label_for' => 'productive_global_following_url_site_3',
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_url_site_3', // field id
        esc_html__( 'Website 3', 'productive-ecommerce' ), // Field label
        'productive_global_callback_following_enable_facebook', // This callback function will be rendering this field. So, all html of this field will be rendered in this callback function.
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_9a
        );

    $args_field_10a = array(
        'label_for' => 'productive_global_following_url_site_4',
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_url_site_4', // field id
        esc_html__( 'Website 4', 'productive-ecommerce' ), // Field label
        'productive_global_callback_following_enable_twitter', // This callback function will be rendering this field. So, all html of this field will be rendered in this callback function.
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_10a
        );

    $args_field_11a = array(
        'label_for' => 'productive_global_following_url_site_5',
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_url_site_5', // field id
        esc_html__( 'Website 5', 'productive-ecommerce' ), // Field label
        'productive_global_callback_following_enable_pinterest', // This callback function will be rendering this field. So, all html of this field will be rendered in this callback function.
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_11a
        );
    
    $args_field_12a = array(
        'label_for' => 'productive_global_following_value_whatsapp',
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_value_whatsapp', // field id
        esc_html__( 'WhatsApp Number', 'productive-ecommerce' ), // Field label
        'productive_global_callback_following_enable_whatsapp', // This callback function will be rendering this field. So, all html of this field will be rendered in this callback function.
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_12a
        );
    
    $args_field_13a = array(
        'label_for' => 'productive_global_following_value_email',
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_value_email', // field id
        esc_html__( 'Email Address', 'productive-ecommerce' ), // Field label
        'productive_global_callback_following_enable_email', // This callback function will be rendering this field. So, all html of this field will be rendered in this callback function.
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_13a
        );
    
    $args_field_14a = array(
        'label_for' => 'productive_global_following_value_phone',
        'class'     => 'options_field_args_css_class'
    );
    add_settings_field(
        'productive_global_following_value_phone', // field id
        esc_html__( 'Phone Number', 'productive-ecommerce' ), // Field label
        'productive_global_callback_following_enable_phone', // This callback function will be rendering this field. So, all html of this field will be rendered in this callback function.
        $productive_global_section_following_options,   // The menu slug of the page that will display this field
        'productive_global_section_following',   // Section name
        $args_field_14a
        );
}

function productive_global_callback_following_heading( $args ) {
    ?>
    <h3><?php echo esc_html__( 'Icon Colours and Dimensions', 'productive-ecommerce' ) ?></h3>
   <?php
}

function productive_global_callback_following_icon_color( $args ) {
        $options = productive_global_get_section_following_options_object();
        $productive_global_following_icon_color = '';
        if (isset( $options['productive_global_following_icon_color']) ) {
            $productive_global_following_icon_color = $options['productive_global_following_icon_color'];
        }
    ?>
    <p>
        <input data-alpha-enabled="true" data-default-color="" class="productive_input_color_picker" type="text" name="productive_global_section_following_options[productive_global_following_icon_color]" value="<?php echo esc_attr( $productive_global_following_icon_color ); ?>" size="40" id="<?php echo esc_attr( $args['label_for'] ); ?>" />
    </p>
    <p>
        <?php echo esc_html__( 'The main colour of each icon. Leave empty to use each social media icon original colour', 'productive-ecommerce' ); ?>
    </p>
   <?php
}

function productive_global_callback_following_icon_bg_color( $args ) {
        $options = productive_global_get_section_following_options_object();
        $productive_global_following_icon_bg_color = '';
        if (isset( $options['productive_global_following_icon_bg_color']) ) {
            $productive_global_following_icon_bg_color = $options['productive_global_following_icon_bg_color'];
        }
    ?>
    <p>
        <input data-alpha-enabled="true" data-default-color="#eef3f7" class="productive_input_color_picker" type="text" name="productive_global_section_following_options[productive_global_following_icon_bg_color]" value="<?php echo esc_attr( $productive_global_following_icon_bg_color ); ?>" size="40" id="<?php echo esc_attr( $args['label_for'] ); ?>" />
    </p>
    <p>
        <?php echo esc_html__( 'Colour of the background surrounding each icon', 'productive-ecommerce' ); ?>
    </p>
   <?php
}

function productive_global_callback_following_icon_bg_color_hover( $args ) {
        $options = productive_global_get_section_following_options_object();
        $productive_global_following_icon_bg_color_hover = '';
        if (isset( $options['productive_global_following_icon_bg_color_hover']) ) {
            $productive_global_following_icon_bg_color_hover = $options['productive_global_following_icon_bg_color_hover'];
        }
    ?>
    <p>
        <input data-alpha-enabled="true" data-default-color="#e9f2f4" class="productive_input_color_picker" type="text" name="productive_global_section_following_options[productive_global_following_icon_bg_color_hover]" value="<?php echo esc_attr( $productive_global_following_icon_bg_color_hover ); ?>" size="40" id="<?php echo esc_attr( $args['label_for'] ); ?>" />
    </p>
    <p>
        <?php echo esc_html__( 'Colour of the background surrounding each icon when hovering over it', 'productive-ecommerce' ); ?>
    </p>
   <?php
}

function productive_global_callback_following_brand_color_around_white_icon( $args ) {        
        $options = productive_global_get_section_following_options_object();
        $productive_global_following_brand_color_around_white_icon = 'no_brand_bg_with_icon';
        if( isset( $options['productive_global_following_brand_color_around_white_icon'] ) ) {
            $productive_global_following_brand_color_around_white_icon = $options['productive_global_following_brand_color_around_white_icon'];
        }
    ?>
        <select id="<?php echo esc_attr( $args['label_for'] ); ?>" class="<?php echo esc_attr( $args['class'] ); ?>"
                    name="productive_global_section_following_options[productive_global_following_brand_color_around_white_icon]">
            <?php
                $productive_global_add_social_media_icons_style_options = productive_global_add_social_media_icons_style_options();
                foreach ( $productive_global_add_social_media_icons_style_options as $key => $productive_global_add_social_media_icons_style_option ) {
                    ?>
                    <option value="<?php echo esc_attr( $key ); ?>" <?php echo selected( $productive_global_following_brand_color_around_white_icon, esc_attr( $key ), false ); ?>>
                       <?php echo esc_html( $productive_global_add_social_media_icons_style_option ); ?>
                    </option>
            <?php
                }
            ?>
        </select>
        <p>
            <?php echo esc_html__( 'Site-wide style for displaying social media icons.', 'productive-ecommerce' ); ?>
        </p>
    <?php
}

function productive_global_callback_following_follow_on_copy_location( $args ) {        
        $options = productive_global_get_section_following_options_object();
        $productive_global_following_follow_on_copy_location = '';
        if( isset( $options['productive_global_following_follow_on_copy_location'] ) ) {
            $productive_global_following_follow_on_copy_location = $options['productive_global_following_follow_on_copy_location'];
        }
    ?>
        <select id="<?php echo esc_attr( $args['label_for'] ); ?>" class="<?php echo esc_attr( $args['class'] ); ?>"
                    name="productive_global_section_following_options[productive_global_following_follow_on_copy_location]">
            <option value="top" <?php echo selected( $productive_global_following_follow_on_copy_location, 'top', false ); ?>>
               <?php echo esc_html__( 'Above Icons', 'productive-ecommerce' ); ?>
            </option>
            <option value="inline" <?php echo selected( $productive_global_following_follow_on_copy_location, 'inline', false ); ?>>
                <?php echo esc_html__( 'Inline with Icons', 'productive-ecommerce' ); ?>
            </option>
        </select>
        <p>
            <?php echo esc_html__( 'Place the "Follow Us:" copy above or inline with social media icons', 'productive-ecommerce' ); ?>
        </p>
    <?php
}

function productive_global_callback_following_icon_size( $args ) {
        $options = productive_global_get_section_following_options_object();
        $productive_global_following_icon_size = '';
        if (isset( $options['productive_global_following_icon_size']) ) {
            $productive_global_following_icon_size = $options['productive_global_following_icon_size'];
        }
    ?>
    <input type="number" name="productive_global_section_following_options[productive_global_following_icon_size]" value="<?php echo esc_attr( $productive_global_following_icon_size ); ?>" size="40" id="<?php echo esc_attr( $args['label_for'] ); ?>" class="<?php echo esc_attr( $args['class'] ); ?>" />
    <p>
        <?php echo esc_html__( 'The size of each icon (default is: 20).', 'productive-ecommerce' ); ?>
    </p>
   <?php
}

function productive_global_callback_following_icon_spacing( $args ) {
        $options = productive_global_get_section_following_options_object();
        $productive_global_following_icon_spacing = '';
        if (isset( $options['productive_global_following_icon_spacing']) ) {
            $productive_global_following_icon_spacing = $options['productive_global_following_icon_spacing'];
        }
    ?>
    <input type="number" name="productive_global_section_following_options[productive_global_following_icon_spacing]" value="<?php echo esc_attr( $productive_global_following_icon_spacing ); ?>" size="40" id="<?php echo esc_attr( $args['label_for'] ); ?>" class="<?php echo esc_attr( $args['class'] ); ?>" />
    <p>
        <?php echo esc_html__( 'The spacing between the icons (default is: 2).', 'productive-ecommerce' ); ?>
    </p>
   <?php
}




function productive_global_callback_following_enabled_heading( $args ) {
    ?>
    <h3><?php echo esc_html__( 'Social Media Platform Profiles', 'productive-ecommerce' ) ?></h3>
   <?php
}

function productive_global_callback_following_enable_linkedin( $args ) {
        $options = productive_global_get_section_following_options_object();
        $productive_global_following_url_site_1 = '';
        if (isset( $options['productive_global_following_url_site_1']) ) {
            $productive_global_following_url_site_1 = $options['productive_global_following_url_site_1'];
        }
    ?>
        <input type="text" name="productive_global_section_following_options[productive_global_following_url_site_1]" value="<?php echo esc_attr( $productive_global_following_url_site_1 ); ?>" size="40" id="<?php echo esc_attr( $args['label_for'] ); ?>" class="<?php echo esc_attr( $args['class'] ); ?>" />
        <p>
            <?php echo esc_html__( 'Start with "https". Leave empty, if not in use', 'productive-ecommerce' ); ?>
        </p>
   <?php
}

function productive_global_callback_following_enable_youtube( $args ) {
        $options = productive_global_get_section_following_options_object();
        $productive_global_following_url_site_2 = '';
        if (isset( $options['productive_global_following_url_site_2']) ) {
            $productive_global_following_url_site_2 = $options['productive_global_following_url_site_2'];
        }
    ?>
        <input type="text" name="productive_global_section_following_options[productive_global_following_url_site_2]" value="<?php echo esc_attr( $productive_global_following_url_site_2 ); ?>" size="40" id="<?php echo esc_attr( $args['label_for'] ); ?>" class="<?php echo esc_attr( $args['class'] ); ?>" />
        <p>
            <?php echo esc_html__( 'Start with "https". Leave empty, if not in use', 'productive-ecommerce' ); ?>
        </p>
   <?php
}

function productive_global_callback_following_enable_facebook( $args ) {
        $options = productive_global_get_section_following_options_object();
        $productive_global_following_url_site_3 = '';
        if (isset( $options['productive_global_following_url_site_3']) ) {
            $productive_global_following_url_site_3 = $options['productive_global_following_url_site_3'];
        }
    ?>
        <input type="text" name="productive_global_section_following_options[productive_global_following_url_site_3]" value="<?php echo esc_attr( $productive_global_following_url_site_3 ); ?>" size="40" id="<?php echo esc_attr( $args['label_for'] ); ?>" class="<?php echo esc_attr( $args['class'] ); ?>" />
        <p>
            <?php echo esc_html__( 'Start with "https". Leave empty, if not in use', 'productive-ecommerce' ); ?>
        </p>
   <?php
}

function productive_global_callback_following_enable_twitter( $args ) {
        $options = productive_global_get_section_following_options_object();
        $productive_global_following_url_site_4 = '';
        if (isset( $options['productive_global_following_url_site_4']) ) {
            $productive_global_following_url_site_4 = $options['productive_global_following_url_site_4'];
        }
    ?>
        <input type="text" name="productive_global_section_following_options[productive_global_following_url_site_4]" value="<?php echo esc_attr( $productive_global_following_url_site_4 ); ?>" size="40" id="<?php echo esc_attr( $args['label_for'] ); ?>" class="<?php echo esc_attr( $args['class'] ); ?>" />
        <p>
            <?php echo esc_html__( 'Start with "https". Leave empty, if not in use', 'productive-ecommerce' ); ?>
        </p>
   <?php
}

function productive_global_callback_following_enable_pinterest( $args ) {
        $options = productive_global_get_section_following_options_object();
        $productive_global_following_url_site_5 = '';
        if (isset( $options['productive_global_following_url_site_5']) ) {
            $productive_global_following_url_site_5 = $options['productive_global_following_url_site_5'];
        }
    ?>
        <input type="text" name="productive_global_section_following_options[productive_global_following_url_site_5]" value="<?php echo esc_attr( $productive_global_following_url_site_5 ); ?>" size="40" id="<?php echo esc_attr( $args['label_for'] ); ?>" class="<?php echo esc_attr( $args['class'] ); ?>" />
        <p>
            <?php echo esc_html__( 'Start with "https". Leave empty, if not in use', 'productive-ecommerce' ); ?>
        </p>
   <?php
}

function productive_global_callback_following_enable_whatsapp( $args ) {
        $options = productive_global_get_section_following_options_object();
        $productive_global_following_value_whatsapp = '';
        if (isset( $options['productive_global_following_value_whatsapp']) ) {
            $productive_global_following_value_whatsapp = $options['productive_global_following_value_whatsapp'];
        }
    ?>
        <input type="text" name="productive_global_section_following_options[productive_global_following_value_whatsapp]" value="<?php echo esc_attr( $productive_global_following_value_whatsapp ); ?>" size="40" id="<?php echo esc_attr( $args['label_for'] ); ?>" class="<?php echo esc_attr( $args['class'] ); ?>" />
        <p>
            <?php echo esc_html__( 'WhatsApp number, including international dial code. Leave empty, if not in use.', 'productive-ecommerce' ); ?>
        </p>
   <?php
}

function productive_global_callback_following_enable_email( $args ) {
        $options = productive_global_get_section_following_options_object();
        $productive_global_following_value_email = '';
        if (isset( $options['productive_global_following_value_email']) ) {
            $productive_global_following_value_email = $options['productive_global_following_value_email'];
        }
    ?>
        <input type="text" name="productive_global_section_following_options[productive_global_following_value_email]" value="<?php echo esc_attr( $productive_global_following_value_email ); ?>" size="40" id="<?php echo esc_attr( $args['label_for'] ); ?>" class="<?php echo esc_attr( $args['class'] ); ?>" />
        <p>
            <?php echo esc_html__( 'A valid email address. Leave empty, if not in use.', 'productive-ecommerce' ); ?>
        </p>
   <?php
}

function productive_global_callback_following_enable_phone( $args ) {
        $options = productive_global_get_section_following_options_object();
        $productive_global_following_value_phone = '';
        if (isset( $options['productive_global_following_value_phone']) ) {
            $productive_global_following_value_phone = $options['productive_global_following_value_phone'];
        }
    ?>
        <input type="text" name="productive_global_section_following_options[productive_global_following_value_phone]" value="<?php echo esc_attr( $productive_global_following_value_phone ); ?>" size="40" id="<?php echo esc_attr( $args['label_for'] ); ?>" class="<?php echo esc_attr( $args['class'] ); ?>" />
        <p>
            <?php echo esc_html__( 'Telephone number, including international dial code. Leave empty, if not in use.', 'productive-ecommerce' ); ?>
        </p>
   <?php
}

/* ============ END Section fields ================= */
// Stop: Popup