<?php
/**
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 */

if ( !defined('ABSPATH') ) {
    die();
}


function productive_global_render_social_media_follow_icons( $misc, $social_media_platforms_source ='standard', $user_id_param = 0 ) {
    
    $user_id = intval( $user_id_param );
    $platform_arrays_collection = array();
    
    if( 'standard' == $social_media_platforms_source ) {
        
        $productive_global_following_url_site_1        = productive_global_following_url_site_1();
        if( isset( $misc['productive_global_following_url_site_1'] ) ) {
            $productive_global_following_url_site_1 = $misc['productive_global_following_url_site_1'];
        }
        if( wp_http_validate_url($productive_global_following_url_site_1) ) {
            $platform_arrays_collection['productive_global_following_url_site_1'] = productive_global_get_social_media_platform_name( $productive_global_following_url_site_1 );
        }
        
        $productive_global_following_url_site_2         = productive_global_following_url_site_2();
        if( isset( $misc['productive_global_following_url_site_2'] ) ) {
            $productive_global_following_url_site_2 = $misc['productive_global_following_url_site_2'];
        }
        if( wp_http_validate_url($productive_global_following_url_site_2) ) {
            $platform_arrays_collection['productive_global_following_url_site_2'] = productive_global_get_social_media_platform_name( $productive_global_following_url_site_2 );
        }
        
        $productive_global_following_url_site_3        = productive_global_following_url_site_3();
        if( isset( $misc['productive_global_following_url_site_3'] ) ) {
            $productive_global_following_url_site_3 = $misc['productive_global_following_url_site_3'];
        }
        if( wp_http_validate_url($productive_global_following_url_site_3) ) {
            $platform_arrays_collection['productive_global_following_url_site_3'] = productive_global_get_social_media_platform_name( $productive_global_following_url_site_3 );
        }
        
        $productive_global_following_url_site_4         = productive_global_following_url_site_4();
        if( isset( $misc['productive_global_following_url_site_4'] ) ) {
            $productive_global_following_url_site_4 = $misc['productive_global_following_url_site_4'];
        }
        if( wp_http_validate_url($productive_global_following_url_site_4) ) {
            $platform_arrays_collection['productive_global_following_url_site_4'] = productive_global_get_social_media_platform_name( $productive_global_following_url_site_4 );
        }
        
        $productive_global_following_url_site_5       = productive_global_following_url_site_5();
        if( isset( $misc['productive_global_following_url_site_5'] ) ) {
            $productive_global_following_url_site_5 = $misc['productive_global_following_url_site_5'];
        }
        if( wp_http_validate_url($productive_global_following_url_site_5) ) {
            $platform_arrays_collection['productive_global_following_url_site_5'] = productive_global_get_social_media_platform_name( $productive_global_following_url_site_5 );
        }
        
        $productive_global_following_value_whatsapp        = productive_global_following_value_whatsapp();
        if( isset( $misc['productive_global_following_value_whatsapp'] ) ) {
            $productive_global_following_value_whatsapp = $misc['productive_global_following_value_whatsapp'];
        }
        if( !empty($productive_global_following_value_whatsapp) ) {
            $social_media_site_name = '';
            $social_media_site_name_suffix = 'whatsapp';
            $productive_global_following_value_whatsapp = str_replace( '+', '', $productive_global_following_value_whatsapp ) . $social_media_site_name_suffix;
            $platform_arrays_collection['productive_global_following_value_whatsapp'] = productive_global_get_social_media_platform_name( $productive_global_following_value_whatsapp, $social_media_site_name, $social_media_site_name_suffix ); 
        }
        
        $productive_global_following_value_email           = productive_global_following_value_email();
        if( isset( $misc['productive_global_following_value_email'] ) ) {
            $productive_global_following_value_email = $misc['productive_global_following_value_email'];
        }
        if( is_email($productive_global_following_value_email) ) {
            $platform_arrays_collection['productive_global_following_value_email'] = productive_global_get_social_media_platform_name( $productive_global_following_value_email );
        }
        
        $productive_global_following_value_phone        = productive_global_following_value_phone();
        if( isset( $misc['productive_global_following_value_phone'] ) ) {
            $productive_global_following_value_phone = $misc['productive_global_following_value_phone'];
        }
        if( !empty($productive_global_following_value_phone) ) {
            $social_media_site_name = '';
            $social_media_site_name_suffix = 'phone';
            $productive_global_following_value_phone = str_replace( '+', '', $productive_global_following_value_phone ) . $social_media_site_name_suffix;
            $platform_arrays_collection['productive_global_following_value_phone'] = productive_global_get_social_media_platform_name( $productive_global_following_value_phone, $social_media_site_name, $social_media_site_name_suffix ); 
        }
        
        if( productive_global_is_productive_forms_active() ) {
            if( isset( $misc['productive_global_following_value_contact_form'] ) && intval( $misc['productive_global_following_value_contact_form'] ) ) {
                $productive_global_following_value_contact_form = 'contact_form';
                $platform_arrays_collection['productive_global_following_value_contact_form'] = productive_global_get_social_media_platform_name( $productive_global_following_value_contact_form ); 
            }

            if( isset( $misc['productive_global_following_value_newsletter_form'] ) && intval( $misc['productive_global_following_value_newsletter_form'] ) ) {
                $productive_global_following_value_newsletter_form = 'newsletter_form';
                $platform_arrays_collection['productive_global_following_value_newsletter_form'] = productive_global_get_social_media_platform_name( $productive_global_following_value_newsletter_form ); 
            }
        }
        
    } else if( 'team_member' == $social_media_platforms_source ) {
        $team_social_site_1         = '';
        $team_social_site_2         = '';
        $team_social_site_3         = '';
        $team_social_site_4         = '';
        
        if ( isset( $misc['team_social_site_1'] ) ) {
            $team_social_site_1 = $misc['team_social_site_1'];
            if( !empty($team_social_site_1) ) {
                $platform_arrays_collection['team_social_site_1'] = productive_global_get_social_media_platform_name( $team_social_site_1 );
            }
        }
        if ( isset( $misc['team_social_site_2'] ) ) {
            $team_social_site_2 = $misc['team_social_site_2'];
            if( !empty($team_social_site_2) ) {
                $platform_arrays_collection['team_social_site_2'] = productive_global_get_social_media_platform_name( $team_social_site_2 );
            }
        }
        if ( isset( $misc['team_social_site_3'] ) ) {
            $team_social_site_3 = $misc['team_social_site_3'];
            if( !empty($team_social_site_3) ) {
                $platform_arrays_collection['team_social_site_3'] = productive_global_get_social_media_platform_name( $team_social_site_3 );
            }
        }
        if ( isset( $misc['team_social_site_4'] ) ) {
            $team_social_site_4 = $misc['team_social_site_4'];
            if( !empty($team_social_site_4) ) {
                $platform_arrays_collection['team_social_site_4'] = productive_global_get_social_media_platform_name( $team_social_site_4 );
            }
        }
        
    } else if( 'user_profile' == $social_media_platforms_source && 0 < $user_id ) {
        
        $productive_user_follow_site_1        = get_user_meta( $user_id, 'productive_user_follow_site_1', true );
        if( !empty($productive_user_follow_site_1) ) {
            $platform_arrays_collection['productive_user_follow_site_1'] = productive_global_get_social_media_platform_name( $productive_user_follow_site_1 );
        }
        
        $productive_user_follow_site_2        = get_user_meta( $user_id, 'productive_user_follow_site_2', true );
        if( !empty($productive_user_follow_site_2) ) {
            $platform_arrays_collection['productive_user_follow_site_2'] = productive_global_get_social_media_platform_name( $productive_user_follow_site_2 );
        }
        
        $productive_user_follow_site_3        = get_user_meta( $user_id, 'productive_user_follow_site_3', true );
        if( !empty($productive_user_follow_site_3) ) {
            $platform_arrays_collection['productive_user_follow_site_3'] = productive_global_get_social_media_platform_name( $productive_user_follow_site_3 );
        }
        
        $productive_user_follow_site_4        = get_user_meta( $user_id, 'productive_user_follow_site_4', true );
        if( !empty($productive_user_follow_site_4) ) {
            $platform_arrays_collection['productive_user_follow_site_4'] = productive_global_get_social_media_platform_name( $productive_user_follow_site_4 );
        }
        
        $productive_user_follow_site_5        = get_user_meta( $user_id, 'productive_user_follow_site_5', true );
        if( !empty($productive_user_follow_site_5) ) {
            $platform_arrays_collection['productive_user_follow_site_5'] = productive_global_get_social_media_platform_name( $productive_user_follow_site_5 );
        }
        
    }
    
    if( !empty( $platform_arrays_collection ) ) {
        
        $section_show_social_media_follow_on_copy = '';
        if( isset( $misc['section_show_social_media_follow_on_copy'] ) ) {
            $section_show_social_media_follow_on_copy = $misc['section_show_social_media_follow_on_copy'];
        }
        
        $section_show_social_media_follow_on_copy_location = productive_global_following_follow_on_copy_location();
        if( isset( $misc['section_show_social_media_follow_on_copy_location'] ) ) {
            $section_show_social_media_follow_on_copy_location = $misc['section_show_social_media_follow_on_copy_location'];
        }
        
        $display_contact_social_media_icons_style = productive_global_following_brand_color_around_white_icon();
        if( isset( $misc['display_contact_social_media_icons_style'] ) ) {
            $display_contact_social_media_icons_style = $misc['display_contact_social_media_icons_style'];
        }
        
        $section_content_social_media_follow_icon_size = productive_global_following_icon_size();
        if( isset( $misc['section_content_social_media_follow_icon_size'] ) ) {
            $section_content_social_media_follow_icon_size = intval( $misc['section_content_social_media_follow_icon_size'] );
        }
        
        $productive_global_follow_icons_css = '';
        
        $section_show_social_media_platform_name = 0;
        if( isset( $misc['section_show_social_media_platform_name'] ) ) {
            $section_show_social_media_platform_name = $misc['section_show_social_media_platform_name'];
        }
        
        $section_hierarchy = 'child';
        if( isset( $misc['section_hierarchy'] ) ) {
            $section_hierarchy = $misc['section_hierarchy'];
        }
        
        $social_media_follow_icons_icons_boxes_spread = '';
        if( isset( $misc['social_media_follow_icons_icons_boxes_spread'] ) ) {
            $social_media_follow_icons_icons_boxes_spread = $misc['social_media_follow_icons_icons_boxes_spread'];
        }
        
        $social_media_follow_icons_icons_boxes_layout = 'horizontal';
        if( isset( $misc['social_media_follow_icons_icons_boxes_layout'] ) ) {
            $social_media_follow_icons_icons_boxes_layout = $misc['social_media_follow_icons_icons_boxes_layout'];
        }
        if( 'inline' == $section_show_social_media_follow_on_copy_location ) {
            $social_media_follow_icons_icons_boxes_layout_css = 'flexed flexed-in-a-flexed gap-10px';
        } else {
            $social_media_follow_icons_icons_boxes_layout_css = 'flexed gap-10px';
        }
        if( 'vertical' == $social_media_follow_icons_icons_boxes_layout ) {
            $social_media_follow_icons_icons_boxes_layout_css = 'grided gap-5px';
        }
        
        $social_media_follow_icons_icons_boxes_layout_width = 'width-autoed';
        $social_media_follow_icons_icon_and_name_box_icon_width = 'width-fit-content';
        $social_media_follow_icons_icons_boxes_spread_css = '';
        
        if( ( 'top' == $section_show_social_media_follow_on_copy_location || empty($section_show_social_media_follow_on_copy) ) &&
                ('auto' == $social_media_follow_icons_icons_boxes_spread && 'vertical' == $social_media_follow_icons_icons_boxes_layout)
            ) {
            $social_media_follow_icons_icons_boxes_layout_width = 'width-100pc';
            $social_media_follow_icons_icon_and_name_box_icon_width = 'width-100pc';
        } else if( ('inline' == $section_show_social_media_follow_on_copy_location || empty($section_show_social_media_follow_on_copy) ) &&
                ('auto' == $social_media_follow_icons_icons_boxes_spread && 'vertical' == $social_media_follow_icons_icons_boxes_layout)
            ) {
            $social_media_follow_icons_icon_and_name_box_icon_width = 'width-100pc';
        }
        
        if( 'auto' == $social_media_follow_icons_icons_boxes_spread ) {
            $social_media_follow_icons_icons_boxes_spread_css = 'flexed-autoed';
        }
        
        $follow_content_type = 'post';
        if( isset( $misc['follow_content_type'] ) ) {
            $follow_content_type = $misc['follow_content_type'];
        }
        
        $section_content_settings_unique_id = 'section_content_unique_id_'. wp_rand();
        if( isset( $misc['section_content_settings_unique_id'] ) ) {
            $section_content_settings_unique_id = $misc['section_content_settings_unique_id'];
        }
        $section_initiator = 'std';
        if( isset( $misc['section_initiator'] ) ) {
            $section_initiator = $misc['section_initiator'];
        }
        
        $productiveminds_section_display = 'grided';
        
        $productiveminds_section_display_icons_container = 'grided gap-15px';
        if ( 'inline' == $section_show_social_media_follow_on_copy_location ) {
            $productiveminds_section_display_icons_container = 'flexed gap-15px';
        }
        
    ?>
        <div class="productiveminds_section social-follow-and-contact <?php echo esc_attr( $follow_content_type ); ?> <?php echo esc_attr( $productiveminds_section_display ); ?> <?php echo esc_attr( $section_initiator ); ?>" id="<?php echo esc_attr( $section_content_settings_unique_id ); ?>">
            <div class="productiveminds_section_uno generic-box-type <?php echo esc_attr( $section_hierarchy ); ?>">
                
                <?php
                    if ( 'parent' == $section_hierarchy ) {
                        $section_content_header_is_show_section_header = 1;
                        $section_title = esc_html__('Share', 'productive-ecommerce');
                        $section_title_suffix = '';
                        $section_title_html_tag = 'h2';
                        $section_heading_auxiliary = '';
                        $section_heading_auxiliary_position = 'bottom';
                        $section_intro = esc_html__('Leave heading fields empty to hide the heading.', 'productive-ecommerce');
                        $section_header_alignment = '';

                        if ( isset( $misc['section_content_header_is_show_section_header'] ) ) {
                            $section_content_header_is_show_section_header = $misc['section_content_header_is_show_section_header'];
                        }
                        if ( isset( $misc['section_title'] ) ) {
                            $section_title = $misc['section_title'];
                        }
                        if ( isset( $misc['section_title_suffix'] ) ) {
                            $section_title_suffix = $misc['section_title_suffix'];
                        }
                        if ( isset( $misc['section_title_html_tag'] ) ) {
                            $section_title_html_tag = $misc['section_title_html_tag'];
                        }
                        if ( isset( $misc['section_heading_auxiliary'] ) ) {
                            $section_heading_auxiliary = $misc['section_heading_auxiliary'];
                        }
                        if ( isset( $misc['section_heading_auxiliary_position'] ) ) {
                            $section_heading_auxiliary_position = $misc['section_heading_auxiliary_position'];
                        }
                        if ( isset( $misc['section_intro'] ) ) {
                            $section_intro = $misc['section_intro'];
                        }
                        if ( isset( $misc['section_header_alignment'] ) ) {
                            $section_header_alignment = $misc['section_header_alignment'];
                        }
                        
                        if ( $section_content_header_is_show_section_header ) {
                            productive_global_render_section_header( $misc );
                        }
                    }
                ?>
                
                <div class="social_media_follow_icons_container productiveminds-alignable-container align-items-center align-content-center <?php echo esc_attr( $productiveminds_section_display_icons_container ); ?>">
                    
                    <?php if( !empty($section_show_social_media_follow_on_copy) ) { ?>
                        <div class="social_media_follow_icons_copy productiveminds-alignable-container width-autoed align-items-center align-content-center">
                            <?php echo esc_html( $section_show_social_media_follow_on_copy ); ?>
                        </div>
                    <?php } ?>
                    
                    <div class="social_media_follow_icons_icons <?php echo esc_attr( $display_contact_social_media_icons_style ); ?> <?php echo esc_attr( $social_media_follow_icons_icons_boxes_layout_width ); ?> <?php echo esc_attr( $social_media_follow_icons_icons_boxes_spread_css ); ?>">
                        <div class="social_media_follow_icons_icons_boxes productiveminds-alignable-container width-100pc <?php echo esc_attr( $social_media_follow_icons_icons_boxes_layout_css ); ?>">
                            
                            <?php
                            foreach ( $platform_arrays_collection as $platform_arrays_collection_key => $platform_arrays_collection_item ) {
                                $platform           = $platform_arrays_collection_item[0];
                                $platform_name      = $platform_arrays_collection_item[1];
                                $platform_css       = $platform_arrays_collection_item[2];
                                $platform_url       = $platform_arrays_collection_item[3];
                                if( strpos( $platform_url, 'whatsapp') !== false ) {
                                    $whats_app_number = trim( str_replace( 'whatsapp', '', $platform_url ) );
                                    $platform_url = 'https://api.whatsapp.com/send?phone='.$whats_app_number;
                                } else if( strpos( $platform_url, 'phone') !== false ) {
                                    $phone_number = trim( str_replace( 'phone', '', $platform_url ) );
                                    $platform_url = 'tel:'.$phone_number;
                                } else if( strpos( $platform_url, 'contact_form') !== false ) {
                                    $platform_url = '#';
                                } else if( strpos( $platform_url, 'newsletter_form') !== false ) {
                                    $platform_url = '#';
                                } else if(is_email($platform_url) ) {
                                    $platform_url = 'mailto:'.$platform_url;
                                }
                                $productive_social_media_icons_args_social_site = array(
                                    'i'=> $platform,
                                    'w'=>$section_content_social_media_follow_icon_size,
                                    'h'=>$section_content_social_media_follow_icon_size,
                                    'css'=> $productive_global_follow_icons_css . ' ' . $platform,
                                );
                            ?>
                                <a target="_blank" href="<?php echo esc_url( $platform_url ); ?>"
                                    class="social_media_follow_icons_icon_and_name_box <?php echo esc_attr( $platform_css ); ?> productiveminds-alignable-container flexed flexed-no-wrap align-items-center align-content-center <?php echo esc_attr( $social_media_follow_icons_icon_and_name_box_icon_width ); ?> gap-5px"
                                 >
                                     <span class="social_media_follow_icons_icon_and_name_box_icon productiveminds-alignable-container width-autoed">
                                         <?php echo wp_kses( productiveminds_get_svg_icon( $productive_social_media_icons_args_social_site ), 'wp_kses_allowed_html' ); ?>
                                     </span>
                                     <?php if( $section_show_social_media_platform_name ) { ?>
                                         <span class="social_media_follow_icons_icon_and_name_box_text productiveminds-alignable-container width-autoed">
                                             <?php echo esc_html( $platform_name ); ?>
                                         </span>
                                     <?php } ?>
                                 </a>
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
                
            </div><!-- productiveminds_section_uno -->
        </div><!-- productiveminds_section -->
    <?php
    }
    
}

function productive_global_get_social_media_platform_name( $social_media_site_url, $social_media_site_name = '', $social_media_site_name_suffix = '' ) {
    $platform = array( '', '' );
    switch ($social_media_site_url) {
        case productive_global_is_a_social_media_platform( $social_media_site_url, 'facebook' ):
            if( empty($social_media_site_name) ) {
                $social_media_site_name = esc_html__('Facebook', 'productive-ecommerce');
            }
            $platform = array( 'facebook', $social_media_site_name, 'facebook-follow-button', $social_media_site_url );
            break;
        case productive_global_is_a_social_media_platform( $social_media_site_url, 'twitter' ):
            if( empty($social_media_site_name) ) {
                $social_media_site_name = esc_html__('Twitter', 'productive-ecommerce');
            }
            $platform = array( 'twitter', $social_media_site_name, 'twitter-follow-button', $social_media_site_url );
            break;
        case productive_global_is_a_social_media_platform( $social_media_site_url, 'x.com' ):
            if( empty($social_media_site_name) ) {
                $social_media_site_name = esc_html__('X (Twitter)', 'productive-ecommerce');
            }
            $platform = array( 'twitter-x', $social_media_site_name, 'twitter-x-follow-button', $social_media_site_url );
            break;
        case productive_global_is_a_social_media_platform( $social_media_site_url, 'linkedin' ):
            if( empty($social_media_site_name) ) {
                $social_media_site_name = esc_html__('Linkedin', 'productive-ecommerce');
            }
            $platform = array( 'linkedin', $social_media_site_name, 'linkedin-follow-button', $social_media_site_url );
            break;
        case productive_global_is_a_social_media_platform( $social_media_site_url, 'instagram' ):
            if( empty($social_media_site_name) ) {
                $social_media_site_name = esc_html__('Instagram', 'productive-ecommerce');
            }
            $platform = array( 'instagram', $social_media_site_name, 'instagram-follow-button', $social_media_site_url );
            break;
        case productive_global_is_a_social_media_platform( $social_media_site_url, 'youtube' ):
            if( empty($social_media_site_name) ) {
                $social_media_site_name = esc_html__('YouTube', 'productive-ecommerce');
            }
            $platform = array( 'youtube', $social_media_site_name, 'youtube-follow-button', $social_media_site_url );
            break;
        case productive_global_is_a_social_media_platform( $social_media_site_url, 'pinterest' ):
            if( empty($social_media_site_name) ) {
                $social_media_site_name = esc_html__('Pinterest', 'productive-ecommerce');
            }
            $platform = array( 'pinterest', $social_media_site_name, 'pinterest-follow-button', $social_media_site_url );
            break;
        
        case is_email( $social_media_site_url ):
            if( empty($social_media_site_name) ) {
                $social_media_site_name = str_replace( $social_media_site_name_suffix, '', $social_media_site_url );
            }
            $platform = array( 'inbox-icon-only', $social_media_site_name, 'email-follow-button', $social_media_site_url );
            break;
        case strpos( $social_media_site_url, 'whatsapp') !== false:
            if( empty($social_media_site_name) ) {
                $social_media_site_name = str_replace( $social_media_site_name_suffix, '', $social_media_site_url );
            }
            $platform = array( 'whatsapp', $social_media_site_name, 'whatsapp-follow-button', $social_media_site_url );
            break;
        case strpos( $social_media_site_url, 'phone') !== false:
            if( empty($social_media_site_name) ) {
                $social_media_site_name = str_replace( $social_media_site_name_suffix, '', $social_media_site_url );
            }
            $platform = array( 'phone', $social_media_site_name, 'phone-follow-button', $social_media_site_url );
            break;
            
        case strpos( $social_media_site_url, 'contact_form') !== false:
            if( empty($social_media_site_name) ) {
                $social_media_site_name = esc_html__('Message Us', 'productive-ecommerce');
            }
            $platform = array( 'tasks', $social_media_site_name, 'contact_form-follow-button', $social_media_site_url );
            break;
        case strpos( $social_media_site_url, 'newsletter_form') !== false:
            if( empty($social_media_site_name) ) {
                $social_media_site_name = esc_html__('Subscribe', 'productive-ecommerce');
            }
            $platform = array( 'bell-o', $social_media_site_name, 'newsletter_form-follow-button', $social_media_site_url );
            break;
            
        default:
            if( empty($social_media_site_name) ) {
                $social_media_site_name = esc_html__('Website', 'productive-ecommerce');
            }
            $platform = array( 'website', $social_media_site_name, 'website-follow-button', $social_media_site_url );
            break;
    }
    return $platform;
}

function productive_global_is_a_social_media_platform( $url, $name ) {
    return filter_var( $url, FILTER_VALIDATE_URL ) && 
        ( strpos($url, $name . '.') !== false || 
        strpos($url, '://' . $name) !== false || 
        strpos($url, 'www.' . $name) !== false );
}
