<?php
/**
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 */

if ( !defined('ABSPATH') ) {
    die();
}


function productive_global_render_social_media_share_icons( $misc, $section_content_social_media_share_url, $section_content_social_media_share_media, $section_content_social_media_share_text ) {
    
    _productive_global_render_social_media_share_icons( $misc, $section_content_social_media_share_url, $section_content_social_media_share_media, $section_content_social_media_share_text );
    
}
add_action( 'productive_global_render_social_shares', 'productive_global_render_social_media_share_icons' );


function _productive_global_render_social_media_share_icons( $misc, $section_content_social_media_share_url, $section_content_social_media_share_media, $section_content_social_media_share_text ) {
    $is_sharing_by_linkedin = productive_global_sharing_enable_linkedin();
    $is_sharing_by_facebook = productive_global_sharing_enable_facebook();
    $is_sharing_by_twitter = productive_global_sharing_enable_twitter();
    $is_sharing_by_pinterest = productive_global_sharing_enable_pinterest();
    $is_sharing_by_instagram = productive_global_sharing_enable_instagram();
    $is_sharing_by_whatsapp = productive_global_sharing_enable_whatsapp();
    $is_sharing_by_email = productive_global_sharing_enable_email();
    
    if( isset( $misc['do_social_share_linkedin'] ) ) {
        $is_sharing_by_linkedin = intval( $misc['do_social_share_linkedin'] );
    }
    if( isset( $misc['do_social_share_facebook'] ) ) {
        $is_sharing_by_facebook = intval( $misc['do_social_share_facebook'] );
    }
    if( isset( $misc['do_social_share_twitter'] ) ) {
        $is_sharing_by_twitter = intval( $misc['do_social_share_twitter'] );
    }
    if( isset( $misc['do_social_share_pinterest'] ) ) {
        $is_sharing_by_pinterest = intval( $misc['do_social_share_pinterest'] );
    }
    if( isset( $misc['do_social_share_instagram'] ) ) {
        $is_sharing_by_instagram = intval( $misc['do_social_share_instagram'] );
    }
    if( isset( $misc['do_social_share_whatsapp'] ) ) {
        $is_sharing_by_whatsapp = intval( $misc['do_social_share_whatsapp'] );
    }
    if( isset( $misc['do_social_share_email'] ) ) {
        $is_sharing_by_email = intval( $misc['do_social_share_email'] );
    }
    
    $is_sharing_by_instagram = 0;
    
    if( $is_sharing_by_linkedin || $is_sharing_by_facebook || $is_sharing_by_twitter || $is_sharing_by_pinterest || $is_sharing_by_instagram || $is_sharing_by_whatsapp || $is_sharing_by_email ) {
        
        $section_show_social_media_share_on_copy = '';
        if( isset( $misc['section_show_social_media_share_on_copy'] ) ) {
            $section_show_social_media_share_on_copy = $misc['section_show_social_media_share_on_copy'];
        }
        
        $section_show_social_media_share_on_copy_location = productive_global_sharing_share_on_copy_location();
        if( isset( $misc['section_show_social_media_share_on_copy_location'] ) ) {
            $section_show_social_media_share_on_copy_location = $misc['section_show_social_media_share_on_copy_location'];
        }
        
        $section_content_social_media_share_email_subject               = $section_content_social_media_share_text . esc_html__(' | ', 'productive-ecommerce') . get_bloginfo( 'name' );
        $section_content_social_media_share_desc_for_pinterest          = $section_content_social_media_share_text . esc_html__(' | ', 'productive-ecommerce') . get_bloginfo( 'name' );
        
        $display_contact_social_media_icons_style = productive_global_sharing_brand_color_around_white_icon();
        if( isset( $misc['display_contact_social_media_icons_style'] ) ) {
            $display_contact_social_media_icons_style = $misc['display_contact_social_media_icons_style'];
        }
        
        if( null == $section_content_social_media_share_media || empty($section_content_social_media_share_media) ) {
            $section_content_social_media_share_media = productive_global_get_site_logo_url();
        }
        
        $section_content_social_media_share_icon_size = productive_global_sharing_icon_size();
        if( isset( $misc['section_content_social_media_share_icon_size'] ) ) {
            $section_content_social_media_share_icon_size = intval( $misc['section_content_social_media_share_icon_size'] );
        }
        
        $productive_global_share_icons_css = '';
        
        $productive_global_share_icons_args_linkedin = array(
            'i'=> 'linkedin', 
            'w'=>$section_content_social_media_share_icon_size, 
            'h'=>$section_content_social_media_share_icon_size, 
            'css'=> $productive_global_share_icons_css . ' linkedin',
        );
        $productive_global_share_icons_args_facebook = array(
            'i'=> 'facebook', 
            'w'=>$section_content_social_media_share_icon_size, 
            'h'=>$section_content_social_media_share_icon_size, 
            'css'=> $productive_global_share_icons_css . ' facebook',
        );
        $productive_global_share_icons_args_twitter = array(
            'i'=> 'twitter', 
            'w'=>$section_content_social_media_share_icon_size, 
            'h'=>$section_content_social_media_share_icon_size, 
            'css'=> $productive_global_share_icons_css . ' twitter',
        );
        $productive_global_share_icons_args_twitter_x = array(
            'i'=> 'twitter-x', 
            'w'=>$section_content_social_media_share_icon_size, 
            'h'=>$section_content_social_media_share_icon_size, 
            'css'=> $productive_global_share_icons_css . ' twitter-x',
        );
        $productive_global_share_icons_args_pinterest = array(
            'i'=> 'pinterest', 
            'w'=>$section_content_social_media_share_icon_size, 
            'h'=>$section_content_social_media_share_icon_size, 
            'css'=> $productive_global_share_icons_css . ' pinterest',
        );
        $productive_global_share_icons_args_instagram = array(
            'i'=> 'instagram', 
            'w'=>$section_content_social_media_share_icon_size, 
            'h'=>$section_content_social_media_share_icon_size, 
            'css'=> $productive_global_share_icons_css . ' instagram',
        );
        $productive_global_share_icons_args_whatsapp = array(
            'i'=> 'whatsapp',
            'w'=>$section_content_social_media_share_icon_size, 
            'h'=>$section_content_social_media_share_icon_size, 
            'css'=> $productive_global_share_icons_css . ' whatsapp',
        );
        $productive_global_share_icons_args_email = array(
            'i'=> 'inbox-icon-only',
            'w'=>$section_content_social_media_share_icon_size,
            'h'=>$section_content_social_media_share_icon_size,
            'css'=> $productive_global_share_icons_css . ' ',
        );
        
        $section_show_social_media_platform_name = 0;
        if( isset( $misc['section_show_social_media_platform_name'] ) ) {
            $section_show_social_media_platform_name = $misc['section_show_social_media_platform_name'];
        }
        
        $section_hierarchy = 'child';
        if( isset( $misc['section_hierarchy'] ) ) {
            $section_hierarchy = $misc['section_hierarchy'];
        }
        
        $social_media_share_icons_icons_boxes_spread = '';
        if( isset( $misc['social_media_share_icons_icons_boxes_spread'] ) ) {
            $social_media_share_icons_icons_boxes_spread = $misc['social_media_share_icons_icons_boxes_spread'];
        }
        
        $social_media_share_icons_icons_boxes_layout = 'horizontal';
        if( isset( $misc['social_media_share_icons_icons_boxes_layout'] ) ) {
            $social_media_share_icons_icons_boxes_layout = $misc['social_media_share_icons_icons_boxes_layout'];
        }
        if( 'inline' == $section_show_social_media_share_on_copy_location ) {
            $social_media_share_icons_icons_boxes_layout_css = 'flexed flexed-in-a-flexed gap-10px';
        } else {
            $social_media_share_icons_icons_boxes_layout_css = 'flexed gap-10px';
        }
        if( 'vertical' == $social_media_share_icons_icons_boxes_layout ) {
            $social_media_share_icons_icons_boxes_layout_css = 'grided gap-5px';
        }
        
        $social_media_share_icons_icons_boxes_layout_width = 'width-autoed';
        $social_media_share_icons_icon_and_name_box_icon_width = 'width-fit-content';
        $social_media_share_icons_icons_boxes_spread_css = '';
        
        if( ( 'top' == $section_show_social_media_share_on_copy_location || empty($section_show_social_media_share_on_copy) ) &&
                ('auto' == $social_media_share_icons_icons_boxes_spread && 'vertical' == $social_media_share_icons_icons_boxes_layout)
            ) {
            $social_media_share_icons_icons_boxes_layout_width = 'width-100pc';
            $social_media_share_icons_icon_and_name_box_icon_width = 'width-100pc';
        } else if( ('inline' == $section_show_social_media_share_on_copy_location || empty($section_show_social_media_share_on_copy) ) &&
                ('auto' == $social_media_share_icons_icons_boxes_spread && 'vertical' == $social_media_share_icons_icons_boxes_layout)
            ) {
            $social_media_share_icons_icon_and_name_box_icon_width = 'width-100pc';
        }
        
        if( 'auto' == $social_media_share_icons_icons_boxes_spread ) {
            $social_media_share_icons_icons_boxes_spread_css = 'flexed-autoed';
        }
        
        $share_content_type = 'post';
        if( isset( $misc['share_content_type'] ) ) {
            $share_content_type = $misc['share_content_type'];
        }
        
        $section_content_settings_unique_id = 'section_content_unique_id_'. wp_rand();
        if( isset( $misc['section_content_settings_unique_id'] ) ) {
            $section_content_settings_unique_id = $misc['section_content_settings_unique_id'];
        }
        $section_initiator = 'std';
        if( isset( $misc['section_initiator'] ) ) {
            $section_initiator = $misc['section_initiator'];
        }
        
        $productiveminds_section_display = 'grided';
        
        $productiveminds_section_display_icons_container = 'grided gap-15px';
        if ( 'inline' == $section_show_social_media_share_on_copy_location ) {
            $productiveminds_section_display_icons_container = 'flexed gap-15px';
        }
    ?>
        <div class="productiveminds_section social-media-share <?php echo esc_attr( $share_content_type ); ?> <?php echo esc_attr( $productiveminds_section_display ); ?> <?php echo esc_attr( $section_initiator ); ?>" id="<?php echo esc_attr( $section_content_settings_unique_id ); ?>">
            <div class="productiveminds_section_uno generic-box-type <?php echo esc_attr( $section_hierarchy ); ?>">
                
                <?php
                    if ( 'parent' == $section_hierarchy ) {
                        $section_content_header_is_show_section_header = 1;
                        $section_title = esc_html__('Share', 'productive-ecommerce');
                        $section_title_suffix = '';
                        $section_title_html_tag = 'h2';
                        $section_heading_auxiliary = '';
                        $section_heading_auxiliary_position = 'bottom';
                        $section_intro = esc_html__('Please provide a description here. Leave heading fields empty to hide the heading.', 'productive-ecommerce');
                        $section_header_alignment = '';

                        if ( isset( $misc['section_content_header_is_show_section_header'] ) ) {
                            $section_content_header_is_show_section_header = $misc['section_content_header_is_show_section_header'];
                        }
                        if ( isset( $misc['section_title'] ) ) {
                            $section_title = $misc['section_title'];
                        }
                        if ( isset( $misc['section_title_suffix'] ) ) {
                            $section_title_suffix = $misc['section_title_suffix'];
                        }
                        if ( isset( $misc['section_title_html_tag'] ) ) {
                            $section_title_html_tag = $misc['section_title_html_tag'];
                        }
                        if ( isset( $misc['section_heading_auxiliary'] ) ) {
                            $section_heading_auxiliary = $misc['section_heading_auxiliary'];
                        }
                        if ( isset( $misc['section_heading_auxiliary_position'] ) ) {
                            $section_heading_auxiliary_position = $misc['section_heading_auxiliary_position'];
                        }
                        if ( isset( $misc['section_intro'] ) ) {
                            $section_intro = $misc['section_intro'];
                        }
                        if ( isset( $misc['section_header_alignment'] ) ) {
                            $section_header_alignment = $misc['section_header_alignment'];
                        }
                        
                        if ( $section_content_header_is_show_section_header ) {
                            productive_global_render_section_header( $misc );
                        }
                    }
                ?>
                
                <div class="social_media_share_icons_container productiveminds-alignable-container align-items-center align-content-center <?php echo esc_attr( $productiveminds_section_display_icons_container ); ?>">
                    
                    <?php if( !empty($section_show_social_media_share_on_copy) ) { ?>
                        <div class="social_media_share_icons_copy productiveminds-alignable-container width-autoed align-items-center align-content-center">
                            <?php echo esc_html( $section_show_social_media_share_on_copy ); ?>
                        </div>
                    <?php } ?>
                    
                    <div class="social_media_share_icons_icons <?php echo esc_attr( $display_contact_social_media_icons_style ); ?> <?php echo esc_attr( $social_media_share_icons_icons_boxes_layout_width ); ?> <?php echo esc_attr( $social_media_share_icons_icons_boxes_spread_css ); ?>">
                        <div class="social_media_share_icons_icons_boxes productiveminds-alignable-container width-100pc <?php echo esc_attr( $social_media_share_icons_icons_boxes_layout_css ); ?>">
                            
                            <?php if( $is_sharing_by_linkedin ) { ?>
                                <a target="_blank" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo esc_url( $section_content_social_media_share_url ); ?>&text=<?php echo esc_attr( $section_content_social_media_share_desc_for_pinterest ); ?>"
                                   class="social_media_share_icons_icon_and_name_box linkedin-share-button productiveminds-alignable-container flexed flexed-no-wrap align-items-center align-content-center <?php echo esc_attr( $social_media_share_icons_icon_and_name_box_icon_width ); ?> gap-5px"
                                >
                                    <span class="social_media_share_icons_icon_and_name_box_icon productiveminds-alignable-container width-autoed">
                                        <?php echo wp_kses( productiveminds_get_svg_icon( $productive_global_share_icons_args_linkedin ), 'wp_kses_allowed_html' ); ?>
                                    </span>
                                    <?php if( $section_show_social_media_platform_name ) { ?>
                                        <span class="social_media_share_icons_icon_and_name_box_text productiveminds-alignable-container width-autoed">
                                            <?php echo esc_html__( 'Linkedin', 'productive-ecommerce' ); ?>
                                        </span>
                                    <?php } ?>
                                </a>
                            <?php } ?>
                            
                            <?php if( $is_sharing_by_facebook ) { ?>
                                <a target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url( $section_content_social_media_share_url ); ?>"
                                   class="social_media_share_icons_icon_and_name_box facebook-share-button productiveminds-alignable-container flexed flexed-no-wrap align-items-center align-content-center <?php echo esc_attr( $social_media_share_icons_icon_and_name_box_icon_width ); ?> gap-5px"
                                >
                                    <span class="social_media_share_icons_icon_and_name_box_icon productiveminds-alignable-container width-autoed">
                                        <?php echo wp_kses( productiveminds_get_svg_icon( $productive_global_share_icons_args_facebook ), 'wp_kses_allowed_html' ); ?>
                                    </span>
                                    <?php if( $section_show_social_media_platform_name ) { ?>
                                        <span class="social_media_share_icons_icon_and_name_box_text productiveminds-alignable-container width-autoed">
                                            <?php echo esc_html__( 'Facebook', 'productive-ecommerce' ); ?>
                                        </span>
                                    <?php } ?>
                                </a>
                            <?php } ?>
                            
                            <?php if( $is_sharing_by_twitter ) { ?>
                                <a target="_blank" href="https://x.com/intent/tweet?text=<?php echo esc_url( $section_content_social_media_share_url ); ?>" data-show-count="false"
                                   class="social_media_share_icons_icon_and_name_box twitter-x-share-button productiveminds-alignable-container flexed flexed-no-wrap align-items-center align-content-center <?php echo esc_attr( $social_media_share_icons_icon_and_name_box_icon_width ); ?> gap-5px"
                                >
                                    <span class="social_media_share_icons_icon_and_name_box_icon productiveminds-alignable-container width-autoed">
                                        <?php echo wp_kses( productiveminds_get_svg_icon( $productive_global_share_icons_args_twitter_x ), 'wp_kses_allowed_html' ); ?>
                                    </span>
                                    <?php if( $section_show_social_media_platform_name ) { ?>
                                        <span class="social_media_share_icons_icon_and_name_box_text productiveminds-alignable-container width-autoed">
                                            <?php echo esc_html__( 'X (Twitter)', 'productive-ecommerce' ); ?>
                                        </span>
                                    <?php } ?>
                                </a>
                            <?php } ?>
                            
                            <?php if( $is_sharing_by_pinterest ) { ?>
                                <a target="_blank" href="https://www.pinterest.com/pin/create/button/?url=<?php echo esc_url( $section_content_social_media_share_url ); ?>&description=<?php echo esc_attr( $section_content_social_media_share_desc_for_pinterest ); ?>&media=<?php echo esc_attr( $section_content_social_media_share_media ); ?>" data-pin-do="buttonBookmark"
                                   class="social_media_share_icons_icon_and_name_box pinterest-share-button productiveminds-alignable-container flexed flexed-no-wrap align-items-center align-content-center <?php echo esc_attr( $social_media_share_icons_icon_and_name_box_icon_width ); ?> gap-5px"
                                >
                                    <span class="social_media_share_icons_icon_and_name_box_icon productiveminds-alignable-container width-autoed">
                                        <?php echo wp_kses( productiveminds_get_svg_icon( $productive_global_share_icons_args_pinterest ), 'wp_kses_allowed_html' ); ?>
                                    </span>
                                    <?php if( $section_show_social_media_platform_name ) { ?>
                                        <span class="social_media_share_icons_icon_and_name_box_text productiveminds-alignable-container width-autoed">
                                            <?php echo esc_html__( 'Pinterest', 'productive-ecommerce' ); ?>
                                        </span>
                                    <?php } ?>
                                </a>
                            <?php } ?>
                            
                            <?php if( $is_sharing_by_instagram ) { ?>
                                <a target="_blank" href="#"
                                   class="social_media_share_icons_icon_and_name_box instagram-share-button productiveminds-alignable-container flexed flexed-no-wrap align-items-center align-content-center <?php echo esc_attr( $social_media_share_icons_icon_and_name_box_icon_width ); ?> gap-5px"
                                >
                                    <span class="social_media_share_icons_icon_and_name_box_icon productiveminds-alignable-container width-autoed">
                                        <?php echo wp_kses( productiveminds_get_svg_icon( $productive_global_share_icons_args_instagram ), 'wp_kses_allowed_html' ); ?>
                                    </span>
                                    <?php if( $section_show_social_media_platform_name ) { ?>
                                        <span class="social_media_share_icons_icon_and_name_box_text productiveminds-alignable-container width-autoed">
                                            <?php echo esc_html__( 'Instagram', 'productive-ecommerce' ); ?>
                                        </span>
                                    <?php } ?>
                                </a>
                            <?php } ?>
                            
                            <?php if( $is_sharing_by_whatsapp ) { ?>
                                <a target="_blank" href="https://api.whatsapp.com/send?text=<?php echo esc_url( $section_content_social_media_share_url ); ?>"
                                   class="social_media_share_icons_icon_and_name_box whatsapp-share-button productiveminds-alignable-container flexed flexed-no-wrap align-items-center align-content-center <?php echo esc_attr( $social_media_share_icons_icon_and_name_box_icon_width ); ?> gap-5px"
                                >
                                    <span class="social_media_share_icons_icon_and_name_box_icon productiveminds-alignable-container width-autoed">
                                        <?php echo wp_kses( productiveminds_get_svg_icon( $productive_global_share_icons_args_whatsapp ), 'wp_kses_allowed_html' ); ?>
                                    </span>
                                    <?php if( $section_show_social_media_platform_name ) { ?>
                                        <span class="social_media_share_icons_icon_and_name_box_text productiveminds-alignable-container width-autoed">
                                            <?php echo esc_html__( 'WhatsApp', 'productive-ecommerce' ); ?>
                                        </span>
                                    <?php } ?>
                                </a>
                            <?php } ?>
                            
                            <?php if( $is_sharing_by_email ) { ?>
                                <a target="_blank" href="mailto:?subject=<?php echo esc_attr( $section_content_social_media_share_email_subject ); ?>&body=<?php echo esc_url( $section_content_social_media_share_url ); ?>"
                                   class="social_media_share_icons_icon_and_name_box email-share-button productiveminds-alignable-container flexed flexed-no-wrap align-items-center align-content-center <?php echo esc_attr( $social_media_share_icons_icon_and_name_box_icon_width ); ?> gap-5px"
                                >
                                    <span class="social_media_share_icons_icon_and_name_box_icon productiveminds-alignable-container width-autoed">
                                        <?php echo wp_kses( productiveminds_get_svg_icon( $productive_global_share_icons_args_email ), 'wp_kses_allowed_html' ); ?>
                                    </span>
                                    <?php if( $section_show_social_media_platform_name ) { ?>
                                        <span class="social_media_share_icons_icon_and_name_box_text productiveminds-alignable-container width-autoed">
                                            <?php echo esc_html__( 'Email', 'productive-ecommerce' ); ?>
                                        </span>
                                    <?php } ?>
                                </a>
                            <?php } ?>
                            
                        </div>
                    </div>
                </div>
                
            </div><!-- productiveminds_section_uno -->
        </div><!-- productiveminds_section -->
    <?php
    }
}





function productive_global_do_social_shares( $misc, $share_url ) {
    $is_sharing_by_facebook = productive_global_sharing_enable_facebook();
    $is_sharing_by_twitter = productive_global_sharing_enable_twitter();
    $is_sharing_by_pinterest = productive_global_sharing_enable_pinterest();
    $is_sharing_by_whatsapp = productive_global_sharing_enable_whatsapp();
    $is_sharing_by_email = productive_global_sharing_enable_email();
    
    if( isset( $misc['is_sharing_by_facebook'] ) ) {
        $is_sharing_by_facebook = $misc['is_sharing_by_facebook'];
    }
    if( isset( $misc['is_sharing_by_twitter'] ) ) {
        $is_sharing_by_twitter = $misc['is_sharing_by_twitter'];
    }
    if( isset( $misc['is_sharing_by_pinterest'] ) ) {
        $is_sharing_by_pinterest = $misc['is_sharing_by_pinterest'];
    }
    if( isset( $misc['is_sharing_by_whatsapp'] ) ) {
        $is_sharing_by_whatsapp = $misc['is_sharing_by_whatsapp'];
    }
    if( isset( $misc['is_sharing_by_email'] ) ) {
        $is_sharing_by_email = $misc['is_sharing_by_email'];
    }
    
    if( $is_sharing_by_facebook || $is_sharing_by_twitter || $is_sharing_by_pinterest || $is_sharing_by_whatsapp || $is_sharing_by_email ) {
        
        $section_show_social_media_share_on_copy                = $misc['section_show_social_media_share_on_copy'];
        $section_show_social_media_share_on_copy_location       = $misc['section_show_social_media_share_on_copy_location'];
        $section_content_social_media_share_icon_size           = $misc['section_content_social_media_share_icon_size'];
        $section_content_social_media_share_email_subject       = $misc['section_content_social_media_share_email_subject'];
        $section_content_social_media_share_desc_for_pinterest  = $misc['section_content_social_media_share_desc_for_pinterest'];
        $section_content_social_media_share_media               = $misc['section_content_social_media_share_media'];
        
        if( null == $section_content_social_media_share_media || empty($section_content_social_media_share_media) ) {
            $section_content_social_media_share_media               = productive_global_get_site_logo_url();
        }
        
        $productive_global_share_icons_dimension = intval( $section_content_social_media_share_icon_size );
        $productive_global_share_icons_css = '';
        $productive_global_share_icons_args_facebook = array(
            'i'=> 'facebook', 
            'w'=>$productive_global_share_icons_dimension, 
            'h'=>$productive_global_share_icons_dimension, 
            'css'=> $productive_global_share_icons_css . ' facebook',
        );
        $productive_global_share_icons_args_twitter = array(
            'i'=> 'twitter', 
            'w'=>$productive_global_share_icons_dimension, 
            'h'=>$productive_global_share_icons_dimension, 
            'css'=> $productive_global_share_icons_css . ' twitter',
        );
        $productive_global_share_icons_args_twitter_x = array(
            'i'=> 'twitter-x', 
            'w'=>$productive_global_share_icons_dimension, 
            'h'=>$productive_global_share_icons_dimension, 
            'css'=> $productive_global_share_icons_css . ' twitter-x',
        );
        $productive_global_share_icons_args_pinterest = array(
            'i'=> 'pinterest', 
            'w'=>$productive_global_share_icons_dimension, 
            'h'=>$productive_global_share_icons_dimension, 
            'css'=> $productive_global_share_icons_css . ' pinterest',
        );
        $productive_global_share_icons_args_instagram = array(
            'i'=> 'instagram', 
            'w'=>$productive_global_share_icons_dimension, 
            'h'=>$productive_global_share_icons_dimension, 
            'css'=> $productive_global_share_icons_css . ' instagram',
        );
        $productive_global_share_icons_args_whatsapp = array(
            'i'=> 'whatsapp',
            'w'=>$productive_global_share_icons_dimension, 
            'h'=>$productive_global_share_icons_dimension, 
            'css'=> $productive_global_share_icons_css . ' whatsapp',
        );
        $productive_global_share_icons_args_email = array(
            'i'=> 'inbox-icon-only',
            'w'=>$productive_global_share_icons_dimension,
            'h'=>$productive_global_share_icons_dimension,
            'css'=> $productive_global_share_icons_css . ' ',
        );
        
        $show_facebook = 1;
        if( isset( $misc['show_facebook'] ) ) {
            $show_facebook = $misc['show_facebook'];
        }
        $show_twitter = 1;
        if( isset( $misc['show_twitter'] ) ) {
            $show_twitter = $misc['show_twitter'];
        }
        $is_old_twitter_icon = 0;
        if( isset( $misc['use_old_twitter_icon'] ) ) {
            $is_old_twitter_icon = $misc['use_old_twitter_icon'];
        }
        $show_pinterest = 1;
        if( isset( $misc['show_pinterest'] ) ) {
            $show_pinterest = $misc['show_pinterest'];
        }
        $show_whatsapp = 1;
        if( isset( $misc['show_whatsapp'] ) ) {
            $show_whatsapp = $misc['show_whatsapp'];
        }
        $show_email = 1;
        if( isset( $misc['show_email'] ) ) {
            $show_email = $misc['show_email'];
        }
        
        $display_contact_social_media_icons_style = productive_global_sharing_brand_color_around_white_icon();
        if( isset( $misc['display_contact_social_media_icons_style'] ) ) {
            $display_contact_social_media_icons_style = $misc['display_contact_social_media_icons_style'];
        }
        
        $section_show_social_media_share_layout = 'grided';
        if( $section_show_social_media_share_on_copy_location == 'inline' ) {
            $section_show_social_media_share_layout = 'flexed';
        }
    ?>
        <div class="productiveminds_minds_the_social_shares">
            <div class="productive_social_shares_box_container <?php echo esc_attr( $display_contact_social_media_icons_style ); ?>">

                <div class="productive_social_shares_box productiveminds-alignable-container align-items-center align-content-center <?php echo esc_attr( $section_show_social_media_share_layout ); ?> <?php echo esc_attr( $section_show_social_media_share_on_copy_location ); ?>">

                    <div class="social-share-text"><?php echo esc_html( $section_show_social_media_share_on_copy ); ?></div>

                    <div class="productive_social_shares_icons_container">
                        <div class="productive_social_shares productiveminds-alignable-container flexed">

                            <?php if( $show_facebook && $is_sharing_by_facebook ) { ?>
                                <span class="productive_social_shares_icon_box">
                                    <a target="_blank" class="facebook-share-button productiveminds-alignable-container width-autoed" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url( $share_url ); ?>">
                                        <?php echo wp_kses( productiveminds_get_svg_icon( $productive_global_share_icons_args_facebook ), 'wp_kses_allowed_html' ); ?>
                                    </a>
                                </span>
                            <?php } ?>

                            <?php if( $is_old_twitter_icon && $show_twitter && $is_sharing_by_twitter ) { ?>
                                <span class="productive_social_shares_icon_box">
                                    <a target="_blank" class="twitter-share-button productiveminds-alignable-container width-autoed" href="https://twitter.com/intent/tweet?text=<?php echo esc_url( $share_url ); ?>" data-show-count="false">
                                        <?php echo wp_kses( productiveminds_get_svg_icon( $productive_global_share_icons_args_twitter ), 'wp_kses_allowed_html' ); ?>
                                    </a>
                                </span>
                            <?php } ?>

                            <?php if( !$is_old_twitter_icon && $show_twitter && $is_sharing_by_twitter ) { ?>
                                <span class="productive_social_shares_icon_box">
                                    <a target="_blank" class="twitter-x-share-button productiveminds-alignable-container width-autoed" href="https://x.com/intent/tweet?text=<?php echo esc_url( $share_url ); ?>" data-show-count="false">
                                        <?php echo wp_kses( productiveminds_get_svg_icon( $productive_global_share_icons_args_twitter_x ), 'wp_kses_allowed_html' ); ?>
                                    </a>
                                </span>
                            <?php } ?>

                            <?php if( $show_pinterest && $is_sharing_by_pinterest ) { ?>
                                <span class="productive_social_shares_icon_box">
                                    <a target="_blank" class="pinterest-share-button productiveminds-alignable-container width-autoed" href="https://www.pinterest.com/pin/create/button/?url=<?php echo esc_url( $share_url ); ?>&description=<?php echo esc_attr( $section_content_social_media_share_desc_for_pinterest ); ?>&media=<?php echo esc_attr( $section_content_social_media_share_media ); ?>" data-pin-do="buttonBookmark">
                                        <?php echo wp_kses( productiveminds_get_svg_icon( $productive_global_share_icons_args_pinterest ), 'wp_kses_allowed_html' ); ?>
                                    </a>
                                </span>
                            <?php } ?>

                            <?php if( $show_whatsapp && $is_sharing_by_whatsapp ) { ?>
                                <span class="productive_social_shares_icon_box">
                                    <a target="_blank" class="whatsapp-share-button productiveminds-alignable-container width-autoed" href="https://api.whatsapp.com/send?text=<?php echo esc_url( $share_url ); ?>">
                                        <?php echo wp_kses( productiveminds_get_svg_icon( $productive_global_share_icons_args_whatsapp ), 'wp_kses_allowed_html' ); ?>
                                    </a>
                                </span>
                            <?php } ?>

                            <?php if( $show_email && $is_sharing_by_email ) { ?>
                                <span class="productive_social_shares_icon_box">
                                    <a target="_blank" class="email-share-button productiveminds-alignable-container width-autoed" href="mailto:?subject=<?php echo esc_attr( $section_content_social_media_share_email_subject ); ?>&body=<?php echo esc_url( $share_url ); ?>">
                                        <?php echo wp_kses( productiveminds_get_svg_icon( $productive_global_share_icons_args_email ), 'wp_kses_allowed_html' ); ?>
                                    </a>
                                </span>
                            <?php } ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php
    }
}
add_action( 'productive_global_do_render_the_social_shares', 'productive_global_do_social_shares' );
