<?php
/**
 * Theme Customiser
 *
 * @package     productive-ecommerce
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 * 
 */

if ( ! defined( 'ABSPATH' ) ) {
    die();
}


if ( ! class_exists( 'Productive_Theme_Customiser_Global_Popup' ) ) {
    
    /**
     * Productive_Theme_Customiser_Global_Popup
     * Theme Customiser Class
     */
    class Productive_Theme_Customiser_Global_Popup extends Productive_Theme_Customiser_Common {
        
        /**
         * Register the customizer
         *
         * @param WP_Customize_Manager $wp_customise param.
         */
        public static function register( $wp_customise ) {
            
            // See common for Panels
            // 
            // Section
            $wp_customise->add_section(
                'productive_ecommerce_theme_global_popup',
                array(
                    'title' => esc_html__( 'Header Popup Options', 'productive-ecommerce' ),
                    'description' => esc_html__( 'Header Popup Options', 'productive-ecommerce' ),
                    'panel' => 'productive_ecommerce_theme_options',
                    'priority' => 20,
                    'capability' => 'edit_theme_options',
                )
                );
            
            // add a setting for productive_ecommerce_enable_global_popup_search control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_enable_global_popup_search',
                array(
                    'type' => 'theme_mod',
                    'default' => true,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_checkbox'),
                )
                );
            // add control..
            $wp_customise->add_control(
                'productive_ecommerce_enable_global_popup_search',
                array(
                    'type' => 'checkbox',
                    'priority' => 60,
                    'section' => 'productive_ecommerce_theme_global_popup',
                    'label' => esc_html__( 'Display Search Box?', 'productive-ecommerce' ),
                    'description' => '',
                    // 'active_callback' => 'is_front_page',
                )
                );
            
            // add a setting for productive_ecommerce_enable_global_popup_account control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_enable_global_popup_account',
                array(
                    'type' => 'theme_mod',
                    'default' => true,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_checkbox'),
                )
                );
            // add control..
            $wp_customise->add_control(
                'productive_ecommerce_enable_global_popup_account',
                array(
                    'type' => 'checkbox',
                    'priority' => 70,
                    'section' => 'productive_ecommerce_theme_global_popup',
                    'label' => esc_html__( 'Display My Account Icon?', 'productive-ecommerce' ),
                    'description' => '',
                    // 'active_callback' => 'is_front_page',
                )
                );

            // add a setting for productive_ecommerce_enable_global_popup_cart control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_enable_global_popup_cart',
                array(
                    'type' => 'theme_mod',
                    'default' => true,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_checkbox'),
                )
            );
            // add control..
            $wp_customise->add_control(
                'productive_ecommerce_enable_global_popup_cart',
                array(
                    'type' => 'checkbox',
                    'priority' => 80,
                    'section' => 'productive_ecommerce_theme_global_popup',
                    'label' => esc_html__( 'Display Mini-Cart Icon?', 'productive-ecommerce' ),
                    'description' => esc_html__( 'Display Cart icon in the header', 'productive-ecommerce' ),
                    // 'active_callback' => 'is_front_page',
                )
                );

                // add a setting for productive_ecommerce_enable_global_popup_wishlist control, below.
            $wp_customise->add_setting(
                    'productive_ecommerce_enable_global_popup_wishlist',
                    array(
                        'type' => 'theme_mod',
                        'default' => true,
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_checkbox'),
                    )
            );
            // add control..
            $wp_customise->add_control(
                    'productive_ecommerce_enable_global_popup_wishlist',
                    array(
                        'type' => 'checkbox',
                        'priority' => 90,
                        'section' => 'productive_ecommerce_theme_global_popup',
                        'label' => esc_html__('Display Wishlist Icon?', 'productive-ecommerce'),
                        'description' => esc_html__('Display Wishlist icon in the header', 'productive-ecommerce'),
                    // 'active_callback' => 'is_front_page',
                    )
            );

            // add a setting for productive_ecommerce_enable_global_popup_compare control, below.
            $wp_customise->add_setting(
                    'productive_ecommerce_enable_global_popup_compare',
                    array(
                        'type' => 'theme_mod',
                        'default' => true,
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_checkbox'),
                    )
            );
            // add control..
            $wp_customise->add_control(
                    'productive_ecommerce_enable_global_popup_compare',
                    array(
                        'type' => 'checkbox',
                        'priority' => 100,
                        'section' => 'productive_ecommerce_theme_global_popup',
                        'label' => esc_html__('Display Compare Icon?', 'productive-ecommerce'),
                        'description' => esc_html__('Display product compare icon in the header', 'productive-ecommerce'),
                    // 'active_callback' => 'is_front_page',
                    )
            );

            if ( function_exists( 'productiveminds_theme_extra_is_active' ) || productive_ecommerce_power_button_required() ) {
                $wp_customise->add_setting(
                        'productive_ecommerce_enable_global_popup_power_button',
                        array(
                            'type' => 'theme_mod',
                            'default' => true,
                            'theme_supports' => '',
                            'transport' => 'refresh',
                            'capability' => 'edit_theme_options',
                            'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_checkbox'),
                        )
                );
                // add control..
                $wp_customise->add_control(
                        'productive_ecommerce_enable_global_popup_power_button',
                        array(
                            'type' => 'checkbox',
                            'priority' => 110,
                            'section' => 'productive_ecommerce_theme_global_popup',
                            'label' => esc_html__('Display Power Button?', 'productive-ecommerce'),
                            'description' => esc_html__('Note, this option is only effective, if power button is part of the current header design.', 'productive-ecommerce'),
                        // 'active_callback' => 'is_front_page',
                        )
                );
            }
            
            // add a setting for productive_ecommerce_enable_global_popup_fullscreen control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_enable_global_popup_fullscreen',
                array(
                    'type' => 'theme_mod',
                    'default' => 'default_height',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_enable_global_popup_fullscreen',
                array(
                    'type' => 'select',
                    'priority' => 200,
                    'section' => 'productive_ecommerce_theme_global_popup',
                    'label' => esc_html__( 'Popup Height', 'productive-ecommerce' ),
                    'description' => esc_html__( 'Select the preferred height of the popup.', 'productive-ecommerce' ),
                    'choices' => array(
                        'default_height' => esc_html__( 'Default Height', 'productive-ecommerce' ),
                        'fullscreen_height' => esc_html__( 'Fullscreen Height', 'productive-ecommerce' ),
                    ),
                )
            );
            
        }
        
        
    } // End of class.
    
    // add hook for the class.
    add_action( 'customize_register', array( 'Productive_Theme_Customiser_Global_Popup', 'register' ) );
    
} // End of if class exists



/**
 * Method productive_ecommerce_global_popup_style.
 *
 * @param string $class ''.
 */
function productive_ecommerce_global_popup_style( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_global_popup_style', PRODUCTIVE_ECOMMERCE_CURRENT_THEME_TEXT_DOMAIN );
}

/**
 * Method productive_ecommerce_global_popup_colour_mode.
 *
 * @param string $class ''.
 */
function productive_ecommerce_global_popup_colour_mode( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_global_popup_colour_mode', 'global_popup_colour_mode_dark' );
}

/**
 * Method productive_ecommerce_enable_global_popup_search.
 *
 * @param string $class ''.
 */
function productive_ecommerce_enable_global_popup_search( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_enable_global_popup_search', true );
}
add_action( 'display_productive_ecommerce_enable_global_popup_search', 'productive_ecommerce_enable_global_popup_search' );

/**
 * Method productive_ecommerce_enable_global_popup_account.
 *
 * @param string $class ''.
 */
function productive_ecommerce_enable_global_popup_account( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_enable_global_popup_account', true );
}

/**
 * Method productive_ecommerce_enable_global_popup_cart.
 *
 * @param string $class ''.
 */
function productive_ecommerce_enable_global_popup_cart( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_enable_global_popup_cart', true );
}

/**
 * Method productive_ecommerce_enable_global_popup_wishlist.
 *
 * @param string $class ''.
 */
function productive_ecommerce_enable_global_popup_wishlist( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_enable_global_popup_wishlist', true );
}

/**
 * Method productive_ecommerce_enable_global_popup_compare.
 *
 * @param string $class ''.
 */
function productive_ecommerce_enable_global_popup_compare( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_enable_global_popup_compare', true );
}

/**
 * Method productive_ecommerce_enable_global_popup_power_button.
 *
 * @param string $class ''.
 */
function productive_ecommerce_enable_global_popup_power_button( $class = '' ) {
    if( productive_ecommerce_dispaly_power_button_in_global_popup() ) {
        return get_theme_mod( 'productive_ecommerce_enable_global_popup_power_button', true );
    } else {
        return false;
    }
}

/**
 * Method productive_ecommerce_enable_switch_language_global_popup.
 *
 * @param string $class ''.
 */
function productive_ecommerce_enable_switch_language_global_popup( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_enable_switch_language_global_popup', true );
}

/**
 * Method productive_ecommerce_enable_switch_currency_global_popup.
 *
 * @param string $class ''.
 */
function productive_ecommerce_enable_switch_currency_global_popup( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_enable_switch_currency_global_popup', true );
}

/**
 * Method productive_ecommerce_enable_global_popup_fullscreen.
 *
 * @param string $class ''.
 */
function productive_ecommerce_enable_global_popup_fullscreen( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_enable_global_popup_fullscreen', 'default_height' );
}