<?php
/**
 * Theme Customiser
 *
 * @package     productive-ecommerce
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 * 
 */

if ( ! defined( 'ABSPATH' ) ) {
    die();
}


if ( ! class_exists( 'Productive_Theme_Customiser_Homepage_Banner_Text_Small' ) ) {
    
    /**
     * Productive_Theme_Customiser_Homepage_Banner_Text_Small
     * Theme Customiser Class
     */
    class Productive_Theme_Customiser_Homepage_Banner_Text_Small extends Productive_Theme_Customiser_Common {
        
        /**
         * Register the customizer
         *
         * @param WP_Customize_Manager $wp_customise param.
         */
        public static function register( $wp_customise ) {
            
            // See common for Panels
            // 
            // Section
            $panel = 'productive_ecommerce_theme_homepage_options';
            $title = esc_html__( 'Banner Explainer Options', 'productive-ecommerce' );
            if ( productive_global_is_pass_addons_active() ) {
                $panel = 'pass_addons_theme_options_homepage';
                $title = esc_html__( 'Banner & Slides Explainer Options', 'productive-ecommerce' );
            } else if ( productive_ecommerce_is_productive_style_active() ) {
                $panel = 'productive_style_theme_options_homepage';
                $title = esc_html__( 'Banner & Slides Explainer Options', 'productive-ecommerce' );
            }
            $wp_customise->add_section(
                'productive_ecommerce_homepage_options_text_small',
                array(
                    'title' => $title,
                    'description' => esc_html__( 'Customize the explainer copy on home banner and slides.', 'productive-ecommerce' ),
                    'panel' => $panel,
                    'priority' => 50,
                    'capability' => 'edit_theme_options',
                )
                );
            
            // add a setting for productive_ecommerce_homepage_usp_textarea_2_color control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_usp_textarea_2_color',
                array(
                    'type' => 'theme_mod',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'default'              => '#000000',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_color'),
                )
                );
            
            $wp_customise->add_control(
                new WP_Customize_Color_Control(
                    $wp_customise,
                    'productive_ecommerce_homepage_usp_textarea_2_color',
                    array(
                        'priority' => 60,
                        'label' => esc_html__( 'Color', 'productive-ecommerce' ),
                        'section' => 'productive_ecommerce_homepage_options_text_small',
                    )
                    )
                );
            
            
            if ( productive_global_is_pass_addons_active() ) {
                // add a setting for productive_ecommerce_banner_text_small_font_family control, below.
                $wp_customise->add_setting(
                    'productive_ecommerce_banner_text_small_font_family',
                    array(
                        'type' => 'theme_mod',
                        'default' => '',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                    )
                );

                // add control...
                $wp_customise->add_control(
                    'productive_ecommerce_banner_text_small_font_family',
                    array(
                        'type' => 'select',
                        'priority' => 70,
                        'section' => 'productive_ecommerce_homepage_options_text_small',
                        'label' => esc_html__( 'Font Family', 'productive-ecommerce' ),
                        'description' => '',
                        'choices' => pass_addons_customiser_get_font_families(),
                    )
                );

                // add a setting for productive_ecommerce_banner_text_small_font_style control, below.
                $wp_customise->add_setting(
                    'productive_ecommerce_banner_text_small_font_style',
                    array(
                        'type' => 'theme_mod',
                        'default' => '',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                    )
                );

                // add control...
                $wp_customise->add_control(
                    'productive_ecommerce_banner_text_small_font_style',
                    array(
                        'type' => 'select',
                        'priority' => 80,
                        'section' => 'productive_ecommerce_homepage_options_text_small',
                        'label' => esc_html__( 'Font Style', 'productive-ecommerce' ),
                        'description' => '',
                        'choices' => pass_addons_customiser_get_font_styles()
                    )
                );

                // add a setting for productive_ecommerce_banner_text_small_font_size control, below.
                $wp_customise->add_setting(
                    'productive_ecommerce_banner_text_small_font_size',
                    array(
                        'type' => 'theme_mod',
                        'default' => '',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_float'),
                    )
                );
                $wp_customise->add_control(
                    'productive_ecommerce_banner_text_small_font_size', 
                    array(
                        'type' => 'number',
                        'priority' => 90,
                        'section' => 'productive_ecommerce_homepage_options_text_small',
                        'label' => esc_html__( 'Font Size (rem)', 'productive-ecommerce' ),
                        'description' => esc_html__( 'This size is scaled relatively across the various elements of the website.', 'productive-ecommerce' ),
                        'input_attrs' => array(
                            'min' => 1.2,
                            'max' => PASS_ADDONS_FONT_SIZE_MAX,
                            'step' => PASS_ADDONS_FONT_SIZE_STEP,
                        ),
                    )
                );

                // add a setting for productive_ecommerce_banner_text_small_font_weight control, below.
                $wp_customise->add_setting(
                    'productive_ecommerce_banner_text_small_font_weight',
                    array(
                        'type' => 'theme_mod',
                        'default' => '',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                    )
                );

                // add control...
                $wp_customise->add_control(
                    'productive_ecommerce_banner_text_small_font_weight',
                    array(
                        'type' => 'select',
                        'priority' => 100,
                        'section' => 'productive_ecommerce_homepage_options_text_small',
                        'label' => esc_html__( 'Font Weight', 'productive-ecommerce' ),
                        'description' => '',
                        'choices' => pass_addons_customiser_get_font_weights(),
                    )
                );

                // add a setting for productive_ecommerce_banner_text_small_line_height control, below.
                $wp_customise->add_setting(
                    'productive_ecommerce_banner_text_small_line_height',
                    array(
                        'type' => 'theme_mod',
                        'default' => '',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_float'),
                    )
                );

                // add control...
                $wp_customise->add_control(
                    'productive_ecommerce_banner_text_small_line_height',
                    array(
                        'type' => 'number',
                        'priority' => 110,
                        'section' => 'productive_ecommerce_homepage_options_text_small',
                        'label' => esc_html__( 'Line Height', 'productive-ecommerce' ),
                        'description' => '',
                        'input_attrs' => array(
                            'min' => PASS_ADDONS_LINE_HEIGHT_SIZE_MIN,
                            'max' => PASS_ADDONS_LINE_HEIGHT_SIZE_MAX,
                            'step' => PASS_ADDONS_LINE_HEIGHT_SIZE_STEP,
                        ),
                    )
                );

                // add a setting for productive_ecommerce_banner_text_small_text_transform control, below.
                $wp_customise->add_setting(
                    'productive_ecommerce_banner_text_small_text_transform',
                    array(
                        'type' => 'theme_mod',
                        'default' => '',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                    )
                );

                // add control...
                $wp_customise->add_control(
                    'productive_ecommerce_banner_text_small_text_transform',
                    array(
                        'type' => 'select',
                        'priority' => 120,
                        'section' => 'productive_ecommerce_homepage_options_text_small',
                        'label' => esc_html__( 'Text Transformation', 'productive-ecommerce' ),
                        'description' => '',
                        'choices' => pass_addons_customiser_get_font_transforms()
                    )
                );

                // add a setting for productive_ecommerce_banner_text_small_text_decoration control, below.
                $wp_customise->add_setting(
                    'productive_ecommerce_banner_text_small_text_decoration',
                    array(
                        'type' => 'theme_mod',
                        'default' => '',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                    )
                );

                // add control...
                $wp_customise->add_control(
                    'productive_ecommerce_banner_text_small_text_decoration',
                    array(
                        'type' => 'select',
                        'priority' => 130,
                        'section' => 'productive_ecommerce_homepage_options_text_small',
                        'label' => esc_html__( 'Text Decoration', 'productive-ecommerce' ),
                        'description' => '',
                        'choices' => pass_addons_customiser_get_font_decorations()
                    )
                );
            } else if ( productive_ecommerce_is_productive_style_active() ) {
                // add a setting for productive_ecommerce_banner_text_small_font_family control, below.
                $wp_customise->add_setting(
                    'productive_ecommerce_banner_text_small_font_family',
                    array(
                        'type' => 'theme_mod',
                        'default' => '',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                    )
                );

                // add control...
                $wp_customise->add_control(
                    'productive_ecommerce_banner_text_small_font_family',
                    array(
                        'type' => 'select',
                        'priority' => 70,
                        'section' => 'productive_ecommerce_homepage_options_text_small',
                        'label' => esc_html__( 'Font Family', 'productive-ecommerce' ),
                        'description' => '',
                        'choices' => productive_style_customiser_get_font_families(),
                    )
                );

                // add a setting for productive_ecommerce_banner_text_small_font_style control, below.
                $wp_customise->add_setting(
                    'productive_ecommerce_banner_text_small_font_style',
                    array(
                        'type' => 'theme_mod',
                        'default' => '',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                    )
                );

                // add control...
                $wp_customise->add_control(
                    'productive_ecommerce_banner_text_small_font_style',
                    array(
                        'type' => 'select',
                        'priority' => 80,
                        'section' => 'productive_ecommerce_homepage_options_text_small',
                        'label' => esc_html__( 'Font Style', 'productive-ecommerce' ),
                        'description' => '',
                        'choices' => productive_style_customiser_get_font_styles()
                    )
                );

                // add a setting for productive_ecommerce_banner_text_small_font_size control, below.
                $wp_customise->add_setting(
                    'productive_ecommerce_banner_text_small_font_size',
                    array(
                        'type' => 'theme_mod',
                        'default' => '',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_float'),
                    )
                );
                $wp_customise->add_control(
                    'productive_ecommerce_banner_text_small_font_size', 
                    array(
                        'type' => 'number',
                        'priority' => 90,
                        'section' => 'productive_ecommerce_homepage_options_text_small',
                        'label' => esc_html__( 'Font Size (rem)', 'productive-ecommerce' ),
                        'description' => esc_html__( 'This size is scaled relatively across the various elements of the website.', 'productive-ecommerce' ),
                        'input_attrs' => array(
                            'min' => 1.2,
                            'max' => PRODUCTIVE_STYLE_FONT_SIZE_MAX,
                            'step' => PRODUCTIVE_STYLE_FONT_SIZE_STEP,
                        ),
                    )
                );

                // add a setting for productive_ecommerce_banner_text_small_font_weight control, below.
                $wp_customise->add_setting(
                    'productive_ecommerce_banner_text_small_font_weight',
                    array(
                        'type' => 'theme_mod',
                        'default' => '',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                    )
                );

                // add control...
                $wp_customise->add_control(
                    'productive_ecommerce_banner_text_small_font_weight',
                    array(
                        'type' => 'select',
                        'priority' => 100,
                        'section' => 'productive_ecommerce_homepage_options_text_small',
                        'label' => esc_html__( 'Font Weight', 'productive-ecommerce' ),
                        'description' => '',
                        'choices' => productive_style_customiser_get_font_weights(),
                    )
                );

                // add a setting for productive_ecommerce_banner_text_small_line_height control, below.
                $wp_customise->add_setting(
                    'productive_ecommerce_banner_text_small_line_height',
                    array(
                        'type' => 'theme_mod',
                        'default' => '',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_float'),
                    )
                );

                // add control...
                $wp_customise->add_control(
                    'productive_ecommerce_banner_text_small_line_height',
                    array(
                        'type' => 'number',
                        'priority' => 110,
                        'section' => 'productive_ecommerce_homepage_options_text_small',
                        'label' => esc_html__( 'Line Height', 'productive-ecommerce' ),
                        'description' => '',
                        'input_attrs' => array(
                            'min' => PRODUCTIVE_STYLE_LINE_HEIGHT_SIZE_MIN,
                            'max' => PRODUCTIVE_STYLE_LINE_HEIGHT_SIZE_MAX,
                            'step' => PRODUCTIVE_STYLE_LINE_HEIGHT_SIZE_STEP,
                        ),
                    )
                );

                // add a setting for productive_ecommerce_banner_text_small_text_transform control, below.
                $wp_customise->add_setting(
                    'productive_ecommerce_banner_text_small_text_transform',
                    array(
                        'type' => 'theme_mod',
                        'default' => '',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                    )
                );

                // add control...
                $wp_customise->add_control(
                    'productive_ecommerce_banner_text_small_text_transform',
                    array(
                        'type' => 'select',
                        'priority' => 120,
                        'section' => 'productive_ecommerce_homepage_options_text_small',
                        'label' => esc_html__( 'Text Transformation', 'productive-ecommerce' ),
                        'description' => '',
                        'choices' => productive_style_customiser_get_font_transforms()
                    )
                );

                // add a setting for productive_ecommerce_banner_text_small_text_decoration control, below.
                $wp_customise->add_setting(
                    'productive_ecommerce_banner_text_small_text_decoration',
                    array(
                        'type' => 'theme_mod',
                        'default' => '',
                        'theme_supports' => '',
                        'transport' => 'refresh',
                        'capability' => 'edit_theme_options',
                        'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                    )
                );

                // add control...
                $wp_customise->add_control(
                    'productive_ecommerce_banner_text_small_text_decoration',
                    array(
                        'type' => 'select',
                        'priority' => 130,
                        'section' => 'productive_ecommerce_homepage_options_text_small',
                        'label' => esc_html__( 'Text Decoration', 'productive-ecommerce' ),
                        'description' => '',
                        'choices' => productive_style_customiser_get_font_decorations()
                    )
                );
            }
            
        }
        
    } // End of class.
    
    // add hook for the class.
    add_action( 'customize_register', array( 'Productive_Theme_Customiser_Homepage_Banner_Text_Small', 'register' ) );
    
} // End of if class exists


// START ============== Productive_Theme_Customiser_Homepage_Banner CUSTOMISERS
/**
 * Method productive_ecommerce_homepage_usp_textarea_2_color.
 *
 * @param string $class ''.
 */
function productive_ecommerce_homepage_usp_textarea_2_color( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_homepage_usp_textarea_2_color', '#000000' );
}

/**
 * Method productive_ecommerce_banner_text_small_font_family.
 *
 * @param string $class ''.
 */
function productive_ecommerce_banner_text_small_font_family( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_banner_text_small_font_family', '' );
}

/**
 * Method productive_ecommerce_banner_text_small_font_style.
 *
 * @param string $class ''.
 */
function productive_ecommerce_banner_text_small_font_style( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_banner_text_small_font_style', '' );
}

/**
 * Method productive_ecommerce_banner_text_small_font_size.
 *
 * @param string $class ''.
 */
function productive_ecommerce_banner_text_small_font_size( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_banner_text_small_font_size', '' );
}

/**
 * Method productive_ecommerce_banner_text_small_font_weight.
 *
 * @param string $class ''.
 */
function productive_ecommerce_banner_text_small_font_weight( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_banner_text_small_font_weight', '' );
}

/**
 * Method productive_ecommerce_banner_text_small_line_height.
 *
 * @param string $class ''.
 */
function productive_ecommerce_banner_text_small_line_height( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_banner_text_small_line_height', '' );
}

/**
 * Method productive_ecommerce_banner_text_small_text_transform.
 *
 * @param string $class ''.
 */
function productive_ecommerce_banner_text_small_text_transform( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_banner_text_small_text_transform', '' );
}

/**
 * Method productive_ecommerce_banner_text_small_text_decoration.
 *
 * @param string $class ''.
 */
function productive_ecommerce_banner_text_small_text_decoration( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_banner_text_small_text_decoration', '' );
}
