<?php
/**
 * Theme Customiser
 *
 * @package     productive-ecommerce
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 * 
 */

if ( ! defined( 'ABSPATH' ) ) {
    die();
}

if ( ! class_exists( 'Productive_Theme_Customiser_Homepage_Blog_Latest' ) ) {
    
    /**
     * Productive_Theme_Customiser_Homepage_Blog_Latest
     * Theme Customiser Class
     */
    class Productive_Theme_Customiser_Homepage_Blog_Latest extends Productive_Theme_Customiser_Common {
        
        /**
         * Register the customizer
         *
         * @param WP_Customize_Manager $wp_customise param.
         */
        public static function register( $wp_customise ) {
            
            // See common for Panels
            // 
            
            // Section
            $panel = 'productive_ecommerce_theme_homepage_options';
            if ( productive_global_is_pass_addons_active() ) {
                $panel = 'pass_addons_theme_options_homepage';
            } else if ( productive_ecommerce_is_productive_style_active() || productive_ecommerce_is_productive_style_extra_active() ) {
                $panel = 'productive_style_theme_options_homepage';
            }
            $wp_customise->add_section(
                'productive_ecommerce_homepage_blog_latest_options',
                array(
                    'title' => esc_html__( 'Latest Blog Posts', 'productive-ecommerce' ),
                    'description' => esc_html__( 'Homepage Newest Blog Posts', 'productive-ecommerce' ),
                    'panel' => $panel,
                    'priority' => 130,
                    'capability' => 'edit_theme_options',
                )
                );
            
            // add a setting for productive_ecommerce_homepage_blog_latest_enable control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_blog_latest_enable',
                array(
                    'type' => 'theme_mod',
                    'default' => true,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_checkbox'),
                )
                );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_blog_latest_enable',
                array(
                    'type' => 'checkbox',
                    'priority' => 10,
                    'section' => 'productive_ecommerce_homepage_blog_latest_options',
                    'label' => esc_html__( 'Enable Latest Blog Posts Section?', 'productive-ecommerce' ),
                    'description' => esc_html__( 'Display latest products section in the Homepage', 'productive-ecommerce' ),
                    // 'active_callback' => 'is_front_page',
                )
                );
            
            // add a setting for productive_ecommerce_homepage_blog_latest_section_title control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_blog_latest_section_title',
                array(
                    'type' => 'theme_mod',
                    'default' => esc_html__( 'Recent Articles', 'productive-ecommerce' ),
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_no_html'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_blog_latest_section_title',
                array(
                    'type' => 'text',
                    'priority' => 20,
                    'section' => 'productive_ecommerce_homepage_blog_latest_options',
                    'label' => esc_html__( 'Section Title', 'productive-ecommerce' ),
                    'description' => esc_html__( 'Section Title (e.g Recent Articles)', 'productive-ecommerce' ),
                )
            );
        }
        
        
    } // End of class.
    add_action( 'customize_register', array( 'Productive_Theme_Customiser_Homepage_Blog_Latest', 'register' ) );
    
    
    /**
     * Method productive_ecommerce_homepage_blog_latest_enable.
     *
     * @param string $class ''.
     */
    function productive_ecommerce_homepage_blog_latest_enable( $class = '' ) {
        return get_theme_mod( 'productive_ecommerce_homepage_blog_latest_enable', true);
    }

    /**
     * Method productive_ecommerce_homepage_blog_latest_section_title.
     *
     * @param string $class ''.
     */
    function productive_ecommerce_homepage_blog_latest_section_title( $class = '' ) {
        return get_theme_mod( 'productive_ecommerce_homepage_blog_latest_section_title', esc_html__( 'Recent Articles', 'productive-ecommerce' ) );
    }

    
} // End of if class exists
