<?php
/**
 * Theme Customiser
 *
 * @package     productive-ecommerce
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 * 
 */

if ( ! defined( 'ABSPATH' ) ) {
    die();
}

if ( ! class_exists( 'Productive_Theme_Customiser_Homepage_Products_Featured' ) ) {
    
    /**
     * Productive_Theme_Customiser_Homepage_Products_Featured
     * Theme Customiser Class
     */
    class Productive_Theme_Customiser_Homepage_Products_Featured extends Productive_Theme_Customiser_Common {
        
        /**
         * Register the customizer
         *
         * @param WP_Customize_Manager $wp_customise param.
         */
        public static function register( $wp_customise ) {
            
            // See common for Panels
            // 
            
            // Section
            $panel = 'productive_ecommerce_theme_homepage_options';
            if ( productive_global_is_pass_addons_active() ) {
                $panel = 'pass_addons_theme_options_homepage';
            } else if ( productive_ecommerce_is_productive_style_active() || productive_ecommerce_is_productive_style_extra_active() ) {
                $panel = 'productive_style_theme_options_homepage';
            }
            $wp_customise->add_section(
                'productive_ecommerce_homepage_products_featured_options',
                array(
                    'title' => esc_html__( 'Featured Products', 'productive-ecommerce' ),
                    'description' => esc_html__( 'Home Featured Products Section', 'productive-ecommerce' ),
                    'panel' => $panel,
                    'priority' => 130,
                    'capability' => 'edit_theme_options',
                )
                );
            
            // add a setting for productive_ecommerce_homepage_products_featured_enable control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_products_featured_enable',
                array(
                    'type' => 'theme_mod',
                    'default' => true,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_checkbox'),
                )
                );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_products_featured_enable',
                array(
                    'type' => 'checkbox',
                    'priority' => 10,
                    'section' => 'productive_ecommerce_homepage_products_featured_options',
                    'label' => esc_html__( 'Enable Featured Products Section?', 'productive-ecommerce' ),
                    'description' => '',
                    // 'active_callback' => 'is_front_page',
                )
            );
            
            // add a setting for productive_ecommerce_homepage_products_featured_section_title control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_products_featured_section_title',
                array(
                    'type' => 'theme_mod',
                    'default' => esc_html__( 'Featured Products', 'productive-ecommerce' ),
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_no_html'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_products_featured_section_title',
                array(
                    'type' => 'text',
                    'priority' => 20,
                    'section' => 'productive_ecommerce_homepage_products_featured_options',
                    'label' => esc_html__( 'Section Title', 'productive-ecommerce' ),
                    'description' => '',
                )
            );
            
            
            // add a setting for productive_ecommerce_homepage_products_featured_section_go_to_shop_copy control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_products_featured_section_go_to_shop_copy',
                array(
                    'type' => 'theme_mod',
                    'default' => esc_html__( 'Shop', 'productive-ecommerce' ),
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_no_html'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_products_featured_section_go_to_shop_copy',
                array(
                    'type' => 'text',
                    'priority' => 30,
                    'section' => 'productive_ecommerce_homepage_products_featured_options',
                    'label' => esc_html__( '"Go to Shop" link Copy', 'productive-ecommerce' ),
                    'description' => esc_html__( 'Leave empty to hide', 'productive-ecommerce' ),
                )
            );
            
            // add a setting for productive_ecommerce_homepage_products_featured_num_cols control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_products_featured_num_cols',
                array(
                    'type' => 'theme_mod',
                    'default' => 3,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_absint'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_products_featured_num_cols',
                array(
                    'type' => 'number',
                    'priority' => 40,
                    'section' => 'productive_ecommerce_homepage_products_featured_options',
                    'label' => esc_html__( 'Number of columns per row', 'productive-ecommerce' ),
                    'description' => esc_html__( 'The number of products to show in a row.', 'productive-ecommerce' ),
                    'input_attrs' => array(
                        'min' => 2,
                        'max' => 7,
                        'step' => 1,
                    ),
                )
            );
            
            // add a setting for productive_ecommerce_homepage_products_featured_num_rows control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_products_featured_num_rows',
                array(
                    'type' => 'theme_mod',
                    'default' => 1,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_absint'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_products_featured_num_rows',
                array(
                    'type' => 'number',
                    'priority' => 50,
                    'section' => 'productive_ecommerce_homepage_products_featured_options',
                    'label' => esc_html__( 'Number of rows', 'productive-ecommerce' ),
                    'description' => '',
                    'input_attrs' => array(
                        'min' => 1,
                        'max' => 2,
                        'step' => 1,
                    ),
                )
            );
            
            // add a setting for productive_ecommerce_homepage_products_featured_design control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_products_featured_design',
                array(
                    'type' => 'theme_mod',
                    'default' => 'design_02',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_products_featured_design',
                array(
                    'type' => 'select',
                    'priority' => 60,
                    'section' => 'productive_ecommerce_homepage_products_featured_options',
                    'label' => esc_html__( 'Section Layout and Design', 'productive-ecommerce' ),
                    'description' => '',
                    'choices' => array (
                        'design_standard' => esc_html__( 'Standard', 'productive-ecommerce' ),
                        'design_01' => esc_html__( 'Design 01', 'productive-ecommerce' ),
                        'design_02' => esc_html__( 'Design 02', 'productive-ecommerce' ),
                    )
                )
            );
            
            // add a setting for productive_ecommerce_homepage_products_featured_section_blocks_ratio control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_products_featured_section_blocks_ratio',
                array(
                    'type' => 'theme_mod',
                    'default' => 'column_70_30',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_products_featured_section_blocks_ratio',
                array(
                    'type' => 'select',
                    'priority' => 60,
                    'section' => 'productive_ecommerce_homepage_products_featured_options',
                    'label' => esc_html__( 'Blocks Ratio', 'productive-ecommerce' ),
                    'description' => '',
                    'choices' => productive_global_get_grid_section_blocks_ratios(),
                )
            );
            
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_products_featured_section_cta_style',
                array(
                    'type' => 'theme_mod',
                    'default' => 'cta1',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_products_featured_section_cta_style',
                array(
                    'type' => 'select',
                    'priority' => 70,
                    'section' => 'productive_ecommerce_homepage_products_featured_options',
                    'label' => esc_html__( 'Hero CTA Style', 'productive-ecommerce' ),
                    'description' => '',
                    'choices' => array (
                        'cta1' => esc_html__( 'Type 01', 'productive-ecommerce' ),
                        'cta2' => esc_html__( 'Type 02', 'productive-ecommerce' ),
                    )
                )
            );
            
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_products_featured_section_hero_color_scheme',
                array(
                    'type' => 'theme_mod',
                    'default' => 'dark_color_scheme',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_products_featured_section_hero_color_scheme',
                array(
                    'type' => 'select',
                    'priority' => 80,
                    'section' => 'productive_ecommerce_homepage_products_featured_options',
                    'label' => esc_html__( 'Hero Content Color Scheme', 'productive-ecommerce' ),
                    'description' => '',
                    'choices' => productive_global_get_colour_schemes_for_contents(),
                )
            );
            
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_products_featured_alignment_v',
                array(
                    'type' => 'theme_mod',
                    'default' => 'align-content-flex-end',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_products_featured_alignment_v',
                array(
                    'type' => 'select',
                    'priority' => 90,
                    'section' => 'productive_ecommerce_homepage_products_featured_options',
                    'label' => esc_html__( 'Hero Vertical Alignment', 'productive-ecommerce' ),
                    'description' => '',
                    'choices' => productive_global_get_vertical_align_content_options(),
                )
            );
            
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_products_featured_alignment_h',
                array(
                    'type' => 'theme_mod',
                    'default' => 'justify-items-start',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_products_featured_alignment_h',
                array(
                    'type' => 'select',
                    'priority' => 100,
                    'section' => 'productive_ecommerce_homepage_products_featured_options',
                    'label' => esc_html__( 'Hero Horizontal Alignment', 'productive-ecommerce' ),
                    'description' => '',
                    'choices' => productive_global_get_horizontal_justify_items_options(),
                )
            );
            
            // add a setting for productive_ecommerce_homepage_products_featured_section_bg_color_scheme control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_products_featured_section_bg_color_scheme',
                array(
                    'type' => 'theme_mod',
                    'default' => 'section_with_themed_bg',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_products_featured_section_bg_color_scheme',
                array(
                    'type' => 'select',
                    'priority' => 110,
                    'section' => 'productive_ecommerce_homepage_products_featured_options',
                    'label' => esc_html__( 'Section Background Color Scheme', 'productive-ecommerce' ),
                    'description' => '',
                    'choices' => productive_global_get_colour_schemes_for_bg(),
                )
            );

            // add a setting for productive_ecommerce_pro_callout_1, below.
            $hero_content_list_url = 'edit.php?post_type='.PRODUCTIVE_ECOMMERCE_PLUGIN_CONTENT_ELEMENT_SLUG.'&'.PRODUCTIVE_ECOMMERCE_PLUGIN_CONTENT_ELEMENT_TAXONOMY_SLUG.'='.PRODUCTIVE_ECOMMERCE_PLUGIN_HOME_SECTION_HERO_TAXONOMY_SLUG_FEATURED;
            $productive_ecommerce_manage_heading = esc_html__( 'Manage Hero Image and Content', 'productive-ecommerce' );
            $productive_ecommerce_manage_list_url = '<a target="_blank" class="" href="'. esc_url( admin_url( $hero_content_list_url ) ) .'">' . esc_html__( 'Manage Hero Content', 'productive-ecommerce' ) . '</a> ';

            $wp_customise->add_setting(
                'productive_ecommerce_homepage_manage_featured_hero_content_list_url',
                array(
                    'type' => 'theme_mod',
                    'default' => '',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_html'),
                )
                );
            // add control..
            $wp_customise->add_control(
                'productive_ecommerce_homepage_manage_featured_hero_content_list_url',
                array(
                    'type' => 'hidden',
                    'priority' => 200,
                    'section' => 'productive_ecommerce_homepage_products_featured_options',
                    'label' => $productive_ecommerce_manage_heading,
                    'description' => $productive_ecommerce_manage_list_url,
                )
                );
        }
        
        
    } // End of class.
    add_action( 'customize_register', array( 'Productive_Theme_Customiser_Homepage_Products_Featured', 'register' ) );
    
    
    /**
     * Method productive_ecommerce_homepage_products_featured_enable.
     *
     * @param string $class ''.
     */
    function productive_ecommerce_homepage_products_featured_enable( $class = '' ) {
        return get_theme_mod( 'productive_ecommerce_homepage_products_featured_enable', true);
    }

    /**
     * Method productive_ecommerce_homepage_products_featured_section_title.
     *
     * @param string $class ''.
     */
    function productive_ecommerce_homepage_products_featured_section_title( $class = '' ) {
        return get_theme_mod( 'productive_ecommerce_homepage_products_featured_section_title', esc_html__( 'Featured Products', 'productive-ecommerce' ) );
    }

    /**
     * Method productive_ecommerce_homepage_products_featured_section_go_to_shop_copy.
     *
     * @param string $class ''.
     */
    function productive_ecommerce_homepage_products_featured_section_go_to_shop_copy( $class = '' ) {
        return get_theme_mod( 'productive_ecommerce_homepage_products_featured_section_go_to_shop_copy', esc_html__( 'Shop', 'productive-ecommerce' ) );
    }

    /**
     * Method productive_ecommerce_homepage_products_featured_num_cols.
     *
     * @param string $class ''.
     */
    function productive_ecommerce_homepage_products_featured_num_cols( $class = '' ) {
        return get_theme_mod( 'productive_ecommerce_homepage_products_featured_num_cols', 3 );
    }

    /**
     * Method productive_ecommerce_homepage_products_featured_num_rows.
     *
     * @param string $class ''.
     */
    function productive_ecommerce_homepage_products_featured_num_rows( $class = '' ) {
        return get_theme_mod( 'productive_ecommerce_homepage_products_featured_num_rows', 1 );
    }

    /**
     * Method productive_ecommerce_homepage_products_featured_design.
     *
     * @param string $class ''.
     */
    function productive_ecommerce_homepage_products_featured_design( $class = '' ) {
        return get_theme_mod( 'productive_ecommerce_homepage_products_featured_design', 'design_02' );
    }

    /**
     * Method productive_ecommerce_homepage_products_featured_section_blocks_ratio.
     *
     * @param string $class ''.
     */
    function productive_ecommerce_homepage_products_featured_section_blocks_ratio( $class = '' ) {
        return get_theme_mod( 'productive_ecommerce_homepage_products_featured_section_blocks_ratio', 'column_70_30' );
    }
    
    /**
     * Method productive_ecommerce_homepage_products_featured_section_cta_style.
     *
     * @param string $class ''.
     */
    function productive_ecommerce_homepage_products_featured_section_cta_style( $class = '' ) {
        return get_theme_mod( 'productive_ecommerce_homepage_products_featured_section_cta_style', 'cta1' );
    }
    
    /**
     * Method productive_ecommerce_homepage_products_featured_section_hero_color_scheme.
     *
     * @param string $class ''.
     */
    function productive_ecommerce_homepage_products_featured_section_hero_color_scheme( $class = '' ) {
        return get_theme_mod( 'productive_ecommerce_homepage_products_featured_section_hero_color_scheme', 'dark_color_scheme' );
    }

    /**
     * Method productive_ecommerce_homepage_products_featured_alignment_v.
     *
     * @param string $class ''.
     */
    function productive_ecommerce_homepage_products_featured_alignment_v( $class = '' ) {
        return get_theme_mod( 'productive_ecommerce_homepage_products_featured_alignment_v', 'align-content-flex-end' );
    }

    /**
     * Method productive_ecommerce_homepage_products_featured_alignment_h.
     *
     * @param string $class ''.
     */
    function productive_ecommerce_homepage_products_featured_alignment_h( $class = '' ) {
        return get_theme_mod( 'productive_ecommerce_homepage_products_featured_alignment_h', 'justify-items-start' );
    }
    
    /**
     * Method productive_ecommerce_homepage_products_featured_section_bg_color_scheme.
     *
     * @param string $class ''.
     */
    function productive_ecommerce_homepage_products_featured_section_bg_color_scheme( $class = '' ) {
        return get_theme_mod( 'productive_ecommerce_homepage_products_featured_section_bg_color_scheme', 'section_with_themed_bg' );
    }

    
} // End of if class exists
