<?php
/**
 * Theme Customiser
 *
 * @package     productive-ecommerce
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 * 
 */

if ( ! defined( 'ABSPATH' ) ) {
    die();
}


if ( ! class_exists( 'Productive_Theme_Customiser_Homepage_Slider_Options' ) ) {
    
    /**
     * Productive_Theme_Customiser_Homepage_Slider_Options
     * Theme Customiser Class
     */
    class Productive_Theme_Customiser_Homepage_Slider_Options extends Productive_Theme_Customiser_Common {
        
        /**
         * Register the customizer
         *
         * @param WP_Customize_Manager $wp_customise param.
         */
        public static function register( $wp_customise ) {
            
            // See common for Panels
            // 
            // Section
            $panel = 'productive_ecommerce_theme_homepage_options';
            if ( productive_global_is_pass_addons_active() ) {
                $panel = 'pass_addons_theme_options_homepage';
            } else if ( productive_ecommerce_is_productive_style_active() ) {
                $panel = 'productive_style_theme_options_homepage';
            }
            $wp_customise->add_section(
                'productive_ecommerce_homepage_options_slider_options',
                array(
                    'title' => esc_html__( 'Slider Options', 'productive-ecommerce' ),
                    'description' => '',
                    'panel' => $panel,
                    'priority' => 20,
                    'capability' => 'edit_theme_options',
                )
                );
            
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_slider_no_of_slides',
                array(
                    'type' => 'theme_mod',
                    'default' => 4,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_absint'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_slider_no_of_slides',
                array(
                    'type' => 'number',
                    'priority' => 10,
                    'section' => 'productive_ecommerce_homepage_options_slider_options',
                    'label' => esc_html__( 'Number of slides to display.', 'productive-ecommerce' ),
                    'description' => '',
                    'input_attrs' => array(
                        'min' => 1,
                        'max' => 10,
                        'step' => 1,
                    ),
                )
            );
            
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_slider_controls_primary_color',
                array(
                    'type' => 'theme_mod',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'default'              => '#0a47bb',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_color'),
                )
                );
            
            $wp_customise->add_control(
                new WP_Customize_Color_Control(
                    $wp_customise,
                    'productive_ecommerce_homepage_slider_controls_primary_color',
                    array(
                        'priority' => 20,
                        'label' => esc_html__( 'Controls Primary Background', 'productive-ecommerce' ),
                        'section' => 'productive_ecommerce_homepage_options_slider_options',
                    )
                    )
                );
            
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_slider_controls_secondary_color',
                array(
                    'type' => 'theme_mod',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'default'              => '#f7f7f7',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_color'),
                )
                );
            
            $wp_customise->add_control(
                new WP_Customize_Color_Control(
                    $wp_customise,
                    'productive_ecommerce_homepage_slider_controls_secondary_color',
                    array(
                        'priority' => 30,
                        'label' => esc_html__( 'Controls Secondary Background', 'productive-ecommerce' ),
                        'section' => 'productive_ecommerce_homepage_options_slider_options',
                    )
                    )
                );
            
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_slider_nav_control_shape',
                array(
                    'type' => 'theme_mod',
                    'default' => 'slider_nav_shape_circle',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_slider_nav_control_shape',
                array(
                    'type' => 'select',
                    'priority' => 40,
                    'section' => 'productive_ecommerce_homepage_options_slider_options',
                    'label' => esc_html__( 'Side Navigation Controls Shape', 'productive-ecommerce' ),
                    'description' => '',
                    'choices' => productive_global_get_slider_nav_control_shapes( true ),
                )
            );
            
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_slider_pagination_control_shape',
                array(
                    'type' => 'theme_mod',
                    'default' => 'slider_pagination_shape_hybrid',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_slider_pagination_control_shape',
                array(
                    'type' => 'select',
                    'priority' => 50,
                    'section' => 'productive_ecommerce_homepage_options_slider_options',
                    'label' => esc_html__( 'Bottom Pagination Controls Shape', 'productive-ecommerce' ),
                    'description' => '',
                    'choices' => productive_global_get_slider_pagination_control_shapes( true ),
                )
            );
            
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_slider_nav_control_padding',
                array(
                    'type' => 'theme_mod',
                    'default' => 25,
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_absint'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_homepage_slider_nav_control_padding',
                array(
                    'type' => 'number',
                    'priority' => 60,
                    'section' => 'productive_ecommerce_homepage_options_slider_options',
                    'label' => esc_html__( 'Nav Control Padding (px)', 'productive-ecommerce' ),
                    'description' => '',
                    'input_attrs' => array(
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ),
                )
            );
            
            // add a setting for productive_ecommerce_pro_callout_1, below.
            $sliders_list_url = 'edit.php?post_type=pro_slider';
            $sliders_add_url = 'post-new.php?post_type=pro_slider';
            $productive_ecommerce_manage_sliders_heading = esc_html__( 'Manage Slides Content', 'productive-ecommerce' );
            $productive_ecommerce_manage_sliders_list_url = '<a target="_blank" class="" href="'. esc_url( admin_url( $sliders_list_url ) ) .'">' . esc_html__( 'Manage Slides', 'productive-ecommerce' ) . '</a> ';
            $productive_ecommerce_manage_sliders_add_url = '<a target="_blank" class="" href="'. esc_url( admin_url( $sliders_add_url ) ) .'">' . esc_html__( 'Add New Slide', 'productive-ecommerce' ) . '</a>';

            $wp_customise->add_setting(
                'productive_ecommerce_homepage_slider_manage_list_url',
                array(
                    'type' => 'theme_mod',
                    'default' => '',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_html'),
                )
                );
            // add control..
            $wp_customise->add_control(
                'productive_ecommerce_homepage_slider_manage_list_url',
                array(
                    'type' => 'hidden',
                    'priority' => 200,
                    'section' => 'productive_ecommerce_homepage_options_slider_options',
                    'label' => $productive_ecommerce_manage_sliders_heading,
                    'description' => $productive_ecommerce_manage_sliders_list_url,
                )
                );

            $wp_customise->add_setting(
                'productive_ecommerce_homepage_slider_manage_add_url',
                array(
                    'type' => 'theme_mod',
                    'default' => '',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_html'),
                )
                );
            // add control..
            $wp_customise->add_control(
                'productive_ecommerce_homepage_slider_manage_add_url',
                array(
                    'type' => 'hidden',
                    'priority' => 210,
                    'section' => 'productive_ecommerce_homepage_options_slider_options',
                    'label' => '',
                    'description' => $productive_ecommerce_manage_sliders_add_url,
                )
                );
            
            
            $sliders_global_options_url = 'admin.php?page=productive_global_options_submenu&tab=section_global_slider_options_tab';
            $productive_global_manage_sliders_options_heading = esc_html__( 'Global Slider Options', 'productive-ecommerce' );
            $productive_global_manage_sliders_options_url = '<a target="_blank" class="" href="'. esc_url( admin_url( $sliders_global_options_url ) ) .'">' . esc_html__( 'Manage Global Slider options', 'productive-ecommerce' ) . '</a> ';
            
            $wp_customise->add_setting(
                'productive_ecommerce_homepage_slider_manage_global_options_url',
                array(
                    'type' => 'theme_mod',
                    'default' => '',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_html'),
                )
            );
            // add control..
            $wp_customise->add_control(
                'productive_ecommerce_homepage_slider_manage_global_options_url',
                array(
                    'type' => 'hidden',
                    'priority' => 300,
                    'section' => 'productive_ecommerce_homepage_options_slider_options',
                    'label' => $productive_global_manage_sliders_options_heading,
                    'description' => $productive_global_manage_sliders_options_url,
                )
            );
            
        }
    } // End of class.
    
    // add hook for the class.
    add_action( 'customize_register', array( 'Productive_Theme_Customiser_Homepage_Slider_Options', 'register' ) );
    
} // End of if class exists


/**
 * Method productive_ecommerce_homepage_slider_no_of_slides.
 *
 * @param string $class ''.
 */
function productive_ecommerce_homepage_slider_no_of_slides() {
    return get_theme_mod( 'productive_ecommerce_homepage_slider_no_of_slides', 4 );
}

/**
 * Method productive_ecommerce_homepage_slider_controls_primary_color.
 *
 * @param string $class ''.
 */
function productive_ecommerce_homepage_slider_controls_primary_color( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_homepage_slider_controls_primary_color', '#0a47bb' );
}

/**
 * Method productive_ecommerce_homepage_slider_controls_secondary_color.
 *
 * @param string $class ''.
 */
function productive_ecommerce_homepage_slider_controls_secondary_color( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_homepage_slider_controls_secondary_color', '#f7f7f7' );
}       

/**
 * Method productive_ecommerce_homepage_slider_pagination_control_shape.
 *
 * @param string $class ''.
 */
function productive_ecommerce_homepage_slider_pagination_control_shape( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_homepage_slider_pagination_control_shape', 'slider_pagination_shape_hybrid' );
}          

/**
 * Method productive_ecommerce_homepage_slider_nav_control_shape.
 *
 * @param string $class ''.
 */
function productive_ecommerce_homepage_slider_nav_control_shape( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_homepage_slider_nav_control_shape', 'slider_nav_shape_circle' );
}

/**
 * Method productive_ecommerce_homepage_slider_nav_control_padding.
 *
 * @param string $class ''.
 */
function productive_ecommerce_homepage_slider_nav_control_padding() {
    return get_theme_mod( 'productive_ecommerce_homepage_slider_nav_control_padding', 25 );
}         

/**
 * Method productive_ecommerce_homepage_slider_content_entrance_easing.
 *
 * @param string $class ''.
 */
function productive_ecommerce_homepage_slider_content_entrance_easing( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_homepage_slider_content_entrance_easing', '--ease' );
}     

/**
 * Method productive_ecommerce_homepage_slider_content_start.
 *
 * @param string $class ''.
 */
function productive_ecommerce_homepage_slider_content_start( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_homepage_slider_content_start', '' );
}
