<?php
/**
 * Theme Customiser
 *
 * @package     productive-ecommerce
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 * 
 */

if ( ! defined( 'ABSPATH' ) ) {
    die();
}


if ( ! class_exists( 'Productive_Theme_Customiser_Layout' ) ) {
    
    /**
     * Productive_Theme_Customiser_Layout
     * Theme Customiser Class
     */
    class Productive_Theme_Customiser_Layout extends Productive_Theme_Customiser_Common {
        
        /**
         * Register the customizer
         *
         * @param WP_Customize_Manager $wp_customise param.
         */
        public static function register( $wp_customise ) {
            
            // See common for Panels
            // 
            // Section
            $wp_customise->add_section(
                'productive_ecommerce_layout_options',
                array(
                    'title' => esc_html__( 'Pages Layout and Design Options', 'productive-ecommerce' ),
                    'description' => esc_html__( 'Layout Options affecting all website pages', 'productive-ecommerce' ),
                    'panel' => 'productive_ecommerce_theme_options',
                    'priority' => 30,
                    'capability' => 'edit_theme_options',
                )
                );
                
            // add a setting for productive_ecommerce_template_layout_options control, below.
            $wp_customise->add_setting(
                'productive_ecommerce_template_layout_options',
                array(
                    'type' => 'theme_mod',
                    'default' => 'one_column',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                )
            );
            $wp_customise->add_control(
                'productive_ecommerce_template_layout_options',
                array(
                    'type' => 'select',
                    'priority' => 10,
                    'section' => 'productive_ecommerce_layout_options',
                    'label' => esc_html__( 'Site-wide Page Layout Options', 'productive-ecommerce' ),
                    'description' => '',
                    'choices' => productive_global_get_theme_page_layout_options(),
                )
            );
            
            $wp_customise->add_setting(
                'productive_ecommerce_page_design_my_account',
                array(
                    'type' => 'theme_mod',
                    'default' => 'my_account_design_woo_default',
                    'theme_supports' => '',
                    'transport' => 'refresh',
                    'capability' => 'edit_theme_options',
                    'sanitize_callback' => array(__CLASS__, 'productive_ecommerce_sanitize_select'),
                )
            );
            $productive_ecommerce_design_options_my_account = array(
                'my_account_design_woo_default'       => esc_html__( 'WooCommerce Default Design', 'productive-ecommerce' ),
                'my_account_design_woo_compact'       => esc_html__( 'Theme&#39;s Compact WooCommerce Design', 'productive-ecommerce' ),
            );
            $wp_customise->add_control(
                'productive_ecommerce_page_design_my_account',
                array(
                    'type' => 'select',
                    'priority' => 110,
                    'section' => 'productive_ecommerce_layout_options',
                    'label' => esc_html__( 'Login/Register Page design', 'productive-ecommerce' ),
                    'description' => '',
                    'choices' => $productive_ecommerce_design_options_my_account,
                )
            );
            
        }
        
    } // End of class.
    
    // add hook for the class.
    add_action( 'customize_register', array( 'Productive_Theme_Customiser_Layout', 'register' ) );
    
}// End of if class exists



/**
 * Method productive_ecommerce_template_layout_options.
 *
 * @param string $class ''.
 */
function productive_ecommerce_template_layout_options( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_template_layout_options', 'one_column' );
}

/**
 * Method display_productive_ecommerce_layout_fullwidth.
 *
 * @param string $class ''.
 */
function productive_ecommerce_layout_fullwidth( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_layout_fullwidth', false );
}
add_action( 'display_productive_ecommerce_layout_fullwidth', 'productive_ecommerce_layout_fullwidth' );

/**
 * Method productive_ecommerce_layout_content_width.
 *
 * @param string $class ''.
 */
function productive_ecommerce_layout_content_width( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_layout_content_width', 0 );
}

/**
 * Method productive_ecommerce_page_design_my_account.
 *
 * @param string $class ''.
 */
function productive_ecommerce_page_design_my_account( $class = '' ) {
    return get_theme_mod( 'productive_ecommerce_page_design_my_account', 'my_account_design_woo_default' );
}

