<?php
/**
 * @package     productive-ecommerce
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 * 
 */


function productive_ecommerce_get_homepage_banner_with_image() {
    $productive_ecommerce_homepage_banner_width = productive_ecommerce_homepage_banner_width();
    $attachment_id = productive_ecommerce_homepage_usp_image();
    $productive_ecommerce_homepage_usp_image = productive_global_get_attachment_url_by_attachment_id( $attachment_id, PRODUCTIVE_ECOMMERCE_HOMEPAGE_USP_IMAGE_REMOTE );
    $homepage_banner_alignment_v = productive_ecommerce_homepage_banner_alignment_v();
    $homepage_banner_alignment_h = productive_ecommerce_homepage_banner_alignment_h();
    $content_auxiliary_location = productive_ecommerce_homepage_banner_auxiliary_location();
?>
    <?php do_action( 'productive_global_render_content_wrapper_full_full_top', '' ); ?>
        <?php
            if( 'page_width_page_banner' == $productive_ecommerce_homepage_banner_width ) {
                do_action('productive_global_render_content_wrapper_full_top'); 
            }
        ?>
        <div class="productiveminds_banner_container main_banner container_with_bg_image home home-type-one productiveminds_banner_container-top-space-two productiveminds-alignable-container <?php echo esc_attr($homepage_banner_alignment_v); ?>" style="background-image: url(<?php echo esc_url( $productive_ecommerce_homepage_usp_image ); ?>)">
            <div class="productiveminds_banner_container_content_bg_overlay"></div>
            <div class="productiveminds_banner_container_content_bg_overlay_content productiveminds-alignable-container_uno-wrapper productiveminds-alignable-container <?php echo esc_attr($homepage_banner_alignment_v); ?> <?php echo esc_attr($homepage_banner_alignment_h); ?>">
                <div class="productiveminds-alignable-container_uno width-autoed">
                    <?php
                        if( 'full_width_page_banner' == $productive_ecommerce_homepage_banner_width ) {
                            do_action('productive_global_render_content_wrapper_full_top');
                        }
                    ?>
                    <div class="productiveminds_banner_container_content productiveminds-alignable-container align-content-center row-gap-10px">
                        <?php 
                            if( 'content_auxiliary_top' == $content_auxiliary_location ) {
                                do_action( 'display_productive_ecommerce_homepage_banner_auxiliary', $content_auxiliary_location );
                            }
                        ?>
                        <?php do_action( 'display_productive_ecommerce_homepage_usp_textarea_1'); ?>
                        <?php do_action( 'display_productive_ecommerce_homepage_usp_textarea_2'); ?>
                        <?php 
                            if( 'content_auxiliary_bottom' == $content_auxiliary_location ) {
                                do_action( 'display_productive_ecommerce_homepage_banner_auxiliary', $content_auxiliary_location );
                            }
                        ?>
                        <div class="cta spacious align-content-center <?php echo esc_attr($homepage_banner_alignment_h); ?>">
                            <?php do_action( 'display_productive_ecommerce_homepage_cta_1_title', 'cta1'); ?>
                            <?php do_action( 'display_productive_ecommerce_homepage_cta_2_title', 'cta2'); ?>
                        </div>
                    </div>
                    <?php
                        if( 'full_width_page_banner' == $productive_ecommerce_homepage_banner_width ) {
                            do_action('productive_global_render_content_wrapper_full_bottom'); 
                        }
                    ?>                
                </div>
            </div>
        </div>
        <?php
            if( 'page_width_page_banner' == $productive_ecommerce_homepage_banner_width ) {
                do_action('productive_global_render_content_wrapper_full_bottom'); 
            }
        ?>
    <?php do_action('productive_global_render_content_wrapper_full_full_bottom'); ?>
<?php
}
add_action( 'display_productive_ecommerce_get_homepage_banner_with_image', 'productive_ecommerce_get_homepage_banner_with_image' );





// ================= start: type two ====================

function productive_ecommerce_get_homepage_banner_with_image_type_two() {
    $attachment_id = productive_ecommerce_homepage_usp_image();
    $productive_ecommerce_homepage_usp_image = productive_global_get_attachment_url_by_attachment_id( $attachment_id, PRODUCTIVE_ECOMMERCE_HOMEPAGE_USP_IMAGE_REMOTE );
    $homepage_banner_alignment_v = productive_ecommerce_homepage_banner_alignment_v();
    $homepage_banner_alignment_h = productive_ecommerce_homepage_banner_alignment_h();
    $content_auxiliary_location = productive_ecommerce_homepage_banner_auxiliary_location();
?>
    <?php do_action('productive_global_render_content_wrapper_full_without_uno_top'); ?>
        <div class="productiveminds_double_grid column_65_35 home-type-two column-gap-10px productiveminds_banner_container-top-space-ten">
            <div class="productiveminds_double_grid_content">
                <div class="productiveminds_banner_container main_banner container_with_bg_image lefted home home-type-two-left productiveminds-alignable-container <?php echo esc_attr($homepage_banner_alignment_v); ?>" style="background-image: url(<?php echo esc_url( $productive_ecommerce_homepage_usp_image ); ?>)">
                    <div class="productiveminds_banner_container_content_bg_overlay"></div>
                    <div class="productiveminds_banner_container_content_bg_overlay_content productiveminds-alignable-container_uno-wrapper productiveminds-alignable-container <?php echo esc_attr($homepage_banner_alignment_v); ?> <?php echo esc_attr($homepage_banner_alignment_h); ?>">
                        <div class="productiveminds-alignable-container_uno width-autoed">
                            <div class="productiveminds_banner_container_content productiveminds-alignable-container align-content-center row-gap-10px">
                                <?php 
                                    if( 'content_auxiliary_top' == $content_auxiliary_location ) {
                                        do_action( 'display_productive_ecommerce_homepage_banner_auxiliary', $content_auxiliary_location );
                                    }
                                ?>
                                <?php do_action( 'display_productive_ecommerce_homepage_usp_textarea_1'); ?>
                                <?php do_action( 'display_productive_ecommerce_homepage_usp_textarea_2'); ?>
                                <?php 
                                    if( 'content_auxiliary_bottom' == $content_auxiliary_location ) {
                                        do_action( 'display_productive_ecommerce_homepage_banner_auxiliary', $content_auxiliary_location );
                                    }
                                ?>
                                <div class="cta spacious align-content-center <?php echo esc_attr($homepage_banner_alignment_h); ?>">
                                    <?php do_action( 'display_productive_ecommerce_homepage_cta_1_title', 'cta1'); ?>
                                    <?php //do_action( 'display_productive_ecommerce_homepage_cta_2_title', 'cta2'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="productiveminds_double_grid_content">
                <div class="productiveminds-alignable-container justify-items-stretch align-content-stretch home-type-two-right-container height-100pc row-gap-10px">
                    <?php 
                        do_action( 'display_productive_ecommerce_content_element_small_banner_using_image_as_bg', 'vertical' );
                    ?>
                </div>
            </div>
        </div>
    <?php do_action('productive_global_render_content_wrapper_full_without_uno_bottom'); ?>
<?php
}
add_action( 'display_productive_ecommerce_get_homepage_banner_with_image_type_two', 'productive_ecommerce_get_homepage_banner_with_image_type_two' );





// ================= start: type four ====================

function productive_ecommerce_get_homepage_banner_with_image_type_three() {
    $productive_ecommerce_homepage_banner_width = productive_ecommerce_homepage_banner_width();
    $attachment_id = productive_ecommerce_homepage_usp_image();
    $productive_ecommerce_homepage_usp_image = productive_global_get_attachment_url_by_attachment_id( $attachment_id, PRODUCTIVE_ECOMMERCE_HOMEPAGE_USP_IMAGE_REMOTE );
    $homepage_banner_alignment_v = productive_ecommerce_homepage_banner_alignment_v();
    $homepage_banner_alignment_h = productive_ecommerce_homepage_banner_alignment_h();
    
    $small_banner_section_height = productive_ecommerce_homepage_small_banner_container_height();
    $small_banner_section_max_width = productive_ecommerce_homepage_small_banner_section_max_width();
    $small_banner_section_top_margin = intval( $small_banner_section_height / 2 );
    
    $content_auxiliary_location = productive_ecommerce_homepage_banner_auxiliary_location();
?>
    <?php do_action( 'productive_global_render_content_wrapper_full_full_top', '' ); ?>
        <?php
            if( 'page_width_page_banner' == $productive_ecommerce_homepage_banner_width ) {
                do_action('productive_global_render_content_wrapper_full_top'); 
            }
        ?>
        <div class="productiveminds_banner_container main_banner container_with_bg_image home home-type-one home-type-three productiveminds_banner_container-top-space-two productiveminds-alignable-container <?php echo esc_attr($homepage_banner_alignment_v); ?>" style="background-image: url(<?php echo esc_url( $productive_ecommerce_homepage_usp_image ); ?>)">
            <div class="productiveminds_banner_container_content_bg_overlay"></div>
            <div class="productiveminds_banner_container_content_bg_overlay_content productiveminds-alignable-container_uno-wrapper productiveminds-alignable-container <?php echo esc_attr($homepage_banner_alignment_v); ?> <?php echo esc_attr($homepage_banner_alignment_h); ?>">
                <div class="productiveminds-alignable-container_uno width-autoed">
                    <?php
                        if( 'full_width_page_banner' == $productive_ecommerce_homepage_banner_width ) {
                            do_action('productive_global_render_content_wrapper_full_top'); 
                        }
                    ?>
                    <div class="productiveminds_banner_container_content productiveminds-alignable-container align-content-center row-gap-10px">
                        <?php 
                            if( 'content_auxiliary_top' == $content_auxiliary_location ) {
                                do_action( 'display_productive_ecommerce_homepage_banner_auxiliary', $content_auxiliary_location );
                            }
                        ?>
                        <?php do_action( 'display_productive_ecommerce_homepage_usp_textarea_1'); ?>
                        <?php do_action( 'display_productive_ecommerce_homepage_usp_textarea_2'); ?>
                        <?php 
                            if( 'content_auxiliary_bottom' == $content_auxiliary_location ) {
                                do_action( 'display_productive_ecommerce_homepage_banner_auxiliary', $content_auxiliary_location );
                            }
                        ?>
                        <div class="cta spacious align-content-center <?php echo esc_attr($homepage_banner_alignment_h); ?>">
                            <?php do_action( 'display_productive_ecommerce_homepage_cta_1_title', 'cta1'); ?>
                            <?php do_action( 'display_productive_ecommerce_homepage_cta_2_title', 'cta2'); ?>
                        </div>
                    </div>
                    <?php
                        if( 'full_width_page_banner' == $productive_ecommerce_homepage_banner_width ) {
                            do_action('productive_global_render_content_wrapper_full_bottom'); 
                        }
                    ?>                
                </div>
            </div>
        </div>
        <div class="homepage-content-element-small-banner-horizontal" style="min-height: <?php echo esc_attr($small_banner_section_height);?>px; width: 90%; max-width: <?php echo esc_attr($small_banner_section_max_width);?>px; margin: -<?php echo esc_attr($small_banner_section_top_margin);?>px auto 120px;">
            <div style="min-height: <?php echo esc_attr($small_banner_section_height);?>px" class="productiveminds_section-container column-gap-50px columns-<?php echo productive_ecommerce_homepage_banner_and_slides_small_banner_num_of_smalls(); ?>">
                <?php 
                    do_action( 'display_productive_ecommerce_content_element_small_banner_using_image_as_bg', 'horizontal' );
                ?>
            </div>
        </div>
        <?php
            if( 'page_width_page_banner' == $productive_ecommerce_homepage_banner_width ) {
                do_action('productive_global_render_content_wrapper_full_bottom'); 
            }
        ?>
    <?php do_action('productive_global_render_content_wrapper_full_full_bottom'); ?>
<?php
}
add_action( 'display_productive_ecommerce_get_homepage_banner_with_image_type_three', 'productive_ecommerce_get_homepage_banner_with_image_type_three' );





// ================= start: using_image_as_bg ====================

/**
* Method for productive_ecommerce_content_element_small_banner_using_image_as_bg
*/
function productive_ecommerce_content_element_small_banner_using_image_as_bg( $direction = 'vertical' ) {
    if ( productive_ecommerce_is_productive_style_active() ) {
        echo productive_ecommerce_get_content_element_small_banner_using_image_as_bg( $direction );
    } else {
       do_action( 'display_productive_ecommerce_content_element_small_banner_placeholder', $direction );
    }
}
add_action( 'display_productive_ecommerce_content_element_small_banner_using_image_as_bg', 'productive_ecommerce_content_element_small_banner_using_image_as_bg');


/**
* Method for productive_ecommerce_get_content_element_small_banner_using_image_as_bg
*/
function productive_ecommerce_get_content_element_small_banner_using_image_as_bg( $direction = 'vertical' ) {
    // Required for type two
    $section_buttons_enabled = productive_ecommerce_is_homepage_banner_enable();
    $limit = productive_ecommerce_homepage_banner_and_slides_small_banner_num_of_smalls();
    
    $taxonomy_args = array(
        array(
            'taxonomy' => PRODUCTIVE_ECOMMERCE_PLUGIN_CONTENT_ELEMENT_TAXONOMY_SLUG,
            'field' => 'slug',
            'terms' => PRODUCTIVE_ECOMMERCE_PLUGIN_CONTENT_ELEMENT_TYPE_HOMEPAGE_ELEMENTS_SMALL_BANNER,
        )
    );
    $args = array(
        'post_type' => PRODUCTIVE_ECOMMERCE_PLUGIN_CONTENT_ELEMENT_SLUG,
        'posts_per_page' => $limit,
        'orderby' => 'menu_order ASC',
        'order' => 'ASC',
        'suppress_filters' => 0,
        'tax_query' => $taxonomy_args,
    );
    $productive_cpt = new WP_Query( $args );
    if ( productive_global_is_productive_style_active() && $productive_cpt->have_posts() ) {
    ?>
        <?php 
            $counter = 1;
            while( $productive_cpt->have_posts() ) {
                $productive_cpt->the_post();
                $element_post_id = get_the_ID();
                $element_meta_object = get_post_meta( $element_post_id, '_pro_content_element', true );
                
                $section_icon_code = '';
                if ( !empty( $element_meta_object['cpt_icon'] ) ) {
                    $section_icon_code = sanitize_text_field( $element_meta_object['cpt_icon'] );
                }
                $section_cta_url = '';
                if ( !empty( $element_meta_object['cpt_url'] ) ) {
                    $section_cta_url = sanitize_text_field( $element_meta_object['cpt_url'] );
                }
                $section_cta_text = '';
                if ( !empty( $element_meta_object['cpt_url_text'] ) ) {
                    $section_cta_text = sanitize_text_field( $element_meta_object['cpt_url_text'] );
                }
                
                $content_alignment = 'righted';
                $button_justify = 'justify-content-flex-end';
                $content_container_css = 'justify-items-end';
                if ( $counter % 2 == 0 ) { 
                    $content_alignment = 'lefted'; 
                    $button_justify = 'justify-content-flex-start';
                    $content_container_css = 'justify-items-start';
                }
                
                $banner_width = 'width-100pc';
                if ( $direction == 'horizontal' ) {
                    $banner_width = 'width-autoed flexed-autoed';
                    $content_container_css = 'justify-items-end width-autoed';
                    $content_alignment = 'righted';
                    $button_justify = 'justify-content-flex-end';
                    if ( $counter % 2 == 0 ) { 
                        $content_alignment = 'lefted';
                        $content_container_css = 'justify-items-start width-autoed';
                        $button_justify = 'justify-content-flex-start';
                    }
                }
                
                $small_banner_container_text_color = productive_ecommerce_homepage_small_banner_elements_text_color();
            ?>
            <div class="homepage-content-element-small-banner productiveminds-alignable-container_uno <?php echo esc_attr($banner_width);?>">
                <div class="productiveminds_banner_container container_with_bg_image home home-type-two-right <?php echo esc_attr($content_alignment);?> productiveminds-alignable-container align-items-flex-end align-content-flex-end <?php echo esc_attr($button_justify);?>" style="background-image: url(<?php echo esc_url( get_the_post_thumbnail_url() ); ?>)">
                    <div class="productiveminds_banner_container_content_bg_overlay"></div>
                    <div class="productiveminds-alignable-container_uno productiveminds-alignable-container <?php echo esc_attr($content_container_css);?>">
                        <div class="productiveminds_banner_container_content productiveminds-alignable-container align-content-center row-gap-5px">
                            <div style="color: <?php echo esc_attr($small_banner_container_text_color);?>;" class="h4 homepage-content-element-small-banner-title"><?php the_title(); ?></div> 
                            <div style="color: <?php echo esc_attr($small_banner_container_text_color);?>;" class="homepage-content-element-small-banner-desc"><?php the_content(); ?></div>
                            <?php if ( $section_buttons_enabled ) { ?>
                                <div class="cta align-content-center <?php echo esc_attr($button_justify);?>">
                                    <a class="cta1" aria-label="<?php echo esc_attr($section_cta_text); ?>" 
                                       href="<?php echo esc_attr($section_cta_url); ?>">
                                        <?php echo esc_html($section_cta_text); ?>
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            $counter++;
            }
            wp_reset_postdata();
        ?>    
    <?php
    } else {
        do_action( 'display_productive_ecommerce_content_element_small_banner_placeholder', $direction );
    }
}





// ================= start: small_banner_placeholder ====================

/**
* Method for productive_ecommerce_content_element_small_banner_placeholder
*/
function productive_ecommerce_content_element_small_banner_placeholder( $direction = 'vertical' ) {
    ?>
    <?php 
    $placeholder_contents = array( 1, 2 );
    foreach ($placeholder_contents as $key => $placeholder_content) {

        $section_background = '#c6ecfd';
        $content_alignment = 'righted';
        $button_justify = 'justify-content-flex-end';
        $content_container_css = 'justify-items-end';
        $section_title = 'Lorem Ipsum One';
        $section_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.';
        $section_cta_text = 'Get Lorem One';
        if ( $key == 1 ) { 
            $section_background = '#CEF9E6';
            $content_alignment = 'lefted'; 
            $button_justify = 'justify-content-flex-start';
            $content_container_css = 'justify-items-start';
            $section_title = 'Lorem Ipsum Two';
            $section_content = 'It was popularised in the 1960s with the release of Letraset industry sheets.';
            $section_cta_text = 'View Lorem two';
        }

        $banner_width = 'width-100pc';
        if ( $direction == 'horizontal' ) {
            $banner_width = 'width-autoed flexed-autoed';
            $content_container_css = 'justify-items-end width-autoed';
            $content_alignment = 'righted';
            $button_justify = 'justify-content-flex-end';
            if ( $key == 1 ) { 
                $content_alignment = 'lefted';
                $content_container_css = 'justify-items-start width-autoed';
                $button_justify = 'justify-content-flex-start';
            }
        }
        
        $small_banner_container_text_color = productive_ecommerce_homepage_small_banner_elements_text_color();
    ?>
        <div class="homepage-content-element-small-banner productiveminds-alignable-container_uno <?php echo esc_attr($banner_width);?>">
            <div class="productiveminds_banner_container container_with_bg_image home home-type-two-right <?php echo esc_attr($content_alignment);?> productiveminds-alignable-container align-items-flex-end align-content-flex-end <?php echo esc_attr($button_justify);?>" style="background: <?php echo esc_attr($section_background);?>">
                <div class="productiveminds_banner_container_content_bg_overlay"></div>
                <div class="productiveminds-alignable-container_uno productiveminds-alignable-container <?php echo esc_attr($content_container_css);?>">
                    <div class="productiveminds_banner_container_content productiveminds-alignable-container align-content-center row-gap-5px">
                        <div style="color: <?php echo esc_attr($small_banner_container_text_color);?>;" class="h4 homepage-content-element-small-banner-title"><?php echo esc_html($section_title); ?></div> 
                        <div style="color: <?php echo esc_attr($small_banner_container_text_color);?>;" class="homepage-content-element-small-banner-desc"><?php echo esc_html($section_content); ?></div>
                        <div class="cta align-content-center <?php echo esc_attr($button_justify);?>">
                            <a class="cta1" href="#"><?php echo esc_html($section_cta_text); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<?php
    }
}
add_action( 'display_productive_ecommerce_content_element_small_banner_placeholder', 'productive_ecommerce_content_element_small_banner_placeholder');





// ================= start: homepage_banner_with_slider ====================

function productive_ecommerce_get_homepage_banner_with_slider( $terms = PRODUCTIVE_ECOMMERCE_PLUGIN_SLIDER_SLUG_FRONTPAGE_SLIDER_TYPE_1) {
    
    $limit = productive_ecommerce_homepage_slider_no_of_slides();
    $productive_ecommerce_homepage_banner_width                             = productive_ecommerce_homepage_banner_width();
    $productive_ecommerce_homepage_slider_content_entrance_easing           = productive_ecommerce_homepage_slider_content_entrance_easing();
    $productive_ecommerce_homepage_slider_content_start                     = productive_ecommerce_homepage_slider_content_start();
    
    $productive_ecommerce_homepage_slider_pagination_control_shape          = productive_ecommerce_homepage_slider_pagination_control_shape();
    $productive_ecommerce_homepage_slider_nav_control_shape                 = productive_ecommerce_homepage_slider_nav_control_shape();
    
    $section_content_settings_unique_id = 'section_content_unique_id_'. rand();
    $section_initiator = 'std';
    $productiveminds_section_display = 'flexed';
    
    $slider_navigation_arrows_control_position = 'nav-arrows-sides-in';
    $slider_pagination_control_position = 'nav-pagination-in';
    $slider_swiper_main_css_class = 'productiveminds-homepage-slider';
    $slider_swiper_css_class_from_elementor = 'via_std';
    
    $taxonomy_args = array(
        array(
            'taxonomy' => PRODUCTIVE_ECOMMERCE_PLUGIN_SLIDER_TAXONOMY_SLUG,
            'field' => 'slug',
            'terms' => $terms,
        )
    );
    $args = array(
        'post_type' => PRODUCTIVE_ECOMMERCE_PLUGIN_SLIDER_POST_TYPE_SLUG,
        'posts_per_page' => $limit,
        'orderby' => 'menu_order ASC',
        'order' => 'ASC',
        'suppress_filters' => 0,
        'tax_query' => $taxonomy_args,
    );
    $productive_cpt = new WP_Query( $args );
    if ( productive_global_is_productive_style_active() && $productive_cpt->have_posts() ) {
        
        $content_auxiliary_location = productive_ecommerce_homepage_banner_auxiliary_location();
        
        ?>
        <div class="productiveminds_section productiveminds-home-hero-slider <?php echo esc_attr( $productiveminds_section_display ); ?> <?php echo esc_attr( $section_initiator ); ?>" id="<?php echo esc_attr( $section_content_settings_unique_id ); ?>">
            <div class="productiveminds_section_uno">
                <div class="productiveminds-slider-content-container">
                    <div class="swiper_container <?php echo esc_attr( $slider_navigation_arrows_control_position ); ?> <?php echo esc_attr( $slider_pagination_control_position ); ?> <?php echo esc_attr( $productive_ecommerce_homepage_slider_pagination_control_shape ); ?> <?php echo esc_attr( $productive_ecommerce_homepage_slider_nav_control_shape ); ?>">
                        <div class="swiper <?php echo esc_attr( $slider_swiper_main_css_class ); ?> <?php echo esc_attr( $slider_swiper_css_class_from_elementor ); ?>">
                            <div class="swiper-wrapper">
                                <?php
                                while( $productive_cpt->have_posts() ) {
                                    $productive_cpt->the_post();
                                    $productive_cpt_id = get_the_ID();

                                    $slider_content_thumbnail_url = get_the_post_thumbnail_url();
                                    $productive_style_render_content_get_loop_data_cpt_obj = productive_style_render_slider_get_loop_data_cpt( $productive_cpt_id, PRODUCTIVE_ECOMMERCE_PLUGIN_SLIDER_POST_TYPE_META_KEY );
                                    $slider_content_alignment_v = $productive_style_render_content_get_loop_data_cpt_obj['productive_cpt_content_alignment_v'];
                                    $slider_content_alignment_h = $productive_style_render_content_get_loop_data_cpt_obj['productive_cpt_content_alignment_h'];
                                    $slider_content_color = $productive_style_render_content_get_loop_data_cpt_obj['productive_cpt_content_color'];
                                    
                                    $copy_and_css = array(
                                        'css_class' => $content_auxiliary_location,
                                        'copy' => $productive_style_render_content_get_loop_data_cpt_obj['productive_cpt_auxiliary_content'],
                                    );
                                ?>
                                <div class="swiper-slide">
                                    <div class="productiveminds_section-single-item productiveminds-alignable-container row-gap-10px">
                                        <?php do_action( 'productive_global_render_content_wrapper_full_full_top', '' ); ?>
                                            <?php
                                                if( 'page_width_page_banner' == $productive_ecommerce_homepage_banner_width ) {
                                                    do_action('productive_global_render_content_wrapper_full_top'); 
                                                }
                                            ?>
                                                    <div class="productiveminds_banner_container main_banner container_with_bg_image home home-slider productiveminds_banner_container-top-space-two productiveminds-alignable-container justify-items-normal justify-content-space-evenly <?php echo esc_attr($slider_content_alignment_v); ?>" style="background-image: url(<?php echo esc_url( $slider_content_thumbnail_url ); ?>)">
                                                        <div class="productiveminds_banner_container_content_bg_overlay"></div>
                                                        <div class="productiveminds_banner_container_content_bg_overlay_content productiveminds-alignable-container_uno-wrapper productiveminds-alignable-container <?php echo esc_attr($slider_content_alignment_v); ?> <?php echo esc_attr($slider_content_alignment_h); ?>">
                                                            <div class="productiveminds-alignable-container_uno width-autoed" data-enter-exit-transition-home-slider="<?php echo esc_attr($productive_ecommerce_homepage_slider_content_start); ?>">
                                                                <?php
                                                                    if( 'full_width_page_banner' == $productive_ecommerce_homepage_banner_width ) {
                                                                        do_action('productive_global_render_content_wrapper_full_top'); 
                                                                    }
                                                                ?>
                                                                <div class="productiveminds_banner_container_content productiveminds-alignable-container row-gap-10px <?php echo esc_attr($slider_content_color); ?> home-slider-content" style="transition: all 0.4s var(<?php echo esc_attr($productive_ecommerce_homepage_slider_content_entrance_easing); ?>)">
                                                                    
                                                                    <?php 
                                                                        if( 'content_auxiliary_top' == $content_auxiliary_location ) {
                                                                            do_action( 'productive_global_render_hero_content_auxiliary', $copy_and_css );
                                                                        }
                                                                    ?>
                                                                    
                                                                    <?php do_action( 'productive_global_render_hero_content_title', get_the_title() ); ?>
                                                                    <?php do_action( 'productive_global_render_hero_content_main', get_the_content() ); ?>
                                                                    
                                                                    <?php 
                                                                        if( 'content_auxiliary_bottom' == $content_auxiliary_location ) {
                                                                            do_action( 'productive_global_render_hero_content_auxiliary', $copy_and_css );
                                                                        }
                                                                    ?>
                                                                    
                                                                    <div class="cta spacious align-content-center">
                                                                        <?php productive_global_hero_content_cta( $productive_style_render_content_get_loop_data_cpt_obj['productive_cpt_url_1'], $productive_style_render_content_get_loop_data_cpt_obj['productive_cpt_url_1_text'], 'cta1' ); ?>
                                                                        <?php productive_global_hero_content_cta( $productive_style_render_content_get_loop_data_cpt_obj['productive_cpt_url_2'], $productive_style_render_content_get_loop_data_cpt_obj['productive_cpt_url_2_text'], 'cta2' ); ?>
                                                                    </div>
                                                                </div>
                                                                <?php
                                                                    if( 'full_width_page_banner' == $productive_ecommerce_homepage_banner_width ) {
                                                                        do_action('productive_global_render_content_wrapper_full_bottom'); 
                                                                    }
                                                                ?>                
                                                            </div>             
                                                        </div>
                                                    </div>
                                            <?php
                                                if( 'page_width_page_banner' == $productive_ecommerce_homepage_banner_width ) {
                                                    do_action('productive_global_render_content_wrapper_full_bottom'); 
                                                }
                                            ?>
                                        <?php do_action('productive_global_render_content_wrapper_full_full_bottom'); ?>
                                    </div>
                                </div>
                                <?php
                                }
                                wp_reset_postdata();
                                ?>
                            </div>
                            <?php
                                // Arrow nav controls
                                $productiveminds_slider_controls = 'all';
                                if ( 'all' == $productiveminds_slider_controls || 
                                    'arrows' == $productiveminds_slider_controls || 
                                    'dots_and_arrows' == $productiveminds_slider_controls || 
                                    'touch_swipe_and_arrows' == $productiveminds_slider_controls ) {
                           ?>
                                <div class="swiper-button-prev"></div>
                                <div class="swiper-button-next"></div>
                           <?php } ?>
                            <?php
                                // Pagination nav controls
                                if ( 'all' == $productiveminds_slider_controls || 
                                    'dots' == $productiveminds_slider_controls || 
                                    'dots_and_arrows' == $productiveminds_slider_controls || 
                                    'touch_swipe_and_dots' == $productiveminds_slider_controls ) {
                           ?>
                                <div class="swiper-pagination"></div>
                           <?php } ?>
                        </div>
                    </div>
                </div>
            </div><!-- productiveminds_section_uno -->
        </div><!-- productiveminds_section -->
<?php } ?>
<?php
}
add_action( 'display_productive_ecommerce_get_homepage_banner_with_slider', 'productive_ecommerce_get_homepage_banner_with_slider' );





// ================= start: products sections ====================

/**
* Method for productive_ecommerce_the_home_section_bestsellers
*/
function productive_ecommerce_the_home_section_bestsellers($source = 'theme') {
    $is_enabled = productive_ecommerce_homepage_products_bestsellers_enable() || 'plugin' == $source;
    if ( productive_ecommerce_is_woocommerce_activated() && $is_enabled ) {
        $misc = array(
            'source'                        => $source,
            'section_content_type'          => 'display_homepage_bestsellers',
            'terms'                         => PRODUCTIVE_ECOMMERCE_PLUGIN_HOME_SECTION_HERO_TAXONOMY_SLUG_BESTSELLERS,
            'limit'                         => 1,
            'cta_style'                     => productive_ecommerce_homepage_products_bestsellers_section_cta_style(),
            'content_alignment_v'           => productive_ecommerce_homepage_products_bestsellers_alignment_v(),
            'content_alignment_h'           => productive_ecommerce_homepage_products_bestsellers_alignment_h(),
            'hero_color_scheme'             => productive_ecommerce_homepage_products_bestsellers_section_hero_color_scheme(),
            'section_design'                => productive_ecommerce_homepage_products_bestsellers_design(),
            'section_blocks_ratio'          => productive_ecommerce_homepage_products_bestsellers_section_blocks_ratio(),
            'section_bg_color_scheme'       => 'page_main_section_container home ' . productive_ecommerce_homepage_products_bestsellers_section_bg_color_scheme(),
        );
        productive_ecommerce_the_home_section_design_select( $misc );
    }
}
add_action( 'display_home_section_bestsellers', 'productive_ecommerce_the_home_section_bestsellers');


/**
* Method for productive_ecommerce_the_home_section_latest
*/
function productive_ecommerce_the_home_section_latest($source = 'theme') {
    $is_enabled = productive_ecommerce_homepage_products_latest_enable() || 'plugin' == $source;
    if ( productive_ecommerce_is_woocommerce_activated() && $is_enabled ) {
        $misc = array(
            'source'                        => $source,
            'section_content_type'          => 'display_homepage_latest',
            'terms'                         => PRODUCTIVE_ECOMMERCE_PLUGIN_HOME_SECTION_HERO_TAXONOMY_SLUG_LATEST,
            'limit'                         => 1,
            'cta_style'                     => productive_ecommerce_homepage_products_latest_section_cta_style(),
            'content_alignment_v'           => productive_ecommerce_homepage_products_latest_alignment_v(),
            'content_alignment_h'           => productive_ecommerce_homepage_products_latest_alignment_h(),
            'hero_color_scheme'             => productive_ecommerce_homepage_products_latest_section_hero_color_scheme(),
            'section_design'                => productive_ecommerce_homepage_products_latest_design(),
            'section_blocks_ratio'          => productive_ecommerce_homepage_products_latest_section_blocks_ratio(),
            'section_bg_color_scheme'       => 'page_main_section_container home ' . productive_ecommerce_homepage_products_latest_section_bg_color_scheme(),
        );
        productive_ecommerce_the_home_section_design_select( $misc );
    }
}
add_action( 'display_home_section_latest', 'productive_ecommerce_the_home_section_latest');


/**
* Method for productive_ecommerce_the_home_section_featured
*/
function productive_ecommerce_the_home_section_featured($source = 'theme') {
    $is_enabled = productive_ecommerce_homepage_products_featured_enable() || 'plugin' == $source;
    if ( productive_ecommerce_is_woocommerce_activated() && $is_enabled ) {
        $misc = array(
            'source'                        => $source,
            'section_content_type'          => 'display_homepage_featured',
            'terms'                         => PRODUCTIVE_ECOMMERCE_PLUGIN_HOME_SECTION_HERO_TAXONOMY_SLUG_FEATURED,
            'limit'                         => 1,
            'cta_style'                     => productive_ecommerce_homepage_products_featured_section_cta_style(),
            'content_alignment_v'           => productive_ecommerce_homepage_products_featured_alignment_v(),
            'content_alignment_h'           => productive_ecommerce_homepage_products_featured_alignment_h(),
            'hero_color_scheme'             => productive_ecommerce_homepage_products_featured_section_hero_color_scheme(),
            'section_design'                => productive_ecommerce_homepage_products_featured_design(),
            'section_blocks_ratio'          => productive_ecommerce_homepage_products_featured_section_blocks_ratio(),
            'section_bg_color_scheme'       => 'page_main_section_container home ' . productive_ecommerce_homepage_products_featured_section_bg_color_scheme(),
        );
        productive_ecommerce_the_home_section_design_select( $misc );
    }
}
add_action( 'display_home_section_featured', 'productive_ecommerce_the_home_section_featured');


function productive_ecommerce_the_home_section_design_select( $misc = array() ) {
    $section_design = $misc['section_design'];
    switch ( $section_design ) {
        case 'design_01':
            productive_ecommerce_the_home_section_design_01( $misc );
            break;

        case 'design_02':
            productive_ecommerce_the_home_section_design_02( $misc );
            break;

        default:
            productive_ecommerce_the_home_section_design_standard( $misc );
            break;
    }
}
add_action( 'display_productive_productive_theme_homepage_woo_product_element_render', 'productive_ecommerce_the_home_section_design_select');

function productive_ecommerce_the_home_section_design_standard( $misc = array() ) {
    $source                         = $misc['source'];
    $section_content_type           = $misc['section_content_type'];
    $section_bg_color_scheme        = $misc['section_bg_color_scheme'];
    ?>
    <?php do_action( 'productive_global_render_content_wrapper_full_full_top', $section_bg_color_scheme ); ?>
    <?php do_action('productive_global_render_content_wrapper_full_top'); ?>
        <div class="section_hero">
            <?php do_action( $section_content_type, $source ); ?>
         </div>
    <?php do_action('productive_global_render_content_wrapper_full_bottom'); ?>
    <?php do_action('productive_global_render_content_wrapper_full_full_bottom'); ?>
    <?php
}

function productive_ecommerce_the_home_section_design_01( $misc = array() ) {
    $source                         = $misc['source'];
    $section_content_type           = $misc['section_content_type'];
    $section_bg_color_scheme        = $misc['section_bg_color_scheme'];
    $section_blocks_ratio           = $misc['section_blocks_ratio'];
    ?>
    <?php do_action( 'productive_global_render_content_wrapper_full_full_top', $section_bg_color_scheme ); ?>
        <?php do_action('productive_global_render_content_wrapper_full_top'); ?>
            <div class="section_hero productiveminds_double_grid <?php echo esc_attr($section_blocks_ratio); ?> gap-50px">
                <div class="height-100pc"><?php productive_ecommerce_display_homepage_content_element_hero_beside_product( $misc ); ?></div>
                <div><?php do_action( $section_content_type, $source ); ?></div>
            </div>
        <?php do_action('productive_global_render_content_wrapper_full_bottom'); ?>
    <?php do_action('productive_global_render_content_wrapper_full_full_bottom'); ?>
    <?php
}

function productive_ecommerce_the_home_section_design_02( $misc = array() ) {
    $source                         = $misc['source'];
    $section_content_type           = $misc['section_content_type'];
    $section_bg_color_scheme        = $misc['section_bg_color_scheme'];
    $section_blocks_ratio           = $misc['section_blocks_ratio'];
    ?>
    <?php do_action( 'productive_global_render_content_wrapper_full_full_top', $section_bg_color_scheme ); ?>
        <?php do_action('productive_global_render_content_wrapper_full_top'); ?>
            <div class="section_hero productiveminds_double_grid <?php echo esc_attr($section_blocks_ratio); ?> gap-50px">
                <div><?php do_action( $section_content_type, $source ); ?></div>
                <div class="section_hero"><?php productive_ecommerce_display_homepage_content_element_hero_beside_product( $misc ); ?></div>
            </div>
        <?php do_action('productive_global_render_content_wrapper_full_bottom'); ?>
    <?php do_action('productive_global_render_content_wrapper_full_full_bottom'); ?>
    <?php
}


function productive_ecommerce_display_homepage_content_element_hero_beside_product( $misc = array() ) {
    
    $terms                  = $misc['terms'];
    $limit                  = $misc['limit'];
    $cta_style              = $misc['cta_style'];
    $content_alignment_v    = $misc['content_alignment_v'];
    $content_alignment_h    = $misc['content_alignment_h'];
    $hero_color_scheme      = $misc['hero_color_scheme'];
    
    $taxonomy_args = array(
        array(
            'taxonomy' => PRODUCTIVE_ECOMMERCE_PLUGIN_CONTENT_ELEMENT_TAXONOMY_SLUG,
            'field' => 'slug',
            'terms' => $terms,
        )
    );
    $args = array(
        'post_type' => PRODUCTIVE_ECOMMERCE_PLUGIN_CONTENT_ELEMENT_SLUG,
        'posts_per_page' => $limit,
        'orderby' => 'menu_order ASC',
        'order' => 'DESC',
        'suppress_filters' => 0,
        'tax_query' => $taxonomy_args,
    );
    $productive_cpt = new WP_Query( $args );
    if ( productive_global_is_productive_style_active() && $productive_cpt->have_posts() ) {
        
        while( $productive_cpt->have_posts() ) {
            
            $productive_cpt->the_post();
            $productive_cpt_id = get_the_ID();

            $productive_style_render_content_get_loop_data_cpt = productive_style_render_content_get_loop_data_cpt( $productive_cpt_id, PRODUCTIVE_ECOMMERCE_PLUGIN_CONTENT_ELEMENT_POST_TYPE_META_KEY );
            
            $content_element_thumbnail_url      = get_the_post_thumbnail_url();
            $productive_cpt_url                 = $productive_style_render_content_get_loop_data_cpt['productive_cpt_url'];
            $productive_cpt_url_text            = $productive_style_render_content_get_loop_data_cpt['productive_cpt_url_text'];
        ?>
            <div class="productiveminds_banner_container container_with_bg_image inner_hero width-100pc height-100pc" style="background-image: url(<?php echo esc_url( $content_element_thumbnail_url ); ?>)">
                <div class="productiveminds_banner_container_content_bg_overlay"></div>
                <div class="productiveminds-alignable-container_inner_hero_box productiveminds-alignable-container width-100pc height-100pc <?php echo esc_attr($content_alignment_v); ?> <?php echo esc_attr($content_alignment_h); ?> <?php echo esc_attr($hero_color_scheme); ?>">
                    <div class="h3">
                        <?php the_title(); ?>
                    </div>
                    <div class="h6">
                        <?php the_content(); ?>
                    </div>
                    <div class="cta spacious align-content-center justify-content-center">
                        <?php productive_global_hero_content_cta( $productive_cpt_url, $productive_cpt_url_text, $cta_style ); ?>
                    </div>
                </div>
            </div>
        <?php
        }
        wp_reset_postdata();
    } else if ( productive_global_is_woocommerce_active() && !productive_ecommerce_is_productive_style_active() ) {
        ?>
            <div class="productiveminds-alignable-container align-content-center justify-content-center width-100pc height-100pc">
                    <?php productive_global_render_no_content_found( 'productive-ecommerce', esc_html__('Missing content? To resolve this, please install the Productive Style plugin and add the relevant data.', 'productive-ecommerce'), 'fs-xs' ); ?>
            </div>
        <?php
    }
}





// ================= start: woo_product_home_sections ====================

/**
* Method for productive_ecommerce_the_homepage_bestsellers
*/
function productive_ecommerce_the_homepage_bestsellers($source = 'theme') {
    $is_enabled = productive_ecommerce_homepage_products_bestsellers_enable() || 'plugin' == $source;
    if ( productive_ecommerce_is_woocommerce_activated() && $is_enabled ) {
        $args = array(
            'numberposts'    => 1,
            'posts_per_page' => '1',
	);
        $product_exists = wc_get_products($args);
        if ( count($product_exists) ) {
            $section_title = productive_ecommerce_homepage_products_bestsellers_section_title();
            $section_go_to_shop_copy = productive_ecommerce_homepage_products_bestsellers_section_go_to_shop_copy();
            $section_cols = productive_ecommerce_homepage_products_bestsellers_num_cols();
            $section_rows = productive_ecommerce_homepage_products_bestsellers_num_rows();
            $limit = $section_cols * $section_rows;
            ?>
            <?php do_action('productive_global_render_content_wrapper_full_top'); ?>
                <div class="productiveminds_widget_container_home <?php echo productive_ecommerce_woo_archives_style(); ?>">
                    <div class="productiveminds-alignable-container flexed align-content-center align-items-center justify-content-space-between justify-items-normal">
                        <h2 class="section-title"><?php echo esc_html($section_title); ?></h2>
                        <div class="section_anchor">
                            <a class="" aria-label="<?php echo esc_attr( $section_go_to_shop_copy ); ?>" href="<?php echo get_permalink( wc_get_page_id( 'Shop' ) ); ?>">
                                 <?php echo esc_html( $section_go_to_shop_copy ); ?>
                             </a>
                        </div>
                    </div>
                    <div><?php echo do_shortcode('[products limit="' . esc_attr($limit) . '" columns="' . esc_attr($section_cols) . '" best_selling="true"]'); ?></div>
                </div>
            <?php do_action('productive_global_render_content_wrapper_full_bottom'); ?>
            <?php
        }
    }
}
add_action( 'display_homepage_bestsellers', 'productive_ecommerce_the_homepage_bestsellers');


/**
* Method for productive_ecommerce_the_homepage_latest
*/
function productive_ecommerce_the_homepage_latest($source = 'theme') {
    $is_enabled = productive_ecommerce_homepage_products_latest_enable() || 'plugin' == $source;
    if ( productive_ecommerce_is_woocommerce_activated() && $is_enabled ) {
        $args = array(
            'numberposts'    => 1,
            'posts_per_page' => '1',
	);
        $product_exists = wc_get_products($args);
        if ( count($product_exists) ) {
            $section_title = productive_ecommerce_homepage_products_latest_section_title();
            $section_go_to_shop_copy = productive_ecommerce_homepage_products_latest_section_go_to_shop_copy();
            $section_cols = productive_ecommerce_homepage_products_latest_num_cols();
            $section_rows = productive_ecommerce_homepage_products_latest_num_rows();
            $limit = $section_cols * $section_rows;
            ?>
            <?php do_action('productive_global_render_content_wrapper_full_top'); ?>
                <div class="productiveminds_widget_container_home <?php echo productive_ecommerce_woo_archives_style(); ?>">
                    <div class="productiveminds-alignable-container flexed align-content-center align-items-center justify-content-space-between justify-items-normal">
                        <h2 class="section-title"><?php echo esc_html($section_title); ?></h2>
                        <div class="section_anchor">
                            <a class="" aria-label="<?php echo esc_attr( $section_go_to_shop_copy ); ?>" href="<?php echo get_permalink( wc_get_page_id( 'Shop' ) ); ?>">
                                 <?php echo esc_html( $section_go_to_shop_copy ); ?>
                             </a>
                        </div>
                    </div>
                    <div><?php echo do_shortcode('[products limit="' . esc_attr($limit) . '" columns="' . esc_attr($section_cols) . '" orderby="id" order="DESC" visibility="visible"]'); ?></div>
                </div>
            <?php do_action('productive_global_render_content_wrapper_full_bottom'); ?>
            <?php
        }
    }
}
add_action( 'display_homepage_latest', 'productive_ecommerce_the_homepage_latest');


/**
* Method for productive_ecommerce_the_homepage_featured
*/
function productive_ecommerce_the_homepage_featured($source = 'theme') {
    $is_enabled = productive_ecommerce_homepage_products_featured_enable() || 'plugin' == $source;
    if ( productive_ecommerce_is_woocommerce_activated() && $is_enabled ) {
        $args = array(
            'numberposts'    => 1,
            'posts_per_page' => '1',
	);
        $product_exists = wc_get_products($args);
        if ( count($product_exists) ) {
            $section_title = productive_ecommerce_homepage_products_featured_section_title();
            $section_go_to_shop_copy = productive_ecommerce_homepage_products_featured_section_go_to_shop_copy();
            $section_cols = productive_ecommerce_homepage_products_featured_num_cols();
            $section_rows = productive_ecommerce_homepage_products_featured_num_rows();
            $limit = $section_cols * $section_rows;
            ?>
            <?php do_action('productive_global_render_content_wrapper_full_top'); ?>
                <div class="productiveminds_widget_container_home <?php echo productive_ecommerce_woo_archives_style(); ?>">
                    <div class="productiveminds-alignable-container flexed align-content-center align-items-center justify-content-space-between justify-items-normal">
                        <h2 class="section-title"><?php echo esc_html($section_title); ?></h2>
                        <div class="section_anchor">
                            <a class="" aria-label="<?php echo esc_attr( $section_go_to_shop_copy ); ?>" href="<?php echo get_permalink( wc_get_page_id( 'Shop' ) ); ?>">
                                 <?php echo esc_html( $section_go_to_shop_copy ); ?>
                             </a>
                        </div>
                    </div>
                    <div><?php echo do_shortcode('[products limit="' . esc_attr($limit) . '" columns="' . esc_attr($section_cols) . '" orderby="title" order="DESC" visibility="featured"]'); ?></div>
                </div>
            <?php do_action('productive_global_render_content_wrapper_full_bottom'); ?>
            <?php
        }
    }
}
add_action( 'display_homepage_featured', 'productive_ecommerce_the_homepage_featured');


/**
* Method for productive_ecommerce_the_homepage_on_sale
*/
function productive_ecommerce_the_homepage_on_sale($source = 'theme') {
    $is_enabled = productive_ecommerce_homepage_products_on_sale_enable() || 'plugin' == $source;
    if ( productive_ecommerce_is_woocommerce_activated() && $is_enabled ) {
        $args = array(
            'numberposts'    => 1,
            'posts_per_page' => '1',
	);
        $product_exists = wc_get_products($args);
        if ( count($product_exists) ) {
            $section_title = productive_ecommerce_homepage_products_on_sale_section_title();
            $section_go_to_shop_copy = productive_ecommerce_homepage_products_on_sale_section_go_to_shop_copy();
            $section_cols = productive_ecommerce_homepage_products_on_sale_num_cols();
            $section_rows = productive_ecommerce_homepage_products_on_sale_num_rows();
            $limit = $section_cols * $section_rows;
            ?>
            <?php do_action('productive_global_render_content_wrapper_full_top'); ?>
                <div class="productiveminds_widget_container_home <?php echo productive_ecommerce_woo_archives_style(); ?>">
                    <div class="productiveminds-alignable-container flexed align-content-center align-items-center justify-content-space-between justify-items-normal">
                        <h2 class="section-title"><?php echo esc_html($section_title); ?></h2>
                        <div class="section_anchor">
                            <a class="" aria-label="<?php echo esc_attr( $section_go_to_shop_copy ); ?>" href="<?php echo get_permalink( wc_get_page_id( 'Shop' ) ); ?>">
                                 <?php echo esc_html( $section_go_to_shop_copy ); ?>
                             </a>
                        </div>
                    </div>
                    <div><?php echo do_shortcode('[products limit="' . esc_attr($limit) . '" columns="' . esc_attr($section_cols) . '" orderby="popularity" on_sale="true"]'); ?></div>
                </div>
            <?php do_action('productive_global_render_content_wrapper_full_bottom'); ?>
            <?php
        }
    }
}
add_action( 'display_homepage_on_sale', 'productive_ecommerce_the_homepage_on_sale');
