<?php
/**
 * Header page.
 * 
 * @package     productive-ecommerce
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 */

function productive_ecommerce_render_site_announcement() {
    if( !productive_ecommerce_announcement_switch_on() ) {
        return;
    }
    $productive_ecommerce_announcement_banner_alignment = productive_ecommerce_announcement_banner_alignment();

    $attachment_id = productive_ecommerce_announcement_banner_bg_image();
    $productive_ecommerce_announcement_banner_bg_image = '';
    if( $attachment_id ) {
        $productive_ecommerce_announcement_banner_bg_image = productive_global_get_attachment_url_by_attachment_id( $attachment_id, PRODUCTIVE_ECOMMERCE_HOMEPAGE_USP_IMAGE_REMOTE );
    }

    $productive_ecommerce_announcement_cta_position = productive_ecommerce_announcement_cta_position();

    ?>

    <?php if( $attachment_id && !empty($productive_ecommerce_announcement_banner_bg_image) ) { ?>
    <div class="site-body-container_box_full header-announcement-container container_with_bg_image" style="background-image: url(<?php echo esc_url( $productive_ecommerce_announcement_banner_bg_image ); ?>)">
    <?php } else { ?> 
    <div class="site-body-container_box_full header-announcement-container">
    <?php } ?> 
        <div class="site-body-container_box">
            <div class="site-body-container_box_uno">
                <div class="announcement-container announcement-text-container productiveminds-alignable-container flexed align-items-center align-content-center <?php echo esc_attr($productive_ecommerce_announcement_banner_alignment) ?>">
                    <?php if( 'left' == $productive_ecommerce_announcement_cta_position ) { ?>
                        <?php do_action( 'display_productive_ecommerce_announcement_cta_text'); ?>
                    <?php } ?>

                    <?php echo productive_ecommerce_announcement_copy(); ?> 

                    <?php if( 'right' == $productive_ecommerce_announcement_cta_position ) { ?>
                        <?php do_action( 'display_productive_ecommerce_announcement_cta_text'); ?>
                    <?php } ?>
                </div>
            </div>
        </div>
        <button aria-label="<?php echo esc_attr('Close Overlay', 'productive-ecommerce'); ?>" class="productive-block-close-button right">
            <?php productive_global_render_close_section_button( 16, false, '', 'no-bg' ); ?>
            <span class="screen-reader-text"><?php echo esc_html__('Close Overlay', 'productive-ecommerce'); ?></span>
        </button>
    </div>
    <?php
}
add_action( 'display_productive_ecommerce_site_announcement', 'productive_ecommerce_render_site_announcement' );
