<?php
/**
 *
 * @package     productive-ecommerce
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 * 
 */

require PRODUCTIVE_ECOMMERCE_THEME_BASE_PATH . '/standard/options/theme-settings.php';


/**
 * Method productive_ecommerce_scripts_inline.
 */
function productive_ecommerce_scripts_inline() {
    $custom_css = productive_ecommerce_apply_custom_css();
    wp_add_inline_style('productive_parent_theme_main_css_style', $custom_css);
}
if ( !is_admin() ) {
    add_action( 'wp_enqueue_scripts', 'productive_ecommerce_scripts', 79 );
    add_action( 'wp_enqueue_scripts', 'productive_ecommerce_scripts_inline', 80 );
} else if ( is_admin() ) {
    global $pagenow;
    if( productive_global_is_block_editor_active() && 
            ( 'post.php' == $pagenow || 'post-new.php' == $pagenow || 'comment.php' == $pagenow ) ) {
        add_action( 'enqueue_block_assets', 'productive_ecommerce_scripts', 79 );
        add_action( 'enqueue_block_assets', 'productive_ecommerce_scripts_inline', 80 );
    }
}

/**
 * Method productive_ecommerce_set_content_width
 * Sets the content width in pixels
 */
function productive_ecommerce_set_content_width() {
    if ( ! isset( $content_width ) ) {
        $content_width = PRODUCTIVE_ECOMMERCE_THEME_CONTENT_DEFAULT_WIDTH;
    }
    if ( ! isset( $GLOBALS['content_width'] ) ) {
        $GLOBALS['content_width'] = apply_filters( 'productive_ecommerce_set_content_width', $content_width );
    }
}
add_action( 'after_setup_theme', 'productive_ecommerce_set_content_width', 0 );

/**
 * Method productive_ecommerce_render_my_account_button
 */
function productive_ecommerce_render_my_account_button() {
    $url = '#';
    $productive_ecommerce_all_header_icons_size = productive_ecommerce_all_header_icons_size();
    if( productive_ecommerce_is_woocommerce_activated() ) {
        $url = get_permalink( wc_get_page_id( 'myaccount' ) );
    } else {
        return;
    }
    $productive_ecommerce_my_account_icon_args = array(
        'i'     => 'user-circle-o', 
        'w'     => $productive_ecommerce_all_header_icons_size, 
        'h'     => $productive_ecommerce_all_header_icons_size, 
        'css'   => '',
        'svg_css'   => ''
    );
    ?>
    <span class="productiveminds_standard_header_button account">
        <a title="<?php echo esc_attr( 'Account', 'productive-ecommerce'); ?>" 
            aria-label="<?php echo esc_attr('Account', 'productive-ecommerce'); ?>" 
            class="righted ten_right_padding" 
            href="<?php echo esc_url( $url ); ?>">
            <?php echo wp_kses( productiveminds_get_svg_icon($productive_ecommerce_my_account_icon_args), 'wp_kses_allowed_html' ); ?>
        </a>
    </span>
    <?php
}
add_action('display_productive_my_account_header_button', 'productive_ecommerce_render_my_account_button');


function productive_ecommerce_dispaly_power_button_in_global_popup() {
    return productive_ecommerce_power_button_required();
}
