<?php
/**
 * Header page.
 *
 * @package     productive-ecommerce
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 * 
 */

wp_body_open();

do_action( 'productive_ecommerce_body_open' );

$is_productive_ecommerce_has_custom_logo = has_custom_logo();
$productive_ecommerce_is_custom_logo_text = '';
if( !$is_productive_ecommerce_has_custom_logo ) {
    $productive_ecommerce_is_custom_logo_text = 'is_custom_logo_text';
}
$productive_ecommerce_customiser_show_search            = productive_ecommerce_enable_header_search();
$productive_ecommerce_customiser_show_account_icon      = productive_ecommerce_enable_header_account();
?>

<header class="site-body-container header-container extra-design-1">
    
    <?php do_action( 'display_productive_ecommerce_countdown_global' ); ?>
    
    <?php do_action( 'display_productive_ecommerce_site_announcement' ); ?>
    
    <?php
        if( productive_ecommerce_is_productive_forms_active() && PRODUCTIVE_ECOMMERCE_CUSTOMIZER_header_contact_section_switch_on ) {
            do_action('display_productive_header_contact_section');
        }
    ?>
    
    <div class="site-body-container_box align-items-center">
        <div class="site-body-container_box_uno relatived">
            
            <div class="productiveminds-alignable-container header-container-box align-items-center align-content-center column-gap-50px <?php echo esc_attr( $productive_ecommerce_is_custom_logo_text ); ?>">
                <div class="header-logo header-site-identity productiveminds-alignable-container align-items-center align-content-center">
                    <?php if ( ! $is_productive_ecommerce_has_custom_logo ) { ?>
                        <a class="logo-text" href="<?php echo esc_url( home_url() ); ?>" >
                            <span class="logo-text-name"><?php bloginfo( 'name' ); ?></span><span class="logo-text-desc"><?php bloginfo( 'description' ); ?></span>
                        </a>
                    <?php } else { ?>
                        <?php productive_ecommerce_the_custom_logo(); ?>
                    <?php } ?>
                </div>
                <div class="productiveminds-alignable-container header-container-inner-box flexed align-items-center align-content-center justify-content-flex-end justify-items-end column-gap-20px row-gap-5px">
                    <div class="site-header-menu flexed-autoed hide-below-landscape-mobile">
                        <?php do_action( 'display_productive_ecommerce_header_nav', 'site-header-menu-nav site_header_nav_big_screen' ); ?>
                    </div>
                    <div class="header-icons">
                        <div class="header-icons-items productiveminds-alignable-container flexed flexed-in-a-flexed justify-content-flex-end row-gap-5px column-gap-20px righted">
                            
                            <?php do_action( 'display_productive_language_and_currency_header_buttons', 'hide-below-landscape-mobile' ); ?>

                            <?php if ( $productive_ecommerce_customiser_show_account_icon ) { ?>
                                <?php do_action('display_productive_my_account_header_button'); ?>
                            <?php } ?>
                                
                            <?php if ( $productive_ecommerce_customiser_show_search ) { ?>
                                <span class="productiveminds_standard_header_button search search_icon_righted hide-below-landscape-mobile">
                                    <?php do_action('display_productive_theme_search_icon', 'search_icon_right'); ?>
                                </span>
                            <?php } ?>
                              
                            <?php
                                if( 'hide_navicon' != productive_ecommerce_header_navicon_style() ) {
                                    do_action( 'display_productive_theme_navicon_std', 'hide-above-landscape-mobile' );
                                }
                            ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php
        if( ( (productive_global_is_productive_style_active() || productive_global_is_pass_addons_active()) && PRODUCTIVE_ECOMMERCE_CUSTOMIZER_breadcrumb_switch_on ) && 'hide_top_banner' == PRODUCTIVE_ECOMMERCE_CUSTOMIZER_show_top_banner ) {
            do_action('productive_breadcrumb_render');
        }
    ?>
</header>
