<?php
/**
 * Part template
 *
 * @package     productive-ecommerce
 * @author      productiveminds.com
 * @copyright   productiveminds.com
 * 
 */

// Remove the Archive Title Prefix such as 'category:' from archives
if ( is_archive() ) {
    add_filter("get_the_archive_title_prefix", "__return_empty_string");
}

$productive_ecommerce_show_top_banner = PRODUCTIVE_ECOMMERCE_CUSTOMIZER_show_top_banner;
$productiveminds_theme_layout = productive_ecommerce_show_sidebars_always_in_blog_archives();
if( 'two_columns_right' == $productiveminds_theme_layout && !is_active_sidebar(PRODUCTIVE_ECOMMERCE_RIGHT_SIDEBAR_ID) ) {
    $productiveminds_theme_layout = 'one_column';
} else if( ('two_columns_left' == $productiveminds_theme_layout && !is_active_sidebar(PRODUCTIVE_ECOMMERCE_LEFT_SIDEBAR_ID) ) || ('three_columns' == $productiveminds_theme_layout && (!is_active_sidebar(PRODUCTIVE_ECOMMERCE_LEFT_SIDEBAR_ID) || !is_active_sidebar(PRODUCTIVE_ECOMMERCE_RIGHT_SIDEBAR_ID)) ) ) {
    $productiveminds_theme_layout = 'one_column';
}
?>

<?php 
    if( 'full_width_top_banner' == $productive_ecommerce_show_top_banner ) {
        get_template_part( 'template-parts/part-top-banner-archive-post', 'top' );
    }
?>

<?php do_action('productive_global_render_content_wrapper_standard_top'); ?>
    
    <div class="productiveminds_section-container main-container-box <?php echo esc_attr( $productiveminds_theme_layout ); ?> <?php echo productive_ecommerce_blog_archives_style(); ?>">
        
        <?php do_action( 'display_sidebar_left', $productiveminds_theme_layout ); ?>
        
        <div class="productive-sidebar-main">
            
            <?php 
                if( 'page_width_top_banner' == $productive_ecommerce_show_top_banner ) {
                    get_template_part( 'template-parts/part-top-banner-archive-post', 'top' );
                } else if( 'hide_top_banner' == $productive_ecommerce_show_top_banner ) { ?>
                    <?php do_action('productive_global_render_content_wrapper_full_top'); ?>
                        <div class="productiveminds_banner_container_content">
                            <h1><?php echo wp_kses_post( get_the_archive_title() ); ?></h1>
                            <div class="productiveminds_container_content_desc"><?php echo wp_kses_post(get_the_archive_description() ); ?></div>
                        </div>
                    <?php do_action('productive_global_render_content_wrapper_full_bottom'); ?>
                <?php }
            ?>
            
            <?php
                $is_blog_block = 1;
                $is_search_result_page = 0;
                $section_show_search_result_post_type = 0;
                $section_show_section_header = 0;
                productive_ecommerce_render_content_archive_item_blog( $is_blog_block, $is_search_result_page, $section_show_search_result_post_type, $section_show_section_header );
            ?>
            <?php productive_global_the_posts_navigation(); ?>
        </div>
        
        <?php do_action( 'display_sidebar_right', $productiveminds_theme_layout ); ?>
        
    </div>
    
<?php do_action('productive_global_render_content_wrapper_standard_bottom');
