<?php
/**
 * The template for displaying product search form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/product-searchform.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

if ( ! defined( 'ABSPATH' ) ) { 
    exit;
}

$productive_ecommerce_search_icon_args = array(
    'i'     => 'search', 
    'w'     => 20, 
    'h'     => 20, 
    'css'   => '',
    'svg_css'   => ''
);

?>
<form method="get" class="searchform search-form woocommerce-product-search" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label class="screen-reader-text" for="woocommerce-product-search-field-<?php echo isset( $index ) ? absint( $index ) : 0; ?>"><?php echo esc_html__( 'Search for:', 'productive-ecommerce' ); ?></label>
	<input type="search" id="woocommerce-product-search-field-<?php echo isset( $index ) ? absint( $index ) : 0; ?>" class="search-field" placeholder="<?php echo esc_attr( 'Search products&hellip;', 'productive-ecommerce' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
        <button aria-label="<?php echo esc_attr('Search', 'productive-ecommerce'); ?>" class="searchsubmit" type="submit" value="" >
            <?php echo wp_kses( productiveminds_get_svg_icon($productive_ecommerce_search_icon_args), 'wp_kses_allowed_html' ); ?>
            <span class="screen-reader-text"><?php echo esc_html__('Search', 'productive-ecommerce'); ?></span>
        </button>
	<input type="hidden" name="post_type" value="product" />
</form>
