<?php
/**
 * Retailer Ecommerce functions
 */

if ( ! function_exists( 'retailer_ecommerce_styles' ) ) :
	function retailer_ecommerce_styles() {
		// Register theme stylesheet.
		wp_register_style('retailer-ecommerce-style',
			get_template_directory_uri() . '/style.css',array(),
			wp_get_theme()->get( 'Version' )
		);
		// Register theme custom code js.
		wp_enqueue_script( 'customcode', 
			get_template_directory_uri() . '/assets/js/customcode.js', array( 'jquery' ) );

		// Enqueue theme stylesheet.
		wp_enqueue_style( 'retailer-ecommerce-style' );

		wp_style_add_data( 'retailer-ecommerce-style', 'rtl', 'replace' );
	}
endif;
add_action( 'wp_enqueue_scripts', 'retailer_ecommerce_styles' );

if ( ! function_exists( 'retailer_ecommerce_setup' ) ) :
function retailer_ecommerce_setup() {

    load_theme_textdomain( 'retailer-ecommerce', get_template_directory() . '/languages' );
	
	// Set up the WordPress core custom background feature.
    add_theme_support( 'custom-background', apply_filters( 'retailer_ecommerce_custom_background_args', array(
	    'default-color' => 'ffffff',
	    'default-image' => '',
    ) ) );

	/**
	 * About Theme Function
	 */
	require get_theme_file_path( '/about-theme/about-theme.php' );

	/**
	 * Customizer
	 */
	require get_template_directory() . '/inc/customizer.php';
	/**
	 * TGM FILE
	 */
	require get_theme_file_path( '/TGM/tgm.php' );
}
endif; 
add_action( 'after_setup_theme', 'retailer_ecommerce_setup' );