(function($) {
    function resetColorsToDefault() {
        // Define default values for your color settings
        const defaultColors = {
            'background_color': '#ffffff',
            'storefront_ecommerce_shop_primary_color': '#31797e',
            'storefront_ecommerce_shop_heading_color': '#34394c',
            'storefront_ecommerce_shop_text_color': '#7f8495',
            'storefront_ecommerce_shop_slider_bg_color' :'#ecf5f4',
            'storefront_ecommerce_shop_footer_bg': '#34394c',
            'modern_ecommerce_post_bg': '#ffffff',
        };

        // Iterate over each setting and set it to its default value
        for (let settingId in defaultColors) {
            wp.customize(settingId).set(defaultColors[settingId]);
        }

        // Optionally refresh the preview
        wp.customize.previewer.refresh();
    }

    // Attach reset function to global scope
    window.resetColorsToDefault = resetColorsToDefault;

    $(document).ready(function() {
        $('.color-reset-btn').val('RESET'); // This adds the 'RESET' text inside the button
    });
})(jQuery);